/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter.ccitt;

import java.util.BitSet;
import org.jpedal.io.filter.ccitt.CCITTDecoder;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class CCITT1D
implements CCITTDecoder {
    boolean BlackIs1;
    boolean isByteAligned;
    int columns = 1728;
    byte[] data;
    int bitReached;
    private static final int EOL = -1;
    private static final boolean debug = false;
    boolean isWhite = true;
    private boolean isTerminating;
    private boolean isEndOfLine;
    private boolean EOS;
    private int cRTC;
    int width;
    int height;
    private int line;
    BitSet out;
    private BitSet inputBits;
    int outPtr;
    private int bytesNeeded;
    int scanlineStride;
    private int inputBitCount;
    private static final int[][][] b = new int[][][]{new int[][]{{3, 2, 0}, {2, 3, 0}}, new int[][]{{2, 1, 0}, {3, 4, 0}}, new int[][]{{3, 5, 0}, {2, 6, 0}}, new int[][]{{3, 7, 0}}, new int[][]{{5, 8, 0}, {4, 9, 0}}, new int[][]{{4, 10, 0}, {5, 11, 0}, {7, 12, 0}}, new int[][]{{4, 13, 0}, {7, 14, 0}}, new int[][]{{24, 15, 0}}, new int[][]{{55, 0, 0}, {23, 16, 0}, {24, 17, 0}, {8, 18, 0}, {15, 64, 1}}, new int[][]{{103, 19, 0}, {104, 20, 0}, {108, 21, 0}, {55, 22, 0}, {40, 23, 0}, {23, 24, 0}, {24, 25, 0}, {8, 1792, 1}, {12, 1856, 1}, {13, 1920, 1}}, new int[][]{{202, 26, 0}, {203, 27, 0}, {204, 28, 0}, {205, 29, 0}, {104, 30, 0}, {105, 31, 0}, {106, 32, 0}, {107, 33, 0}, {210, 34, 0}, {211, 35, 0}, {212, 36, 0}, {213, 37, 0}, {214, 38, 0}, {215, 39, 0}, {108, 40, 0}, {109, 41, 0}, {218, 42, 0}, {219, 43, 0}, {84, 44, 0}, {85, 45, 0}, {86, 46, 0}, {87, 47, 0}, {100, 48, 0}, {101, 49, 0}, {82, 50, 0}, {83, 51, 0}, {36, 52, 0}, {55, 53, 0}, {56, 54, 0}, {39, 55, 0}, {40, 56, 0}, {88, 57, 0}, {89, 58, 0}, {43, 59, 0}, {44, 60, 0}, {90, 61, 0}, {102, 62, 0}, {103, 63, 0}, {200, 128, 1}, {201, 192, 1}, {91, 256, 1}, {51, 320, 1}, {52, 384, 1}, {53, 448, 1}, {1, -1, 1}, {18, 1984, 1}, {19, 2048, 1}, {20, 2112, 1}, {21, 2176, 1}, {22, 2240, 1}, {23, 2304, 1}, {28, 2368, 1}, {29, 2432, 1}, {30, 2496, 1}, {31, 2560, 1}}, new int[][]{{108, 512, 1}, {109, 576, 1}, {74, 640, 1}, {75, 704, 1}, {76, 768, 1}, {77, 832, 1}, {114, 896, 1}, {115, 960, 1}, {116, 1024, 1}, {117, 1088, 1}, {118, 1152, 1}, {119, 1216, 1}, {82, 1280, 1}, {83, 1344, 1}, {84, 1408, 1}, {85, 1472, 1}, {90, 1536, 1}, {91, 1600, 1}, {100, 1664, 1}, {101, 1728, 1}}};
    private static final int[][][] w = new int[][][]{new int[][]{{7, 2, 0}, {8, 3, 0}, {11, 4, 0}, {12, 5, 0}, {14, 6, 0}, {15, 7, 0}}, new int[][]{{19, 8, 0}, {20, 9, 0}, {7, 10, 0}, {8, 11, 0}, {27, 64, 1}, {18, 128, 1}}, new int[][]{{7, 1, 0}, {8, 12, 0}, {3, 13, 0}, {52, 14, 0}, {53, 15, 0}, {42, 16, 0}, {43, 17, 0}, {23, 192, 1}, {24, 1664, 1}}, new int[][]{{39, 18, 0}, {12, 19, 0}, {8, 20, 0}, {23, 21, 0}, {3, 22, 0}, {4, 23, 0}, {40, 24, 0}, {43, 25, 0}, {19, 26, 0}, {36, 27, 0}, {24, 28, 0}, {55, 256, 1}}, new int[][]{{53, 0, 0}, {2, 29, 0}, {3, 30, 0}, {26, 31, 0}, {27, 32, 0}, {18, 33, 0}, {19, 34, 0}, {20, 35, 0}, {21, 36, 0}, {22, 37, 0}, {23, 38, 0}, {40, 39, 0}, {41, 40, 0}, {42, 41, 0}, {43, 42, 0}, {44, 43, 0}, {45, 44, 0}, {4, 45, 0}, {5, 46, 0}, {10, 47, 0}, {11, 48, 0}, {82, 49, 0}, {83, 50, 0}, {84, 51, 0}, {85, 52, 0}, {36, 53, 0}, {37, 54, 0}, {88, 55, 0}, {89, 56, 0}, {90, 57, 0}, {91, 58, 0}, {74, 59, 0}, {75, 60, 0}, {50, 61, 0}, {51, 62, 0}, {52, 63, 0}, {54, 320, 1}, {55, 384, 1}, {100, 448, 1}, {101, 512, 1}, {104, 576, 1}, {103, 640, 1}}, new int[][]{{204, 704, 1}, {205, 768, 1}, {210, 832, 1}, {211, 896, 1}, {212, 960, 1}, {213, 1024, 1}, {214, 1088, 1}, {215, 1152, 1}, {216, 1216, 1}, {217, 1280, 1}, {218, 1344, 1}, {219, 1408, 1}, {152, 1472, 1}, {153, 1536, 1}, {154, 1600, 1}, {155, 1728, 1}}, new int[0][], new int[][]{{8, 1792, 1}, {12, 1856, 1}, {13, 1920, 1}}, new int[][]{{1, -1, 1}, {18, 1984, 1}, {19, 2048, 1}, {20, 2112, 1}, {21, 2176, 1}, {22, 2240, 1}, {23, 2304, 1}, {28, 2368, 1}, {29, 2432, 1}, {30, 2496, 1}, {31, 2560, 1}}};
    private boolean eofLineMarker;

    public CCITT1D(byte[] rawData, int width, int height, PdfObject DecodeParms) {
        this.data = rawData;
        this.bitReached = 0;
        this.columns = width;
        if (DecodeParms != null) {
            this.BlackIs1 = DecodeParms.getBoolean(1297445940);
            int columnsSet = DecodeParms.getInt(1162902911);
            if (columnsSet != -1) {
                this.columns = columnsSet;
            }
            this.isByteAligned = DecodeParms.getBoolean(-823077984);
            this.eofLineMarker = DecodeParms.getBoolean(1517116800);
        }
        this.width = this.columns;
        this.height = height;
        this.scanlineStride = this.columns + 7 >> 3;
        this.bytesNeeded = height * this.scanlineStride;
        this.out = new BitSet(this.bytesNeeded << 3);
        this.inputBitCount = this.data.length << 3;
        this.inputBits = CCITT1D.fromByteArray(this.data, this.inputBitCount);
    }

    CCITT1D() {
    }

    @Override
    public byte[] decode() {
        this.moveToEOLMarker();
        this.decode1DRun();
        byte[] buffer = this.createOutputFromBitset();
        if (this.BlackIs1) {
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = (byte)(255 - buffer[i]);
            }
        }
        return buffer;
    }

    byte[] createOutputFromBitset() {
        byte[] output = new byte[this.bytesNeeded];
        int bytePtr = 0;
        int bitPtr = 7;
        int entry = 0;
        for (int j = 0; j < this.outPtr; ++j) {
            if (this.out.get(j)) {
                int mask = 1 << bitPtr;
                entry = (byte)(entry | mask);
                --bitPtr;
            } else {
                --bitPtr;
            }
            if ((j + 1) % this.width == 0 && j != 0) {
                bitPtr = -1;
            }
            if (bitPtr >= 0 || bytePtr >= output.length) continue;
            output[bytePtr] = entry;
            ++bytePtr;
            bitPtr = 7;
            entry = 0;
        }
        return output;
    }

    private void decode1DRun() {
        while (!this.EOS) {
            if (this.isTerminating) {
                this.isTerminating = false;
                boolean bl = this.isWhite = !this.isWhite;
                if (this.isEndOfLine) {
                    this.isEndOfLine = false;
                    this.isWhite = true;
                }
            }
            boolean pixelIsWhite = this.isWhite;
            int pixelCount = this.getCodeWord();
            if (pixelCount <= 0) continue;
            if (pixelIsWhite) {
                this.out.set(this.outPtr, this.outPtr + pixelCount, true);
            }
            this.outPtr += pixelCount;
        }
    }

    private int getCodeWord() {
        int pixelCount = 0;
        int itemFound = -1;
        int maskAdj = 0;
        int startBitLength = 2;
        int endBit = 14;
        int code = 0;
        int bits = 0;
        if (this.isWhite) {
            startBitLength = 4;
            endBit = 13;
        }
        for (int bitLength = startBitLength; bitLength < endBit; ++bitLength) {
            code = this.get1DBits(bitLength, true) & 0xFF;
            itemFound = CCITT1D.checkTables(code, bitLength, this.isWhite);
            if (itemFound != -1) {
                bits = bitLength;
                bitLength = endBit;
                continue;
            }
            if (bitLength != 8) continue;
            ++maskAdj;
            ++this.bitReached;
        }
        if (itemFound != -1) {
            this.bitReached = this.bitReached + bits - maskAdj;
            pixelCount = this.processCodeWord(itemFound, code, bits);
        } else if (this.bitReached > this.inputBitCount) {
            this.EOS = true;
        }
        return pixelCount;
    }

    private int processCodeWord(int itemFound, int code, int bits) {
        boolean isT;
        int pixelCount;
        if (this.isWhite) {
            pixelCount = w[bits - 4][itemFound][1];
            isT = w[bits - 4][itemFound][2] == 0;
        } else {
            pixelCount = b[bits - 2][itemFound][1];
            boolean bl = isT = b[bits - 2][itemFound][2] == 0;
        }
        if (isT) {
            this.isTerminating = true;
        }
        if (pixelCount == -1) {
            if (this.line != 0) {
                LogWriter.writeLog("EOF marker encountered but not EOL yet!");
            }
            this.line = 0;
            this.isWhite = true;
            this.isTerminating = false;
        }
        if (pixelCount != -1) {
            this.line += pixelCount;
            if (this.line == this.width) {
                if (isT) {
                    this.line = 0;
                    this.isEndOfLine = true;
                }
            } else if (this.line > this.width) {
                this.line = 0;
                this.isEndOfLine = true;
            }
        }
        if (bits == 12 && code == 1) {
            ++this.cRTC;
            if (this.cRTC == 6) {
                this.EOS = true;
            }
        } else {
            this.cRTC = 0;
        }
        if (this.cRTC != 6 && this.isEndOfLine && this.isByteAligned && !this.eofLineMarker) {
            int iPart = this.bitReached % 8;
            int iDrop = 8 - iPart;
            if (iPart > 0) {
                this.bitReached += iDrop;
            }
        }
        return pixelCount;
    }

    int get1DBits(int bitsToGet) {
        return this.get1DBits(bitsToGet, false);
    }

    private int get1DBits(int bitsToGet, boolean is1D) {
        int tmp = 0;
        int maskAdj = 0;
        if (is1D && bitsToGet > 8) {
            ++maskAdj;
        }
        for (int y = 0; y < bitsToGet; ++y) {
            if (!this.inputBits.get(y + this.bitReached)) continue;
            int mask = 1 << bitsToGet - y - 1 - maskAdj;
            tmp |= mask;
        }
        return tmp;
    }

    private static int checkTables(int possCode, int bitLength, boolean isWhite) {
        int itemFound = -1;
        int[][] table = isWhite ? w[bitLength - 4] : b[bitLength - 2];
        int size = table.length;
        for (int z = 0; z < size; ++z) {
            if (possCode != table[z][0]) continue;
            itemFound = z;
            z = size;
        }
        return itemFound;
    }

    private static BitSet fromByteArray(byte[] bytes, int bitsNeeded) {
        int bitSetPtr = 0;
        BitSet bits = new BitSet(bitsNeeded);
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte aByte;
            byte tmp = aByte = byArray[i];
            for (int z = 7; z >= 0; --z) {
                int value = tmp & 1 << z;
                if (value >= 1) {
                    bits.set(bitSetPtr, true);
                }
                ++bitSetPtr;
            }
        }
        return bits;
    }

    private void moveToEOLMarker() {
        boolean isEOL = false;
        int i = 0;
        while (!isEOL) {
            isEOL = true;
            for (i = 0; i < 12; ++i) {
                boolean bit = this.inputBits.get(i + this.bitReached);
                if (i == 11) {
                    if (bit) continue;
                    isEOL = false;
                    continue;
                }
                if (!bit) continue;
                isEOL = false;
            }
            ++this.bitReached;
            if (this.bitReached <= 26) continue;
            this.bitReached = 0;
            return;
        }
        this.bitReached = this.bitReached + i - 1;
    }
}

