/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.images.ImageLibrary;
import org.jpedal.utils.LogWriter;

public class StandardImageLibrary
implements ImageLibrary {
    @Override
    public byte[] JBIGDecode(byte[] data, byte[] globalData) {
        return null;
    }

    @Override
    public int convertCMYKtoRGB(int cc, int mm, int yy, int kk) {
        return 0;
    }

    @Override
    public byte[] convertCMYK2RGB(int w, int h, int pixelCount, byte[] data) {
        return null;
    }

    @Override
    public void processJPEG(int dim, byte[] data, int[] maskArray, int[] output) {
    }

    @Override
    public BufferedImage JPEG2000ToRGBImage(byte[] data) {
        return null;
    }

    @Override
    public byte[] getUnconvertedBytesFromJPEG2000(byte[] data) {
        return null;
    }

    @Override
    public byte[] getUnconvertedBytesFromJPEG(byte[] data, int adobeColorTransform) {
        return null;
    }

    @Override
    public byte[] getBytesFromJPEG(byte[] data) {
        Raster ras = StandardImageLibrary.getRasterFromJPEG2000(data);
        return ((DataBufferByte)ras.getDataBuffer()).getData();
    }

    private static Raster getRasterFromJPEG2000(byte[] data) {
        ImageReader iir = null;
        WritableRaster ras = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG2000");
            while (iterator.hasNext() && !(iir = iterator.next()).canReadRaster()) {
            }
            if (iir == null) {
                throw new IOException("Exception in getRasterFromJPEG2000");
            }
            ImageIO.setUseCache(false);
            ImageInputStream iin = ImageIO.createImageInputStream(in);
            iir.setInput(iin, true);
            ras = iir.read(0).getRaster();
            in.close();
            iir.dispose();
            iin.close();
        }
        catch (Exception ee) {
            LogWriter.writeLog("Problem closing  " + ee);
        }
        return ras;
    }

    @Override
    public BufferedImage getTiffImage(int tiffImageToLoad, String file) {
        return null;
    }

    @Override
    public int getTiffPageCount(String file) {
        return 0;
    }

    @Override
    public void write(BufferedImage image, String type, String file_name, boolean fasterPNG) throws IOException {
        ImageIO.write((RenderedImage)image, type, new File(file_name));
    }

    @Override
    public BufferedImage read(File f) throws Exception {
        return ImageIO.read(f);
    }

    @Override
    public BufferedImage convert(Raster ras, int w, int h) {
        byte[] rasData = ((DataBufferByte)ras.getDataBuffer()).getData();
        return StandardImageLibrary.decode(rasData, w, h);
    }

    @Override
    public BufferedImage convert(byte[] cmyk, int w, int h) {
        return StandardImageLibrary.decode(cmyk, w, h);
    }

    private static BufferedImage decode(byte[] rasData, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 1);
        int[] imageData = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        ColorSpace CMYK = GenericColorSpace.getColorSpaceInstance();
        int dim = w * h;
        int p = 0;
        for (int i = 0; i < dim; ++i) {
            int c = rasData[p++] & 0xFF;
            int m = rasData[p++] & 0xFF;
            int y = rasData[p++] & 0xFF;
            int k = rasData[p++] & 0xFF;
            float[] RGB = CMYK.toRGB(new float[]{(float)c / 255.0f, (float)m / 255.0f, (float)y / 255.0f, (float)k / 255.0f});
            int r = (int)(RGB[0] * 255.0f);
            int g = (int)(RGB[1] * 255.0f);
            int b = (int)(RGB[2] * 255.0f);
            imageData[i] = r << 16 | g << 8 | b;
        }
        return image;
    }
}

