/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFStitching
extends PDFGenericFunction
implements PDFFunction {
    private PDFFunction[] functions;
    private float[] bounds = new float[0];
    private final float[] subinput = new float[1];

    public PDFStitching(PDFFunction[] functions, float[] encode, float[] bounds, float[] domain, float[] range) {
        super(domain, range);
        if (bounds != null) {
            this.bounds = bounds;
        }
        if (encode != null) {
            this.encode = encode;
        }
        if (functions != null) {
            this.functions = functions;
        }
    }

    @Override
    public float[] compute(float[] values) {
        int subi;
        float x = PDFStitching.min(PDFStitching.max(values[0], this.domain[0]), this.domain[1]);
        for (subi = this.bounds.length - 1; subi >= 0 && !(x >= this.bounds[subi]); --subi) {
        }
        float xmin = this.domain[0];
        float xmax = this.domain[1];
        if (++subi > 0) {
            xmin = this.bounds[subi - 1];
        }
        if (subi < this.bounds.length) {
            xmax = this.bounds[subi];
        }
        float ymin = this.encode[subi * 2];
        float ymax = this.encode[subi * 2 + 1];
        this.subinput[0] = PDFStitching.interpolate(x, xmin, xmax, ymin, ymax);
        float[] output = this.functions[subi].computeStitch(this.subinput);
        if (this.range != null) {
            for (int i = 0; i != this.range.length / 2; ++i) {
                output[i] = PDFStitching.min(PDFStitching.max(output[i], this.range[i * 2]), this.range[i * 2 + 1]);
            }
        }
        return output;
    }

    @Override
    public float[] computeStitch(float[] values) {
        int subi;
        float x = PDFStitching.min(PDFStitching.max(values[0], this.domain[0]), this.domain[1]);
        for (subi = this.bounds.length - 1; subi >= 0 && !(x >= this.bounds[subi]); --subi) {
        }
        float xmin = this.domain[0];
        float xmax = this.domain[1];
        if (++subi > 0) {
            xmin = this.bounds[subi - 1];
        }
        if (subi < this.bounds.length) {
            xmax = this.bounds[subi];
        }
        float ymin = this.encode[subi * 2];
        float ymax = this.encode[subi * 2 + 1];
        this.subinput[0] = PDFStitching.interpolate(x, xmin, xmax, ymin, ymax);
        float[] output = this.functions[subi].compute(this.subinput);
        for (int i = 0; i != this.range.length / 2; ++i) {
            output[i] = PDFStitching.min(PDFStitching.max(output[i], this.range[i * 2]), this.range[i * 2 + 1]);
        }
        return output;
    }
}

