/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashSet;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.PathData;
import org.jpedal.fonts.tt.hinting.TTVM;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Path;
import org.jpedal.utils.repositories.Vector_Short;

public class TTGlyph
extends PdfGlyph
implements Serializable {
    private Area glyphShape;
    private boolean hasEndCurve;
    private boolean hasHintingApplied;
    private transient Vector_Path paths = new Vector_Path(10);
    private boolean ttHintingRequired;
    public static boolean useHinting = true;
    private boolean containsBrokenGlyfData;
    private int[] scaledX;
    private int[] scaledY;
    private int BPoint1;
    private int BPoint2;
    private final Vector_Int xtranslateValues = new Vector_Int(5);
    private final Vector_Int ytranslateValues = new Vector_Int(5);
    private final short leftSideBearing;
    private final Vector_Double xscaleValues = new Vector_Double(5);
    private final Vector_Double yscaleValues = new Vector_Double(5);
    private final Vector_Double scale01Values = new Vector_Double(5);
    private final Vector_Double scale10Values = new Vector_Double(5);
    private double xscale = 1.0;
    private double yscale = 1.0;
    private double scale01;
    private double scale10;
    private int[] instructions;
    private int xtranslate;
    private int ytranslate;
    private int currentInstructionDepth = Integer.MAX_VALUE;
    private final Vector_Object glyfX = new Vector_Object(5);
    private final Vector_Object glyfY = new Vector_Object(5);
    private final Vector_Object curves = new Vector_Object(5);
    private final Vector_Object contours = new Vector_Object(5);
    private final Vector_Int endPtIndices = new Vector_Int(5);
    private int contourCount;
    private final float unitsPerEm;
    private int compCount = 1;
    private boolean isComposite;
    private double pixelSize;
    private final HashSet<String> testedFonts;
    private int BP1x = -1;
    private int BP2x = -1;
    private int BP1y = -1;
    private int BP2y = -1;
    private int existingXTranslate;
    private int existingYTranslate;
    private int depth;
    private TTVM vm;
    private String baseFontName;

    TTGlyph(Glyf currentGlyf, FontFile2 glyfTable, Hmtx currentHmtx, int idx, float unitsPerEm, TTVM vm, HashSet<String> testedFonts) {
        this.testedFonts = testedFonts;
        this.setGlyphNumber(idx + 1);
        this.isHinted = true;
        this.leftSideBearing = currentHmtx.getLeftSideBearing(idx);
        this.unitsPerEm = unitsPerEm;
        int p = currentGlyf.getCharString(idx);
        glyfTable.setPointer(p);
        if (glyfTable.getBytesLeft() > 4) {
            this.readGlyph(currentGlyf, glyfTable);
            this.vm = vm;
            if (this.createGlyph(this.isHinted)) {
                this.failedOnHinting = true;
                this.isHinted = false;
            }
        }
    }

    TTGlyph(Glyf currentGlyf, FontFile2 glyfTable, Hmtx currentHmtx, int idx, float unitsPerEm, String baseFontName, HashSet<String> testedFonts) {
        this.testedFonts = testedFonts;
        this.setGlyphNumber(idx + 1);
        this.leftSideBearing = currentHmtx.getLeftSideBearing(idx);
        this.unitsPerEm = unitsPerEm;
        this.baseFontName = baseFontName;
        int p = currentGlyf.getCharString(idx);
        glyfTable.setPointer(p);
        if (glyfTable.getBytesLeft() > 4) {
            this.readGlyph(currentGlyf, glyfTable);
            this.createGlyph(false);
        }
    }

    public void setPaths(Vector_Path vp) {
        this.paths = vp;
    }

    public void writePathsToStream(ObjectOutput os) throws IOException {
        if (this.paths != null) {
            int i;
            GeneralPath[] generalPaths = this.paths.get();
            int count = 0;
            for (i = 0; i < generalPaths.length; ++i) {
                if (generalPaths[i] != null) continue;
                count = i;
                break;
            }
            os.writeObject(count);
            for (i = 0; i < count; ++i) {
                PathIterator pathIterator = generalPaths[i].getPathIterator(new AffineTransform());
                PathSerializer.serializePath(os, pathIterator);
            }
        }
    }

    @Override
    public void render(int type, Graphics2D g2, float scaling, boolean isFormGlyph) {
        AffineTransform restore = g2.getTransform();
        BasicStroke oldStroke = (BasicStroke)g2.getStroke();
        float strokeWidth = oldStroke.getLineWidth();
        if (strokeWidth < 0.0f) {
            strokeWidth = -strokeWidth;
        }
        if (this.hasHinting()) {
            g2.scale(0.01, 0.01);
            strokeWidth *= 100.0f;
        }
        g2.setStroke(new BasicStroke(strokeWidth, 0, 1, oldStroke.getMiterLimit(), oldStroke.getDashArray(), oldStroke.getDashPhase()));
        for (int jj = 0; jj < this.paths.size() - 1; ++jj) {
            if ((type & 2) == 2) {
                g2.fill(this.paths.elementAt(jj));
                continue;
            }
            if ((type & 1) != 1 || this.hasEndCurve && ((BasicStroke)g2.getStroke()).getDashPhase() == 0.0f && ((BasicStroke)g2.getStroke()).getDashArray() != null) continue;
            g2.draw(this.paths.elementAt(jj));
        }
        if (this.hasHinting()) {
            g2.setStroke(oldStroke);
            g2.setTransform(restore);
        }
    }

    @Override
    public Area getShape() {
        if (this.glyphShape == null) {
            GeneralPath path = this.paths.elementAt(0);
            if (path != null) {
                path = (GeneralPath)path.clone();
                for (int jj = 1; jj < this.paths.size() - 1; ++jj) {
                    GeneralPath nextPath = this.paths.elementAt(jj);
                    if (nextPath == null) continue;
                    path.append(nextPath, false);
                }
            } else {
                return null;
            }
            this.glyphShape = new Area(path);
        }
        return this.glyphShape;
    }

    private void createPaths(int[] pX, int[] pY, boolean[] onCurve, boolean[] endOfContour, int endIndex) {
        if (endOfContour == null) {
            return;
        }
        TTGlyph.setFirstPoint(endOfContour, onCurve, pX, pY);
        int c = pX.length;
        int fc = TTGlyph.getEndofFirstContour(endOfContour, c);
        PathData pathData = new PathData(pX, pY, onCurve, endOfContour);
        int xs = 0;
        int ys = 0;
        int lc = 0;
        boolean isEnd = false;
        for (int j = 0; j < endIndex; ++j) {
            int p = j % fc;
            int p1 = (j + 1) % fc;
            int p2 = (j + 2) % fc;
            int pm1 = (j - 1) % fc;
            if (j == 0) {
                pm1 = fc - 1;
            }
            if (p1 < lc) {
                p1 += lc;
            }
            if (p2 < lc) {
                p2 += lc;
            }
            if (endOfContour[j]) {
                isEnd = true;
                if (onCurve[fc]) {
                    xs = pX[fc];
                    ys = pY[fc];
                } else {
                    xs = pX[j + 1];
                    ys = pY[j + 1];
                }
                lc = fc;
                fc = TTGlyph.findNextContour(endOfContour, c, fc, j);
            }
            if (lc == fc && onCurve[p] && p - endIndex > 1) {
                j = c;
                continue;
            }
            if (onCurve[p] && onCurve[p1]) {
                pathData.straightLine(p1);
            } else if (j < c - 3 && (fc - lc >= 1 || fc == lc)) {
                j = pathData.calcCurvePoints(p, p1, p2, pm1, fc, j);
                if (!endOfContour[p] || p <= 0 || !endOfContour[p - 1]) {
                    this.hasEndCurve = true;
                    pathData.completeCurve();
                }
                if (pathData.checkEnd && endOfContour[j]) {
                    isEnd = true;
                    xs = pX[fc];
                    ys = pY[fc];
                    lc = fc;
                    fc = TTGlyph.findNextContour(endOfContour, c, fc, j);
                }
            }
            if (endOfContour[p]) {
                pathData.closePath();
            }
            if (!isEnd) continue;
            pathData.moveTo(xs, ys);
            isEnd = false;
        }
        this.paths.addElement(pathData.getPath());
    }

    private static int findNextContour(boolean[] endOfContour, int c, int fc, int j) {
        for (int jj = j + 1; jj < c; ++jj) {
            if (!endOfContour[jj]) continue;
            fc = jj + 1;
            jj = c;
        }
        return fc;
    }

    private static int getEndofFirstContour(boolean[] endOfContour, int c) {
        int fc = -1;
        for (int jj = 0; jj < c; ++jj) {
            if (!endOfContour[jj]) continue;
            fc = jj + 1;
            jj = c;
        }
        return fc;
    }

    private static void setFirstPoint(boolean[] endOfContour, boolean[] onCurve, int[] pX, int[] pY) {
        int ptCount = endOfContour.length;
        int start = 0;
        int firstPt = -1;
        for (int ii = 0; ii < ptCount; ++ii) {
            if (endOfContour[ii]) {
                if (!(firstPt == -1 || onCurve[start] && onCurve[ii])) {
                    TTGlyph.setPoint(pX, pY, onCurve, start, firstPt, ii);
                }
                start = ii + 1;
                firstPt = -1;
                continue;
            }
            if (!onCurve[ii] || firstPt != -1) continue;
            firstPt = ii;
        }
    }

    private static void setPoint(int[] pX, int[] pY, boolean[] onCurve, int start, int firstPt, int ii) {
        int diff = firstPt - start;
        int pXlength = pX.length;
        int[] old_pX = new int[pXlength];
        System.arraycopy(pX, 0, old_pX, 0, pXlength);
        int[] old_pY = new int[pXlength];
        System.arraycopy(pY, 0, old_pY, 0, pXlength);
        boolean[] old_onCurve = new boolean[pXlength];
        System.arraycopy(onCurve, 0, old_onCurve, 0, pXlength);
        for (int oldPos = start; oldPos < ii + 1; ++oldPos) {
            int newPos = oldPos + diff;
            if (newPos > ii) {
                newPos -= ii - start + 1;
            }
            pX[oldPos] = old_pX[newPos];
            pY[oldPos] = old_pY[newPos];
            onCurve[oldPos] = old_onCurve[newPos];
        }
    }

    public void flushArea() {
        this.glyphShape = null;
    }

    private boolean createGlyph(boolean isHinted) {
        boolean failed = false;
        if (isHinted) {
            if (this.createHintedGlyph()) {
                failed = true;
            }
        } else {
            this.createUnhintedGlyph();
        }
        return failed;
    }

    private void createUnhintedGlyph() {
        for (int i = 0; i < this.compCount; ++i) {
            int[] pX = (int[])this.glyfX.elementAt(i);
            int[] pY = (int[])this.glyfY.elementAt(i);
            boolean[] onCurve = (boolean[])this.curves.elementAt(i);
            boolean[] endOfContour = (boolean[])this.contours.elementAt(i);
            int endIndex = this.endPtIndices.elementAt(i);
            if (this.isComposite) {
                this.setCompositeValue(i, pX, pY);
            }
            if (this.baseFontName != null && this.instructions != null && !this.testedFonts.contains(this.baseFontName)) {
                this.testedFonts.add(this.baseFontName);
                this.baseFontName = this.baseFontName.toLowerCase();
                if (this.baseFontName.contains("mingli") || this.baseFontName.contains("kai") || this.baseFontName.contains("huatian")) {
                    this.ttHintingRequired = true;
                    LogWriter.writeLog("TrueType hinting probably required for font " + this.baseFontName);
                }
            }
            this.createPaths(pX, pY, onCurve, endOfContour, endIndex);
        }
    }

    static int midPt(int a, int b) {
        return a + (b - a) / 2;
    }

    private void scaler(int[] pX, int[] pY) {
        this.scaledX = new int[pX.length];
        this.scaledY = new int[pY.length];
        double scale = this.pixelSize / (double)(this.unitsPerEm * 1000.0f) * 64.0;
        for (int i = 0; i < pX.length; ++i) {
            this.scaledX[i] = (int)(scale * (double)pX[i] + 0.5);
            this.scaledY[i] = (int)(scale * (double)pY[i] + 0.5);
        }
        this.scaledX[pX.length - 2] = 0;
        this.scaledY[pY.length - 2] = 0;
        this.scaledX[pX.length - 1] = (int)(scale * (double)this.leftSideBearing + 0.5);
        this.scaledY[pY.length - 1] = 0;
    }

    private void readComplexGlyph(Glyf currentGlyf, FontFile2 currentFontFile) {
        this.isComposite = true;
        this.pullValues();
        this.BPoint1 = -1;
        this.BPoint2 = -1;
        boolean WE_HAVE_INSTRUCTIONS = false;
        int count = currentGlyf.getGlypfCount();
        while (true) {
            int flag = currentFontFile.getNextUint16();
            int glyphIndex = currentFontFile.getNextUint16();
            if (glyphIndex >= count) {
                this.containsBrokenGlyfData = true;
                break;
            }
            WE_HAVE_INSTRUCTIONS = this.setValues(currentFontFile, WE_HAVE_INSTRUCTIONS, flag);
            int localX = this.xtranslate;
            int localY = this.ytranslate;
            this.xtranslate += this.existingXTranslate;
            this.ytranslate += this.existingYTranslate;
            this.saveValues();
            int pointer = currentFontFile.getPointer();
            int p = currentGlyf.getCharString(glyphIndex);
            if (p != -1) {
                if (p < 0) {
                    p = -p;
                }
                currentFontFile.setPointer(p);
                this.existingXTranslate = this.xtranslate;
                this.existingYTranslate = this.ytranslate;
                ++this.depth;
                this.readGlyph(currentGlyf, currentFontFile);
                --this.depth;
                this.existingXTranslate -= localX;
                this.existingYTranslate -= localY;
            }
            currentFontFile.setPointer(pointer);
            if ((flag & 0x20) == 0) {
                if (WE_HAVE_INSTRUCTIONS) {
                    int[] instructions = TTGlyph.readInstructions(currentFontFile);
                    if (this.depth > this.currentInstructionDepth) break;
                    this.instructions = instructions;
                    this.currentInstructionDepth = this.depth;
                    break;
                }
                if (this.depth > this.currentInstructionDepth) break;
                this.instructions = new int[0];
                this.currentInstructionDepth = this.depth;
                break;
            }
            ++this.compCount;
        }
    }

    private boolean setValues(FontFile2 currentFontFile, boolean WE_HAVE_INSTRUCTIONS, int flag) {
        boolean ARG_1AND_2_ARE_WORDS = (flag & 1) == 1;
        boolean ARGS_ARE_XY_VALUES = (flag & 2) == 2;
        boolean WE_HAVE_A_SCALE = (flag & 8) == 8;
        boolean WE_HAVE_AN_X_AND_Y_SCALE = (flag & 0x40) == 64;
        boolean WE_HAVE_A_TWO_BY_TWO = (flag & 0x80) == 128;
        boolean bl = WE_HAVE_INSTRUCTIONS = WE_HAVE_INSTRUCTIONS || (flag & 0x100) == 256;
        if (ARG_1AND_2_ARE_WORDS && ARGS_ARE_XY_VALUES) {
            this.xtranslate = currentFontFile.getNextInt16();
            this.ytranslate = currentFontFile.getNextInt16();
        } else if (!ARG_1AND_2_ARE_WORDS && ARGS_ARE_XY_VALUES) {
            this.xtranslate = currentFontFile.getNextint8();
            this.ytranslate = currentFontFile.getNextint8();
        } else if (ARG_1AND_2_ARE_WORDS) {
            this.BPoint1 = currentFontFile.getNextUint16();
            this.BPoint2 = currentFontFile.getNextUint16();
            this.xtranslate = 0;
            this.ytranslate = 0;
        } else {
            this.BPoint1 = currentFontFile.getNextUint8();
            this.BPoint2 = currentFontFile.getNextUint8();
            this.xtranslate = 0;
            this.ytranslate = 0;
        }
        this.xscale = 1.0;
        this.scale01 = 0.0;
        this.scale10 = 0.0;
        this.yscale = 1.0;
        if (WE_HAVE_A_SCALE || WE_HAVE_AN_X_AND_Y_SCALE || WE_HAVE_A_TWO_BY_TWO) {
            if (WE_HAVE_A_SCALE && !WE_HAVE_AN_X_AND_Y_SCALE && !WE_HAVE_A_TWO_BY_TWO) {
                this.xscale = currentFontFile.getF2Dot14();
                this.scale01 = 0.0;
                this.scale10 = 0.0;
                this.yscale = this.xscale;
            } else if (!WE_HAVE_A_SCALE && WE_HAVE_AN_X_AND_Y_SCALE && !WE_HAVE_A_TWO_BY_TWO) {
                this.xscale = currentFontFile.getF2Dot14();
                this.scale01 = 0.0;
                this.scale10 = 0.0;
                this.yscale = currentFontFile.getF2Dot14();
            } else if (!WE_HAVE_A_SCALE && !WE_HAVE_AN_X_AND_Y_SCALE) {
                this.xscale = currentFontFile.getF2Dot14();
                this.scale01 = currentFontFile.getF2Dot14();
                this.scale10 = currentFontFile.getF2Dot14();
                this.yscale = currentFontFile.getF2Dot14();
            }
        }
        return WE_HAVE_INSTRUCTIONS;
    }

    private void saveValues() {
        this.xtranslateValues.addElement(this.xtranslate);
        this.ytranslateValues.addElement(this.ytranslate);
        this.xscaleValues.addElement(this.xscale);
        this.yscaleValues.addElement(this.yscale);
        this.scale01Values.addElement(this.scale01);
        this.scale10Values.addElement(this.scale10);
    }

    private void pullValues() {
        this.xtranslateValues.pull();
        this.ytranslateValues.pull();
        this.xscaleValues.pull();
        this.yscaleValues.pull();
        this.scale01Values.pull();
        this.scale10Values.pull();
    }

    private void readSimpleGlyph(FontFile2 currentFontFile) {
        int flagCount = 1;
        Vector_Int rawFlags = new Vector_Int(50);
        Vector_Int endPts = new Vector_Int(50);
        Vector_Short XX = new Vector_Short(50);
        Vector_Short Y = new Vector_Short(50);
        try {
            int lastPt = TTGlyph.getLastPt(currentFontFile, endPts, this.contourCount);
            if (currentFontFile.hasValuesLeft()) {
                int[] instructions = TTGlyph.readInstructions(currentFontFile);
                if (this.depth < this.currentInstructionDepth) {
                    this.instructions = instructions;
                }
                int count = lastPt + 1;
                for (int i = 0; i < count; ++i) {
                    if (currentFontFile.getBytesLeft() < 1) {
                        return;
                    }
                    int flag = currentFontFile.getNextUint8();
                    rawFlags.addElement(flag);
                    ++flagCount;
                    if ((flag & 8) != 8) continue;
                    int repeatCount = currentFontFile.getNextUint8();
                    for (int r = 1; r <= repeatCount; ++r) {
                        rawFlags.addElement(flag);
                        ++flagCount;
                    }
                    i += repeatCount;
                }
                TTGlyph.readXValues(currentFontFile, rawFlags, XX, count);
                if (TTGlyph.readYValues(currentFontFile, rawFlags, Y, count)) {
                    return;
                }
                int endPtIndex = 0;
                int x = 0;
                int y = 0;
                int[] flags = rawFlags.get();
                int[] endPtsOfContours = endPts.get();
                short[] XPoints = XX.get();
                short[] YPoints = Y.get();
                count = XPoints.length;
                int[] pX = new int[count + 2];
                int[] pY = new int[count + 2];
                boolean[] onCurve = new boolean[count + 2];
                boolean[] endOfContour = new boolean[count + 2];
                int endIndex = 0;
                for (int i = 0; i < count; ++i) {
                    boolean endPt;
                    boolean bl = endPt = endPtsOfContours[endPtIndex] == i;
                    if (endPt) {
                        ++endPtIndex;
                        endIndex = i + 1;
                    }
                    pX[i] = x += XPoints[i];
                    pY[i] = y += YPoints[i];
                    onCurve[i] = i < flagCount && (flags[i] & 1) != 0;
                    endOfContour[i] = endPt;
                }
                this.setValues(pX, pY);
                this.glyfX.addElement(pX);
                this.glyfY.addElement(pY);
                this.curves.addElement(onCurve);
                this.contours.addElement(endOfContour);
                this.endPtIndices.addElement(endIndex);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Caught an Exception while reading TTGlyph bytes" + e);
        }
    }

    private void setValues(int[] pX, int[] pY) {
        for (int i = 0; i < pX.length; ++i) {
            int lX = pX[i];
            int lY = pY[i];
            pX[i] = !this.isComposite ? (!this.hasHinting() ? (int)((float)lX / this.unitsPerEm) : lX) : (!this.hasHinting() ? (int)(((double)lX * this.xscale + (double)lY * this.scale10 + (double)this.xtranslate) / (double)this.unitsPerEm) : (int)((double)lX * this.xscale + (double)lY * this.scale10 + (double)this.xtranslate));
            if (!this.isComposite) {
                if (!this.hasHinting()) {
                    pY[i] = (int)((float)lY / this.unitsPerEm);
                    continue;
                }
                pY[i] = lY;
                continue;
            }
            pY[i] = !this.hasHinting() ? (int)(((double)lX * this.scale01 + (double)lY * this.yscale + (double)this.ytranslate) / (double)this.unitsPerEm) : (int)((double)lX * this.scale01 + (double)lY * this.yscale + (double)this.ytranslate);
        }
    }

    private static int getLastPt(FontFile2 currentFontFile, Vector_Int endPts, int contourCount) {
        int lastPt = 0;
        for (int i = 0; i < contourCount; ++i) {
            lastPt = currentFontFile.getNextUint16();
            endPts.addElement(lastPt);
        }
        return lastPt;
    }

    private static int[] readInstructions(FontFile2 currentFontFile) {
        int instructionLength = currentFontFile.getNextUint16();
        int[] instructions = new int[instructionLength];
        for (int i = 0; i < instructionLength; ++i) {
            instructions[i] = currentFontFile.getNextUint8();
        }
        return instructions;
    }

    private static boolean readYValues(FontFile2 currentFontFile, Vector_Int rawFlags, Vector_Short y, int count) {
        for (int i = 0; i < count; ++i) {
            int flag = rawFlags.elementAt(i);
            if ((flag & 0x20) != 0) {
                if ((flag & 4) != 0) {
                    if (currentFontFile.getBytesLeft() < 1) {
                        return true;
                    }
                    y.addElement((short)currentFontFile.getNextUint8());
                    continue;
                }
                y.addElement((short)0);
                continue;
            }
            if ((flag & 4) != 0) {
                y.addElement((short)(-currentFontFile.getNextUint8()));
                continue;
            }
            short val = currentFontFile.getNextSignedInt16();
            y.addElement(val);
        }
        return false;
    }

    private static void readXValues(FontFile2 currentFontFile, Vector_Int rawFlags, Vector_Short XX, int count) {
        for (int i = 0; i < count; ++i) {
            short x1;
            int flag = rawFlags.elementAt(i);
            if ((flag & 0x10) != 0) {
                if ((flag & 2) != 0) {
                    x1 = (short)currentFontFile.getNextUint8();
                    XX.addElement(x1);
                    continue;
                }
                XX.addElement((short)0);
                continue;
            }
            if ((flag & 2) != 0) {
                x1 = (short)(-currentFontFile.getNextUint8());
                XX.addElement(x1);
                continue;
            }
            x1 = currentFontFile.getNextSignedInt16();
            XX.addElement(x1);
        }
    }

    private void readGlyph(Glyf currentGlyf, FontFile2 currentFontFile) {
        this.contourCount = currentFontFile.getNextUint16();
        short minX = (short)currentFontFile.getNextUint16();
        short minY = (short)currentFontFile.getNextUint16();
        short maxX = (short)currentFontFile.getNextUint16();
        short maxY = (short)currentFontFile.getNextUint16();
        if (minX > maxX || minY > maxY) {
            return;
        }
        if (this.contourCount != 65535) {
            if (this.contourCount > 0) {
                this.readSimpleGlyph(currentFontFile);
            }
        } else {
            this.readComplexGlyph(currentGlyf, currentFontFile);
        }
    }

    @Override
    public boolean containsBrokenData() {
        return this.containsBrokenGlyfData;
    }

    private boolean createHintedGlyph() {
        boolean failedOnHinting = false;
        for (int i = 0; i < this.compCount; ++i) {
            int[] pX = (int[])this.glyfX.elementAt(i);
            int[] pY = (int[])this.glyfY.elementAt(i);
            if (!this.isComposite) continue;
            this.setCompositeValue(i, pX, pY);
        }
        this.pixelSize = 1562.5;
        int coordCount = 2;
        int[] componentLengths = new int[this.compCount];
        for (int i = 0; i < this.compCount; ++i) {
            coordCount += this.endPtIndices.elementAt(i);
            componentLengths[i] = this.endPtIndices.elementAt(i);
        }
        int[] allX = new int[coordCount];
        int[] allY = new int[coordCount];
        boolean[] allOnCurve = new boolean[coordCount];
        boolean[] allEndOfContour = new boolean[coordCount];
        int[] allEndIndex = new int[this.compCount];
        int offset = 0;
        for (int i = 0; i < this.compCount; ++i) {
            int[] pX = (int[])this.glyfX.elementAt(i);
            int[] pY = (int[])this.glyfY.elementAt(i);
            boolean[] onCurve = (boolean[])this.curves.elementAt(i);
            boolean[] endOfContour = (boolean[])this.contours.elementAt(i);
            int endIndex = this.endPtIndices.elementAt(i);
            if (pX != null && pY != null) {
                this.scaler(pX, pY);
            }
            if (onCurve == null || endOfContour == null) continue;
            for (int j = 0; j < componentLengths[i]; ++j) {
                allX[offset + j] = this.scaledX[j];
                allY[offset + j] = this.scaledY[j];
                allOnCurve[offset + j] = onCurve[j];
                allEndOfContour[offset + j] = endOfContour[j];
                allEndIndex[i] = endIndex;
            }
            offset += componentLengths[i];
        }
        double scaler = this.pixelSize / (double)(this.unitsPerEm * 1000.0f) * 64.0;
        allX[allX.length - 1] = (int)(scaler * (double)this.leftSideBearing + 0.5);
        if (this.instructions != null && this.instructions.length > 0) {
            failedOnHinting = this.vm.processGlyph(this.instructions, allX, allY, allOnCurve, allEndOfContour, this.pixelSize, scaler);
        }
        this.hasHintingApplied = true;
        this.paths.clear();
        offset = 0;
        for (int i = 0; i < this.compCount; ++i) {
            int[] thisX = (int[])this.glyfX.elementAt(i);
            int[] thisY = (int[])this.glyfY.elementAt(i);
            boolean[] onCurve = (boolean[])this.curves.elementAt(i);
            boolean[] endOfContour = (boolean[])this.contours.elementAt(i);
            if (thisX == null || thisY == null || onCurve == null || endOfContour == null) {
                return true;
            }
            int endIndex = allEndIndex[i];
            for (int j = 0; j < componentLengths[i]; ++j) {
                thisX[j] = allX[offset + j];
                thisY[j] = allY[offset + j];
                onCurve[j] = allOnCurve[offset + j];
                endOfContour[j] = allEndOfContour[offset + j];
            }
            this.createPaths(thisX, thisY, onCurve, endOfContour, endIndex);
            offset += componentLengths[i];
        }
        return failedOnHinting;
    }

    private void setCompositeValue(int i, int[] pX, int[] pY) {
        this.setValues(i);
        if (this.BPoint1 != -1 && this.BPoint2 != -1 && pX != null && pY != null) {
            if (this.BP1x == -1 && this.BP2x == -1 && this.BP1y == -1 && this.BP2y == -1) {
                this.BP1x = pX[this.BPoint1];
                this.BP1y = pY[this.BPoint1];
            } else {
                this.BP2x = pX[this.BPoint2];
                this.BP2y = pY[this.BPoint2];
                int xx = this.BP1x - this.BP2x;
                int yy = this.BP1y - this.BP2y;
                int count = pX.length;
                int ii = 0;
                while (ii < count) {
                    int n = ii;
                    pX[n] = pX[n] + xx;
                    int n2 = ii++;
                    pY[n2] = pY[n2] + yy;
                }
                this.BP1x = -1;
                this.BP2x = -1;
                this.BP1y = -1;
                this.BP2y = -1;
            }
        }
    }

    private void setValues(int i) {
        this.xtranslate = this.xtranslateValues.elementAt(i);
        this.ytranslate = this.ytranslateValues.elementAt(i);
        this.xscale = this.xscaleValues.elementAt(i);
        this.yscale = this.yscaleValues.elementAt(i);
        this.scale01 = this.scale01Values.elementAt(i);
        this.scale10 = this.scale10Values.elementAt(i);
    }

    @Override
    public boolean hasHintingApplied() {
        return this.hasHintingApplied;
    }

    public boolean isTTHintingRequired() {
        return this.ttHintingRequired;
    }

    static {
        String value = System.getProperty("org.jpedal.useTTFontHinting");
        if (value != null) {
            useHinting = value.equalsIgnoreCase("true");
        }
    }
}

