/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.DecodeData;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.objects.T1GlyphNumber;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class T1Glyphs
extends PdfJavaGlyphs {
    private boolean is1C;
    private String[] nameForGlyphIndex;
    private DynamicVectorRenderer dynamicVectorRenderer;
    private final Map<String, byte[]> charStrings = new HashMap<String, byte[]>();
    private final Map<String, Integer> glyphNumbers = new HashMap<String, Integer>();
    private static final int max = 100;
    private double[] operandsRead = new double[100];
    private int operandReached;
    private float[] pt;
    private double xs = -1.0;
    private double ys = -1.0;
    private double x;
    private double y;
    private int ptCount;
    private int currentOp;
    private int hintCount;
    private boolean allowAll;
    private double h;
    private boolean isCID;
    private int[] nominalWidthX = new int[]{0};
    private int[] defaultWidthX = new int[0];
    private boolean defaultWidthsPassed;
    private int[] fdSelect;
    private boolean inEndcharSEAC;

    public T1Glyphs(boolean isCID) {
        this.isCID = isCID;
    }

    public T1Glyphs() {
        this.nameForGlyphIndex = new String[65536];
    }

    public static String[] readFontNames(FontData fontData) {
        String[] fontNames;
        block10: {
            fontNames = new String[]{null};
            try (BufferedReader br = new BufferedReader(new StringReader(new String(fontData.getBytes(0, fontData.length()))));){
                int nameEnd;
                int nameStart;
                String line = null;
                do {
                    try {
                        line = br.readLine();
                    }
                    catch (IOException e) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                    if (line != null) continue;
                    break block10;
                } while (!line.startsWith("/FontName") || (nameStart = line.indexOf(47, 9)) == -1 || (nameEnd = line.indexOf(32, nameStart)) == -1);
                String name = line.substring(nameStart + 1, nameEnd);
                fontNames[0] = name.toLowerCase();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        fontData.close();
        return fontNames;
    }

    private void processFlex(GlyphFactory factory, DecodeData data) {
        boolean isFlex = data.isFlex;
        int routine = data.lastVal;
        if (isFlex && this.ptCount == 14 && routine == 0) {
            data.isFlex = false;
            for (int i = 0; i < 12; i += 6) {
                factory.curveTo(this.pt[i], this.pt[i + 1], this.pt[i + 2], this.pt[i + 3], this.pt[i + 4], this.pt[i + 5]);
            }
        } else if (!isFlex && routine >= 0 && routine <= 2) {
            data.isFlex = true;
            this.ptCount = 0;
            this.pt = new float[16];
        }
    }

    private void endchar(GlyphFactory factory, int rawInt) {
        if (this.operandReached == 5) {
            --this.operandReached;
            ++this.currentOp;
        }
        if (this.operandReached == 4 && !this.inEndcharSEAC) {
            StandardFonts.checkLoaded(1);
            float adx = (float)(this.x + this.operandsRead[this.currentOp]);
            float ady = (float)(this.y + this.operandsRead[this.currentOp + 1]);
            String bchar = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[this.currentOp + 2]);
            String achar = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[this.currentOp + 3]);
            this.x = 0.0;
            this.y = 0.0;
            this.inEndcharSEAC = true;
            this.decodeGlyph(null, factory, bchar, rawInt, "");
            factory.closePath();
            factory.moveTo(adx, ady);
            this.x = adx;
            this.y = ady;
            this.decodeGlyph(null, factory, achar, rawInt, "");
            this.inEndcharSEAC = false;
            if (this.xs == -1.0) {
                this.xs = this.x;
                this.ys = this.y;
            }
        } else {
            factory.closePath();
        }
    }

    private int mask(int p) {
        this.hintCount += this.operandReached / 2;
        for (int count = this.hintCount; count > 0; count -= 8) {
            ++p;
        }
        return p;
    }

    private double sbw() {
        double val;
        this.y = val = this.operandsRead[this.operandReached - 2];
        this.xs = this.x = (val = this.operandsRead[this.operandReached - 1]);
        this.ys = this.y;
        this.allowAll = true;
        double yy = this.y;
        this.h = this.operandsRead[this.operandReached - 3];
        return yy;
    }

    private void hMoveTo(GlyphFactory factory, boolean isFirst) {
        if (isFirst && this.operandReached == 2) {
            ++this.currentOp;
        }
        double val = this.operandsRead[this.currentOp];
        this.x += val;
        factory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
    }

    private void rMoveTo(GlyphFactory factory, boolean isFirst) {
        if (isFirst && this.operandReached == 3) {
            ++this.currentOp;
        }
        double val = this.operandsRead[this.currentOp + 1];
        this.y += val;
        val = this.operandsRead[this.currentOp];
        this.x += val;
        factory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
    }

    private void vhhvCurveTo(GlyphFactory factory, int key) {
        boolean isHor;
        boolean bl = isHor = key == 31;
        while (this.operandReached >= 4) {
            this.operandReached -= 4;
            if (isHor) {
                this.x += this.operandsRead[this.currentOp];
            } else {
                this.y += this.operandsRead[this.currentOp];
            }
            this.pt[0] = (float)this.x;
            this.pt[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 1];
            this.y += this.operandsRead[this.currentOp + 2];
            this.pt[2] = (float)this.x;
            this.pt[3] = (float)this.y;
            if (isHor) {
                this.y += this.operandsRead[this.currentOp + 3];
                if (this.operandReached == 1) {
                    this.x += this.operandsRead[this.currentOp + 4];
                }
            } else {
                this.x += this.operandsRead[this.currentOp + 3];
                if (this.operandReached == 1) {
                    this.y += this.operandsRead[this.currentOp + 4];
                }
            }
            this.pt[4] = (float)this.x;
            this.pt[5] = (float)this.y;
            factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
            this.currentOp += 4;
            isHor = !isHor;
        }
    }

    private void vvhhCurveTo(GlyphFactory factory, int key) {
        boolean isVV;
        boolean bl = isVV = key == 26;
        if ((this.operandReached & 1) == 1) {
            if (isVV) {
                this.x += this.operandsRead[0];
            } else {
                this.y += this.operandsRead[0];
            }
            ++this.currentOp;
        }
        while (this.currentOp < this.operandReached) {
            if (isVV) {
                this.y += this.operandsRead[this.currentOp];
            } else {
                this.x += this.operandsRead[this.currentOp];
            }
            this.pt[0] = (float)this.x;
            this.pt[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 1];
            this.y += this.operandsRead[this.currentOp + 2];
            this.pt[2] = (float)this.x;
            this.pt[3] = (float)this.y;
            if (isVV) {
                this.y += this.operandsRead[this.currentOp + 3];
            } else {
                this.x += this.operandsRead[this.currentOp + 3];
            }
            this.pt[4] = (float)this.x;
            this.pt[5] = (float)this.y;
            this.currentOp += 4;
            factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        }
    }

    private void rLineCurve(GlyphFactory factory) {
        for (int lineCount = (this.operandReached - 6) / 2; lineCount > 0; --lineCount) {
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            factory.lineTo((float)this.x, (float)this.y);
            this.currentOp += 2;
        }
        float[] coords = new float[6];
        this.x += this.operandsRead[this.currentOp];
        this.y += this.operandsRead[this.currentOp + 1];
        coords[0] = (float)this.x;
        coords[1] = (float)this.y;
        this.x += this.operandsRead[this.currentOp + 2];
        this.y += this.operandsRead[this.currentOp + 3];
        coords[2] = (float)this.x;
        coords[3] = (float)this.y;
        this.x += this.operandsRead[this.currentOp + 4];
        this.y += this.operandsRead[this.currentOp + 5];
        coords[4] = (float)this.x;
        coords[5] = (float)this.y;
        factory.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
        this.currentOp += 6;
    }

    private void closePath(GlyphFactory factory) {
        if (this.xs != -1.0) {
            factory.lineTo((float)this.xs, (float)this.ys);
        }
        this.xs = -1.0;
    }

    private void hsbw(GlyphFactory factory, int glyphNumber) {
        this.x += this.operandsRead[0];
        factory.moveTo((float)this.x, 0.0f);
        if (this.baseFontName != null && this.dynamicVectorRenderer != null && this.dynamicVectorRenderer.isHTMLorSVG()) {
            this.dynamicVectorRenderer.saveAdvanceWidth(this.objID, String.valueOf(glyphNumber), (int)this.ys);
        }
        this.allowAll = true;
    }

    private void pop() {
        if (this.operandReached > 0) {
            --this.operandReached;
        }
    }

    private void div() {
        double value = this.operandsRead[this.operandReached - 2] / this.operandsRead[this.operandReached - 1];
        --this.operandReached;
        this.operandsRead[this.operandReached - 1] = value;
    }

    private void vMoveTo(GlyphFactory factory, boolean isFirst) {
        if (isFirst && this.operandReached == 2) {
            ++this.currentOp;
        }
        this.y += this.operandsRead[this.currentOp];
        factory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
    }

    private void rLineTo(GlyphFactory factory) {
        for (int lineCount = this.operandReached / 2; lineCount > 0; --lineCount) {
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            factory.lineTo((float)this.x, (float)this.y);
            this.currentOp += 2;
        }
    }

    private void hvLineTo(GlyphFactory factory, int key) {
        boolean isHor = key == 6;
        for (int start = 0; start < this.operandReached; ++start) {
            if (isHor) {
                this.x += this.operandsRead[start];
            } else {
                this.y += this.operandsRead[start];
            }
            factory.lineTo((float)this.x, (float)this.y);
            isHor = !isHor;
        }
    }

    private void rrCurveTo(GlyphFactory factory) {
        for (int curveCount = this.operandReached / 6; curveCount > 0; --curveCount) {
            float[] coords = new float[6];
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            coords[0] = (float)this.x;
            coords[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 2];
            this.y += this.operandsRead[this.currentOp + 3];
            coords[2] = (float)this.x;
            coords[3] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 4];
            this.y += this.operandsRead[this.currentOp + 5];
            coords[4] = (float)this.x;
            coords[5] = (float)this.y;
            factory.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
            this.currentOp += 6;
        }
    }

    private void rCurveLine(GlyphFactory factory) {
        for (int curveCount = (this.operandReached - 2) / 6; curveCount > 0; --curveCount) {
            float[] coords = new float[6];
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            coords[0] = (float)this.x;
            coords[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 2];
            this.y += this.operandsRead[this.currentOp + 3];
            coords[2] = (float)this.x;
            coords[3] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 4];
            this.y += this.operandsRead[this.currentOp + 5];
            coords[4] = (float)this.x;
            coords[5] = (float)this.y;
            factory.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
            this.currentOp += 6;
        }
        this.x += this.operandsRead[this.currentOp];
        this.y += this.operandsRead[this.currentOp + 1];
        factory.lineTo((float)this.x, (float)this.y);
        this.currentOp += 2;
    }

    private void seac(GlyphFactory factory, int rawInt, int currentOp) {
        StandardFonts.checkLoaded(1);
        float adx = (float)this.operandsRead[currentOp + 1];
        float ady = (float)this.operandsRead[currentOp + 2];
        String bchar = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[currentOp + 3]);
        String achar = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[currentOp + 4]);
        double preX = this.x;
        this.y = 0.0;
        this.decodeGlyph(null, factory, bchar, rawInt, "");
        factory.closePath();
        factory.moveTo(0.0f, 0.0f);
        this.x = (double)adx + preX;
        this.y = ady;
        this.decodeGlyph(null, factory, achar, rawInt, "");
    }

    private void flex1(GlyphFactory factory) {
        int points;
        double dx = 0.0;
        double dy = 0.0;
        double x1 = this.x;
        double y1 = this.y;
        for (int count = 0; count < 10; count += 2) {
            dx += this.operandsRead[count];
            dy += this.operandsRead[count + 1];
        }
        boolean isHorizontal = Math.abs(dx) > Math.abs(dy);
        for (points = 0; points < 6; points += 2) {
            this.x += this.operandsRead[points];
            this.y += this.operandsRead[points + 1];
            this.pt[points] = (float)this.x;
            this.pt[points + 1] = (float)this.y;
        }
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        for (points = 0; points < 4; points += 2) {
            this.x += this.operandsRead[points + 6];
            this.y += this.operandsRead[points + 7];
            this.pt[points] = (float)this.x;
            this.pt[points + 1] = (float)this.y;
        }
        if (isHorizontal) {
            this.x += this.operandsRead[10];
            this.y = y1;
        } else {
            this.x = x1;
            this.y += this.operandsRead[10];
        }
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
    }

    private void flex(GlyphFactory factory) {
        for (int curves = 0; curves < 12; curves += 6) {
            for (int points = 0; points < 6; points += 2) {
                this.x += this.operandsRead[curves + points];
                this.y += this.operandsRead[curves + points + 1];
                this.pt[points] = (float)this.x;
                this.pt[points + 1] = (float)this.y;
            }
            factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        }
    }

    private void hflex(GlyphFactory factory) {
        this.x += this.operandsRead[0];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[1];
        this.y += this.operandsRead[2];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[3];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        this.x += this.operandsRead[4];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[5];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[6];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
    }

    private void hflex1(GlyphFactory factory) {
        this.x += this.operandsRead[0];
        this.y += this.operandsRead[1];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[2];
        this.y += this.operandsRead[3];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[4];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        this.x += this.operandsRead[5];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[6];
        this.y += this.operandsRead[7];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[8];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        factory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
    }

    @Override
    public PdfGlyph getEmbeddedGlyph(GlyphFactory factory, String glyph, float[][] Trm, int rawInt, String displayValue, float currentWidth, String key) {
        Integer num;
        PdfGlyph transformedGlyph2;
        if (Trm != null && (this.lastTrm[0][0] != Trm[0][0] || this.lastTrm[1][0] != Trm[1][0] || this.lastTrm[0][1] != Trm[0][1] || this.lastTrm[1][1] != Trm[1][1])) {
            this.lastTrm = Trm;
            this.flush();
        }
        if ((transformedGlyph2 = this.getEmbeddedCachedShape(rawInt)) == null) {
            this.operandsRead = new double[100];
            this.operandReached = 0;
            this.x = 0.0;
            this.y = 0.0;
            this.decodeGlyph(key, factory, glyph, rawInt, displayValue);
            transformedGlyph2 = factory.getGlyph();
            this.setEmbeddedCachedShape(rawInt, transformedGlyph2);
        }
        if ((num = this.glyphNumbers.get(glyph)) == null) {
            num = this.glyphNumbers.get(Integer.toString(rawInt));
        }
        if (num == null) {
            num = this.glyphNumbers.get(key);
        }
        if (num != null) {
            transformedGlyph2.setGlyphNumber(num);
        }
        return transformedGlyph2;
    }

    private void decodeGlyph(String embKey, GlyphFactory factory, String glyph, int rawInt, String displayValue) {
        Integer glyphNumber;
        byte[] glyphStream;
        this.allowAll = false;
        if (this.isCID) {
            glyphStream = this.charStrings.get(String.valueOf(rawInt));
            glyphNumber = this.glyphNumbers.get(String.valueOf(rawInt));
        } else {
            if (glyph == null) {
                glyph = displayValue;
            }
            if (glyph == null && (glyph = embKey) == null) {
                glyph = ".notdef";
            }
            glyphStream = this.charStrings.get(glyph);
            glyphNumber = this.glyphNumbers.get(glyph);
            if (glyphStream == null) {
                if (embKey != null) {
                    glyphStream = this.charStrings.get(embKey);
                    glyphNumber = this.glyphNumbers.get(embKey);
                }
                if (glyphStream == null) {
                    glyphStream = this.charStrings.get(".notdef");
                    glyphNumber = this.glyphNumbers.get(".notdef");
                }
            }
        }
        if (glyphStream != null) {
            this.decodeGlyphStream(factory, rawInt, glyphStream, glyphNumber);
        }
    }

    private void resetValues() {
        this.ptCount = 0;
        this.currentOp = 0;
        this.hintCount = 0;
        this.pt = new float[6];
        this.h = 100000.0;
        if (this.is1C) {
            this.operandsRead = new double[100];
            this.operandReached = 0;
            this.allowAll = true;
        }
    }

    private void decodeGlyphStream(GlyphFactory factory, int rawInt, byte[] stream, int glyphNumber) {
        boolean isFirst = true;
        this.resetValues();
        DecodeData data = new DecodeData(stream);
        int p = 0;
        int lastNumberStart = 0;
        int key = 0;
        while (p < data.dicEnd) {
            int nextVal = data.glyphStream[p] & 0xFF;
            if (nextVal > 31 || nextVal == 28) {
                lastNumberStart = p;
                p = T1GlyphNumber.getNumber(data.glyphStream, p, this.operandsRead, this.operandReached, this.is1C);
                data.lastVal = (int)this.operandsRead[this.operandReached];
                ++this.operandReached;
                if (lastNumberStart != 0) continue;
                this.getPotentialWidth(rawInt, data);
                continue;
            }
            boolean isTwoByte = false;
            if (nextVal == 12) {
                nextVal = 3072 + (data.glyphStream[p + 1] & 0xFF);
                isTwoByte = true;
            }
            if (this.is1C && data.nonSubrCommandCount == 0 && nextVal != 10 && nextVal != 11 && nextVal != 29) {
                this.saveWidths(nextVal, data.potentialWidth, glyphNumber);
            }
            ++data.nonSubrCommandCount;
            int lastKey = key;
            key = nextVal;
            ++p;
            this.currentOp = 0;
            switch (nextVal) {
                case 3079: {
                    data.yy = this.sbw();
                    this.operandReached = 0;
                    break;
                }
                case 13: {
                    this.hsbw(factory, glyphNumber);
                    this.operandReached = 0;
                    break;
                }
                case 3088: {
                    this.processFlex(factory, data);
                    ++p;
                    this.operandReached = 0;
                    break;
                }
                case 10: 
                case 29: {
                    int currentFD = this.getCurrentFD(rawInt);
                    p = this.subroutine(factory, data, p, lastNumberStart, key, lastKey, currentFD);
                    break;
                }
                default: {
                    if (!this.allowAll && key != 3084) break;
                    if (isTwoByte) {
                        this.handle2ByteOp(factory, rawInt, key);
                        ++p;
                        break;
                    }
                    p = this.decodeAllCommands(data, factory, rawInt, isFirst, p, key, data.dicEnd, data.isFlex);
                }
            }
            data.trackBounds(this.y);
            if (!isFirst || key == 19 || key == 29 || key == 10 || key == 11) continue;
            isFirst = false;
        }
        data.setMinY(factory, this.h);
    }

    private int subroutine(GlyphFactory factory, DecodeData data, int p, int lastNumberStart, int key, int lastKey, int currentFD) {
        --data.nonSubrCommandCount;
        if (!this.is1C && key == 10 && data.lastVal >= 0 && data.lastVal <= 2 && lastKey != 11 && this.operandReached > 5) {
            this.processFlex(factory, data);
            this.operandReached = 0;
        } else {
            p = this.subroutine(data, p, lastNumberStart, key, currentFD);
        }
        return p;
    }

    private int getCurrentFD(int rawInt) {
        Integer glyphNo;
        if (this.is1C && (glyphNo = this.glyphNumbers.get(String.valueOf(rawInt))) != null && this.fdSelect != null) {
            return this.fdSelect[glyphNo - 1];
        }
        return 0;
    }

    private int subroutine(DecodeData data, int p, int lastNumberStart, int key, int currentFD) {
        byte[] newStream;
        String fdKey = "";
        if (this.is1C) {
            if (key == 10) {
                data.lastVal += this.localBias[currentFD];
                fdKey = currentFD + "-";
            } else {
                data.lastVal += this.globalBias;
            }
        }
        if ((newStream = key == 10 ? this.charStrings.get("subrs" + fdKey + data.lastVal) : this.charStrings.get("global" + data.lastVal)) != null) {
            data.resizeArray(p, lastNumberStart, newStream);
            p = lastNumberStart;
            if (this.operandReached > 0) {
                --this.operandReached;
            }
        }
        return p;
    }

    private void saveWidths(int nextVal, int potentialWidth, int glyphNumber) {
        boolean hasOddArgs = false;
        if (nextVal == 22 || nextVal == 4 || nextVal == 3081 || nextVal == 3086 || nextVal == 3098 || nextVal == 3090 || nextVal == 3099 || nextVal == 3093 || nextVal == 3077) {
            hasOddArgs = true;
        }
        if (hasOddArgs ? this.operandReached % 2 == 0 : this.operandReached % 2 == 1) {
            this.saveWidth(glyphNumber, potentialWidth);
        }
    }

    private int decodeAllCommands(DecodeData data, GlyphFactory factory, int rawInt, boolean isFirst, int p, int key, int dicEnd, boolean isFlex) {
        boolean leaveOperands = false;
        switch (key) {
            case 0: {
                leaveOperands = true;
                break;
            }
            case 1: 
            case 3: 
            case 18: 
            case 23: {
                this.hintCount += this.operandReached / 2;
                this.operandReached = 0;
                break;
            }
            case 4: {
                if (isFlex) {
                    this.flex();
                    break;
                }
                this.vMoveTo(factory, isFirst);
                break;
            }
            case 5: {
                this.rLineTo(factory);
                break;
            }
            case 6: 
            case 7: {
                this.hvLineTo(factory, key);
                break;
            }
            case 8: {
                this.rrCurveTo(factory);
                break;
            }
            case 9: {
                this.closePath(factory);
                break;
            }
            case 11: {
                --data.nonSubrCommandCount;
                leaveOperands = true;
                break;
            }
            case 14: {
                this.endchar(factory, rawInt);
                p = dicEnd + 1;
                break;
            }
            case 15: 
            case 16: {
                break;
            }
            case 19: 
            case 20: {
                p = this.mask(p);
                break;
            }
            case 21: {
                this.rMoveTo(factory, isFirst, isFlex);
                break;
            }
            case 22: {
                this.hMoveTo(factory, isFirst, isFlex);
                break;
            }
            case 24: {
                this.rCurveLine(factory);
                break;
            }
            case 25: {
                this.rLineCurve(factory);
                break;
            }
            case 26: 
            case 27: {
                this.vvhhCurveTo(factory, key);
                break;
            }
            case 30: 
            case 31: {
                this.vhhvCurveTo(factory, key);
                break;
            }
            default: {
                leaveOperands = true;
            }
        }
        if (!leaveOperands) {
            this.operandReached = 0;
        }
        return p;
    }

    private void rMoveTo(GlyphFactory factory, boolean isFirst, boolean isFlex) {
        if (isFlex) {
            this.moveToAsFlex();
        } else {
            this.rMoveTo(factory, isFirst);
        }
    }

    private void hMoveTo(GlyphFactory factory, boolean isFirst, boolean isFlex) {
        if (isFlex) {
            double val = this.operandsRead[this.currentOp];
            this.x += val;
            this.pt[this.ptCount] = (float)this.x;
            ++this.ptCount;
            this.pt[this.ptCount] = (float)this.y;
            ++this.ptCount;
        } else {
            this.hMoveTo(factory, isFirst);
        }
    }

    private void getPotentialWidth(int rawInt, DecodeData data) {
        if (this.nominalWidthX.length == 1) {
            data.increasePotentialWidth(this.nominalWidthX[0]);
        } else {
            int glyphNo = this.glyphNumbers.get(String.valueOf(rawInt)) - 1;
            if (glyphNo < this.fdSelect.length) {
                data.increasePotentialWidth(this.nominalWidthX[this.fdSelect[glyphNo]]);
            }
        }
    }

    private void handle2ByteOp(GlyphFactory factory, int rawInt, int key) {
        boolean leaveOperands = false;
        switch (key) {
            case 3078: {
                this.seac(factory, rawInt, this.currentOp);
                break;
            }
            case 3084: {
                this.div();
                leaveOperands = true;
                break;
            }
            case 3089: {
                this.pop();
                leaveOperands = true;
                break;
            }
            case 3106: {
                this.hflex(factory);
                break;
            }
            case 3107: {
                this.flex(factory);
                break;
            }
            case 3108: {
                this.hflex1(factory);
                break;
            }
            case 3109: {
                this.flex1(factory);
                break;
            }
        }
        if (!leaveOperands) {
            this.operandReached = 0;
        }
    }

    private void moveToAsFlex() {
        double val = this.operandsRead[this.currentOp + 1];
        this.y += val;
        val = this.operandsRead[this.currentOp];
        this.x += val;
        this.pt[this.ptCount] = (float)this.x;
        ++this.ptCount;
        this.pt[this.ptCount] = (float)this.y;
        ++this.ptCount;
    }

    private void flex() {
        double val = this.operandsRead[this.currentOp];
        this.y += val;
        this.pt[this.ptCount] = (float)this.x;
        ++this.ptCount;
        this.pt[this.ptCount] = (float)this.y;
        ++this.ptCount;
    }

    private void saveWidth(int glyphNumber, int potentialWidth) {
        if (this.baseFontName != null && this.dynamicVectorRenderer != null && this.dynamicVectorRenderer.isHTMLorSVG()) {
            this.dynamicVectorRenderer.saveAdvanceWidth(this.objID, String.valueOf(glyphNumber - 1), potentialWidth);
            if (!this.defaultWidthsPassed) {
                for (int i = 0; i < this.defaultWidthX.length; ++i) {
                    this.dynamicVectorRenderer.saveAdvanceWidth(this.objID, "JPedalDefaultWidth" + i, this.defaultWidthX[i]);
                }
                this.defaultWidthsPassed = true;
            }
        }
    }

    @Override
    public void setCharString(String glyph, byte[] stream, int glyphNo) {
        this.charStrings.put(glyph, stream);
        this.glyphNumbers.put(glyph, glyphNo);
    }

    @Override
    public void setNameForGlyphIndex(int index, String charName) {
        if (this.nameForGlyphIndex == null) {
            this.nameForGlyphIndex = new String[65536];
        }
        if (index < this.nameForGlyphIndex.length) {
            this.nameForGlyphIndex[index] = charName;
        }
    }

    @Override
    public String getNameForGlyphIndex(int index) {
        return this.nameForGlyphIndex[index];
    }

    @Override
    public boolean is1C() {
        return this.is1C;
    }

    public void setWidthValues(int[] defaultWidthX, int[] nominalWidthX) {
        this.nominalWidthX = nominalWidthX;
        this.defaultWidthX = defaultWidthX;
    }

    @Override
    public void setis1C(boolean is1C) {
        this.is1C = is1C;
    }

    @Override
    public void setRenderer(DynamicVectorRenderer current) {
        this.dynamicVectorRenderer = current;
        if (this.baseFontName != null && this.dynamicVectorRenderer != null && this.dynamicVectorRenderer.isHTMLorSVG()) {
            for (int i = 0; i < this.defaultWidthX.length; ++i) {
                this.dynamicVectorRenderer.saveAdvanceWidth(this.objID, "JPedalDefaultWidth" + i, this.defaultWidthX[i]);
            }
        }
    }

    public void setFDSelect(int[] fdSelect) {
        this.fdSelect = fdSelect;
    }

    @Override
    public boolean containsKey(String key) {
        return this.charStrings.containsKey(key);
    }

    @Override
    public Map<String, byte[]> getCharStringData() {
        return Collections.unmodifiableMap(this.charStrings);
    }

    public int getGlyphNumber(String glyphName) {
        return this.glyphNumbers.get(glyphName);
    }
}

