/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import org.jpedal.PdfDecoderInt;
import org.jpedal.PdfDecoderServer;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;

abstract class BaseTextExtraction {
    private byte[] byteArray;
    private boolean isOpen;
    int maxCount = -1;
    private int lastPage = -1;
    PdfGroupingAlgorithms currentGrouping;
    PdfPageData currentPageData;
    String output_dir;
    ExtractTypes type;
    private String user_dir = System.getProperty("user.dir");
    PdfDecoderInt decode_pdf;
    static final String separator = System.getProperty("file.separator");
    private String password;
    String fileName;
    private boolean extractPlainText;

    void decodeFile(String rootDir) throws PdfException {
        throw new UnsupportedOperationException("decodeFile Not supported yet.");
    }

    BaseTextExtraction(String fileName) {
        this.fileName = fileName;
    }

    BaseTextExtraction(String fileName, boolean extractPlainText) {
        this.fileName = fileName;
        this.extractPlainText = extractPlainText;
    }

    BaseTextExtraction(byte[] byteArray) {
        this.byteArray = byteArray;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    void init() {
        switch (this.type) {
            case FIND_TEXT_IN_RECTANGLE: {
                this.decode_pdf = new PdfDecoderServer(false);
                this.decode_pdf.setExtractionMode(1);
                PdfDecoderServer.init(true);
                break;
            }
            case OUTLINE: {
                this.decode_pdf = new PdfDecoderServer(false);
                this.decode_pdf.setExtractionMode(1);
                PdfDecoderServer.init(true);
                break;
            }
            case TEXT_IN_RECTANGLE: {
                this.decode_pdf = new PdfDecoderServer(false);
                FontMappings.setFontReplacements();
                this.decode_pdf.setExtractionMode(1);
                PdfDecoderServer.init(true);
                if (!this.extractPlainText) break;
                this.decode_pdf.useTextExtraction();
                break;
            }
            case TEXT_AS_WORDLIST: {
                this.decode_pdf = new PdfDecoderServer(true);
                FontMappings.setFontReplacements();
                this.decode_pdf.setExtractionMode(1);
                PdfDecoderServer.init(true);
                this.decode_pdf.useTextExtraction();
                PdfGroupingAlgorithms.useUnrotatedCoords = false;
                break;
            }
            case STRUCTURED_TEXT: {
                this.decode_pdf = new PdfDecoderServer(false);
                PdfDecoderServer.init(false);
                break;
            }
            default: {
                this.decode_pdf = new PdfDecoderServer(false);
                PdfDecoderServer.init(false);
            }
        }
        if (!this.user_dir.endsWith(separator)) {
            this.user_dir = this.user_dir + separator;
        }
    }

    void selectPage(int page) throws PdfException {
        if (page != this.lastPage) {
            this.currentPageData = this.decode_pdf.getPdfPageData();
            this.decode_pdf.flushObjectValues(true);
            try {
                boolean flag = this.decode_pdf.getFormRenderer().getCompData().formsRasterizedForDisplay();
                this.decode_pdf.getFormRenderer().getCompData().setRasterizeForms(true);
                this.decode_pdf.decodePage(page);
                this.decode_pdf.getFormRenderer().getCompData().setRasterizeForms(flag);
            }
            catch (Exception ex) {
                throw new PdfException(ex.getMessage());
            }
            this.currentGrouping = this.decode_pdf.getGroupingObject();
            this.lastPage = page;
        }
    }

    public int getPageCount() {
        this.checkFileOpened();
        return this.decode_pdf.getPageCount();
    }

    public boolean openPDFFile() throws PdfException {
        this.lastPage = -1;
        this.isOpen = false;
        try {
            if (this.fileName != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfFile(this.fileName);
                } else {
                    this.decode_pdf.openPdfFile(this.fileName, this.password);
                }
            } else if (this.byteArray != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfArray(this.byteArray);
                } else {
                    this.decode_pdf.openPdfArray(this.byteArray, this.password);
                }
            } else {
                return false;
            }
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() || !this.decode_pdf.isExtractionAllowed()) {
                if (!this.decode_pdf.isExtractionAllowed()) {
                    throw new PdfException("Not permitted to extract from PDF");
                }
                if (this.password == null) {
                    throw new PdfException("Unable to open encrypted PDF file - call setPassword(passsword) ");
                }
                throw new PdfException("Unable to open encrypted PDF file with password " + this.password);
            }
        }
        catch (Exception e) {
            throw new PdfException(e.getMessage());
        }
        this.isOpen = true;
        return true;
    }

    public void closePDFfile() {
        if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
            this.decode_pdf.flushObjectValues(true);
            this.decode_pdf.closePdfFile();
        }
    }

    void processFiles(String rootDir) throws PdfException {
        if (rootDir.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(rootDir);
        } else {
            File testDir;
            if (!rootDir.endsWith("\\") && !rootDir.endsWith("/")) {
                rootDir = rootDir + separator;
            }
            if (!(testDir = new File(rootDir)).isDirectory()) {
                throw new PdfException("No input directory " + rootDir);
            }
            String[] files = null;
            try {
                File inputFiles = new File(rootDir);
                if (!inputFiles.isDirectory()) {
                    System.err.println(rootDir + " is not a directory. Exiting program");
                } else {
                    files = inputFiles.list();
                }
            }
            catch (Exception ee) {
                throw new PdfException("Exception trying to access file " + ee.getMessage());
            }
            if (files != null) {
                for (String file : files) {
                    if (!file.toLowerCase().endsWith(".pdf")) continue;
                    this.fileName = rootDir + file;
                    this.decodeFile(rootDir + file);
                }
            }
        }
    }

    void checkFileOpened() {
        if (!this.isOpen) {
            throw new RuntimeException("PDF file needs to be opened with openPDFFile() method first");
        }
    }

    static enum ExtractTypes {
        FIND_TEXT_IN_RECTANGLE,
        OUTLINE,
        STRUCTURED_TEXT,
        TEXT_AS_WORDLIST,
        TEXT_IN_RECTANGLE;

    }
}

