/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.idrsolutions.image.utility.SupportedFormats;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.examples.images.BaseImageExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;

public class ExtractClippedImages
extends BaseImageExtraction {
    private static int outputCount;
    private static float[] outputSizes;
    private static String[] outputDirectories;
    private static final Color backgroundColor;

    public ExtractClippedImages(String fileName) {
        super(fileName);
        this.init();
    }

    public ExtractClippedImages(byte[] byteArray) {
        super(byteArray);
        this.init();
    }

    public BufferedImage getClippedImage(int page, int imageNumber) throws PdfException {
        return this.getClippedImage(page, this.getImageName(page, imageNumber));
    }

    private BufferedImage getClippedImage(int page, String image_name) throws PdfException {
        this.selectPage(page);
        return this.decode_pdf.getObjectStore().loadStoredImage("CLIP_" + image_name);
    }

    public static void writeAllClippedImagesToDirs(String inputDir, String outDir, String imageType, String[] subDirs) throws PdfException {
        if (!SupportedFormats.hasEncoderSupportForImageFormat(imageType)) {
            throw new RuntimeException("Unknown image format - " + imageType);
        }
        ExtractClippedImages extract = new ExtractClippedImages(inputDir);
        extract.setup(outDir, imageType, subDirs);
        extract.processFiles(inputDir);
        extract.closePDFfile();
    }

    private void setup(String outDir, String imageType, String[] subDirs) throws PdfException {
        if (!outDir.endsWith(separator)) {
            outDir = outDir + separator;
        }
        this.imageType = imageType;
        outputCount = subDirs.length / 2;
        outputSizes = new float[outputCount];
        outputDirectories = new String[outputCount];
        for (int i = 0; i < outputCount; ++i) {
            try {
                ExtractClippedImages.outputSizes[i] = Float.parseFloat(subDirs[i * 2]);
            }
            catch (Exception e) {
                throw new PdfException("Exception " + e + " reading integer " + subDirs[i * 2]);
            }
            try {
                File dir;
                ExtractClippedImages.outputDirectories[i] = outDir + subDirs[1 + i * 2];
                if (!outputDirectories[i].endsWith("\\") && !outputDirectories[i].endsWith("/")) {
                    int n = i;
                    outputDirectories[n] = outputDirectories[n] + separator;
                }
                if ((dir = new File(outputDirectories[i])).exists()) continue;
                dir.mkdirs();
                continue;
            }
            catch (Exception e) {
                throw new PdfException("Exception " + e + " with directory " + subDirs[4 + i * 2]);
            }
        }
    }

    @Override
    void decodeFile(String file_name) throws PdfException {
        if (this.openPDFFile()) {
            boolean start = true;
            int end = this.getPageCount();
            try {
                for (int page = 1; page < end + 1; ++page) {
                    int i;
                    LogWriter.writeLog("Decoding Page " + page);
                    int image_count = this.getImageCount(page);
                    if (image_count > 0) {
                        LogWriter.writeLog("page " + page + "contains " + image_count + " images");
                    } else {
                        LogWriter.writeLog("No bitmapped images on page " + page);
                    }
                    LogWriter.writeLog("Writing out " + image_count + " images");
                    float[] x1 = new float[image_count];
                    float[] y1 = new float[image_count];
                    float[] w = new float[image_count];
                    float[] h = new float[image_count];
                    String[] image_name = new String[image_count];
                    BufferedImage[] image = new BufferedImage[image_count];
                    for (i = 0; i < image_count; ++i) {
                        image_name[i] = this.getImageName(page, i);
                        x1[i] = this.pdf_images.getImageXCoord(i);
                        y1[i] = this.pdf_images.getImageYCoord(i);
                        w[i] = this.pdf_images.getImageWidth(i);
                        h[i] = this.pdf_images.getImageHeight(i);
                        image[i] = this.getClippedImage(page, image_name[i]);
                    }
                    for (i = 0; i < image_count; ++i) {
                        if (image[i] == null) continue;
                        this.generateVersions(file_name, page, "<PAGELOCATION x1=\"" + x1[i] + "\" y1=\"" + (y1[i] + h[i]) + "\" x2=\"" + (x1[i] + w[i]) + "\" y2=\"" + y1[i] + "\" />\n", image[i], i);
                    }
                    this.decode_pdf.flushObjectValues(true);
                }
            }
            catch (Exception e) {
                this.decode_pdf.closePdfFile();
                LogWriter.writeLog("Exception " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.decode_pdf.closePdfFile();
    }

    private void generateVersions(String file_name, int page, String s, BufferedImage bufferedImage, int i) {
        for (int versions = 0; versions < outputCount; ++versions) {
            try {
                BufferedImage image_to_save = bufferedImage;
                if (image_to_save == null) continue;
                int index = file_name.lastIndexOf(92);
                if (index == -1) {
                    index = file_name.lastIndexOf(47);
                }
                if (index == -1) {
                    index = 0;
                }
                String nameToUse = file_name.substring(index, file_name.length() - 4);
                String outputName = outputDirectories[versions] + nameToUse + '_' + page + '_' + i;
                float scaling = 1.0f;
                int newHeight = image_to_save.getHeight();
                if (outputSizes[versions] > 0.0f) {
                    scaling = outputSizes[versions] / (float)newHeight;
                    if (scaling > 1.0f) {
                        scaling = 1.0f;
                    } else {
                        Image scaledImage = image_to_save.getScaledInstance(-1, (int)outputSizes[versions], 4);
                        image_to_save = new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 2);
                        Graphics2D g2 = image_to_save.createGraphics();
                        g2.drawImage(scaledImage, 0, 0, null);
                    }
                }
                if (this.imageType.startsWith("jp") && !this.imageType.equalsIgnoreCase("jp2")) {
                    int iw = image_to_save.getWidth();
                    int ih = image_to_save.getHeight();
                    BufferedImage background = new BufferedImage(iw, ih, 1);
                    Graphics2D g2 = (Graphics2D)background.getGraphics();
                    g2.setPaint(backgroundColor);
                    g2.fillRect(0, 0, iw, ih);
                    g2.drawImage((Image)image_to_save, 0, 0, null);
                    image_to_save = background;
                }
                if (image_to_save.getType() == 0) {
                    image_to_save = ColorSpaceConvertor.convertToARGB(image_to_save);
                }
                try {
                    DefaultImageHelper.write(image_to_save, this.imageType, outputName + '.' + this.imageType);
                }
                catch (IOException ex) {
                    LogWriter.writeLog("Exception in writing image " + ex);
                }
                try (OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(outputName + ".xml"), StandardCharsets.UTF_8);){
                    output_stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    output_stream.write("<!-- Pixel Location of image x1,y1,x2,y2\n");
                    output_stream.write("(x1,y1 is top left corner)\n");
                    output_stream.write("(origin is bottom left corner)  -->\n");
                    output_stream.write("\n\n<META>\n");
                    output_stream.write(s);
                    output_stream.write("<FILE>" + file_name + "</FILE>\n");
                    output_stream.write("<ORIGINALHEIGHT>" + newHeight + "</ORIGINALHEIGHT>\n");
                    output_stream.write("<SCALEDHEIGHT>" + image_to_save.getHeight() + "</SCALEDHEIGHT>\n");
                    output_stream.write("<SCALING>" + scaling + "</SCALING>\n");
                    output_stream.write("</META>\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception " + ee + " in extracting images");
            }
        }
    }

    public static void main(String[] args) {
        String[] subDirs = ExtractClippedImages.validateInputValues(args);
        try {
            ExtractClippedImages.writeAllClippedImagesToDirs(args[0], args[1], args[2], subDirs);
        }
        catch (PdfException e) {
            throw new RuntimeException(e);
        }
    }

    private static String[] validateInputValues(String[] args) throws RuntimeException {
        String[] subDirs;
        String inputDir;
        if (args.length >= 5 && args.length % 2 == 1) {
            LogWriter.writeLog("Values read");
            LogWriter.writeLog("inputDir=" + args[0]);
            LogWriter.writeLog("type=" + args[1]);
            LogWriter.writeLog("Directory and height pair values" + args[3] + " <> " + args[4] + '<');
            inputDir = args[0];
            outputCount = args.length - 3;
            subDirs = new String[outputCount];
            for (int i = 0; i < outputCount; ++i) {
                LogWriter.writeLog(args[i + 3]);
                if (i % 2 == 0 && !args[i + 3].matches("((-|\\+)?[0-9]+(\\.[0-9]+)?)+")) {
                    throw new RuntimeException("Invalid value: " + args[i + 3]);
                }
                subDirs[i] = args[i + 3];
            }
        } else {
            if ((args.length - 3) % 2 == 1) {
                throw new RuntimeException("Value/Directory pairs invalid");
            }
            System.out.println("Requires");
            System.out.println("inputDir processedDir imageOutputType");
            System.out.println("height Directory (as many pairs as you like)");
            throw new RuntimeException("Not enough parameters passed to software");
        }
        File pdf_file = new File(inputDir);
        if (!pdf_file.exists()) {
            throw new RuntimeException("Directory " + inputDir + " not found");
        }
        return subDirs;
    }

    @Override
    void init() {
        this.type = BaseImageExtraction.ExtractTypes.CLIPPED_IMAGES;
        super.init();
    }

    public int getImageCount(int page) throws PdfException {
        this.selectPage(page);
        return this.pdf_images.getImageCount();
    }

    private String getImageName(int page, int imageNumber) throws PdfException {
        this.selectPage(page);
        return this.pdf_images.getImageName(imageNumber);
    }

    static {
        backgroundColor = Color.WHITE;
    }
}

