/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import java.io.File;
import org.jpedal.PdfDecoderInt;
import org.jpedal.PdfDecoderServer;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.PdfImageData;

abstract class BaseImageExtraction {
    private byte[] byteArray;
    private boolean isOpen;
    private int lastPage = -1;
    PdfImageData pdf_images;
    String output_dir;
    String imageType = "png";
    String name = "image";
    ExtractTypes type = ExtractTypes.IMAGES;
    String user_dir = System.getProperty("user.dir");
    PdfDecoderInt decode_pdf;
    static final String separator = System.getProperty("file.separator");
    private String password;
    String fileName;

    void decodeFile(String rootDir) throws PdfException {
        throw new UnsupportedOperationException("decodeFile Not supported yet.");
    }

    BaseImageExtraction(String fileName) {
        this.fileName = fileName;
    }

    BaseImageExtraction(byte[] byteArray) {
        this.byteArray = byteArray;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    void init() {
        this.decode_pdf = new PdfDecoderServer(false);
        switch (this.type) {
            case IMAGES: {
                String opiFlag = System.getProperty("org.jpedal.opi");
                if (opiFlag == null) {
                    this.decode_pdf.setExtractionMode(1030);
                    break;
                }
                this.decode_pdf.setExtractionMode(1286);
                break;
            }
            case CLIPPED_IMAGES: {
                this.decode_pdf.setExtractionMode(36, 1.0f);
                break;
            }
        }
        if (!this.user_dir.endsWith(separator)) {
            this.user_dir = this.user_dir + separator;
        }
    }

    void selectPage(int page) throws PdfException {
        if (page != this.lastPage) {
            this.decode_pdf.flushObjectValues(true);
            try {
                this.decode_pdf.decodePage(page);
            }
            catch (Exception ex) {
                throw new PdfException(ex.getMessage());
            }
            this.pdf_images = this.decode_pdf.getPdfImageData();
            this.lastPage = page;
        }
    }

    public int getPageCount() {
        return this.decode_pdf.getPageCount();
    }

    void checkFileOpened() {
        if (!this.isOpen) {
            throw new RuntimeException("PDF file needs to be opened with openPDFFile() method first");
        }
    }

    public boolean openPDFFile() throws PdfException {
        int pointer;
        this.isOpen = false;
        this.lastPage = -1;
        if (this.fileName != null && (pointer = this.fileName.lastIndexOf(separator)) != -1) {
            this.name = this.fileName.substring(pointer + 1, this.fileName.length() - 4);
        }
        try {
            if (this.fileName != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfFile(this.fileName);
                } else {
                    this.decode_pdf.openPdfFile(this.fileName, this.password);
                }
            } else if (this.byteArray != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfArray(this.byteArray);
                } else {
                    this.decode_pdf.openPdfArray(this.byteArray, this.password);
                }
            } else {
                return false;
            }
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() || !this.decode_pdf.isExtractionAllowed()) {
                if (!this.decode_pdf.isExtractionAllowed()) {
                    throw new PdfException("Not permitted to extract from PDF");
                }
                if (this.password == null) {
                    throw new PdfException("Unable to open encrypted PDF file - call setPassword(passsword) ");
                }
                throw new PdfException("Unable to open encrypted PDF file with password " + this.password);
            }
        }
        catch (Exception e) {
            throw new PdfException(e.getMessage());
        }
        this.isOpen = true;
        return true;
    }

    public void closePDFfile() {
        if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
            this.decode_pdf.flushObjectValues(true);
            this.decode_pdf.closePdfFile();
        }
    }

    void processFiles(String rootDir) throws PdfException {
        if (rootDir.toLowerCase().endsWith(".pdf")) {
            this.decodeFile(rootDir);
        } else {
            File testDir;
            if (!rootDir.endsWith("\\") && !rootDir.endsWith("/")) {
                rootDir = rootDir + separator;
            }
            if (!(testDir = new File(rootDir)).isDirectory()) {
                throw new PdfException("No input directory " + rootDir);
            }
            String[] files = null;
            try {
                File inputFiles = new File(rootDir);
                if (!inputFiles.isDirectory()) {
                    System.err.println(rootDir + " is not a directory. Exiting program");
                } else {
                    files = inputFiles.list();
                }
            }
            catch (Exception ee) {
                throw new PdfException("Exception trying to access file " + ee.getMessage());
            }
            if (files != null) {
                for (String file : files) {
                    if (!file.toLowerCase().endsWith(".pdf")) continue;
                    this.fileName = rootDir + file;
                    this.decodeFile(rootDir + file);
                }
            }
        }
    }

    static enum ExtractTypes {
        IMAGES,
        CLIPPED_IMAGES,
        RASTERIZED_PAGE;

    }
}

