/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorMapping;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.LimitedArray;
import org.jpedal.color.PdfColor;
import org.jpedal.color.SeparationColorSpace;

public class DeviceNColorSpace
extends SeparationColorSpace {
    private final int[] lookup = new int[256];
    private final LimitedArray lim = new LimitedArray();

    DeviceNColorSpace(int componentCount, ColorMapping colorMapper, float[] domain, GenericColorSpace altCS) {
        this.setType(960981604);
        this.componentCount = componentCount;
        this.colorMapper = colorMapper;
        this.domain = domain;
        this.altCS = altCS;
    }

    @Override
    public void setColor(float[] raw) {
        if (this.getIndexedMap() != null && !this.isConverted) {
            raw = this.flattenIndexedValue(raw);
        }
        if (raw.length == 1) {
            int key = (int)(raw[0] * 255.0f);
            if (this.lookup[key] != 0) {
                int v = this.lookup[key];
                this.altCS.currentColor = new PdfColor(v >> 16 & 0xFF, v >> 8 & 0xFF, v & 0xFF);
            } else {
                float[] operand = this.colorMapper.getOperandFloat(raw);
                this.altCS.setColor(operand);
                this.lookup[key] = this.altCS.getColor().getRGB();
            }
        } else {
            long key = 0L;
            for (float n : raw) {
                key = key << 8 | (long)((int)(n * 255.0f));
            }
            int v = this.lim.get(key);
            if (v != 0) {
                this.altCS.currentColor = new PdfColor(v >> 16 & 0xFF, v >> 8 & 0xFF, v & 0xFF);
            } else {
                float[] operand = this.colorMapper.getOperandFloat(raw);
                this.altCS.setColor(operand);
                this.lim.put(key, this.altCS.getColor().getRGB());
            }
        }
    }

    @Override
    public BufferedImage dataToRGB(byte[] data, int w, int h) {
        return this.createImage(w, h, data);
    }

    @Override
    BufferedImage createImage(int w, int h, byte[] rawData) {
        byte[] rgb = new byte[w * h * 3];
        int bytesCount = rawData.length;
        int byteCount = rawData.length / this.componentCount;
        int[] values = new int[this.componentCount];
        int j = 0;
        int j2 = 0;
        for (int i = 0; i < byteCount && j < bytesCount; ++i) {
            for (int comp = 0; comp < this.componentCount; ++comp) {
                values[comp] = rawData[j] & 0xFF;
                ++j;
            }
            this.setColor(values);
            int foreground = this.altCS.currentColor.getRGB();
            rgb[j2] = (byte)(foreground >> 16 & 0xFF);
            rgb[j2 + 1] = (byte)(foreground >> 8 & 0xFF);
            rgb[j2 + 2] = (byte)(foreground & 0xFF);
            j2 += 3;
        }
        int[] bands = new int[]{0, 1, 2};
        BufferedImage image = new BufferedImage(w, h, 1);
        DataBufferByte dataBuf = new DataBufferByte(rgb, rgb.length);
        WritableRaster raster = Raster.createInterleavedRaster(dataBuf, w, h, w * 3, 3, bands, null);
        image.setData(raster);
        return image;
    }

    public byte[] getRGBBytes(byte[] rawData, int w, int h) {
        byte[] rgb = new byte[w * h * 3];
        int bytesCount = rawData.length;
        int byteCount = rawData.length / this.componentCount;
        int[] values = new int[this.componentCount];
        int j = 0;
        int j2 = 0;
        for (int i = 0; i < byteCount && j < bytesCount; ++i) {
            for (int comp = 0; comp < this.componentCount; ++comp) {
                values[comp] = rawData[j] & 0xFF;
                ++j;
            }
            this.setColor(values);
            int foreground = this.altCS.currentColor.getRGB();
            rgb[j2] = (byte)(foreground >> 16 & 0xFF);
            rgb[j2 + 1] = (byte)(foreground >> 8 & 0xFF);
            rgb[j2 + 2] = (byte)(foreground & 0xFF);
            j2 += 3;
        }
        return rgb;
    }
}

