/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import org.jpedal.color.FastColorSpaceCMYK;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.ColorSpaceConvertor;

public class DeviceCMYKColorSpace
extends GenericColorSpace {
    private float lastC = -1.0f;
    private float lastM = -1.0f;
    private float lastY = -1.0f;
    private float lastK = -1.0f;
    private static final ColorSpace CMYK = new FastColorSpaceCMYK();

    @Override
    public void invalidateCaching(int color) {
        super.invalidateCaching(color);
        this.lastC = -1.0f;
        this.lastM = -1.0f;
        this.lastY = -1.0f;
        this.lastK = -1.0f;
    }

    public DeviceCMYKColorSpace() {
        this.componentCount = 4;
        this.cs = CMYK;
        this.setType(1498837125);
    }

    @Override
    public final BufferedImage dataToRGB(byte[] data, int width, int height) {
        return ColorSpaceConvertor.convertFromICCCMYK(width, height, data);
    }

    @Override
    public final void setColor(float[] operand) {
        int length = operand.length;
        if (this.getIndexedMap() != null && !this.isConverted) {
            operand = this.flattenIndexedValue(operand);
            length = 4;
        }
        this.c = 1.0f;
        this.y = 1.0f;
        this.m = 1.0f;
        this.k = 1.0f;
        switch (length) {
            case 1: {
                this.c = operand[0];
                this.m = operand[0];
                this.y = operand[0];
                this.k = operand[0];
                break;
            }
            case 2: {
                this.c = operand[0];
                this.m = operand[1];
                break;
            }
            case 3: {
                this.c = operand[0];
                this.m = operand[1];
                this.y = operand[2];
                break;
            }
            default: {
                this.c = operand[0];
                this.m = operand[1];
                this.y = operand[2];
                this.k = operand[3];
            }
        }
        if (this.lastC != this.c || this.lastM != this.m || this.lastY != this.y || this.lastK != this.k) {
            this.rawValues = new float[4];
            this.rawValues[0] = this.c;
            this.rawValues[1] = this.m;
            this.rawValues[2] = this.y;
            this.rawValues[3] = this.k;
            this.lastC = this.c;
            this.lastM = this.m;
            this.lastY = this.y;
            this.lastK = this.k;
            int cc = (int)(this.c * 255.0f);
            int mm = (int)(this.m * 255.0f);
            int yy = (int)(this.y * 255.0f);
            int kk = (int)(this.k * 255.0f);
            int bb = ExternalHandlers.ImageLib.convertCMYKtoRGB(cc, mm, yy, kk);
            this.currentColor = new PdfColor(bb);
        }
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] data, int w, int h) {
        byte[] output;
        int pixelCount = w * h * 4;
        int dataSize = data.length;
        if (pixelCount > dataSize) {
            pixelCount = dataSize - 3;
        }
        if ((output = ExternalHandlers.ImageLib.convertCMYK2RGB(w, h, pixelCount, data)) != null) {
            return output;
        }
        return DeviceCMYKColorSpace.convertCMYK2RGBWithSimple(w, h, pixelCount, data);
    }

    public static byte[] convertCMYK2RGBWithSimple(int w, int h, int pixelCount, byte[] data) {
        byte[] output = new byte[w * h * 3];
        int pp = 0;
        for (int i = 0; i < pixelCount; i += 4) {
            float cc = (float)(data[i] & 0xFF) / 255.0f;
            float mm = (float)(data[i + 1] & 0xFF) / 255.0f;
            float yy = (float)(data[i + 2] & 0xFF) / 255.0f;
            float kk = (float)(data[i + 3] & 0xFF) / 255.0f;
            output[pp++] = (byte)(255.0f * (1.0f - cc) * (1.0f - kk));
            output[pp++] = (byte)(255.0f * (1.0f - mm) * (1.0f - kk));
            output[pp++] = (byte)(255.0f * (1.0f - yy) * (1.0f - kk));
        }
        return output;
    }

    @Override
    public final byte[] convertIndexToRGB(byte[] index) {
        this.isConverted = true;
        return this.convert4Index(index);
    }
}

