/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jpedal.FileAccess;
import org.jpedal.Parser;
import org.jpedal.PdfDecoderInt;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.display.Display;
import org.jpedal.display.DisplayOffsets;
import org.jpedal.display.GUIDisplay;
import org.jpedal.display.PageOffsets;
import org.jpedal.display.swing.SingleDisplay;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.external.RenderChangeListener;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.EmptyActionHandler;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.outlines.OutlineData;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.structuredtext.MarkedContentGenerator;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.DecoderResults;
import org.jpedal.parser.SwingPrinter;
import org.jpedal.render.BaseDisplay;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.RenderUtils;
import org.jpedal.text.TextLines;
import org.jpedal.utils.DPIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.ScalingFactory;
import org.w3c.dom.Document;

public class PdfDecoder
extends JPanel
implements Printable,
Pageable,
PdfDecoderInt {
    public static final String version;
    private BufferedImage previewImage;
    private String previewText;
    final DecoderOptions options = new DecoderOptions();
    public final SwingPrinter swingPrinter = new SwingPrinter();
    private final ExternalHandlers externalHandlers = new ExternalHandlers();
    private final PdfResources res = new PdfResources();
    final FileAccess fileAccess = new FileAccess(this.externalHandlers, this.res, this.options);
    private final DecoderResults resultsFromDecode = new DecoderResults();
    final Parser parser = new Parser(this.externalHandlers, this.options, this.fileAccess, this.res, this.resultsFromDecode);
    private final DPIFactory scalingdpi = new DPIFactory();
    private final DisplayOffsets displayOffsets = new DisplayOffsets();
    private boolean useNewGraphicsMode = true;
    public Display pages;
    private boolean isNewRotationSet;
    private int displayRotation;
    private int x_size = 100;
    private int y_size = 100;
    private float scaling = 1.0f;
    private boolean alwaysEncryptFile;
    private Border myBorder;
    private StatusBar statusBar;
    int specialMode = -1;
    private int textPrint;
    private Cursor defaultCursor;
    private transient int lastPageNumber = -1;
    private transient int lastDisplayRotation = -1;
    private transient float lastScaling = -1.0f;
    private transient Rectangle lastVisibleRect = new Rectangle(0, 0, 1, 1);
    private transient Rectangle lastBounds = new Rectangle(0, 0, 1, 1);
    private transient BufferedImage offScreenImage;
    private transient int offScreenMultiplier = -1;

    @Override
    public void setEncryptTempFiles() {
        this.alwaysEncryptFile = true;
    }

    @Override
    public boolean isOpen() {
        return this.fileAccess.isOpen();
    }

    private void drawPreviewImage(Graphics2D g2, Rectangle visibleRect) {
        if (this.previewImage != null) {
            int iw = this.previewImage.getWidth();
            int ih = this.previewImage.getHeight();
            int textWidth = g2.getFontMetrics().stringWidth(this.previewText);
            int width = Math.max(iw, textWidth);
            int x = visibleRect.x + visibleRect.width - 40 - width;
            int y = (visibleRect.y + visibleRect.height - 20 - ih) / 2;
            Composite original = g2.getComposite();
            g2.setPaint(Color.BLACK);
            g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
            g2.fill(new RoundRectangle2D.Double(x - 10, y - 10, width + 20, ih + 35, 10.0, 10.0));
            g2.setComposite(original);
            g2.setPaint(Color.WHITE);
            g2.drawImage((Image)this.previewImage, x += (width - iw) / 2, y, null);
            int xOffset = (iw + 20 - textWidth) / 2;
            g2.drawString(this.previewText, x + xOffset - 10, y + ih + 15);
        }
    }

    @Override
    public Document getMarkedContent() {
        return new MarkedContentGenerator().getMarkedContentTree(this.res, this.fileAccess.getPdfPageData(), this.getIO());
    }

    @Override
    public ExternalHandlers getExternalHandler() {
        return this.externalHandlers;
    }

    @Override
    public int getDisplayRotation() {
        return this.displayRotation;
    }

    @Override
    public int getPageNumber() {
        return this.fileAccess.getPageNumber();
    }

    @Override
    public void setDisplayRotation(int newRotation) {
        this.displayRotation = newRotation;
    }

    @Override
    public Display getPages() {
        return this.pages;
    }

    @Override
    public int getlastPageDecoded() {
        return this.fileAccess.getLastPageDecoded();
    }

    @Override
    public DisplayOffsets getDisplayOffsets() {
        return this.displayOffsets;
    }

    @Override
    public Iterator<Integer> getPageInfo(int type) {
        return this.resultsFromDecode.getPageInfo(type);
    }

    @Override
    public OutlineData getOutlineData() {
        return this.res.getOutlineData();
    }

    @Override
    public boolean isLoadingLinearizedPDF() {
        return this.fileAccess.linearParser.linearizedBackgroundReaderer != null && this.fileAccess.linearParser.linearizedBackgroundReaderer.isAlive();
    }

    @Override
    public void setScaling(float scaleFactor) {
        this.scaling = scaleFactor;
    }

    @Override
    public int getPageAlignment() {
        return this.options.getPageAlignment();
    }

    public static void init(boolean newEmbedWidthData) {
        DecoderOptions.embedWidthData = newEmbedWidthData;
    }

    public PdfDecoder(boolean newRender) {
        this.init2(newRender);
    }

    public PdfDecoder() {
        this.init2(true);
    }

    private void init2(boolean render) {
        String alwaysEncrypt = System.getProperty("org.jpedal.alwaysEncryptLocalFileSystemData");
        this.alwaysEncryptFile = alwaysEncrypt != null && alwaysEncrypt.equalsIgnoreCase("true");
        this.pages = new SingleDisplay(this, this.options);
        this.options.setRenderPage(render);
        if (!FontMappings.fontsInitialised) {
            FontMappings.initFonts();
            FontMappings.fontsInitialised = true;
        }
        if (render) {
            this.setLayout(null);
            this.setPreferredSize(new Dimension(100, 100));
        }
    }

    public static void disposeAllStatic() {
        StandardFonts.dispose();
        FontMappings.dispose();
    }

    @Override
    public final void dispose() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.parser.disposeObjects();
        } else {
            Runnable doPaintComponent = this.parser::disposeObjects;
            SwingUtilities.invokeLater(doPaintComponent);
        }
        for (PropertyChangeListener propertyChangeListener : this.getPropertyChangeListeners()) {
            this.removePropertyChangeListener(propertyChangeListener);
        }
        for (EventListener eventListener : this.getComponentListeners()) {
            this.removeComponentListener((ComponentListener)eventListener);
        }
        for (EventListener eventListener : this.getMouseListeners()) {
            this.removeMouseListener((MouseListener)eventListener);
        }
        this.removeAll();
    }

    @Override
    public final void closePdfFile() {
        if (this.pages != null) {
            this.pages.stopGeneratingPage();
            this.pages.disableScreen();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.validate();
        } else {
            Runnable doPaintComponent = this::validate;
            SwingUtilities.invokeLater(doPaintComponent);
        }
        if (this.externalHandlers.getFormRenderer() != null) {
            this.externalHandlers.getFormRenderer().getCompData().dispose();
        }
        this.swingPrinter.clear();
        this.fileAccess.closePdfFile();
    }

    public final PdfData getPdfBackgroundData() {
        return this.parser.getPdfBackgroundData();
    }

    @Override
    public final PdfData getPdfData() throws PdfException {
        return this.parser.getPdfData();
    }

    @Override
    public final boolean hasOutline() {
        return this.res.hasOutline();
    }

    @Override
    public final Document getOutlineAsXML() {
        return this.res.getOutlineAsXML(this.getIO());
    }

    @Override
    public final PdfPageData getPdfPageData() {
        return this.fileAccess.getPdfPageData();
    }

    public void setPagePrintRange(int start, int end) throws PdfException {
        this.swingPrinter.setPagePrintRange(start, end, this.fileAccess.getPageCount());
    }

    public void setTextPrint(int textPrint) {
        this.textPrint = textPrint;
    }

    public void useLogicalPrintOffset(int pagesPrinted) {
        this.swingPrinter.useLogicalPrintOffset(pagesPrinted);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int page) throws PrinterException {
        return this.swingPrinter.print(graphics, pageFormat, page, this.getIO(), this, this.externalHandlers, this.res, this.getPageNumber(), this.options);
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int pageIndex) throws PdfException {
        return this.getPageAsHiRes(pageIndex, false);
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int pageIndex, Map<Integer, Object> params) throws PdfException {
        if (params != null) {
            this.modifyNonstaticJPedalParameters(params);
        }
        return this.getPageAsHiRes(pageIndex);
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int pageIndex, Map<Integer, Object> params, boolean isTransparent) throws PdfException {
        if (params != null) {
            this.options.set(params);
        }
        return this.getPageAsHiRes(pageIndex, isTransparent);
    }

    @Override
    public synchronized BufferedImage getPageAsHiRes(int pageIndex, boolean isTransparent) throws PdfException {
        return this.parser.getPageAsHiRes(pageIndex, isTransparent);
    }

    @Override
    public BufferedImage getPageAsImage(int pageIndex) throws PdfException {
        BufferedImage img = this.getPageAsImage(pageIndex, false, this.scaling);
        if (this.pages != null) {
            AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
            formRenderer.getCompData().resetScaledLocation(this.pages.getOldScaling(), this.displayRotation, 0);
        }
        return img;
    }

    @Override
    public BufferedImage getPageAsImage(int pageIndex, float scaling) throws PdfException {
        BufferedImage img = this.getPageAsImage(pageIndex, false, scaling);
        if (this.pages != null) {
            AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
            formRenderer.getCompData().resetScaledLocation(this.pages.getOldScaling(), this.displayRotation, 0);
        }
        return img;
    }

    @Override
    public BufferedImage getPageAsTransparentImage(int pageIndex) throws PdfException {
        return this.getPageAsImage(pageIndex, true, this.scaling);
    }

    private BufferedImage getPageAsImage(int pageIndex, boolean imageIsTransparent, float scaling) throws PdfException {
        Parser localParser = this.parser.createNewParser();
        localParser.setParms(this.displayRotation, scaling, 0, this.specialMode);
        return localParser.getPageAsImage(pageIndex, imageIsTransparent);
    }

    @Override
    public float getHiResUpscaleFactor() {
        return this.parser.getHiResUpscaleFactor();
    }

    @Override
    public final void flushObjectValues(boolean reinit) {
        this.parser.flushObjectValues(reinit);
    }

    @Override
    public final PdfImageData getPdfImageData() {
        return this.parser.getPdfImageData();
    }

    public final PdfImageData getPdfBackgroundImageData() {
        return this.parser.getPdfBackgroundImageData();
    }

    @Override
    public final void setRenderMode(int mode) {
        this.parser.setRenderMode(mode);
    }

    @Override
    public final void setExtractionMode(int mode) {
        this.parser.setExtractionMode(mode);
    }

    @Override
    public void modifyNonstaticJPedalParameters(Map<Integer, Object> values) throws PdfException {
        this.options.set(values);
        if (values.containsKey(JPedalSettings.DISPLAY_BACKGROUND)) {
            this.setBackground(this.options.getDisplayBackgroundColor());
        }
    }

    public static void modifyJPedalParameters(Map<Integer, Object> values) throws PdfException {
        if (values != null) {
            DecoderOptions.modifyJPedalParameters(values);
        }
    }

    @Override
    public final PdfFileInformation getFileInformationData() {
        return this.res.getMetaData(this.getIO());
    }

    @Override
    public final void setExtractionMode(int mode, float scaling) {
        this.scaling = scaling;
        this.parser.setExtractionMode(mode, scaling);
    }

    @Override
    public DPIFactory getDPIFactory() {
        return this.scalingdpi;
    }

    @Override
    public void setPageParameters(float scaling, int pageNumber) {
        boolean layersChanged;
        PdfLayerList layers;
        this.fileAccess.setPageNumber(pageNumber);
        this.parser.resetMultiplyer();
        if (this.getDisplayView() == 5 && scaling == -100.0f) {
            return;
        }
        if (scaling > 0.0f) {
            this.scaling = scaling;
        } else {
            scaling = this.scaling;
        }
        if (this.pages != null) {
            this.pages.setScaling(scaling);
        }
        if ((layers = this.res.getPdfLayerList()) != null && (layersChanged = layers.setZoom(this.scalingdpi.removeScaling(scaling)))) {
            this.decodePage(-1);
        }
        PdfPageData pageData = this.fileAccess.getPdfPageData();
        pageData.setScalingValue(scaling);
        int mediaW = pageData.getMediaBoxWidth(pageNumber);
        int max_y = pageData.getMediaBoxHeight(pageNumber);
        int cropW = pageData.getCropBoxWidth(pageNumber);
        int cropH = pageData.getCropBoxHeight(pageNumber);
        this.x_size = (int)((float)cropW * scaling);
        this.y_size = (int)((float)cropH * scaling);
        if (!this.isNewRotationSet && this.getDisplayView() != 5) {
            this.displayRotation = pageData.getRotation(pageNumber);
        } else {
            this.isNewRotationSet = false;
        }
        DynamicVectorRenderer currentDisplay = this.fileAccess.getDynamicRenderer();
        currentDisplay.init(mediaW, max_y, this.options.getPageColor());
        RenderUtils.setDisplayOptions(currentDisplay, this.options);
        this.pages.init(scaling, this.displayRotation, this.getPageNumber(), currentDisplay, true);
        this.pages.setPageRotation(this.displayRotation);
        AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
        if (formRenderer != null) {
            formRenderer.getCompData().setForceRedraw(true);
        }
    }

    @Override
    public void setPageParameters(float scaling, int pageNumber, int newRotation) {
        this.isNewRotationSet = true;
        this.displayRotation = newRotation;
        if (this.getDisplayView() == 5) {
            this.pages.init(0.0f, this.displayRotation, 0, null, false);
        } else {
            this.setPageParameters(scaling, pageNumber);
        }
    }

    @Override
    public void setStatusBarObject(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    @Override
    public void waitForDecodingToFinish() {
        this.fileAccess.waitForDecodingToFinish();
    }

    @Override
    public void setPreviewThumbnail(BufferedImage previewImage, String previewText) {
        this.previewImage = previewImage;
        this.previewText = previewText;
        this.lastPageNumber = -1;
    }

    @Override
    public DynamicVectorRenderer getDynamicRenderer() {
        return this.fileAccess.getDynamicRenderer();
    }

    @Override
    public DynamicVectorRenderer getDynamicRenderer(boolean reset) {
        return this.fileAccess.getDynamicRenderer(reset);
    }

    public void setPDFCursor(Cursor c) {
        if (GUIDisplay.allowChangeCursor) {
            this.setCursor(c);
        }
    }

    public void setDefaultCursor(Cursor c) {
        this.defaultCursor = c;
        if (GUIDisplay.allowChangeCursor) {
            this.setCursor(c);
        }
    }

    @Override
    public void setCursor(Cursor c) {
        if (GUIDisplay.allowChangeCursor) {
            if (c.getType() == 0 && this.defaultCursor != null) {
                super.setCursor(this.defaultCursor);
            } else {
                super.setCursor(c);
            }
        }
    }

    @Override
    public final void decodePage(int rawPage) {
        if (this.getDisplayView() != 1) {
            return;
        }
        this.lastPageNumber = -1;
        boolean isPageAvailable = this.isPageAvailable(rawPage);
        PdfObject pdfObject = this.fileAccess.linearParser.getLinearPageObject();
        if (!isPageAvailable) {
            return;
        }
        if (pdfObject != null) {
            this.fileAccess.readAllPageReferences(true, pdfObject, new HashMap<String, Integer>(1000), new HashMap<String, String>(1000), rawPage, this.getFormRenderer(), this.res, this.options.getInsetW(), this.options.getInsetH());
        }
        this.parser.setStatusBar(this.statusBar);
        this.parser.setParms(this.displayRotation, this.scaling, (int)this.pages.getIndent(), this.specialMode);
        this.parser.decodePage(rawPage);
        this.pages.refreshDisplay();
    }

    @Override
    public synchronized boolean isPageAvailable(int rawPage) {
        return this.parser.isPageAvailable(rawPage);
    }

    public void printAdditionalObjectsOverPage(int page, int[] type, Color[] colors, Object[] obj) {
        this.swingPrinter.printAdditionalObjectsOverPage(page, type, colors, obj);
    }

    public void printAdditionalObjectsOverAllPages(int[] type, Color[] colors, Object[] obj) {
        this.swingPrinter.printAdditionalObjectsOverAllPages(type, colors, obj);
    }

    @Override
    public void drawAdditionalObjectsOverPage(int page, int[] type, Color[] colors, Object[] obj) throws PdfException {
        DynamicVectorRenderer currentDisplay = this.fileAccess.getDynamicRenderer();
        if (page == this.getPageNumber()) {
            currentDisplay.drawAdditionalObjectsOverPage(type, colors, obj);
        }
        this.pages.refreshDisplay();
    }

    @Override
    public void flushAdditionalObjectsOnPage(int page) {
        if (page == this.getPageNumber()) {
            DynamicVectorRenderer currentDisplay = this.fileAccess.getDynamicRenderer();
            currentDisplay.writeCustom(42, null);
        }
        this.pages.refreshDisplay();
    }

    @Override
    public final synchronized void decodePageInBackground(int i) {
        this.parser.decodePageInBackground(i);
    }

    @Override
    public final int getPageCount() {
        return this.fileAccess.getPageCount();
    }

    @Override
    public final boolean isEncrypted() {
        return this.fileAccess.isEncrypted();
    }

    @Override
    public final boolean isPasswordSupplied() {
        return this.fileAccess.isPasswordSupplied(this.getIO());
    }

    @Override
    public boolean isFileViewable() {
        return this.fileAccess.isFileViewable(this.getIO());
    }

    @Override
    public boolean isExtractionAllowed() {
        if (this.getIO() != null) {
            PdfFileReader objectReader = this.getIO().getObjectReader();
            DecryptionFactory decryption = objectReader.getDecryptionObject();
            return decryption == null || decryption.getBooleanValue(103);
        }
        return false;
    }

    @Override
    public final void setEncryptionPassword(String password) throws PdfException {
        if (this.getIO() == null) {
            throw new PdfException("Must open PdfDecoder file first");
        }
        this.getIO().getObjectReader().setPassword(password);
        if (this.getIO() != null) {
            try {
                this.preOpen();
                this.fileAccess.openPdfFile();
                this.postOpen();
            }
            catch (PdfException e) {
                LogWriter.writeLog("Exception " + e + " opening file");
            }
        }
    }

    @Override
    public final void openPdfArray(byte[] data, String password) throws PdfException {
        if (data == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        this.preOpen();
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.fileAccess.openPdfArray(data, password);
        this.postOpen();
    }

    @Override
    public final void openPdfArray(byte[] data) throws PdfException {
        if (this.alwaysEncryptFile) {
            this.openPdfArray(data, DecryptionFactory.getDynamicPassword());
            return;
        }
        if (data == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        this.preOpen();
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.fileAccess.openPdfArray(data);
        this.postOpen();
    }

    @Override
    public void openPdfFile(String filename, Certificate certificate, PrivateKey key) throws PdfException {
        this.fileAccess.setUserEncryption(certificate, key);
        this.openPdfFile(filename);
    }

    @Override
    public final void openPdfFileFromStream(Object filename, String password) throws PdfException {
        this.preOpen();
        this.fileAccess.openPdfFileFromStream(filename, password);
        this.postOpen();
    }

    @Override
    public final void openPdfFile(String filename) throws PdfException {
        if (this.alwaysEncryptFile) {
            this.openPdfFile(filename, DecryptionFactory.getDynamicPassword());
            return;
        }
        if (this.fileAccess.isOpen && this.fileAccess.linearParser.linearizedBackgroundReaderer == null) {
            this.closePdfFile();
        }
        this.preOpen();
        this.fileAccess.openPdfFile(filename);
        this.postOpen();
    }

    @Override
    public final void openPdfFile(String filename, String password) throws PdfException {
        if (this.fileAccess.isOpen) {
            this.closePdfFile();
        }
        this.preOpen();
        this.fileAccess.openPdfFile(filename, false, password);
        this.postOpen();
    }

    @Override
    public final boolean openPdfFileFromURL(String pdfUrl, boolean supportLinearized) throws PdfException {
        boolean flag;
        if (this.alwaysEncryptFile) {
            return this.openPdfFileFromURL(pdfUrl, supportLinearized, DecryptionFactory.getDynamicPassword());
        }
        this.preOpen();
        String rawFileName = null;
        try {
            URL url = new URL(pdfUrl);
            rawFileName = url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
            InputStream is = url.openStream();
            flag = this.fileAccess.readFile(supportLinearized, is, rawFileName, null);
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
            flag = this.fileAccess.readFile(supportLinearized, null, rawFileName, null);
        }
        this.postOpen();
        return flag;
    }

    @Override
    public final boolean openPdfFileFromURL(String pdfUrl, boolean supportLinearized, String password) throws PdfException {
        boolean flag;
        String rawFileName = null;
        try {
            URL url = new URL(pdfUrl);
            rawFileName = url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
            try (InputStream is = url.openStream();){
                flag = this.fileAccess.readFile(supportLinearized, is, rawFileName, password);
            }
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
            flag = this.fileAccess.readFile(supportLinearized, null, rawFileName, password);
        }
        this.preOpen();
        this.postOpen();
        return flag;
    }

    @Override
    public final boolean openPdfFileFromInputStream(InputStream is, boolean supportLinearized) throws PdfException {
        if (this.alwaysEncryptFile) {
            return this.openPdfFileFromInputStream(is, supportLinearized, DecryptionFactory.getDynamicPassword());
        }
        String rawFileName = "inputstream" + System.currentTimeMillis() + '-' + this.fileAccess.getObjectStore().getKey() + ".pdf";
        this.preOpen();
        boolean flag = this.fileAccess.readFile(supportLinearized, is, rawFileName, null);
        this.postOpen();
        return flag;
    }

    @Override
    public final boolean openPdfFileFromInputStream(InputStream is, boolean supportLinearized, String password) throws PdfException {
        String rawFileName = "inputstream" + System.currentTimeMillis() + '-' + this.fileAccess.getObjectStore().getKey() + ".pdf";
        this.preOpen();
        boolean flag = this.fileAccess.readFile(supportLinearized, is, rawFileName, password);
        this.postOpen();
        return flag;
    }

    private void postOpen() {
        ActionHandler handler;
        if (this.fileAccess.getPageCount() < 2) {
            this.options.setDisplayView(1);
        } else {
            this.options.setDisplayView(this.options.getPageMode());
        }
        if (this.fileAccess.getOffset() == null) {
            this.fileAccess.setOffset(new PageOffsets(this.fileAccess.getPageCount(), this.fileAccess.getPdfPageData()));
        }
        if ((handler = this.externalHandlers.getFormActionHandler()) != null) {
            handler.init(this, this.externalHandlers.getJavaScript(), this.getFormRenderer());
        }
    }

    private void preOpen() {
        this.pages.disableScreen();
        this.pages.stopGeneratingPage();
        this.fileAccess.setDecoding(true);
        this.options.setDisplayView(2);
        this.swingPrinter.lastPrintedPage = -1;
        this.swingPrinter.currentPrintDecoder = null;
        this.fileAccess.setDecoding(false);
        this.parser.resetOnOpen();
        ExpressionEngine userExpressionEngine = (ExpressionEngine)this.externalHandlers.getExternalHandler(6);
        this.externalHandlers.openPdfFile(userExpressionEngine);
        AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
        ActionHandler handler = this.externalHandlers.getFormActionHandler();
        if (handler == null) {
            handler = new EmptyActionHandler();
        }
        formRenderer.resetHandler(handler, this.scalingdpi.getDpi(), this.externalHandlers.getJavaScript());
        formRenderer.getCompData().setRootDisplayComponent(this);
    }

    @Override
    public Object getJPedalObject(int id) {
        return this.parser.getJPedalObject(id);
    }

    @Override
    public void setPageMode(int mode) {
        this.options.setPageMode(mode);
    }

    @Override
    public boolean isXMLExtraction() {
        return this.options.isXMLExtraction();
    }

    @Override
    public void useTextExtraction() {
        this.options.setXMLExtraction(false);
    }

    @Override
    public void useXMLExtraction() {
        this.options.setXMLExtraction(true);
    }

    public void clearScreen() {
        DynamicVectorRenderer currentDisplay = this.fileAccess.getDynamicRenderer();
        currentDisplay.writeCustom(43, null);
        this.pages.refreshDisplay();
    }

    @Override
    public void setStreamCacheSize(int size) {
        this.fileAccess.setStreamCacheSize(size);
    }

    @Override
    public boolean hasEmbeddedFonts() {
        return this.resultsFromDecode.hasEmbeddedFonts();
    }

    @Override
    public int getPageFromObjectRef(String ref) {
        return this.getIO().convertObjectToPageNumber(ref);
    }

    @Override
    public String getInfo(int type) {
        return this.parser.getInfo(type);
    }

    @Override
    public AcroRenderer getFormRenderer() {
        return this.externalHandlers.getFormRenderer();
    }

    @Override
    public Javascript getJavaScript() {
        return this.externalHandlers.getJavaScript();
    }

    public boolean isPageSuccessful() {
        return this.swingPrinter.isPageSuccessful();
    }

    @Override
    public String getPageDecodeReport() {
        return this.parser.getPageDecodeReport();
    }

    public String getPageFailureMessage() {
        return this.swingPrinter.getPageFailureMessage();
    }

    @Override
    public BufferedImage getSelectedRectangleOnscreen(float t_x1, float t_y1, float t_x2, float t_y2, float scaling) {
        AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
        BufferedImage img = PdfDecoder.getSelectedRectangleOnscreen(t_x1, t_y1, t_x2, t_y2, scaling, this.getPageNumber(), this.fileAccess.getPdfPageData(), formRenderer, this.fileAccess.getDynamicRenderer());
        formRenderer.getCompData().resetScaledLocation(this.pages.getOldScaling(), this.displayRotation, 0);
        return img;
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.fileAccess.getObjectStore();
    }

    @Override
    public void setObjectStore(ObjectStore newStore) {
        this.fileAccess.setObjectStore(newStore);
    }

    @Override
    public DecoderOptions getDecoderOptions() {
        return this.options;
    }

    @Override
    public PdfGroupingAlgorithms getGroupingObject() throws PdfException {
        return this.parser.getGroupingObject();
    }

    @Override
    public PdfGroupingAlgorithms getBackgroundGroupingObject() {
        return this.parser.getBackgroundGroupingObject();
    }

    @Override
    public final String getPDFVersion() {
        if (this.getIO() == null) {
            return "";
        }
        return this.getIO().getObjectReader().getType();
    }

    @Override
    public void resetForNonPDFPage(int pageCount) {
        this.parser.resetFontsInFile();
        this.fileAccess.setPageCount(pageCount);
        AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
        if (formRenderer != null) {
            formRenderer.removeDisplayComponentsFromScreen();
        }
        this.fileAccess.setPageData(new PdfPageData());
    }

    public boolean hasAllImages() {
        return this.resultsFromDecode.getImagesProcessedFully();
    }

    @Override
    public boolean getPageDecodeStatus(int status) {
        return this.resultsFromDecode.getPageDecodeStatus(status);
    }

    @Override
    public String getPageDecodeStatusReport(int status) {
        return this.resultsFromDecode.getPageDecodeStatusReport(status);
    }

    public void setPrintAutoRotateAndCenter(boolean value) {
        this.swingPrinter.setCenterOnScaling(value);
        this.swingPrinter.setAutoRotate(value);
    }

    public void setPrintCurrentView(boolean value) {
        this.swingPrinter.printOnlyVisible = value;
    }

    @Override
    public void addExternalHandler(Object newHandler, int type) {
        this.externalHandlers.addExternalHandler(newHandler, type);
    }

    @Override
    public Object getExternalHandler(int type) {
        switch (type) {
            case 16: {
                return this.pages;
            }
            case 17: {
                return this.fileAccess.getOffset();
            }
            case 37: {
                return this.displayOffsets;
            }
            case 35: {
                return this.fileAccess;
            }
        }
        return this.externalHandlers.getExternalHandler(type);
    }

    @Override
    public PdfObjectReader getIO() {
        return this.parser.getIO();
    }

    @Override
    public String getFileName() {
        return this.fileAccess.getFilename();
    }

    @Override
    public boolean isForm() {
        return this.res.isForm() || this.getFormRenderer() != null && this.getFormRenderer().isXFA();
    }

    @Override
    public Printable getPrintable(int page) throws IndexOutOfBoundsException {
        return this;
    }

    public void setAllowDifferentPrintPageSizes(boolean allowDifferentPrintPageSizes) {
        this.swingPrinter.allowDifferentPrintPageSizes = allowDifferentPrintPageSizes;
    }

    @Override
    public TextLines getTextLines() {
        return this.parser.getTextLines();
    }

    @Override
    public final void setInset(int width, int height) {
        this.options.setInset(width, height);
        AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
        if (formRenderer != null) {
            formRenderer.setInsets(width, height);
        }
    }

    public void ensurePointIsVisible(Point p) {
        super.scrollRectToVisible(new Rectangle(p.x, this.y_size - p.y, this.getScrollInterval(), this.getScrollInterval()));
    }

    public void setPrintIndent(int oddPages, int evenPages) {
        this.swingPrinter.setPrintIndent(oddPages, evenPages);
    }

    @Override
    public void setUserOffsets(int x, int y, int mode) {
        this.displayOffsets.setUserOffsets(x, y, this.getHeight(), mode);
        this.repaint();
    }

    public Point getUserOffsets(int mode) {
        return this.displayOffsets.getUserOffsets(mode);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension pageSize = null;
        int displayView = this.options.getDisplayView();
        if (displayView != 1) {
            pageSize = new Dimension(this.pages.getPageSize(displayView)[0], this.pages.getPageSize(displayView)[1]);
        }
        int insetW = this.options.getInsetW();
        int insetH = this.options.getInsetH();
        if (pageSize == null) {
            pageSize = this.displayRotation == 90 || this.displayRotation == 270 ? new Dimension(this.y_size + insetW + insetW, this.x_size + insetH + insetH) : new Dimension(this.x_size + insetW + insetW, this.y_size + insetH + insetH);
        }
        return pageSize;
    }

    @Override
    public final Dimension getMinimumSize() {
        return new Dimension(100 + this.options.getInsetW(), 100 + this.options.getInsetH());
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    @Override
    public final void updateCursorBoxOnScreen(int[] rectParams, int outlineColor) {
        if (this.options.getDisplayView() != 1) {
            return;
        }
        this.pages.updateCursorBoxOnScreen(rectParams, outlineColor, this.getPageNumber(), this.x_size, this.y_size);
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
            if (this.options.isHighlightFormFields()) {
                this.paintFormFieldHighlights(g);
            }
        }
        catch (Error err) {
            if (LogWriter.isRunningFromIDE) {
                throw new RuntimeException("Memory Error in painting " + err);
            }
            this.pages.flushPageCaches();
            this.pages.stopGeneratingPage();
            super.paint(g);
        }
    }

    private void paintFormFieldHighlights(Graphics g) {
        AcroRenderer renderer = this.getFormRenderer();
        if (renderer != null) {
            Object[] values;
            for (Object val : values = renderer.getFormComponents(null, ReturnValues.FORMOBJECTS_FROM_NAME, this.getPageNumber())) {
                Component comp;
                FormObject form = (FormObject)val;
                int formType = form.getFormType();
                boolean[] flags = form.getFieldFlags();
                if (formType == 7 || formType == 10 || formType == 11 || flags[1] || !(comp = (Component)form.getGUIComponent()).isVisible()) continue;
                Rectangle rect = comp.getBounds();
                g.setColor(this.options.getFormFieldsHighlightColor());
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isOpen() && this.options.isUseOffScreenRendering() && this.getDisplayView() == 1) {
            this.renderOffScreen(g);
        } else {
            RenderChangeListener customRenderChangeListener = (RenderChangeListener)this.externalHandlers.getExternalHandler(21);
            if (customRenderChangeListener != null) {
                customRenderChangeListener.renderingStarted(this.getPageNumber());
            }
            super.paintComponent(g);
            if (SwingUtilities.isEventDispatchThread()) {
                this.threadSafePaint(g);
                this.renderImageHighlight((Graphics2D)g);
                this.renderTextHighlight((Graphics2D)g);
                this.renderSnapshotHighlight((Graphics2D)g);
                if (customRenderChangeListener != null) {
                    customRenderChangeListener.renderingEnded(this.getPageNumber());
                }
            } else {
                int page = this.getPageNumber();
                Runnable doPaintComponent = () -> {
                    this.threadSafePaint(g);
                    this.renderImageHighlight((Graphics2D)g);
                    this.renderTextHighlight((Graphics2D)g);
                    this.renderSnapshotHighlight((Graphics2D)g);
                    if (customRenderChangeListener != null) {
                        customRenderChangeListener.renderingEnded(page);
                    }
                };
                SwingUtilities.invokeLater(doPaintComponent);
            }
        }
    }

    private void renderOffScreen(Graphics g) {
        RenderChangeListener customRenderChangeListener;
        if (this.offScreenMultiplier == -1) {
            this.offScreenMultiplier = 1;
            if (DecoderOptions.isRunningOnMac) {
                this.offScreenMultiplier = 2;
            }
        }
        if ((customRenderChangeListener = (RenderChangeListener)this.externalHandlers.getExternalHandler(21)) != null) {
            customRenderChangeListener.renderingStarted(this.getPageNumber());
        }
        if (this.lastPageNumber != this.getPageNumber() || this.lastDisplayRotation != this.displayRotation || this.lastScaling != this.scaling || !this.lastVisibleRect.equals(this.getVisibleRect()) || !this.lastBounds.equals(this.getBounds())) {
            this.updateOffScreenImage((Graphics2D)g, customRenderChangeListener);
        } else {
            this.renderOffScreenImageToScreen((Graphics2D)g, customRenderChangeListener);
        }
    }

    private void updateOffScreenImage(Graphics2D screenGraphics, RenderChangeListener customRenderChangeListener) {
        this.lastPageNumber = this.getPageNumber();
        this.lastDisplayRotation = this.displayRotation;
        this.lastScaling = this.scaling;
        this.lastBounds = this.getBounds();
        if (!this.lastVisibleRect.equals(this.getVisibleRect())) {
            this.lastVisibleRect = this.getVisibleRect();
            this.offScreenImage = new BufferedImage(this.lastVisibleRect.width * this.offScreenMultiplier, this.lastVisibleRect.height * this.offScreenMultiplier, 2);
        }
        Graphics2D offscreenGraphics = this.offScreenImage.createGraphics();
        offscreenGraphics.scale(this.offScreenMultiplier, this.offScreenMultiplier);
        offscreenGraphics.setClip(this.offScreenImage.getMinX(), this.offScreenImage.getMinY(), this.offScreenImage.getWidth(), this.offScreenImage.getHeight());
        super.paintComponent(offscreenGraphics);
        offscreenGraphics.translate(-this.lastVisibleRect.getX(), -this.lastVisibleRect.getY());
        if (SwingUtilities.isEventDispatchThread()) {
            this.buildOffScreenImage(offscreenGraphics, screenGraphics, customRenderChangeListener);
        } else {
            Runnable doPaintComponent = () -> this.buildOffScreenImage(offscreenGraphics, screenGraphics, customRenderChangeListener);
            SwingUtilities.invokeLater(doPaintComponent);
        }
    }

    private void buildOffScreenImage(Graphics2D image, Graphics2D screen, RenderChangeListener customRenderChangeListener) {
        this.threadSafePaint(image);
        this.renderOffScreenImageToScreen(screen, customRenderChangeListener);
    }

    private void renderTextHighlight(Graphics2D g2) {
        TextLines lines = this.getTextLines();
        int[][] highlights = lines.getHighlightedAreasAs2DArray(this.getPageNumber());
        if (highlights != null) {
            AffineTransform original = g2.getTransform();
            this.setTransformForOffScreenRender(g2);
            PdfPageData pageData = this.getPdfPageData();
            int pageNumber = this.getPageNumber();
            for (int[] highlight : highlights) {
                PdfDecoder.drawHighlight(g2, highlight, this.scaling, this.displayRotation, this.pages.getXCordForPage(pageNumber), this.pages.getYCordForPage(pageNumber), pageData, pageNumber, false, true);
            }
            g2.setTransform(original);
        }
    }

    private void renderSnapshotHighlight(Graphics2D g2) {
        AffineTransform original = g2.getTransform();
        this.setTransformForOffScreenRender(g2);
        int pageNumber = this.getPageNumber();
        PdfPageData pageData = this.getPdfPageData();
        int[] snapshotCoords = this.pages.getCursorBoxOnScreenAsArray();
        if (this.getDisplayView() == 1 && snapshotCoords != null && DecoderOptions.showMouseBox) {
            PdfDecoder.drawHighlight(g2, snapshotCoords, this.scaling, this.displayRotation, ((GUIDisplay)this.pages).insetW, ((GUIDisplay)this.pages).insetH, pageData, pageNumber, true, false);
        }
        g2.setTransform(original);
    }

    private void renderImageHighlight(Graphics2D g2) {
        AffineTransform original = g2.getTransform();
        this.setTransformForOffScreenRender(g2);
        int pageNumber = this.getPageNumber();
        PdfPageData pageData = this.getPdfPageData();
        if (this.getDisplayView() == 1) {
            PdfDecoder.drawHighlight(g2, this.pages.getHighlightedImage(), this.scaling, this.displayRotation, ((GUIDisplay)this.pages).insetW, ((GUIDisplay)this.pages).insetH, pageData, pageNumber, true, true);
        } else {
            this.pages.setHighlightedImage(null);
        }
        g2.setTransform(original);
    }

    private static void drawHighlight(Graphics2D g2, int[] highlightedImage, float scaling, int displayRotation, int insetW, int insetH, PdfPageData pageData, int pageNumber, boolean strokeBounds, boolean fillBounds) {
        if (highlightedImage != null) {
            int finalX;
            int finalY;
            int x = (int)((float)highlightedImage[0] * scaling + 0.5f);
            int y = (int)((float)highlightedImage[1] * scaling + 0.5f);
            int w = (int)((float)highlightedImage[2] * scaling + 0.5f);
            int h = (int)((float)highlightedImage[3] * scaling + 0.5f);
            if (w < 0) {
                w = -w;
                x -= w;
            }
            if (h < 0) {
                h = -h;
                y -= h;
            }
            int finalW = w;
            int finalH = h;
            int scaledCropX = (int)((float)pageData.getCropBoxX(pageNumber) * scaling);
            int scaledCropY = (int)((float)pageData.getCropBoxY(pageNumber) * scaling);
            int scaledCropW = (int)((float)pageData.getCropBoxWidth(pageNumber) * scaling);
            int scaledCropH = (int)((float)pageData.getCropBoxHeight(pageNumber) * scaling);
            switch (displayRotation) {
                case 90: {
                    finalH = w;
                    finalW = h;
                    finalY = insetH + x - scaledCropX;
                    finalX = insetW + y - scaledCropY;
                    break;
                }
                case 180: {
                    finalX = scaledCropX + scaledCropW - x - w + insetW;
                    finalY = insetH + y - scaledCropY;
                    break;
                }
                case 270: {
                    finalH = w;
                    finalW = h;
                    finalY = insetH + scaledCropW - (x + w - scaledCropX);
                    finalX = insetW + scaledCropH - (y + h - scaledCropY);
                    break;
                }
                default: {
                    finalX = insetW + x - scaledCropX;
                    finalY = insetH + scaledCropY + scaledCropH - y - h;
                }
            }
            Color oldColor = g2.getColor();
            Composite oldComposite = g2.getComposite();
            Stroke oldStroke = g2.getStroke();
            boolean isInverted = BaseDisplay.invertHighlight;
            if (isInverted) {
                g2.setColor(Color.WHITE);
                g2.setXORMode(Color.BLACK);
            } else {
                g2.setColor(DecoderOptions.highlightColor);
            }
            if (strokeBounds) {
                g2.setStroke(new BasicStroke(2.0f));
                g2.drawRect(finalX, finalY, finalW, finalH);
                g2.setStroke(oldStroke);
            }
            if (fillBounds) {
                if (!isInverted) {
                    g2.setComposite(AlphaComposite.getInstance(3, DecoderOptions.highlightComposite));
                }
                g2.fillRect(finalX, finalY, finalW, finalH);
            }
            g2.setColor(oldColor);
            g2.setComposite(oldComposite);
        }
    }

    private void renderOffScreenImageToScreen(Graphics2D g, RenderChangeListener customRenderChangeListener) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.renderOffScreenImage(g, customRenderChangeListener, this.lastPageNumber);
        } else {
            Runnable doPaintComponent = () -> this.renderOffScreenImage(g, customRenderChangeListener, this.lastPageNumber);
            SwingUtilities.invokeLater(doPaintComponent);
        }
    }

    private void renderOffScreenImage(Graphics2D screenGraphics, RenderChangeListener customRenderChangeListener, int page) {
        PageOffsets currentOffset;
        screenGraphics.scale(1.0f / (float)this.offScreenMultiplier, 1.0f / (float)this.offScreenMultiplier);
        screenGraphics.drawImage((Image)this.offScreenImage, this.lastVisibleRect.x * this.offScreenMultiplier, this.lastVisibleRect.y * this.offScreenMultiplier, null);
        screenGraphics.scale(this.offScreenMultiplier, this.offScreenMultiplier);
        this.renderImageHighlight(screenGraphics);
        this.renderTextHighlight(screenGraphics);
        this.renderSnapshotHighlight(screenGraphics);
        AcroRenderer formRenderer = this.getFormRenderer();
        if (formRenderer != null && (currentOffset = this.fileAccess.getOffset()) != null) {
            formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation, (int)this.pages.getIndent(), this.displayOffsets.getUserOffsetX(), this.displayOffsets.getUserOffsetY(), this.getDisplayView(), currentOffset.getWidestPageNR(), currentOffset.getWidestPageR());
            formRenderer.getCompData().resetScaledLocation(this.scaling, this.displayRotation, (int)this.pages.getIndent());
        }
        if (customRenderChangeListener != null) {
            customRenderChangeListener.renderingEnded(page);
        }
    }

    private void setTransformForOffScreenRender(Graphics2D g2) {
        g2.translate(this.displayOffsets.getUserOffsetX(), this.displayOffsets.getUserOffsetY());
        if (this.getPageAlignment() == 2) {
            double width = this.getBounds().getWidth();
            int displayView = this.getDisplayView();
            if (displayView == 4) {
                PdfPageData pageData = this.getPdfPageData();
                int pageCount = this.getPageCount();
                g2.translate(this.getIndentForCenteredFacing(pageData, pageCount, width), 0.0);
            } else {
                int pdfWidth = this.getPDFWidth();
                if (displayView != 1) {
                    pdfWidth = this.pages.getPageSize(displayView)[0];
                }
                g2.translate((width - (double)pdfWidth) / 2.0, 0.0);
            }
        }
    }

    private double getIndentForCenteredFacing(PdfPageData pageData, int pageCount, double displayWidth) {
        int page = this.getPageNumber();
        if (this.pages.getBoolean(Display.BoolValue.SEPARATE_COVER) && page != 1 && (page & 1) == 1) {
            --page;
        } else if (!this.pages.getBoolean(Display.BoolValue.SEPARATE_COVER) && (page & 1) == 0) {
            --page;
        }
        int firstW = 0;
        if (page != 0) {
            firstW = this.getPageWidthAfterRotation(pageData, page);
        }
        int secondW = page + 1 > pageCount ? firstW : this.getPageWidthAfterRotation(pageData, page);
        if (page == 0) {
            firstW = secondW;
        }
        int pageGap = 0;
        if (!this.pages.getBoolean(Display.BoolValue.TURNOVER_ON) || pageData.hasMultipleSizes() || pageCount == 2) {
            pageGap = 5;
        }
        return (displayWidth - (double)((float)(firstW + secondW) * this.scaling)) / 2.0 - (double)pageGap - (double)((GUIDisplay)this.pages).insetW;
    }

    private int getPageWidthAfterRotation(PdfPageData pageData, int page) {
        if ((this.displayRotation + pageData.getRotation(page)) % 180 == 90) {
            return pageData.getCropBoxHeight(page);
        }
        return pageData.getCropBoxWidth(page);
    }

    private synchronized void threadSafePaint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        DynamicVectorRenderer currentDisplay = this.fileAccess.getDynamicRenderer();
        int displayView = this.options.getDisplayView();
        if (!this.fileAccess.isDecoding() && this.options.getRenderPage()) {
            Rectangle visibleRect = this.getVisibleRect();
            AffineTransform rawAf = g2.getTransform();
            this.pages.init(this.scaling, this.displayRotation, this.fileAccess.getPageNumber(), currentDisplay, false);
            this.pages.paintPage(g2, this.externalHandlers.getFormRenderer(), this.parser.getTextLines());
            this.pages.drawBorder();
            g2.setTransform(rawAf);
            this.pages.drawFacing(visibleRect);
            if (displayView == 1) {
                this.drawPreviewImage(g2, this.getVisibleRect());
            }
        } else {
            currentDisplay.setG2(g2);
            currentDisplay.writeCustom(41, null);
        }
    }

    @Override
    public int getPDFWidth() {
        int insetW = this.options.getInsetW();
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            return this.y_size + insetW + insetW;
        }
        return this.x_size + insetW + insetW;
    }

    @Override
    public final int getPDFHeight() {
        int insetH = this.options.getInsetH();
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            return this.x_size + insetH + insetH;
        }
        return this.y_size + insetH + insetH;
    }

    @Override
    public final void setPDFBorder(Border newBorder) {
        this.myBorder = newBorder;
    }

    public final Border getPDFBorder() {
        return this.myBorder;
    }

    @Override
    public void setHardwareAccelerationforScreen(boolean useAcceleration) {
        this.options.useHardwareAcceleration(useAcceleration);
    }

    @Override
    public int getScrollInterval() {
        return this.options.getScrollInterval();
    }

    @Override
    public void setScrollInterval(int scrollInterval) {
        this.options.setScrollInterval(scrollInterval);
    }

    @Override
    public int getDisplayView() {
        return this.options.getDisplayView();
    }

    public void setPrintPageScalingMode(int pageScalingMode) {
        this.swingPrinter.setPrintPageScalingMode(pageScalingMode);
    }

    public void setUsePDFPaperSize(boolean usePDFPaperSize) {
        this.swingPrinter.usePDFPaperSize = usePDFPaperSize;
    }

    @Override
    public float getScaling() {
        return this.scaling;
    }

    @Override
    public int getInsetH() {
        return this.options.getInsetH();
    }

    @Override
    public int getInsetW() {
        return this.options.getInsetW();
    }

    @Override
    public int getNumberOfPages() {
        return this.swingPrinter.getNumberOfPages(this.fileAccess.getPageCount());
    }

    @Override
    public PageFormat getPageFormat(int p) throws IndexOutOfBoundsException {
        PageFormat pf = this.swingPrinter.getPageFormat(p, this.fileAccess.getPdfPageData(), this.fileAccess.getPageCount());
        if (pf == null) {
            pf = new PageFormat();
        }
        return pf;
    }

    public PageFormat getUserSetPageFormat(int p) throws IndexOutOfBoundsException {
        return this.swingPrinter.getPageFormat(p, this.fileAccess.getPdfPageData(), this.fileAccess.getPageCount());
    }

    public void setCenterOnScaling(boolean center) {
        this.swingPrinter.setCenterOnScaling(center);
    }

    public void setPrintAutoRotate(boolean rotate) {
        this.swingPrinter.setAutoRotate(rotate);
    }

    public void setPageFormat(int p, PageFormat pf) {
        this.swingPrinter.putPageFormat(p, pf);
    }

    public void setPageFormat(PageFormat pf) {
        this.swingPrinter.putPageFormat(-1, pf);
    }

    public void setPagePrintRange(SetOfIntegerSyntax range) throws PdfException {
        if (range == null) {
            throw new PdfException("[PDF] null page range entered");
        }
        this.swingPrinter.setPagePrintRange(range, this.fileAccess.getPageCount());
    }

    public void setPrintPageMode(int mode) {
        this.swingPrinter.setPrintPageMode(mode);
    }

    public final void stopPrinting() {
        this.swingPrinter.stopPrinting();
    }

    public int getCurrentPrintPage() {
        return this.swingPrinter.getCurrentPrintPage();
    }

    public void resetCurrentPrintPage() {
        this.swingPrinter.currentPrintPage = 0;
        this.getFormRenderer().getCompData().resetAfterPrinting();
    }

    @Override
    public int getSpecialMode() {
        return this.specialMode;
    }

    @Override
    public boolean useNewGraphicsMode() {
        return this.useNewGraphicsMode;
    }

    @Override
    public void useNewGraphicsMode(boolean isEnabled) {
        this.useNewGraphicsMode = isEnabled;
    }

    @Override
    public int[] getMaxSizeWH() {
        int[] whArr = new int[]{this.getMaximumSize().width, this.getMaximumSize().height};
        return whArr;
    }

    @Override
    public int[] getPaneBounds() {
        int[] boundsArr = new int[]{this.getBounds().width, this.getBounds().height};
        return boundsArr;
    }

    @Override
    public void repaintPane(int page) {
        this.repaint();
    }

    @Override
    public void requestFocus() {
        this.requestFocusInWindow();
    }

    private static BufferedImage getSelectedRectangleOnscreen(float t_x1, float t_y1, float t_x2, float t_y2, float scaling, int pageNumber, PdfPageData pageData, AcroRenderer formRenderer, DynamicVectorRenderer currentDisplay) {
        int mediaBoxH = pageData.getMediaBoxHeight(pageNumber);
        int crw = pageData.getCropBoxWidth(pageNumber);
        int crh = pageData.getCropBoxHeight(pageNumber);
        int crx = pageData.getCropBoxX(pageNumber);
        int cry = pageData.getCropBoxY(pageNumber);
        if (t_y2 < (float)cry) {
            t_y2 = cry;
        }
        if (t_x1 < (float)crx) {
            t_x1 = crx;
        }
        if (t_y1 > (float)(crh + cry)) {
            t_y1 = crh + cry;
        }
        if (t_x2 > (float)(crx + crw)) {
            t_x2 = crx + crw;
        }
        if (t_x2 - t_x1 < 1.0f || t_y1 - t_y2 < 1.0f) {
            return null;
        }
        float scalingFactor = scaling / 100.0f;
        float imgWidth = t_x2 - t_x1;
        float imgHeight = t_y1 - t_y2;
        BufferedImage img = new BufferedImage((int)(imgWidth * scalingFactor), (int)(imgHeight * scalingFactor), 1);
        Graphics2D g2 = img.createGraphics();
        if (cry > 0) {
            cry = mediaBoxH - crh - cry;
        }
        AffineTransform scaleAf = new AffineTransform(ScalingFactory.getScalingForImage(pageNumber, 0, scalingFactor, pageData));
        int cx = -crx;
        int cy = -cry;
        scaleAf.translate(cx, -cy);
        scaleAf.translate(-(t_x1 - (float)crx), (float)mediaBoxH - t_y1 - (float)cry);
        AffineTransform af = g2.getTransform();
        g2.transform(scaleAf);
        currentDisplay.setG2(g2);
        currentDisplay.writeCustom(41, new Rectangle(crx, cry, crw, crh));
        currentDisplay.paint(null, null, null);
        if (formRenderer != null && formRenderer.hasFormsOnPage(pageNumber) && !formRenderer.getCompData().formsRasterizedForDisplay()) {
            formRenderer.getCompData().renderFormsOntoG2(g2, pageNumber, 0, 0, null, formRenderer.getFormFactory(), pageData.getMediaBoxHeight(pageNumber));
        }
        g2.setTransform(af);
        g2.dispose();
        return img;
    }

    @Override
    public int getTextPrint() {
        return this.textPrint;
    }

    @Override
    public PdfObject getViewerPreferences() {
        return this.res.getPdfObject(5);
    }

    static {
        String versionSet;
        InputStream is = ExternalHandlers.class.getClassLoader().getResourceAsStream("version.num");
        Properties props = new Properties();
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException ex) {
                LogWriter.writeLog("Exception: " + ex.getMessage());
            }
        }
        version = (versionSet = props.getProperty("release")) != null ? versionSet : "@VERSION@";
        String name = System.getProperty("os.name");
        if (name.equals("Mac OS X")) {
            DecoderOptions.isRunningOnMac = true;
        } else if (name.startsWith("Windows")) {
            DecoderOptions.isRunningOnWindows = true;
        } else if (name.startsWith("AIX")) {
            DecoderOptions.isRunningOnAIX = true;
        } else if (name.equals("Linux")) {
            DecoderOptions.isRunningOnLinux = true;
        }
        try {
            DecoderOptions.javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        }
        catch (NumberFormatException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }
}

