/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.blends;

import java.awt.CompositeContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

class Blender
implements CompositeContext {
    private final float fixedAlpha;
    private final boolean srcPA;
    private final boolean backPA;
    private final boolean srcHasAlpha;
    private final boolean backHasAlpha;
    private final int bm;

    Blender(ColorModel srcColorModel, ColorModel dstColorModel, int blendMode, float alpha) {
        this.srcPA = srcColorModel.isAlphaPremultiplied();
        this.backPA = dstColorModel.isAlphaPremultiplied();
        this.fixedAlpha = alpha;
        this.bm = blendMode;
        this.srcHasAlpha = srcColorModel.hasAlpha();
        this.backHasAlpha = dstColorModel.hasAlpha();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void compose(Raster srcRaster, Raster backdropRaster, WritableRaster dstOut) {
        int width = Math.min(srcRaster.getWidth(), backdropRaster.getWidth());
        int height = Math.min(srcRaster.getHeight(), backdropRaster.getHeight());
        int[] src = new int[width];
        int[] backdrop = new int[width];
        int[] out = new int[width];
        for (int y = 0; y < height; ++y) {
            srcRaster.getDataElements(0, y, width, 1, src);
            backdropRaster.getDataElements(0, y, width, 1, backdrop);
            Blender.blend(this.bm, width, src, backdrop, out, this.fixedAlpha, this.srcPA, this.backPA, this.srcHasAlpha, this.backHasAlpha);
            dstOut.setDataElements(0, y, width, 1, out);
        }
    }

    private static void blend(int bm, int width, int[] src, int[] backdrop, int[] out, float fa, boolean srcPA, boolean backPA, boolean srcHasAlpha, boolean backHasAlpha) {
        switch (bm) {
            case 1451587725: {
                Blender.multiply(width, src, backdrop, out, fa, srcPA, backPA, srcHasAlpha, backHasAlpha);
                break;
            }
            case 1110792305: {
                Blender.screen(width, src, backdrop, out, fa, srcPA, backPA, srcHasAlpha, backHasAlpha);
                break;
            }
            case 1113290622: {
                Blender.overlay(width, src, backdrop, out, fa, srcPA, backPA, srcHasAlpha, backHasAlpha);
                break;
            }
            case 1786342520: {
                Blender.hardlight(width, src, backdrop, out, fa, srcPA, backPA, srcHasAlpha, backHasAlpha);
                break;
            }
            case 2020441219: {
                Blender.softlight(width, src, backdrop, out, fa, srcPA, backPA, srcHasAlpha, backHasAlpha);
                break;
            }
            case 2071170184: {
                Blender.colorDodge(width, src, backdrop, out, fa, srcPA, backPA, srcHasAlpha, backHasAlpha);
                break;
            }
            case 1367441811: {
                Blender.colorBurn(width, src, backdrop, out, fa, srcPA, backPA, srcHasAlpha, backHasAlpha);
                break;
            }
            case 1111181679: {
                Blender.darken(width, src, backdrop, out, fa, srcPA, backPA, srcHasAlpha, backHasAlpha);
                break;
            }
            case 945843829: {
                Blender.lighten(width, src, backdrop, out, fa, srcPA, backPA, srcHasAlpha, backHasAlpha);
                break;
            }
            case 1802796208: {
                Blender.difference(width, src, backdrop, out, fa, srcPA, backPA, srcHasAlpha, backHasAlpha);
                break;
            }
            case -1955824744: {
                Blender.exclusion(width, src, backdrop, out, fa, srcPA, backPA, srcHasAlpha, backHasAlpha);
            }
        }
    }

    private static void multiply(int width, int[] src, int[] backdrop, int[] out, float fa, boolean srcPA, boolean backPA, boolean srcHasAlpha, boolean backHasAlpha) {
        for (int i = 0; i < width; ++i) {
            float bo;
            float go;
            float ro;
            int s = src[i];
            int b = backdrop[i];
            float as = srcHasAlpha ? (float)(s >> 24 & 0xFF) / 255.0f : 1.0f;
            float rs = (float)(s >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s >> 8 & 0xFF) / 255.0f;
            float bs = (float)(s & 0xFF) / 255.0f;
            if (srcPA) {
                if (as != 0.0f) {
                    rs /= as;
                    gs /= as;
                    bs /= as;
                } else {
                    rs = 0.0f;
                    gs = 0.0f;
                    bs = 0.0f;
                }
            }
            float ab = backHasAlpha ? (float)(b >> 24 & 0xFF) / 255.0f : 1.0f;
            float rb = (float)(b >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b >> 8 & 0xFF) / 255.0f;
            float bb = (float)(b & 0xFF) / 255.0f;
            if (backPA) {
                if (ab != 0.0f) {
                    rb /= ab;
                    gb /= ab;
                    bb /= ab;
                } else {
                    rb = 0.0f;
                    gb = 0.0f;
                    bb = 0.0f;
                }
            }
            float as1 = 1.0f - (as *= fa);
            float ab1 = 1.0f - ab;
            float ao = as + ab * as1;
            if (rb == 1.0f && gb == 1.0f && bb == 1.0f) {
                ro = rs;
                go = gs;
                bo = bs;
            } else {
                ro = rb * rs;
                go = gb * gs;
                bo = bb * bs;
            }
            ro = (as1 * ab * rb + ab1 * as * rs + ab * as * ro) / ao;
            go = (as1 * ab * gb + ab1 * as * gs + ab * as * go) / ao;
            bo = (as1 * ab * bb + ab1 * as * bs + ab * as * bo) / ao;
            out[i] = (int)(ao * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo * 255.0f);
        }
    }

    private static void screen(int width, int[] src, int[] backdrop, int[] out, float fa, boolean srcPA, boolean backPA, boolean srcHasAlpha, boolean backHasAlpha) {
        for (int i = 0; i < width; ++i) {
            float bo;
            float go;
            float ro;
            int s = src[i];
            int b = backdrop[i];
            float as = srcHasAlpha ? (float)(s >> 24 & 0xFF) / 255.0f : 1.0f;
            float rs = (float)(s >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s >> 8 & 0xFF) / 255.0f;
            float bs = (float)(s & 0xFF) / 255.0f;
            if (srcPA) {
                if (as != 0.0f) {
                    rs /= as;
                    gs /= as;
                    bs /= as;
                } else {
                    rs = 0.0f;
                    gs = 0.0f;
                    bs = 0.0f;
                }
            }
            float ab = backHasAlpha ? (float)(b >> 24 & 0xFF) / 255.0f : 1.0f;
            float rb = (float)(b >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b >> 8 & 0xFF) / 255.0f;
            float bb = (float)(b & 0xFF) / 255.0f;
            if (backPA) {
                if (ab != 0.0f) {
                    rb /= ab;
                    gb /= ab;
                    bb /= ab;
                } else {
                    rb = 0.0f;
                    gb = 0.0f;
                    bb = 0.0f;
                }
            }
            float as1 = 1.0f - (as *= fa);
            float ab1 = 1.0f - ab;
            float ao = as + ab * as1;
            if (rb == 1.0f && gb == 1.0f && bb == 1.0f) {
                ro = rs;
                go = gs;
                bo = bs;
            } else {
                ro = rb + rs - rb * rs;
                go = gb + gs - gb * gs;
                bo = bb + bs - bb * bs;
            }
            ro = (as1 * ab * rb + ab1 * as * rs + ab * as * ro) / ao;
            go = (as1 * ab * gb + ab1 * as * gs + ab * as * go) / ao;
            bo = (as1 * ab * bb + ab1 * as * bs + ab * as * bo) / ao;
            out[i] = (int)(ao * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo * 255.0f);
        }
    }

    private static void overlay(int width, int[] src, int[] backdrop, int[] out, float fa, boolean srcPA, boolean backPA, boolean srcHasAlpha, boolean backHasAlpha) {
        for (int i = 0; i < width; ++i) {
            float bo;
            float go;
            float ro;
            int s = src[i];
            int b = backdrop[i];
            float as = srcHasAlpha ? (float)(s >> 24 & 0xFF) / 255.0f : 1.0f;
            float rs = (float)(s >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s >> 8 & 0xFF) / 255.0f;
            float bs = (float)(s & 0xFF) / 255.0f;
            if (srcPA) {
                if (as != 0.0f) {
                    rs /= as;
                    gs /= as;
                    bs /= as;
                } else {
                    rs = 0.0f;
                    gs = 0.0f;
                    bs = 0.0f;
                }
            }
            float ab = backHasAlpha ? (float)(b >> 24 & 0xFF) / 255.0f : 1.0f;
            float rb = (float)(b >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b >> 8 & 0xFF) / 255.0f;
            float bb = (float)(b & 0xFF) / 255.0f;
            if (backPA) {
                if (ab != 0.0f) {
                    rb /= ab;
                    gb /= ab;
                    bb /= ab;
                } else {
                    rb = 0.0f;
                    gb = 0.0f;
                    bb = 0.0f;
                }
            }
            float as1 = 1.0f - (as *= fa);
            float ab1 = 1.0f - ab;
            float ao = as + ab * as1;
            if (rb == 1.0f && gb == 1.0f && bb == 1.0f) {
                ro = rs;
                go = gs;
                bo = bs;
            } else {
                if (rb <= 0.5f) {
                    ro = rs * 2.0f * rb;
                } else {
                    ro = 2.0f * rb - 1.0f;
                    ro = rs + ro - ro * rs;
                }
                if (gb <= 0.5f) {
                    go = gs * 2.0f * gb;
                } else {
                    go = 2.0f * gb - 1.0f;
                    go = gs + go - go * gs;
                }
                if (bb <= 0.5f) {
                    bo = bs * 2.0f * bb;
                } else {
                    bo = 2.0f * bb - 1.0f;
                    bo = bs + bo - bo * bs;
                }
            }
            ro = (as1 * ab * rb + ab1 * as * rs + ab * as * ro) / ao;
            go = (as1 * ab * gb + ab1 * as * gs + ab * as * go) / ao;
            bo = (as1 * ab * bb + ab1 * as * bs + ab * as * bo) / ao;
            out[i] = (int)(ao * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo * 255.0f);
        }
    }

    private static void hardlight(int width, int[] src, int[] backdrop, int[] out, float fa, boolean srcPA, boolean backPA, boolean srcHasAlpha, boolean backHasAlpha) {
        for (int i = 0; i < width; ++i) {
            float bo;
            float go;
            float ro;
            int s = src[i];
            int b = backdrop[i];
            float as = srcHasAlpha ? (float)(s >> 24 & 0xFF) / 255.0f : 1.0f;
            float rs = (float)(s >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s >> 8 & 0xFF) / 255.0f;
            float bs = (float)(s & 0xFF) / 255.0f;
            if (srcPA) {
                if (as != 0.0f) {
                    rs /= as;
                    gs /= as;
                    bs /= as;
                } else {
                    rs = 0.0f;
                    gs = 0.0f;
                    bs = 0.0f;
                }
            }
            float ab = backHasAlpha ? (float)(b >> 24 & 0xFF) / 255.0f : 1.0f;
            float rb = (float)(b >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b >> 8 & 0xFF) / 255.0f;
            float bb = (float)(b & 0xFF) / 255.0f;
            if (backPA) {
                if (ab != 0.0f) {
                    rb /= ab;
                    gb /= ab;
                    bb /= ab;
                } else {
                    rb = 0.0f;
                    gb = 0.0f;
                    bb = 0.0f;
                }
            }
            float as1 = 1.0f - (as *= fa);
            float ab1 = 1.0f - ab;
            float ao = as + ab * as1;
            if (rb == 1.0f && gb == 1.0f && bb == 1.0f) {
                ro = rs;
                go = gs;
                bo = bs;
            } else {
                if (rs <= 0.5f) {
                    ro = rb * 2.0f * rs;
                } else {
                    ro = 2.0f * rs - 1.0f;
                    ro = rb + ro - ro * rb;
                }
                if (gs <= 0.5f) {
                    go = gb * 2.0f * gs;
                } else {
                    go = 2.0f * gs - 1.0f;
                    go = gb + go - go * gb;
                }
                if (bs <= 0.5f) {
                    bo = bb * 2.0f * bs;
                } else {
                    bo = 2.0f * bs - 1.0f;
                    bo = bb + bo - bo * bb;
                }
            }
            ro = (as1 * ab * rb + ab1 * as * rs + ab * as * ro) / ao;
            go = (as1 * ab * gb + ab1 * as * gs + ab * as * go) / ao;
            bo = (as1 * ab * bb + ab1 * as * bs + ab * as * bo) / ao;
            out[i] = (int)(ao * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo * 255.0f);
        }
    }

    private static void softlight(int width, int[] src, int[] backdrop, int[] out, float fa, boolean srcPA, boolean backPA, boolean srcHasAlpha, boolean backHasAlpha) {
        for (int i = 0; i < width; ++i) {
            float bo;
            float go;
            float ro;
            int s = src[i];
            int b = backdrop[i];
            float as = srcHasAlpha ? (float)(s >> 24 & 0xFF) / 255.0f : 1.0f;
            float rs = (float)(s >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s >> 8 & 0xFF) / 255.0f;
            float bs = (float)(s & 0xFF) / 255.0f;
            if (srcPA) {
                if (as != 0.0f) {
                    rs /= as;
                    gs /= as;
                    bs /= as;
                } else {
                    rs = 0.0f;
                    gs = 0.0f;
                    bs = 0.0f;
                }
            }
            float ab = backHasAlpha ? (float)(b >> 24 & 0xFF) / 255.0f : 1.0f;
            float rb = (float)(b >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b >> 8 & 0xFF) / 255.0f;
            float bb = (float)(b & 0xFF) / 255.0f;
            if (backPA) {
                if (ab != 0.0f) {
                    rb /= ab;
                    gb /= ab;
                    bb /= ab;
                } else {
                    rb = 0.0f;
                    gb = 0.0f;
                    bb = 0.0f;
                }
            }
            float as1 = 1.0f - (as *= fa);
            float ab1 = 1.0f - ab;
            float ao = as + ab * as1;
            if (rb == 1.0f && gb == 1.0f && bb == 1.0f) {
                ro = rs;
                go = gs;
                bo = bs;
            } else {
                float bx;
                if (rs <= 0.5f) {
                    ro = rb - (1.0f - 2.0f * rs) * rb * (1.0f - rb);
                } else {
                    bx = rb <= 0.25f ? ((16.0f * rb - 12.0f) * rb + 4.0f) * rb : (float)Math.sqrt(rb);
                    ro = rb + (2.0f * rs - 1.0f) * (bx - rb);
                }
                if (gs <= 0.5f) {
                    go = gb - (1.0f - 2.0f * gs) * gb * (1.0f - gb);
                } else {
                    bx = gb <= 0.25f ? ((16.0f * gb - 12.0f) * gb + 4.0f) * gb : (float)Math.sqrt(gb);
                    go = gb + (2.0f * gs - 1.0f) * (bx - gb);
                }
                if (bs <= 0.5f) {
                    bo = bb - (1.0f - 2.0f * bs) * bb * (1.0f - bb);
                } else {
                    bx = bb <= 0.25f ? ((16.0f * bb - 12.0f) * bb + 4.0f) * bb : (float)Math.sqrt(bb);
                    bo = bb + (2.0f * bs - 1.0f) * (bx - bb);
                }
            }
            ro = (as1 * ab * rb + ab1 * as * rs + ab * as * ro) / ao;
            go = (as1 * ab * gb + ab1 * as * gs + ab * as * go) / ao;
            bo = (as1 * ab * bb + ab1 * as * bs + ab * as * bo) / ao;
            out[i] = (int)(ao * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo * 255.0f);
        }
    }

    private static void darken(int width, int[] src, int[] backdrop, int[] out, float fa, boolean srcPA, boolean backPA, boolean srcHasAlpha, boolean backHasAlpha) {
        for (int i = 0; i < width; ++i) {
            float bo;
            float go;
            float ro;
            int s = src[i];
            int b = backdrop[i];
            float as = srcHasAlpha ? (float)(s >> 24 & 0xFF) / 255.0f : 1.0f;
            float rs = (float)(s >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s >> 8 & 0xFF) / 255.0f;
            float bs = (float)(s & 0xFF) / 255.0f;
            if (srcPA) {
                if (as != 0.0f) {
                    rs /= as;
                    gs /= as;
                    bs /= as;
                } else {
                    rs = 0.0f;
                    gs = 0.0f;
                    bs = 0.0f;
                }
            }
            float ab = backHasAlpha ? (float)(b >> 24 & 0xFF) / 255.0f : 1.0f;
            float rb = (float)(b >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b >> 8 & 0xFF) / 255.0f;
            float bb = (float)(b & 0xFF) / 255.0f;
            if (backPA) {
                if (ab != 0.0f) {
                    rb /= ab;
                    gb /= ab;
                    bb /= ab;
                } else {
                    rb = 0.0f;
                    gb = 0.0f;
                    bb = 0.0f;
                }
            }
            float as1 = 1.0f - (as *= fa);
            float ab1 = 1.0f - ab;
            float ao = as + ab * as1;
            if (rb == 1.0f && gb == 1.0f && bb == 1.0f) {
                ro = rs;
                go = gs;
                bo = bs;
            } else {
                ro = Math.min(rs, rb);
                go = Math.min(gs, gb);
                bo = Math.min(bs, bb);
            }
            ro = (as1 * ab * rb + ab1 * as * rs + ab * as * ro) / ao;
            go = (as1 * ab * gb + ab1 * as * gs + ab * as * go) / ao;
            bo = (as1 * ab * bb + ab1 * as * bs + ab * as * bo) / ao;
            out[i] = (int)(ao * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo * 255.0f);
        }
    }

    private static void lighten(int width, int[] src, int[] backdrop, int[] out, float fa, boolean srcPA, boolean backPA, boolean srcHasAlpha, boolean backHasAlpha) {
        for (int i = 0; i < width; ++i) {
            float bo;
            float go;
            float ro;
            int s = src[i];
            int b = backdrop[i];
            float as = srcHasAlpha ? (float)(s >> 24 & 0xFF) / 255.0f : 1.0f;
            float rs = (float)(s >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s >> 8 & 0xFF) / 255.0f;
            float bs = (float)(s & 0xFF) / 255.0f;
            if (srcPA) {
                if (as != 0.0f) {
                    rs /= as;
                    gs /= as;
                    bs /= as;
                } else {
                    rs = 0.0f;
                    gs = 0.0f;
                    bs = 0.0f;
                }
            }
            float ab = backHasAlpha ? (float)(b >> 24 & 0xFF) / 255.0f : 1.0f;
            float rb = (float)(b >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b >> 8 & 0xFF) / 255.0f;
            float bb = (float)(b & 0xFF) / 255.0f;
            if (backPA) {
                if (ab != 0.0f) {
                    rb /= ab;
                    gb /= ab;
                    bb /= ab;
                } else {
                    rb = 0.0f;
                    gb = 0.0f;
                    bb = 0.0f;
                }
            }
            float as1 = 1.0f - (as *= fa);
            float ab1 = 1.0f - ab;
            float ao = as + ab * as1;
            if (rb == 1.0f && gb == 1.0f && bb == 1.0f) {
                ro = rs;
                go = gs;
                bo = bs;
            } else {
                ro = Math.max(rs, rb);
                go = Math.max(gs, gb);
                bo = Math.max(bs, bb);
            }
            ro = (as1 * ab * rb + ab1 * as * rs + ab * as * ro) / ao;
            go = (as1 * ab * gb + ab1 * as * gs + ab * as * go) / ao;
            bo = (as1 * ab * bb + ab1 * as * bs + ab * as * bo) / ao;
            out[i] = (int)(ao * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo * 255.0f);
        }
    }

    private static void colorDodge(int width, int[] src, int[] backdrop, int[] out, float fa, boolean srcPA, boolean backPA, boolean srcHasAlpha, boolean backHasAlpha) {
        for (int i = 0; i < width; ++i) {
            float bo;
            float go;
            float ro;
            int s = src[i];
            int b = backdrop[i];
            float as = srcHasAlpha ? (float)(s >> 24 & 0xFF) / 255.0f : 1.0f;
            float rs = (float)(s >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s >> 8 & 0xFF) / 255.0f;
            float bs = (float)(s & 0xFF) / 255.0f;
            if (srcPA) {
                if (as != 0.0f) {
                    rs /= as;
                    gs /= as;
                    bs /= as;
                } else {
                    rs = 0.0f;
                    gs = 0.0f;
                    bs = 0.0f;
                }
            }
            float ab = backHasAlpha ? (float)(b >> 24 & 0xFF) / 255.0f : 1.0f;
            float rb = (float)(b >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b >> 8 & 0xFF) / 255.0f;
            float bb = (float)(b & 0xFF) / 255.0f;
            if (backPA) {
                if (ab != 0.0f) {
                    rb /= ab;
                    gb /= ab;
                    bb /= ab;
                } else {
                    rb = 0.0f;
                    gb = 0.0f;
                    bb = 0.0f;
                }
            }
            float as1 = 1.0f - (as *= fa);
            float ab1 = 1.0f - ab;
            float ao = as + ab * as1;
            if (rb == 1.0f && gb == 1.0f && bb == 1.0f) {
                ro = rs;
                go = gs;
                bo = bs;
            } else {
                ro = rs == 1.0f ? 1.0f : Math.min(1.0f, rb / (1.0f - rs));
                go = gs == 1.0f ? 1.0f : Math.min(1.0f, gb / (1.0f - gs));
                bo = bs == 1.0f ? 1.0f : Math.min(1.0f, bb / (1.0f - bs));
            }
            ro = (as1 * ab * rb + ab1 * as * rs + ab * as * ro) / ao;
            go = (as1 * ab * gb + ab1 * as * gs + ab * as * go) / ao;
            bo = (as1 * ab * bb + ab1 * as * bs + ab * as * bo) / ao;
            out[i] = (int)(ao * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo * 255.0f);
        }
    }

    private static void colorBurn(int width, int[] src, int[] backdrop, int[] out, float fa, boolean srcPA, boolean backPA, boolean srcHasAlpha, boolean backHasAlpha) {
        for (int i = 0; i < width; ++i) {
            float bo;
            float go;
            float ro;
            int s = src[i];
            int b = backdrop[i];
            float as = srcHasAlpha ? (float)(s >> 24 & 0xFF) / 255.0f : 1.0f;
            float rs = (float)(s >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s >> 8 & 0xFF) / 255.0f;
            float bs = (float)(s & 0xFF) / 255.0f;
            if (srcPA) {
                if (as != 0.0f) {
                    rs /= as;
                    gs /= as;
                    bs /= as;
                } else {
                    rs = 0.0f;
                    gs = 0.0f;
                    bs = 0.0f;
                }
            }
            float ab = backHasAlpha ? (float)(b >> 24 & 0xFF) / 255.0f : 1.0f;
            float rb = (float)(b >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b >> 8 & 0xFF) / 255.0f;
            float bb = (float)(b & 0xFF) / 255.0f;
            if (backPA) {
                if (ab != 0.0f) {
                    rb /= ab;
                    gb /= ab;
                    bb /= ab;
                } else {
                    rb = 0.0f;
                    gb = 0.0f;
                    bb = 0.0f;
                }
            }
            float as1 = 1.0f - (as *= fa);
            float ab1 = 1.0f - ab;
            float ao = as + ab * as1;
            if (rb == 1.0f && gb == 1.0f && bb == 1.0f) {
                ro = rs;
                go = gs;
                bo = bs;
            } else {
                ro = rs == 0.0f ? 0.0f : 1.0f - Math.min(1.0f, (1.0f - rb) / rs);
                go = gs == 0.0f ? 0.0f : 1.0f - Math.min(1.0f, (1.0f - gb) / gs);
                bo = bs == 0.0f ? 0.0f : 1.0f - Math.min(1.0f, (1.0f - bb) / bs);
            }
            ro = (as1 * ab * rb + ab1 * as * rs + ab * as * ro) / ao;
            go = (as1 * ab * gb + ab1 * as * gs + ab * as * go) / ao;
            bo = (as1 * ab * bb + ab1 * as * bs + ab * as * bo) / ao;
            out[i] = (int)(ao * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo * 255.0f);
        }
    }

    private static void difference(int width, int[] src, int[] backdrop, int[] out, float fa, boolean srcPA, boolean backPA, boolean srcHasAlpha, boolean backHasAlpha) {
        for (int i = 0; i < width; ++i) {
            float bo;
            float go;
            float ro;
            int s = src[i];
            int b = backdrop[i];
            float as = srcHasAlpha ? (float)(s >> 24 & 0xFF) / 255.0f : 1.0f;
            float rs = (float)(s >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s >> 8 & 0xFF) / 255.0f;
            float bs = (float)(s & 0xFF) / 255.0f;
            if (srcPA) {
                if (as != 0.0f) {
                    rs /= as;
                    gs /= as;
                    bs /= as;
                } else {
                    rs = 0.0f;
                    gs = 0.0f;
                    bs = 0.0f;
                }
            }
            float ab = backHasAlpha ? (float)(b >> 24 & 0xFF) / 255.0f : 1.0f;
            float rb = (float)(b >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b >> 8 & 0xFF) / 255.0f;
            float bb = (float)(b & 0xFF) / 255.0f;
            if (backPA) {
                if (ab != 0.0f) {
                    rb /= ab;
                    gb /= ab;
                    bb /= ab;
                } else {
                    rb = 0.0f;
                    gb = 0.0f;
                    bb = 0.0f;
                }
            }
            float as1 = 1.0f - (as *= fa);
            float ab1 = 1.0f - ab;
            float ao = as + ab * as1;
            if (rb == 1.0f && gb == 1.0f && bb == 1.0f) {
                ro = rs;
                go = gs;
                bo = bs;
            } else {
                ro = Math.abs(rb - rs);
                go = Math.abs(gb - gs);
                bo = Math.abs(bb - bs);
            }
            ro = (as1 * ab * rb + ab1 * as * rs + ab * as * ro) / ao;
            go = (as1 * ab * gb + ab1 * as * gs + ab * as * go) / ao;
            bo = (as1 * ab * bb + ab1 * as * bs + ab * as * bo) / ao;
            out[i] = (int)(ao * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo * 255.0f);
        }
    }

    private static void exclusion(int width, int[] src, int[] backdrop, int[] out, float fa, boolean srcPA, boolean backPA, boolean srcHasAlpha, boolean backHasAlpha) {
        for (int i = 0; i < width; ++i) {
            float bo;
            float go;
            float ro;
            int s = src[i];
            int b = backdrop[i];
            float as = srcHasAlpha ? (float)(s >> 24 & 0xFF) / 255.0f : 1.0f;
            float rs = (float)(s >> 16 & 0xFF) / 255.0f;
            float gs = (float)(s >> 8 & 0xFF) / 255.0f;
            float bs = (float)(s & 0xFF) / 255.0f;
            if (srcPA) {
                if (as != 0.0f) {
                    rs /= as;
                    gs /= as;
                    bs /= as;
                } else {
                    rs = 0.0f;
                    gs = 0.0f;
                    bs = 0.0f;
                }
            }
            float ab = backHasAlpha ? (float)(b >> 24 & 0xFF) / 255.0f : 1.0f;
            float rb = (float)(b >> 16 & 0xFF) / 255.0f;
            float gb = (float)(b >> 8 & 0xFF) / 255.0f;
            float bb = (float)(b & 0xFF) / 255.0f;
            if (backPA) {
                if (ab != 0.0f) {
                    rb /= ab;
                    gb /= ab;
                    bb /= ab;
                } else {
                    rb = 0.0f;
                    gb = 0.0f;
                    bb = 0.0f;
                }
            }
            float as1 = 1.0f - (as *= fa);
            float ab1 = 1.0f - ab;
            float ao = as + ab * as1;
            if (rb == 1.0f && gb == 1.0f && bb == 1.0f) {
                ro = rs;
                go = gs;
                bo = bs;
            } else {
                ro = rb + rs - 2.0f * rb * rs;
                go = gb + gs - 2.0f * gb * gs;
                bo = bb + bs - 2.0f * bb * bs;
            }
            ro = (as1 * ab * rb + ab1 * as * rs + ab * as * ro) / ao;
            go = (as1 * ab * gb + ab1 * as * gs + ab * as * go) / ao;
            bo = (as1 * ab * bb + ab1 * as * bs + ab * as * bo) / ao;
            out[i] = (int)(ao * 255.0f) << 24 | (int)(ro * 255.0f) << 16 | (int)(go * 255.0f) << 8 | (int)(bo * 255.0f);
        }
    }
}

