/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.util;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;

public class ImageUtils {
    public static BufferedImage fixSubBufferedImage(BufferedImage image) {
        boolean needFix;
        boolean bl = needFix = image.getSampleModel().getWidth() != image.getWidth() || image.getSampleModel().getHeight() != image.getHeight();
        if (needFix) {
            if (image.getType() == 10) {
                BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 10);
                byte[] pixelBytes = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int p = 0;
                for (int y = 0; y < image.getHeight(); ++y) {
                    for (int x = 0; x < image.getWidth(); ++x) {
                        pixelBytes[p++] = (byte)(image.getRGB(x, y) & 0xFF);
                    }
                }
                return result;
            }
            BufferedImage result = image.getColorModel().hasAlpha() ? new BufferedImage(image.getWidth(), image.getHeight(), 2) : new BufferedImage(image.getWidth(), image.getHeight(), 1);
            int[] pixelInts = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
            int p = 0;
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    pixelInts[p++] = image.getRGB(x, y);
                }
            }
            return result;
        }
        return image;
    }
}

