/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

class IFD {
    public int imageWidth;
    public int imageHeight;
    public int samplesPerPixel = 1;
    public int[] bps = new int[]{0};
    public int compressionType = 1;
    public int photometric;
    public int rowsPerStrip;
    public int[] stripOffsets;
    public int[] stripByteCounts;
    public int fillOrder = 1;
    public int nextIFD;
    public byte[] colorMap;
    public int planarConfiguration = 1;
    public int tileWidth;
    public int tileLength;
    public int[] tileOffsets;
    public int[] tileByteCounts;
    public int predictor = 1;
    public int[] sampleFormat = new int[]{1, 1, 1};
    public byte[] iccProfile;
    public boolean isOldJpeg;
    public int jpegIFOffset;
    public int jpegIFLength;
    public byte[] jpegIFData;
    public int jpegProc = 1;
    public int[] jpegQOffsets;
    public int[] jpegDCOffsets;
    public int[] jpegACOffsets;
    public byte[][] jpegQData;
    public byte[][] jpegDCData;
    public byte[][] jpegACData;
    public final int[] jpegFrequency = new int[]{2, 1, 1};
    public int jpegRestartInterval;
    public byte[] jpegTables;
    public String xmpMeta;
    public int t4Options;
    public int t6Options;
    public boolean isLittle;

    IFD() {
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ImageWidth: ").append(this.imageWidth);
        str.append("\nImageHeight: ").append(this.imageHeight);
        str.append("\nSamplesPerPixel: ").append(this.samplesPerPixel);
        str.append("\nCompressionType: ").append(this.compressionType);
        str.append("\nPhotomtric: ").append(this.photometric);
        str.append("\nRowsPerStrip: ").append(this.rowsPerStrip);
        str.append("\nPlanarConfig: ").append(this.planarConfiguration);
        str.append("\nFillOrder: ").append(this.fillOrder);
        str.append("\nbits per sample: ");
        for (int bp : this.bps) {
            str.append('\t').append(bp);
        }
        str.append('\n');
        if (this.tileOffsets != null) {
            str.append("Tile Width: ").append(this.tileWidth).append("\n Tile Height: ").append(this.tileLength).append('\n');
        }
        return str.toString();
    }
}

