/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.scale;

import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.JDeliImageSupport;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;

public class QualityScaler
extends JDeliImage {
    private static final float PI_FLOAT = (float)Math.PI;
    private static final float PI_FLOAT2 = 9.869605f;

    public static BufferedImage getScaledImage(BufferedImage srcImage, int destWidth, int destHeight) {
        JDeliImageSupport.optimiseImage(srcImage);
        int sw = srcImage.getWidth();
        int sh = srcImage.getHeight();
        ColorModel cm = srcImage.getColorModel();
        int nComp = cm.getNumComponents();
        if (destWidth == sw && destHeight == sh) {
            return srcImage;
        }
        if (destHeight < 4 || destWidth < 4 || sw < 4 || sh < 4) {
            return QualityScaler.getCubicScaled(srcImage, destWidth, destHeight);
        }
        switch (srcImage.getType()) {
            case 1: 
            case 4: {
                BufferedImage destImage = new BufferedImage(destWidth, destHeight, srcImage.getType());
                int[] inPixels = ((DataBufferInt)srcImage.getRaster().getDataBuffer()).getData();
                int[] outPixels = ((DataBufferInt)destImage.getRaster().getDataBuffer()).getData();
                QualityScaler.doIntFilter(inPixels, outPixels, sw, sh, destWidth, destHeight, nComp);
                return destImage;
            }
            case 2: 
            case 3: {
                int[] inPixels = ((DataBufferInt)srcImage.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < inPixels.length; ++i) {
                    if (inPixels[i] != 0) continue;
                    inPixels[i] = 0xFFFFFF;
                }
                BufferedImage destImage = new BufferedImage(destWidth, destHeight, srcImage.getType());
                int[] outPixels = ((DataBufferInt)destImage.getRaster().getDataBuffer()).getData();
                QualityScaler.doIntFilter(inPixels, outPixels, sw, sh, destWidth, destHeight, nComp);
                return destImage;
            }
            case 5: 
            case 6: 
            case 10: {
                BufferedImage destImage = new BufferedImage(destWidth, destHeight, srcImage.getType());
                byte[] inBytes = ((DataBufferByte)srcImage.getRaster().getDataBuffer()).getData();
                byte[] outBytes = ((DataBufferByte)destImage.getRaster().getDataBuffer()).getData();
                QualityScaler.doByteFilter(inBytes, outBytes, sw, sh, destWidth, destHeight, nComp);
                return destImage;
            }
            case 12: {
                BufferedImage grayImage = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(), 10);
                grayImage.createGraphics().drawImage((Image)srcImage, 0, 0, null);
                BufferedImage destImage = new BufferedImage(destWidth, destHeight, grayImage.getType());
                byte[] inBytes = ((DataBufferByte)grayImage.getRaster().getDataBuffer()).getData();
                byte[] outBytes = ((DataBufferByte)destImage.getRaster().getDataBuffer()).getData();
                nComp = 1;
                QualityScaler.doByteFilter(inBytes, outBytes, sw, sh, destWidth, destHeight, nComp);
                return destImage;
            }
        }
        BufferedImage colImage = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(), 6);
        colImage.createGraphics().drawImage((Image)srcImage, 0, 0, null);
        BufferedImage destImage = new BufferedImage(destWidth, destHeight, colImage.getType());
        byte[] inBytes = ((DataBufferByte)colImage.getRaster().getDataBuffer()).getData();
        byte[] outBytes = ((DataBufferByte)destImage.getRaster().getDataBuffer()).getData();
        nComp = 4;
        QualityScaler.doByteFilter(inBytes, outBytes, sw, sh, destWidth, destHeight, nComp);
        return destImage;
    }

    public static byte[] getScaledBytes(byte[] src, int srcWidth, int srcHeight, int dstWidth, int dstHeight, int nComp) {
        byte[] output = new byte[dstWidth * dstHeight * nComp];
        QualityScaler.doByteFilter(src, output, srcWidth, srcHeight, dstWidth, dstHeight, nComp);
        return output;
    }

    private static BufferedImage getCubicScaled(BufferedImage image, int width, int height) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        double scaleX = (double)width / (double)imageWidth;
        double scaleY = (double)height / (double)imageHeight;
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp scaleOP = new AffineTransformOp(scaleTransform, 3);
        return scaleOP.filter(image, new BufferedImage(width, height, image.getType()));
    }

    private static void doIntFilter(int[] inPixels, int[] outPixels, int srcWidth, int srcHeight, int dstWidth, int dstHeight, int nComp) {
        WeightBox horizontalBox = QualityScaler.generateWeightBox(srcWidth, dstWidth);
        WeightBox verticalBox = QualityScaler.generateWeightBox(srcHeight, dstHeight);
        QualityScaler.doIntScaling(inPixels, outPixels, srcWidth, srcHeight, dstWidth, dstHeight, nComp, horizontalBox, verticalBox);
    }

    private static void doByteFilter(byte[] inBytes, byte[] outBytes, int srcWidth, int srcHeight, int dstWidth, int dstHeight, int nComp) {
        WeightBox horizontalBox = QualityScaler.generateWeightBox(srcWidth, dstWidth);
        WeightBox verticalBox = QualityScaler.generateWeightBox(srcHeight, dstHeight);
        QualityScaler.doByteScaling(inBytes, outBytes, srcWidth, srcHeight, dstWidth, dstHeight, nComp, horizontalBox, verticalBox);
    }

    private static WeightBox generateWeightBox(int srcSize, int dstSize) {
        float scale = (float)dstSize / (float)srcSize;
        int[] arrN = new int[dstSize];
        float fwidth = 3.0f;
        float width = scale < 1.0f ? 3.0f / scale : 3.0f * scale;
        int nContr = (int)(width * 2.0f + 2.0f);
        float[] weights = new float[dstSize * nContr];
        int[] pixels = new int[dstSize * nContr];
        if (scale < 1.0f) {
            QualityScaler.getSmallScaling(srcSize, dstSize, scale, arrN, nContr, weights, pixels, width);
        } else {
            QualityScaler.getLargerScaling(srcSize, dstSize, scale, arrN, nContr, weights, pixels);
        }
        return new WeightBox(arrN, pixels, weights, nContr);
    }

    private static void getLargerScaling(int srcSize, int dstSize, float scale, int[] arrN, int nContr, float[] weights, int[] pixels) {
        for (int i = 0; i < dstSize; ++i) {
            int k;
            int subindex = i * nContr;
            float center = (float)i / scale;
            int left = (int)Math.floor(center - 3.0f);
            int right = (int)Math.ceil(center + 3.0f);
            for (int j = left; j < right; ++j) {
                float weight = QualityScaler.apply(center - (float)j);
                if (weight == 0.0f) continue;
                int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                int k2 = arrN[i];
                int n2 = i;
                arrN[n2] = arrN[n2] + 1;
                if (n < 0 || n >= srcSize) {
                    weight = 0.0f;
                }
                pixels[subindex + k2] = n;
                weights[subindex + k2] = weight;
            }
            int max = arrN[i];
            float tot = 0.0f;
            for (k = 0; k < max; ++k) {
                tot += weights[subindex + k];
            }
            if (tot == 0.0f) continue;
            for (k = 0; k < max; ++k) {
                int n = subindex + k;
                weights[n] = weights[n] / tot;
            }
        }
    }

    private static void getSmallScaling(int srcSize, int dstSize, float scale, int[] arrN, int nContr, float[] weights, int[] pixels, float width) {
        float fNormFac = (float)(1.0 / (Math.ceil(width) / 3.0));
        for (int i = 0; i < dstSize; ++i) {
            int k;
            int subindex = i * nContr;
            float center = (float)i / scale;
            int left = (int)Math.floor(center - width);
            int right = (int)Math.ceil(center + width);
            for (int j = left; j <= right; ++j) {
                float weight = QualityScaler.apply((center - (float)j) * fNormFac);
                if (weight == 0.0f) continue;
                int n = j < 0 ? -j : (j >= srcSize ? srcSize - j + srcSize - 1 : j);
                int k2 = arrN[i];
                int n2 = i;
                arrN[n2] = arrN[n2] + 1;
                if (n < 0 || n >= srcSize) {
                    weight = 0.0f;
                }
                pixels[subindex + k2] = n;
                weights[subindex + k2] = weight;
            }
            int max = arrN[i];
            float tot = 0.0f;
            for (k = 0; k < max; ++k) {
                tot += weights[subindex + k];
            }
            if (tot == 0.0f) continue;
            for (k = 0; k < max; ++k) {
                int n = subindex + k;
                weights[n] = weights[n] / tot;
            }
        }
    }

    private static void doIntScaling(int[] inPixels, int[] outPixels, int srcWidth, int srcHeight, int dstWidth, int dstHeight, int nComp, WeightBox horizontalBox, WeightBox verticalBox) {
        int[] tempPixels = new int[srcWidth];
        int[] srcPixels = new int[srcWidth];
        int stripLen = dstWidth * nComp;
        byte[] dstPixels = new byte[dstWidth * nComp];
        byte[] workPixels = new byte[srcHeight * dstWidth * nComp];
        byte[] hasVisited = new byte[srcHeight];
        for (int dstY = 0; dstY < dstHeight; ++dstY) {
            int pos;
            long sample;
            int yTimesNumContributors = dstY * verticalBox.numContributors;
            int max = verticalBox.ns[dstY];
            int index = yTimesNumContributors;
            for (int j = 0; j < max; ++j) {
                int vLoc = verticalBox.pixels[index++];
                if (hasVisited[vLoc] != 0) continue;
                hasVisited[vLoc] = 1;
                QualityScaler.getIntPixels(inPixels, vLoc, srcWidth, srcPixels);
                for (int nc = 0; nc < nComp; ++nc) {
                    QualityScaler.getHorizontalComps(srcPixels, nc, tempPixels, nComp);
                    for (int i = 0; i < dstWidth; ++i) {
                        int sampleLocation = i * nComp;
                        int horizontalMax = horizontalBox.ns[i];
                        sample = 0L;
                        int hIndex = i * horizontalBox.numContributors;
                        for (int jj = 0; jj < horizontalMax; ++jj) {
                            sample += (long)tempPixels[horizontalBox.pixels[hIndex]] * horizontalBox.weights[hIndex];
                            ++hIndex;
                        }
                        pos = vLoc * stripLen + sampleLocation + nc;
                        QualityScaler.clamp(workPixels, pos, sample);
                    }
                }
            }
            for (int x = 0; x < dstWidth; ++x) {
                int xLoc = x * nComp;
                for (int channel = nComp - 1; channel >= 0; --channel) {
                    sample = 0L;
                    int ix = yTimesNumContributors;
                    for (int j = max - 1; j >= 0; --j) {
                        int valueLocation = verticalBox.pixels[ix];
                        pos = valueLocation * stripLen + xLoc + channel;
                        sample += (long)(workPixels[pos] & 0xFF) * verticalBox.weights[ix];
                        ++ix;
                    }
                    pos = channel + xLoc;
                    QualityScaler.clamp(dstPixels, pos, sample);
                }
            }
            QualityScaler.setIntPixels(dstPixels, outPixels, dstY, dstWidth, nComp);
        }
    }

    private static void doByteScaling(byte[] inBytes, byte[] outBytes, int srcWidth, int srcHeight, int dstWidth, int dstHeight, int nComp, WeightBox horizontalBox, WeightBox verticalBox) {
        int[] tempPixels = new int[srcWidth];
        byte[] srcPixels = new byte[srcWidth * nComp];
        int stripLen = dstWidth * nComp;
        byte[] dstPixels = new byte[dstWidth * nComp];
        byte[] workPixels = new byte[srcHeight * dstWidth * nComp];
        byte[] hasVisited = new byte[srcHeight];
        for (int dstY = 0; dstY < dstHeight; ++dstY) {
            int pos;
            long sample;
            int nc;
            int j;
            int yTimesNumContributors = dstY * verticalBox.numContributors;
            int max = verticalBox.ns[dstY];
            int index = yTimesNumContributors;
            for (j = 0; j < max; ++j) {
                int vLoc = verticalBox.pixels[index++];
                if (hasVisited[vLoc] != 0) continue;
                hasVisited[vLoc] = 1;
                int vsnc = vLoc * stripLen;
                QualityScaler.getBytePixels(inBytes, vLoc, srcWidth, srcPixels, nComp);
                for (nc = 0; nc < nComp; ++nc) {
                    QualityScaler.getHorizontalCompsBytes(srcPixels, nc, tempPixels, nComp);
                    for (int i = 0; i < dstWidth; ++i) {
                        int hMax = horizontalBox.ns[i];
                        sample = 0L;
                        int hIndex = i * horizontalBox.numContributors;
                        for (int jj = 0; jj < hMax; ++jj) {
                            sample += (long)tempPixels[horizontalBox.pixels[hIndex]] * horizontalBox.weights[hIndex];
                            ++hIndex;
                        }
                        pos = vsnc + i * nComp + nc;
                        QualityScaler.clamp(workPixels, pos, sample);
                    }
                }
            }
            for (int x = 0; x < dstWidth; ++x) {
                int xLoc = x * nComp;
                for (nc = 0; nc < nComp; ++nc) {
                    sample = 0L;
                    int ix = yTimesNumContributors;
                    for (j = 0; j < max; ++j) {
                        pos = verticalBox.pixels[ix] * stripLen + xLoc + nc;
                        sample += (long)(workPixels[pos] & 0xFF) * verticalBox.weights[ix];
                        ++ix;
                    }
                    pos = nc + xLoc;
                    QualityScaler.clamp(dstPixels, pos, sample);
                }
            }
            QualityScaler.setBytePixels(dstPixels, outBytes, dstY, dstWidth, nComp);
        }
    }

    private static void clamp(byte[] image, int pos, long sample) {
        image[pos] = (byte)((sample /= 0xFFFFFFFFFFL) < 0L ? 0 : (byte)(sample > 255L ? -1 : (byte)sample));
    }

    private static void getHorizontalComps(int[] src, int channel, int[] dest, int nComp) {
        int nc = 8 * (nComp - channel - 1);
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = src[i] >> nc & 0xFF;
        }
    }

    private static void getHorizontalCompsBytes(byte[] src, int channel, int[] dest, int nComp) {
        int nc = channel;
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = src[nc] & 0xFF;
            nc += nComp;
        }
    }

    private static void getIntPixels(int[] inPixels, int y, int w, int[] array) {
        System.arraycopy(inPixels, y * w, array, 0, w);
    }

    private static void getBytePixels(byte[] inPixels, int y, int w, byte[] array, int nComp) {
        int bp = y * w * nComp;
        System.arraycopy(inPixels, bp, array, 0, array.length);
    }

    private static void setIntPixels(byte[] dstPixels, int[] outPixels, int dstY, int dstWidth, int nComp) {
        int dstPointer = dstY * dstWidth;
        int bp = 0;
        for (int i = 0; i < dstWidth; ++i) {
            int pixValue = 0;
            for (int j = 0; j < nComp; ++j) {
                pixValue |= (dstPixels[bp++] & 0xFF) << 8 * (nComp - j - 1);
            }
            outPixels[dstPointer + i] = pixValue;
        }
    }

    private static void setBytePixels(byte[] dstPixels, byte[] outPixels, int dstY, int dstWidth, int nComp) {
        int dstPointer = dstY * dstWidth * nComp;
        System.arraycopy(dstPixels, 0, outPixels, dstPointer, dstWidth * nComp);
    }

    private static float apply(float value) {
        if (value == 0.0f) {
            return 1.0f;
        }
        if (value < 0.0f) {
            value = -value;
        }
        if (value < 3.0f) {
            float pv = (float)Math.PI * value;
            return (float)(3.0 * Math.sin(pv) * Math.sin((double)pv / 3.0) / (double)(9.869605f * value * value));
        }
        return 0.0f;
    }

    private static final class WeightBox {
        private final int[] ns;
        private final int[] pixels;
        private final long[] weights;
        private final int numContributors;

        private WeightBox(int[] arrN, int[] arrPixel, float[] arrWeight, int numContributors) {
            this.ns = arrN;
            this.pixels = arrPixel;
            this.weights = new long[arrWeight.length];
            this.numContributors = numContributors;
            for (int i = 0; i < this.weights.length; ++i) {
                this.weights[i] = (long)((double)arrWeight[i] * 1.0 * 1.099511627775E12);
            }
        }
    }
}

