/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.Subband;
import com.idrsolutions.image.jpeg2000.data.SubbandCoefficient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Trns {
    private static final float ALPHA = -1.5861343f;
    private static final float BETA = -0.052980117f;
    private static final float GAMMA = 0.8829111f;
    private static final float DELTA = 0.44350687f;
    private static final float ZETA = 1.2301741f;
    private static final float ZETA_ = 0.8128931f;

    public static List<Subband> getForward(float[] pixels, int iw, int ih, int NL, boolean reversible) {
        Subband cur = new Subband();
        ArrayList<Subband> result = new ArrayList<Subband>();
        cur.width = iw;
        cur.height = ih;
        cur.floats = pixels;
        for (int lev = 1; lev <= NL; ++lev) {
            Subband[] coefs = Trns.twoDSD(cur, iw, ih, lev, reversible);
            cur = coefs[0];
            for (int i = 3; i > 0; --i) {
                result.add(coefs[i]);
            }
        }
        result.add(cur);
        Collections.reverse(result);
        return result;
    }

    private static Subband[] twoDSD(Subband a, int iw, int ih, int lev, boolean reversible) {
        int extH = a.height + 8;
        int extW = a.width + 8;
        float[] ext = new float[Math.max(extH, extW)];
        int u0 = a.x;
        int u1 = a.x + a.width;
        int v0 = a.y;
        int v1 = a.y + a.height;
        int w = a.width;
        float[] items = new float[a.height];
        for (int u = u0; u < u1; ++u) {
            int x;
            for (x = v0; x < v1; ++x) {
                items[x] = a.floats[x * w + u];
            }
            Trns.oneDSD(items, 0, a.height, ext, reversible);
            for (x = v0; x < v1; ++x) {
                a.floats[x * w + u] = items[x];
            }
        }
        int len = u1 - u0;
        for (int v = v0; v < v1; ++v) {
            Trns.oneDSD(a.floats, v * w, len, ext, reversible);
        }
        Subband ll = new Subband();
        int powN = 1 << lev;
        int powM = 1 << lev - 1;
        ll.width = (int)Math.abs(Math.ceil(1.0 * (double)iw / (double)powN));
        ll.height = (int)Math.abs(Math.ceil(1.0 * (double)ih / (double)powN));
        ll.floats = new float[ll.width * ll.height];
        Trns.interleaveLL(a, ll, u0, u1, v0, v1);
        ll.type = 0;
        Subband hl = new Subband();
        hl.width = (int)Math.abs(Math.ceil((1.0 * (double)iw - (double)powM) / (double)powN));
        hl.height = ll.height;
        hl.floats = new float[hl.width * hl.height];
        Trns.interleaveHL(a, hl, u0, u1, v0, v1);
        hl.type = 2;
        Subband lh = new Subband();
        lh.width = ll.width;
        lh.height = (int)Math.abs(Math.ceil((1.0 * (double)ih - (double)powM) / (double)powN));
        lh.floats = new float[lh.width * lh.height];
        Trns.interleaveLH(a, lh, u0, u1, v0, v1);
        lh.type = 1;
        Subband hh = new Subband();
        hh.width = hl.width;
        hh.height = lh.height;
        hh.floats = new float[hh.width * hh.height];
        Trns.interleaveHH(a, hh, u0, u1, v0, v1);
        hh.type = 3;
        return new Subband[]{ll, hl, lh, hh};
    }

    private static void oneDSD(float[] items, int offset, int len, float[] ext, boolean reversible) {
        int i;
        System.arraycopy(items, offset, ext, 4, len);
        int i1 = len;
        for (i = 0; i < 4; ++i) {
            ext[3 - i] = items[offset + i + 1];
        }
        for (i = 0; i < 4; ++i) {
            ext[i1 + 4 + i] = items[offset + i1 - 2 - i];
        }
        int i0 = 4;
        i1 = len + 4;
        if (reversible) {
            Trns.filterReverse(i0, i1, ext);
        } else {
            Trns.filterIrreverse(i0, i1, ext);
        }
        System.arraycopy(ext, 4, items, offset, len);
    }

    private static void filterReverse(int i0, int i1, float[] ext) {
        int n = i0 - 2 >> 1;
        int n2 = n << 1;
        int jj = i1 + 1;
        while (n2 + 1 < jj) {
            int n3 = n2 + 1;
            ext[n3] = ext[n3] - (float)((int)((ext[n2] + ext[n2 + 2]) / 2.0f));
            n2 += 2;
        }
        n = i0 >> 1;
        jj = i1;
        for (n2 = n << 1; n2 < jj; n2 += 2) {
            int n4 = n2;
            ext[n4] = ext[n4] + (float)((int)((ext[n2 - 1] + ext[n2 + 1] + 2.0f) / 4.0f));
        }
    }

    private static void filterIrreverse(int i0, int i1, float[] ext) {
        int n = i0 - 4 >> 1;
        int jj = i1 + 3;
        int n2 = n << 1;
        while (n2 + 1 < jj) {
            int n3 = n2 + 1;
            ext[n3] = ext[n3] + -1.5861343f * (ext[n2] + ext[n2 + 2]);
            n2 += 2;
        }
        n = i0 - 2 >> 1;
        jj = i1 + 2;
        for (n2 = n << 1; n2 < jj; n2 += 2) {
            int n4 = n2;
            ext[n4] = ext[n4] + -0.052980117f * (ext[n2 - 1] + ext[n2 + 1]);
        }
        n = i0 - 2 >> 1;
        jj = i1 + 1;
        for (n2 = (n << 1) + 1; n2 < jj; n2 += 2) {
            int n5 = n2;
            ext[n5] = ext[n5] + 0.8829111f * (ext[n2 - 1] + ext[n2 + 1]);
        }
        jj = i1;
        n = i0 >> 1;
        for (n2 = n << 1; n2 < jj; n2 += 2) {
            int n6 = n2;
            ext[n6] = ext[n6] + 0.44350687f * (ext[n2 - 1] + ext[n2 + 1]);
            int n7 = n2;
            ext[n7] = ext[n7] * 0.8128931f;
        }
        n = i0 - 1 >> 1;
        for (n2 = (n << 1) + 1; n2 < jj; n2 += 2) {
            int n8 = n2;
            ext[n8] = ext[n8] * 1.2301741f;
        }
    }

    private static void interleaveLL(Subband a, Subband b, int u0, int u1, int v0, int v1) {
        int ub = (int)Math.ceil((float)u0 / 2.0f);
        int vb = (int)Math.ceil((float)v0 / 2.0f);
        int aw = a.width;
        int bw = b.width;
        float[] auv = a.floats;
        float[] buv = b.floats;
        int uend = u1 + 1 >> 1;
        int vend = v1 + 1 >> 1;
        while (true) {
            int vb2 = vb << 1;
            do {
                buv[vb * bw + ub] = auv[vb2 * aw + 2 * ub];
            } while (++ub < uend);
            if (++vb >= vend) break;
            ub = u0 + 1 >> 1;
        }
    }

    private static void interleaveHL(Subband a, Subband b, int u0, int u1, int v0, int v1) {
        int aw = a.width;
        int bw = b.width;
        float[] auv = a.floats;
        float[] buv = b.floats;
        int ub = u0 >> 1;
        int vb = v0 + 1 >> 1;
        int uend = u1 >> 1;
        int vend = v1 + 1 >> 1;
        while (true) {
            int vb2 = vb << 1;
            do {
                buv[vb * bw + ub] = auv[vb2 * aw + 2 * ub + 1];
            } while (++ub < uend);
            if (++vb >= vend) break;
            ub = u0 >> 1;
        }
    }

    private static void interleaveLH(Subband a, Subband b, int u0, int u1, int v0, int v1) {
        int aw = a.width;
        int bw = b.width;
        float[] auv = a.floats;
        float[] buv = b.floats;
        int ub = u0 + 1 >> 1;
        int vb = v0 >> 1;
        int uend = u1 + 1 >> 1;
        int vend = v1 >> 1;
        while (true) {
            int vb2 = vb << 1;
            do {
                buv[vb * bw + ub] = auv[(vb2 + 1) * aw + 2 * ub];
            } while (++ub < uend);
            if (++vb >= vend) break;
            ub = u0 + 1 >> 1;
        }
    }

    private static void interleaveHH(Subband a, Subband b, int u0, int u1, int v0, int v1) {
        int aw = a.width;
        int bw = b.width;
        float[] auv = a.floats;
        float[] buv = b.floats;
        int ub = u0 >> 1;
        int vb = v0 >> 1;
        int uend = u1 >> 1;
        int vend = v1 >> 1;
        while (true) {
            int vb2 = vb << 1;
            do {
                buv[vb * bw + ub] = auv[(vb2 + 1) * aw + 2 * ub + 1];
            } while (++ub < uend);
            if (++vb >= vend) break;
            ub = u0 >> 1;
        }
    }

    public static SubbandCoefficient getInversed(List<SubbandCoefficient> subCos, int u0, int v0, boolean reversible) {
        SubbandCoefficient sb = subCos.get(0);
        for (int i = 1; i < subCos.size(); ++i) {
            sb = Trns.getNext(sb, subCos.get(i), u0, v0, reversible);
        }
        return sb;
    }

    private static void applyFilter(float[] data, int size, boolean reversible) {
        Trns.initData(data, size);
        int len = size >> 1;
        if (reversible) {
            Trns.reverse(data, len);
        } else {
            Trns.processData(data, len);
        }
    }

    private static void processData(float[] data, int len) {
        float next;
        int j = 1;
        int n = len + 4;
        while (n > 0) {
            int n2 = j;
            data[n2] = data[n2] * 0.8128931f;
            --n;
            j += 2;
        }
        j = 2;
        float current = 0.44350687f * data[j - 1];
        for (n = len + 2; n >= 0; --n) {
            next = 0.44350687f * data[j + 1];
            data[j] = 1.2301741f * data[j] - current - next;
            if (--n < 0) break;
            current = 0.44350687f * data[(j += 2) + 1];
            data[j] = 1.2301741f * data[j] - current - next;
            j += 2;
        }
        j = 3;
        current = 0.8829111f * data[j - 1];
        for (n = len + 1; n >= 0; --n) {
            next = 0.8829111f * data[j + 1];
            int n3 = j;
            data[n3] = data[n3] - (current + next);
            if (--n < 0) break;
            current = 0.8829111f * data[(j += 2) + 1];
            int n4 = j;
            data[n4] = data[n4] - (current + next);
            j += 2;
        }
        j = 4;
        current = -0.052980117f * data[j - 1];
        for (n = len; n >= 0; --n) {
            next = -0.052980117f * data[j + 1];
            int n5 = j;
            data[n5] = data[n5] - (current + next);
            if (--n < 0) break;
            current = -0.052980117f * data[(j += 2) + 1];
            int n6 = j;
            data[n6] = data[n6] - (current + next);
            j += 2;
        }
        if (len != 0) {
            j = 5;
            current = -1.5861343f * data[j - 1];
            for (n = len - 1; n >= 0; --n) {
                next = -1.5861343f * data[j + 1];
                int n7 = j;
                data[n7] = data[n7] - (current + next);
                if (--n < 0) break;
                current = -1.5861343f * data[(j += 2) + 1];
                int n8 = j;
                data[n8] = data[n8] - (current + next);
                j += 2;
            }
        }
    }

    private static void initData(float[] data, int size) {
        int aa = 3;
        int bb = 5;
        int cc = 4 + size - 2;
        int dd = 4 + size;
        data[aa--] = data[bb++];
        data[dd++] = data[cc--];
        data[aa--] = data[bb++];
        data[dd++] = data[cc--];
        data[aa--] = data[bb++];
        data[dd++] = data[cc--];
        data[aa] = data[bb];
        data[dd] = data[cc];
    }

    private static void reverse(float[] data, int len) {
        int n;
        int j = 4;
        for (n = len; n >= 0; --n) {
            int n2 = j;
            data[n2] = data[n2] - (float)((int)(data[j - 1] + data[j + 1] + 2.0f) >> 2);
            j += 2;
        }
        j = 5;
        for (n = len - 1; n >= 0; --n) {
            int n3 = j;
            data[n3] = data[n3] + (float)((int)(data[j - 1] + data[j + 1]) >> 1);
            j += 2;
        }
    }

    private static SubbandCoefficient getNext(SubbandCoefficient ll, SubbandCoefficient other, int u0, int v0, boolean reversible) {
        int widthLL = ll.width;
        int heightLL = ll.height;
        int width = other.width;
        int height = other.height;
        int w2 = width << 1;
        Trns.updateItemCount(ll, other, widthLL, heightLL, w2);
        int bufferPadding = 4;
        Trns.getK(other, u0, width, height, reversible);
        int numBuffers = 16;
        float[][] colBuffers = new float[numBuffers][height + 8];
        int currentBuffer = 0;
        int ss = 4 + height;
        if (height == 1) {
            Trns.handleSinglePixelHeight(other, v0, width);
        } else {
            Trns.handleOtherHeights(other, width, height, numBuffers, colBuffers, currentBuffer, ss, reversible);
        }
        SubbandCoefficient sc = new SubbandCoefficient();
        sc.width = width;
        sc.height = height;
        sc.floatItems = other.floatItems;
        return sc;
    }

    private static void handleOtherHeights(SubbandCoefficient other, int width, int height, int numBuffers, float[][] colBuffers, int currentBuffer, int ss, boolean reversible) {
        for (int u = 0; u < width; ++u) {
            if (currentBuffer == 0) {
                numBuffers = Math.min(width - u, numBuffers);
                int k = u;
                for (int l = 4; l < ss; ++l) {
                    for (int b = 0; b < numBuffers; ++b) {
                        colBuffers[b][l] = other.floatItems[k + b];
                    }
                    k += width;
                }
                currentBuffer = numBuffers;
            }
            float[] buffer = colBuffers[--currentBuffer];
            Trns.applyFilter(buffer, height, reversible);
            if (currentBuffer != 0) continue;
            int k = u - numBuffers + 1;
            for (int l = 4; l < ss; ++l) {
                for (int b = 0; b < numBuffers; ++b) {
                    other.floatItems[k + b] = colBuffers[b][l];
                }
                k += width;
            }
        }
    }

    private static void handleSinglePixelHeight(SubbandCoefficient other, int v0, int width) {
        if ((v0 & 1) != 0) {
            int u = 0;
            while (u < width) {
                int n = u++;
                other.floatItems[n] = (float)((double)other.floatItems[n] * 0.5);
            }
        }
    }

    private static void getK(SubbandCoefficient other, int u0, int width, int height, boolean reversible) {
        block3: {
            float[] rowBuffer;
            block2: {
                rowBuffer = new float[width + 8];
                if (width != 1) break block2;
                if ((u0 & 1) == 0) break block3;
                int k = 0;
                for (int v = 0; v < height; ++v) {
                    int n = k++;
                    other.floatItems[n] = other.floatItems[n] * 0.5f;
                }
                break block3;
            }
            int k = 0;
            for (int v = 0; v < height; ++v) {
                System.arraycopy(other.floatItems, k, rowBuffer, 4, width);
                Trns.applyFilter(rowBuffer, width, reversible);
                System.arraycopy(rowBuffer, 4, other.floatItems, k, width);
                k += width;
            }
        }
    }

    private static void updateItemCount(SubbandCoefficient ll, SubbandCoefficient other, int widthLL, int heightLL, int w2) {
        int k = 0;
        for (int i = 0; i < heightLL; ++i) {
            int l = i * w2;
            for (int j = 0; j < widthLL; ++j) {
                other.floatItems[l] = ll.floatItems[k++];
                l += 2;
            }
        }
    }
}

