/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.COD;
import com.idrsolutions.image.jpeg2000.data.Cmap;
import com.idrsolutions.image.jpeg2000.data.CodeBlock;
import com.idrsolutions.image.jpeg2000.data.EntropyEncoder;
import com.idrsolutions.image.jpeg2000.data.Palette;
import com.idrsolutions.image.jpeg2000.data.Precinct;
import com.idrsolutions.image.jpeg2000.data.PrecinctInfo;
import com.idrsolutions.image.jpeg2000.data.QCD;
import com.idrsolutions.image.jpeg2000.data.SIZ;
import com.idrsolutions.image.jpeg2000.data.Tile;
import com.idrsolutions.image.jpeg2000.data.TileBand;
import com.idrsolutions.image.jpeg2000.data.TileComponent;
import com.idrsolutions.image.jpeg2000.data.TileResolution;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Info {
    public static final int CS_CMYK = 12;
    public static final int CS_SYCC = 18;
    public int imageWidth;
    public int imageHeight;
    public int nComp;
    public int bitDepth;
    public byte[] bitDepths;
    public int enumerateCS;
    public final List<Integer> contiguousCodeStreamBoxes = new ArrayList<Integer>();
    public Tile tileProcess;
    public boolean mainSOC;
    public SIZ siz;
    public COD cod;
    public QCD qcd;
    public QCD[] qcc;
    public Palette palette;
    public final int[] ROI = new int[8];
    public Cmap cmap;
    public final HashMap<Integer, Tile> tilesMap = new HashMap();
    public final HashMap<Integer, Integer> cDef = new HashMap();
    public int[] magnArray = new int[4096];
    public byte[] nbrArray = new byte[4096];
    public byte[] signArray = new byte[4096];
    public byte[] curFlagArray = new byte[4096];
    public byte[] bitsDecArray = new byte[4096];
    public final byte[] a_Array = new byte[4096];
    public final EntropyEncoder entropy = new EntropyEncoder();

    public void generateTileMap() {
        int numXTiles = (int)Math.ceil(1.0 * (double)(this.siz.Xsiz - this.siz.XTOsiz) / (double)this.siz.XTsiz);
        int numYTiles = (int)Math.ceil(1.0 * (double)(this.siz.Ysiz - this.siz.YTOsiz) / (double)this.siz.YTsiz);
        int index = 0;
        for (int q = 0; q < numYTiles; ++q) {
            for (int p = 0; p < numXTiles; ++p) {
                Tile tile = new Tile();
                tile.x0 = Math.max(this.siz.XTOsiz + p * this.siz.XTsiz, this.siz.XOsiz);
                tile.y0 = Math.max(this.siz.YTOsiz + q * this.siz.YTsiz, this.siz.YOsiz);
                tile.x1 = Math.min(this.siz.XTOsiz + (p + 1) * this.siz.XTsiz, this.siz.Xsiz);
                tile.y1 = Math.min(this.siz.YTOsiz + (q + 1) * this.siz.YTsiz, this.siz.Ysiz);
                for (int i = 0; i < this.siz.Csiz; ++i) {
                    int XRsiz_ = this.siz.precisionInfo[i][1];
                    int YRsiz_ = this.siz.precisionInfo[i][2];
                    TileComponent tc = new TileComponent();
                    tc.x0 = (int)Math.ceil(1.0 * (double)tile.x0 / (double)XRsiz_);
                    tc.x1 = (int)Math.ceil(1.0 * (double)tile.x1 / (double)XRsiz_);
                    tc.y0 = (int)Math.ceil(1.0 * (double)tile.y0 / (double)YRsiz_);
                    tc.y1 = (int)Math.ceil(1.0 * (double)tile.y1 / (double)YRsiz_);
                    tile.components.add(tc);
                }
                this.tilesMap.put(index, tile);
                ++index;
            }
        }
    }

    public static void updateCodeBlocks(TileResolution tr, TileBand tb, int xcb_, int ycb_) {
        int codeblockWidth = 1 << xcb_;
        int codeblockHeight = 1 << ycb_;
        int cbx0 = tb.x0 >> xcb_;
        int cby0 = tb.y0 >> ycb_;
        int cbx1 = tb.x1 + codeblockWidth - 1 >> xcb_;
        int cby1 = tb.y1 + codeblockHeight - 1 >> ycb_;
        PrecinctInfo precintInfo = tr.precinctInfo;
        List<CodeBlock> codeblocks = tb.codeBlocks;
        List<Precinct> precincts = tb.precincts;
        for (int j = cby0; j < cby1; ++j) {
            for (int i = cbx0; i < cbx1; ++i) {
                Precinct precinct;
                int precintNumber;
                CodeBlock cblk = new CodeBlock();
                cblk.x = i;
                cblk.y = j;
                cblk.tbx0 = codeblockWidth * i;
                cblk.tby0 = codeblockHeight * j;
                cblk.tbx1 = codeblockWidth * (i + 1);
                cblk.tby1 = codeblockHeight * (j + 1);
                cblk.tbx0_ = Math.max(tb.x0, cblk.tbx0);
                cblk.tby0_ = Math.max(tb.y0, cblk.tby0);
                cblk.tbx1_ = Math.min(tb.x1, cblk.tbx1);
                cblk.tby1_ = Math.min(tb.y1, cblk.tby1);
                int pi = (int)Math.floor((double)(cblk.tbx0_ - tb.x0) / ((double)precintInfo.precinctWidthInSubband * 1.0));
                int pj = (int)Math.floor((double)(cblk.tby0_ - tb.y0) / ((double)precintInfo.precinctHeightInSubband * 1.0));
                cblk.precinctNumber = precintNumber = pi + pj * precintInfo.numPrecinctsWide;
                cblk.subbandType = tb.type;
                cblk.Lblock = 3;
                if (cblk.tbx1_ <= cblk.tbx0_ || cblk.tby1_ <= cblk.tby0_) continue;
                codeblocks.add(cblk);
                if (precincts.size() > precintNumber) {
                    precinct = precincts.get(precintNumber);
                    if (i < precinct.cbx0) {
                        precinct.cbx0 = i;
                    } else if (i > precinct.cbx1) {
                        precinct.cbx1 = i;
                    }
                    if (j < precinct.cby0) {
                        precinct.cbx0 = j;
                    } else if (j > precinct.cby1) {
                        precinct.cby1 = j;
                    }
                } else {
                    precinct = new Precinct();
                    precinct.cby0 = j;
                    precinct.cby1 = j;
                    precinct.cbx0 = i;
                    precinct.cbx1 = i;
                    precincts.add(precinct);
                }
                cblk.precinct = precinct;
            }
        }
    }

    public static void getComponentAsABGR(BufferedImage image, int[] pix) {
        switch (image.getType()) {
            case 10: {
                Info.updateGray(image, pix);
                break;
            }
            case 5: {
                Info.updateBGR(image, pix);
                break;
            }
            case 6: 
            case 7: {
                Info.updateABGR(image, pix);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                Info.updateRGB(image, pix);
                break;
            }
            case 4: {
                Info.updateBGR_INT(image, pix);
                break;
            }
            case 13: {
                Info.updateIndexed(image, pix);
                break;
            }
            case 11: {
                Info.updateGray16(image, pix);
                break;
            }
            default: {
                Info.updateCustom(image, pix);
            }
        }
    }

    private static void updateGray(BufferedImage image, int[] r) {
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < data.length; ++i) {
            r[i] = data[i] & 0xFF;
        }
    }

    private static void updateGray16(BufferedImage image, int[] pix) {
        short[] data = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < data.length; i += 2) {
            pix[i] = data[i] >> 8;
        }
    }

    private static void updateBGR(BufferedImage image, int[] pix) {
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int p = 0;
        for (int i = 0; i < data.length; i += 3) {
            int b = data[i] & 0xFF;
            int g = data[i + 1] & 0xFF;
            int r = data[i + 2] & 0xFF;
            pix[p++] = b << 16 | g << 8 | r;
        }
    }

    private static void updateABGR(BufferedImage image, int[] pix) {
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int p = 0;
        for (int i = 0; i < data.length; i += 4) {
            int a = data[i] & 0xFF;
            int b = data[i + 1] & 0xFF;
            int g = data[i + 2] & 0xFF;
            int r = data[i + 3] & 0xFF;
            pix[p++] = a << 24 | b << 16 | g << 8 | r;
        }
    }

    private static void updateRGB(BufferedImage image, int[] pix) {
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < pixels.length; ++i) {
            int v = pixels[i];
            int a = v >> 24 & 0xFF;
            int r = v >> 16 & 0xFF;
            int g = v >> 8 & 0xFF;
            int b = v & 0xFF;
            pix[i] = a << 24 | b << 16 | g << 8 | r;
        }
    }

    private static void updateBGR_INT(BufferedImage image, int[] pix) {
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        System.arraycopy(pixels, 0, pix, 0, pix.length);
    }

    private static void updateIndexed(BufferedImage image, int[] pix) {
        int[] argb = new int[256];
        IndexColorModel icm = (IndexColorModel)image.getColorModel();
        icm.getRGBs(argb);
        byte[] temp = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < temp.length; ++i) {
            int v = argb[temp[i] & 0xFF];
            int a = v >> 24 & 0xFF;
            int r = v >> 16 & 0xFF;
            int g = v >> 8 & 0xFF;
            int b = v & 0xFF;
            pix[i] = a << 24 | b << 16 | g << 8 | r;
        }
    }

    private static void updateCustom(BufferedImage image, int[] pix) {
        int i = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int v = image.getRGB(x, y);
                int a = v >> 24 & 0xFF;
                int r = v >> 16 & 0xFF;
                int g = v >> 8 & 0xFF;
                int b = v & 0xFF;
                pix[i++] = a << 24 | b << 16 | g << 8 | r;
            }
        }
    }

    public static float[] getBoundary(int x, int y, int x2, int y2, int iw, int ih, float[] data) {
        float[] result = new float[(x2 - x) * (y2 - y)];
        int p = 0;
        for (int i = y; i < x2; ++i) {
            for (int j = x; j < y2; ++j) {
                result[p++] = data[i * ih + j];
            }
        }
        return result;
    }
}

