/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.JDeliImageSupport;
import com.idrsolutions.image.jpeg.data.AdobeHolder;
import com.idrsolutions.image.jpeg.data.Component;
import com.idrsolutions.image.jpeg.data.DCT;
import com.idrsolutions.image.jpeg.data.Frame;
import com.idrsolutions.image.jpeg.data.HTree;
import com.idrsolutions.image.jpeg.data.IndexMap;
import com.idrsolutions.image.jpeg.data.Info;
import com.idrsolutions.image.jpeg.data.JFIFHolder;
import com.idrsolutions.image.jpeg.data.JpegScanner;
import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import com.idrsolutions.image.jpeglossless.JpegLosslessDecoder;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public class JpegDecoder
extends JDeliImage
implements Decoder {
    private int offset;
    private byte[] data;
    private boolean cmykInverted = true;
    private final HashMap<Integer, int[]> qTables = new HashMap();
    private Info info;
    public static final byte[] ZIGZAGORDER = new byte[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};

    @Override
    public BufferedImage read(byte[] jpegRawData) throws Exception {
        this.info = new Info();
        this.offset = 0;
        this.updateJpegInfo(jpegRawData);
        if (this.info.isLossless) {
            JpegLosslessDecoder decoder = new JpegLosslessDecoder();
            return decoder.read(jpegRawData);
        }
        return JDeliImageSupport.optimiseImage(JpegDecoder.getBufferdImageFromInfo(this.info, this.cmykInverted));
    }

    @Override
    public BufferedImage read(File file) throws Exception {
        byte[] bytes = new byte[(int)file.length()];
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            dis.readFully(bytes);
        }
        return JDeliImageSupport.optimiseImage(this.read(bytes));
    }

    private static BufferedImage getFromGray(int width, int height, byte[] input) {
        BufferedImage image = new BufferedImage(width, height, 10);
        byte[] pixelsByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        System.arraycopy(input, 0, pixelsByte, 0, pixelsByte.length);
        return image;
    }

    private static void fromRGBToBGR(byte[] input) {
        int ii = input.length;
        for (int i = 0; i < ii; i += 3) {
            byte t = input[i];
            input[i] = input[i + 2];
            input[i + 2] = t;
        }
    }

    private static void fromYUVtoBGR(byte[] input) {
        int ii = input.length;
        for (int i = 0; i < ii; i += 3) {
            int y = ((input[i] & 0xFF) << 8) + 128;
            int u = (input[i + 1] & 0xFF) - 128;
            int v = (input[i + 2] & 0xFF) - 128;
            int r = y + 359 * v >> 8;
            int g = y - 88 * u - 183 * v >> 8;
            int b = y + 454 * u >> 8;
            byte by = (byte)(b < 0 ? 0 : (byte)(input[i] = (byte)(b > 255 ? -1 : (byte)b)));
            byte by2 = (byte)(g < 0 ? 0 : (byte)(input[i + 1] = (byte)(g > 255 ? -1 : (byte)g)));
            input[i + 2] = (byte)(r < 0 ? 0 : (byte)(r > 255 ? -1 : (byte)r));
        }
    }

    private static BufferedImage getFromCMYK(int width, int height, byte[] input, boolean isInversed) {
        BufferedImage image = new BufferedImage(width, height, 5);
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        if (isInversed) {
            int ii = input.length;
            for (int i = 0; i < ii; ++i) {
                input[i] = (byte)(~(input[i] & 0xFF));
            }
        }
        EnumeratedSpace.convertCMYKToBGR(input, pixels);
        return image;
    }

    private static BufferedImage getFromYCCK(int width, int height, byte[] input, boolean isInversed) {
        int i;
        int ii;
        BufferedImage image = new BufferedImage(width, height, 5);
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        if (isInversed) {
            ii = input.length;
            for (i = 0; i < ii; ++i) {
                input[i] = (byte)(~(input[i] & 0xFF));
            }
        }
        ii = width * height * 4;
        for (i = 0; i < ii; i += 4) {
            int y = input[i] & 0xFF;
            int u = input[i + 1] & 0xFF;
            int v = input[i + 2] & 0xFF;
            int c = (int)(434.456 - (double)y - 1.402 * (double)v);
            int m = (int)(119.541 - (double)y + 0.344 * (double)u + 0.714 * (double)v);
            y = (int)(481.816 - (double)y - 1.772 * (double)u);
            byte by = (byte)(c < 0 ? 0 : (byte)(input[i] = (byte)(c > 255 ? -1 : (byte)c)));
            byte by2 = (byte)(m < 0 ? 0 : (byte)(input[i + 1] = (byte)(m > 255 ? -1 : (byte)m)));
            input[i + 2] = (byte)(y < 0 ? 0 : (byte)(y > 255 ? -1 : (byte)y));
        }
        EnumeratedSpace.convertCMYKToBGR(input, pixels);
        return image;
    }

    private static BufferedImage getBufferdImageFromInfo(Info info, boolean cmykInverted) throws IOException {
        BufferedImage image = null;
        switch (info.nComp) {
            case 1: {
                byte[] input = JpegDecoder.decodeSamples(info);
                image = JpegDecoder.getFromGray(info.width, info.height, input);
                break;
            }
            case 2: {
                throw new IOException("two color component jpegs not supported yet");
            }
            case 3: {
                image = new BufferedImage(info.width, info.height, 5);
                byte[] input = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                JpegDecoder.decodeSamplesWithOutput(info, input);
                if (info.adobe != null && info.adobe.transformCode == 0) {
                    JpegDecoder.fromRGBToBGR(input);
                    break;
                }
                JpegDecoder.fromYUVtoBGR(input);
                break;
            }
            case 4: {
                byte[] input = JpegDecoder.decodeSamples(info);
                image = info.adobe == null ? JpegDecoder.getFromCMYK(info.width, info.height, input, cmykInverted) : (info.adobe.transformCode == 0 ? JpegDecoder.getFromCMYK(info.width, info.height, input, cmykInverted) : JpegDecoder.getFromYCCK(info.width, info.height, input, cmykInverted));
            }
        }
        return image;
    }

    public byte[] readComponentsAsRawBytes(byte[] jpegRawData) throws Exception {
        this.info = new Info();
        this.offset = 0;
        this.updateJpegInfo(jpegRawData);
        return JpegDecoder.decodeSamples(this.info);
    }

    public byte[] readAsUnconvertedBytes(byte[] jpegRawData, int adobeColorTransform) throws Exception {
        this.info = new Info();
        this.offset = 0;
        this.updateJpegInfo(jpegRawData);
        byte[] output = JpegDecoder.decodeSamples(this.info);
        switch (this.info.nComp) {
            case 3: {
                int colorTransform;
                int n = colorTransform = adobeColorTransform == -1 ? 1 : adobeColorTransform;
                if (this.info.adobe != null) {
                    if (this.info.adobe.transformCode == 0) break;
                    JpegDecoder.convertYUVToRGB(output);
                    break;
                }
                if (colorTransform != 1) break;
                JpegDecoder.convertYUVToRGB(output);
                break;
            }
            case 4: {
                int colorTransform;
                int n = colorTransform = adobeColorTransform == -1 ? 0 : adobeColorTransform;
                if (this.info.adobe != null) {
                    if (this.info.adobe.transformCode == 0) break;
                    JpegDecoder.convertYCCKtoCMYK(output);
                    break;
                }
                if (colorTransform != 1) break;
                JpegDecoder.convertYCCKtoCMYK(output);
            }
        }
        return output;
    }

    private static void convertYCCKtoCMYK(byte[] output) {
        int len = output.length;
        for (int i = 0; i < len; i += 4) {
            int y = output[i] & 0xFF;
            int u = output[i + 1] & 0xFF;
            int v = output[i + 2] & 0xFF;
            double cc = 434.456 - (double)y - 1.402 * (double)v;
            double mm = 119.541 - (double)y + 0.344 * (double)u + 0.714 * (double)v;
            double yy = 481.816 - (double)y - 1.772 * (double)u;
            byte by = (byte)(cc < 0.0 ? 0 : (byte)(output[i] = (byte)(cc > 255.0 ? -1 : (byte)cc)));
            byte by2 = (byte)(mm < 0.0 ? 0 : (byte)(output[i + 1] = (byte)(mm > 255.0 ? -1 : (byte)mm)));
            output[i + 2] = (byte)(yy < 0.0 ? 0 : (byte)(yy > 255.0 ? -1 : (byte)yy));
        }
    }

    private static void convertYUVToRGB(byte[] output) {
        int len = output.length;
        for (int i = 0; i < len; i += 3) {
            int y = output[i] & 0xFF;
            int u = (output[i + 1] & 0xFF) - 128;
            int v = (output[i + 2] & 0xFF) - 128;
            int r = y + 45 * v / 32;
            int g = y - (11 * u + 23 * v) / 32;
            int b = y + 113 * u / 64;
            byte by = (byte)(r < 0 ? 0 : (byte)(output[i] = (byte)(r > 255 ? -1 : (byte)r)));
            byte by2 = (byte)(g < 0 ? 0 : (byte)(output[i + 1] = (byte)(g > 255 ? -1 : (byte)g)));
            output[i + 2] = (byte)(b < 0 ? 0 : (byte)(b > 255 ? -1 : (byte)b));
        }
    }

    private static byte[] decodeSamples(Info info) {
        byte[] output = new byte[info.width * info.height * info.nComp];
        JpegDecoder.decodeSamplesWithOutput(info, output);
        return output;
    }

    private static void decodeSamplesWithOutput(Info info, byte[] output) {
        int nc = info.nComp;
        int iw = info.width;
        int ih = info.height;
        for (int i = 0; i < nc; ++i) {
            int w;
            int yi;
            int h;
            Component comp = info.frame.components.get(i);
            int blockX18 = comp.blocksX + 1 << 3;
            float scaleX = (float)comp.h * 1.0f / (float)info.maxH;
            float scaleY = (float)comp.v * 1.0f / (float)info.maxV;
            short[] compData = comp.codeBlock;
            int po = i;
            if (scaleX == 1.0f && scaleY == 1.0f) {
                for (h = 0; h < ih; ++h) {
                    yi = blockX18 * (h & 0xFFFFFF8) | (h & 7) << 3;
                    for (w = 0; w < iw; ++w) {
                        output[po] = (byte)compData[yi + ((w & 0xFFFFFF8) << 3 | w & 7)];
                        po += nc;
                    }
                }
                continue;
            }
            for (h = 0; h < ih; ++h) {
                int k = (int)((float)h * scaleY);
                yi = blockX18 * (k & 0xFFFFFF8) | (k & 7) << 3;
                for (w = 0; w < iw; ++w) {
                    int j = (int)((float)w * scaleX);
                    output[po] = (byte)compData[yi + ((j & 0xFFFFFF8) << 3 | j & 7)];
                    po += nc;
                }
            }
        }
    }

    private void updateJpegInfo(byte[] data) throws Exception {
        this.data = data;
        int length = data.length;
        int ri = 0;
        Frame frame = new Frame();
        if (this.readUShort() != 65496) {
            throw new Exception("This File is not a valid JPEG");
        }
        HTree[] huffmanTablesAC = new HTree[10];
        HTree[] huffmanTablesDC = new HTree[10];
        int markerRead = this.readUShort();
        while (markerRead != 65497 && this.offset < length) {
            switch (markerRead) {
                case 65504: 
                case 65505: 
                case 65506: 
                case 65507: 
                case 65508: 
                case 65509: 
                case 65510: 
                case 65511: 
                case 65512: 
                case 65513: 
                case 65514: 
                case 65515: 
                case 65516: 
                case 65517: 
                case 65518: 
                case 65519: {
                    this.updateAPPMarkers(markerRead);
                    break;
                }
                case 65472: 
                case 65473: 
                case 65474: {
                    this.updateSOFMarkers(frame, markerRead, data);
                    break;
                }
                case 65475: 
                case 65477: 
                case 65478: 
                case 65479: {
                    this.info.isLossless = true;
                    return;
                }
                case 65481: 
                case 65482: 
                case 65483: {
                    throw new Exception("Arithmetic encoded Jpeg is not supported yet");
                }
                case 65499: {
                    this.updateDQT(data);
                    break;
                }
                case 65476: {
                    this.updateDHTMarkers(data, huffmanTablesDC, huffmanTablesAC);
                    break;
                }
                case 65501: {
                    this.offset += 2;
                    ri = this.readUShort();
                    break;
                }
                case 65498: {
                    this.updateSOSMarkers(data, frame, huffmanTablesDC, huffmanTablesAC, ri);
                    break;
                }
                case 65534: {
                    this.readDataArray();
                    break;
                }
                case 65535: {
                    if ((data[this.offset] & 0xFF) == 255) break;
                    --this.offset;
                    break;
                }
                case 65496: {
                    break;
                }
                default: {
                    int len = this.readUShort();
                    this.offset += len - 2;
                }
            }
            if (this.offset + 1 >= length) break;
            markerRead = this.readUShort();
            while (markerRead >> 8 < 255 && this.offset < length) {
                markerRead = this.readUShort();
            }
        }
        JpegDecoder.setInfo(frame, this.info, this.qTables);
    }

    private static void setInfo(Frame frame, Info info, HashMap<Integer, int[]> qTables) {
        info.width = frame.scanH;
        info.height = frame.scanV;
        for (Component component : frame.components) {
            component.qTable = qTables.get(component.qID);
            JpegDecoder.buildComponentData(component, frame.precision);
        }
        info.maxH = frame.maxH;
        info.maxV = frame.maxV;
        info.nComp = frame.components.size();
        info.frame = frame;
    }

    private void updateSOFMarkers(Frame frame, int markerRead, byte[] data1) {
        this.offset += 2;
        frame.extended = markerRead == 65473;
        frame.progressive = markerRead == 65474;
        frame.precision = data1[this.offset++] & 0xFF;
        frame.scanV = this.readUShort();
        frame.scanH = this.readUShort();
        int componentsCount = data1[this.offset++] & 0xFF;
        int maxH = 0;
        int maxV = 0;
        for (int i = 0; i < componentsCount; ++i) {
            int componentId = data1[this.offset] & 0xFF;
            int vh = data1[this.offset + 1] & 0xFF;
            int h = vh >> 4;
            int v = vh & 0xF;
            maxH = Math.max(maxH, h);
            maxV = Math.max(maxV, v);
            int qId = data1[this.offset + 2] & 0xFF;
            Component comp = new Component();
            comp.h = h;
            comp.v = v;
            comp.qID = qId;
            frame.components.add(comp);
            frame.componentID.put(componentId, frame.components.size() - 1);
            this.offset += 3;
        }
        frame.maxH = maxH;
        frame.maxV = maxV;
        JpegDecoder.initializeComponents(frame);
    }

    private void updateDHTMarkers(byte[] data1, HTree[] huffmanTablesDC, HTree[] huffmanTablesAC) {
        int codeLengthTotal;
        int huffmanLength = this.readUShort();
        for (int i = 2; i < huffmanLength; i += 17 + codeLengthTotal) {
            int huffmanTableSpec = data1[this.offset++] & 0xFF;
            int[] codeLengths = new int[16];
            codeLengthTotal = 0;
            for (int j = 0; j < 16; ++j) {
                codeLengths[j] = data1[this.offset] & 0xFF;
                codeLengthTotal += codeLengths[j];
                ++this.offset;
            }
            int[] huffmanValues = new int[codeLengthTotal];
            int j = 0;
            while (j < codeLengthTotal) {
                huffmanValues[j] = data1[this.offset] & 0xFF;
                ++j;
                ++this.offset;
            }
            if (huffmanTableSpec >> 4 == 0) {
                huffmanTablesDC[huffmanTableSpec & 0xF] = JpegDecoder.generateHuffmanTable(codeLengths, huffmanValues);
                continue;
            }
            huffmanTablesAC[huffmanTableSpec & 0xF] = JpegDecoder.generateHuffmanTable(codeLengths, huffmanValues);
        }
    }

    private void updateSOSMarkers(byte[] data1, Frame frame, HTree[] huffmanTablesDC, HTree[] huffmanTablesAC, int ri) {
        this.offset += 2;
        int sc = data1[this.offset++] & 0xFF;
        ArrayList<Component> components = new ArrayList<Component>();
        for (int i = 0; i < sc; ++i) {
            int componentIndex = frame.componentID.get(data1[this.offset++] & 0xFF);
            Component component = frame.components.get(componentIndex);
            int tableSpec = data1[this.offset++] & 0xFF;
            component.huffmanTableDC = huffmanTablesDC[tableSpec >> 4];
            component.huffmanTableAC = huffmanTablesAC[tableSpec & 0xF];
            components.add(component);
        }
        int sStart = data1[this.offset++] & 0xFF;
        int sEnd = data1[this.offset++] & 0xFF;
        int sApprox = data1[this.offset++] & 0xFF;
        JpegScanner scanner = new JpegScanner(data1);
        this.offset = scanner.decodeScan(this.offset, frame, components, ri, sStart, sEnd, sApprox >> 4, sApprox & 0xF);
    }

    private void updateAPPMarkers(int markerRead) {
        byte[] apps = this.readDataArray();
        if (markerRead == 65504 && JpegDecoder.isJFIF(apps)) {
            JFIFHolder jfif = new JFIFHolder();
            jfif.majorNo = apps[5] & 0xFF;
            jfif.minorNo = apps[6] & 0xFF;
            jfif.xDensity = (apps[8] & 0xFF) << 8 | apps[9] & 0xFF;
            jfif.yDensity = (apps[10] & 0xFF) << 8 | apps[11] & 0xFF;
            jfif.thumbnailWidth = apps[12] & 0xFF;
            jfif.thumbnailHeight = apps[13] & 0xFF;
            this.info.jfif = jfif;
        } else if (markerRead == 65518 && JpegDecoder.isAdobe(apps)) {
            AdobeHolder adobe = new AdobeHolder();
            adobe.version = apps[6] & 0xFF;
            adobe.flag0 = apps[7] & 0xFF00 | apps[8] & 0xFF;
            adobe.flag1 = apps[9] & 0xFF00 | apps[10] & 0xFF;
            adobe.transformCode = apps[11] & 0xFF;
            this.info.adobe = adobe;
        }
    }

    private void updateDQT(byte[] data) {
        int dqtLen = this.readUShort();
        int quantizationTablesEnd = dqtLen + this.offset - 2;
        while (this.offset < quantizationTablesEnd) {
            byte z;
            int i;
            int qs = data[this.offset++] & 0xFF;
            int[] tableData = new int[64];
            if (qs >> 4 == 0) {
                for (i = 0; i < 64; ++i) {
                    z = ZIGZAGORDER[i];
                    tableData[z] = data[this.offset++] & 0xFF;
                }
            } else if (qs >> 4 == 1) {
                for (i = 0; i < 64; ++i) {
                    z = ZIGZAGORDER[i];
                    tableData[z] = this.readUShort();
                }
            }
            this.qTables.put(qs & 0xF, tableData);
        }
    }

    private int readUShort() {
        int value = (this.data[this.offset] & 0xFF) << 8 | this.data[this.offset + 1] & 0xFF;
        this.offset += 2;
        return value;
    }

    private static boolean isJFIF(byte[] db) {
        return (db[0] & 0xFF) == 74 && (db[1] & 0xFF) == 70 && (db[2] & 0xFF) == 73 && (db[3] & 0xFF) == 70 && (db[4] & 0xFF) == 0;
    }

    private static boolean isAdobe(byte[] db) {
        return (db[0] & 0xFF) == 65 && (db[1] & 0xFF) == 100 && (db[2] & 0xFF) == 111 && (db[3] & 0xFF) == 98 && (db[4] & 0xFF) == 101;
    }

    private byte[] readDataArray() {
        int len = this.readUShort();
        byte[] bb = new byte[len - 2];
        System.arraycopy(this.data, this.offset, bb, 0, bb.length);
        this.offset += bb.length;
        return bb;
    }

    private static void initializeComponents(Frame frame) {
        int mcusPerLine = (int)Math.ceil((double)frame.scanH / 8.0 / (double)frame.maxH);
        int mcusPerColumn = (int)Math.ceil((double)frame.scanV / 8.0 / (double)frame.maxV);
        for (Component component : frame.components) {
            int blocksPerLine = (int)Math.ceil(Math.ceil((double)frame.scanH / 8.0) * (double)component.h / (1.0 * (double)frame.maxH));
            int blocksPerColumn = (int)Math.ceil(Math.ceil((double)frame.scanV / 8.0) * (double)component.v / (1.0 * (double)frame.maxV));
            int blocksPerLineForMcu = mcusPerLine * component.h;
            int blocksPerColumnForMcu = mcusPerColumn * component.v;
            int blocksBufferSize = 64 * (blocksPerColumnForMcu + 1) * (blocksPerLineForMcu + 1);
            component.codeBlock = new short[blocksBufferSize];
            component.blocksX = blocksPerLine;
            component.blocksY = blocksPerColumn;
        }
        frame.mcusX = mcusPerLine;
        frame.mcusY = mcusPerColumn;
    }

    private static void buildComponentData(Component component, int bitsCount) {
        int blocksPerLine = component.blocksX;
        int blocksPerColumn = component.blocksY;
        if (bitsCount == 12) {
            for (int blockRow = 0; blockRow < blocksPerColumn; ++blockRow) {
                for (int blockCol = 0; blockCol < blocksPerLine; ++blockCol) {
                    int offset = JpegScanner.getCodeBlockOffset(component, blockRow, blockCol);
                    DCT.IDCTQ12(component, offset);
                }
            }
        } else {
            int[] p = new int[64];
            for (int blockRow = 0; blockRow < blocksPerColumn; ++blockRow) {
                for (int blockCol = 0; blockCol < blocksPerLine; ++blockCol) {
                    int offset = JpegScanner.getCodeBlockOffset(component, blockRow, blockCol);
                    DCT.IDCTQ(component, offset, p);
                }
            }
        }
    }

    public void setInverted(boolean inverted) {
        this.cmykInverted = inverted;
    }

    public Info getInfo() {
        return this.info;
    }

    private static HTree generateHuffmanTable(int[] codeLengths, int[] symbols) {
        int length;
        int k = 0;
        Stack<IndexMap> code = new Stack<IndexMap>();
        for (length = 16; length > 0 && codeLengths[length - 1] == 0; --length) {
        }
        IndexMap p = new IndexMap(new HTree());
        code.push(p);
        for (int i = 0; i < length; ++i) {
            IndexMap q;
            int cc = codeLengths[i];
            for (int j = 0; j < cc; ++j) {
                p = (IndexMap)code.pop();
                p.children.nodes[p.index] = new HTree(symbols[k]);
                while (p.index > 0) {
                    p = (IndexMap)code.pop();
                }
                ++p.index;
                code.push(p);
                while (code.size() <= i) {
                    q = new IndexMap(new HTree());
                    code.push(q);
                    p.children.nodes[p.index] = q.children;
                    p = q;
                }
                ++k;
            }
            if (i + 1 >= length) continue;
            q = new IndexMap(new HTree());
            code.push(q);
            p.children.nodes[p.index] = q.children;
            p = q;
        }
        return ((IndexMap)code.elementAt((int)0)).children;
    }

    static {
        String imageLib2ClassPath = "com/idrsolutions/image/JDeliImageSupport.class";
        ClassLoader loader = JpegDecoder.class.getClassLoader();
        if (loader.getResource("com/idrsolutions/image/JDeliImageSupport.class") != null) {
            try {
                loader.loadClass("com.idrsolutions.image.JDeliImageSupport").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                System.out.println("Unable to instance JDeli " + ex);
            }
        }
    }
}

