/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heif.data;

import com.idrsolutions.image.utility.BitReader;

class ScalingListData {
    private final byte[][] scaling_list_pred_mode_flag = new byte[4][6];
    private final int[][] scaling_list_pred_matrix_id_delta = new int[4][6];
    private final int[][] scaling_list_dc_coef_minus8 = new int[4][6];
    private int[][][] scalingList;
    private int nextCoef;
    private int coefNum;
    private int scaling_list_delta_coef;

    public ScalingListData(BitReader reader) {
        for (int sizeId = 0; sizeId < 4; ++sizeId) {
            for (int matrixId = 0; matrixId < 6; matrixId += sizeId == 3 ? 3 : 1) {
                this.scaling_list_pred_mode_flag[sizeId][matrixId] = reader.readBit();
                if (this.scaling_list_pred_mode_flag[sizeId][matrixId] == 0) {
                    this.scaling_list_pred_matrix_id_delta[sizeId][matrixId] = reader.ue();
                    continue;
                }
                this.nextCoef = 8;
                this.coefNum = Math.min(64, 1 << 4 + (sizeId << 1));
                if (sizeId > 1) {
                    this.scaling_list_dc_coef_minus8[sizeId - 2][matrixId] = reader.se();
                    this.nextCoef = this.scaling_list_dc_coef_minus8[sizeId - 2][matrixId] + 8;
                }
                for (int i = 0; i < this.coefNum; ++i) {
                    this.scaling_list_delta_coef = reader.se();
                    this.scalingList[sizeId][matrixId][i] = this.nextCoef = (this.nextCoef + this.scaling_list_delta_coef + 256) % 256;
                }
            }
        }
    }
}

