/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heif.data;

import com.idrsolutions.image.heif.data.D;
import com.idrsolutions.image.heif.data.RbspTrailingBits;
import com.idrsolutions.image.heif.data.ScalingListData;
import com.idrsolutions.image.utility.BitReader;

class Pps {
    private final int pps_pic_parameter_set_id;
    private final int pps_seq_parameter_set_id;
    final byte dependent_slice_segments_enabled_flag;
    final byte output_flag_present_flag;
    final int num_extra_slice_header_bits;
    private final byte sign_data_hiding_enabled_flag;
    final byte cabac_init_present_flag;
    private final int num_ref_idx_l0_default_active_minus1;
    private final int num_ref_idx_l1_default_active_minus1;
    private final int init_qp_minus26;
    private final byte constrained_intra_pred_flag;
    private final byte transform_skip_enabled_flag;
    final byte cu_qp_delta_enabled_flag;
    private final int pps_cb_qp_offset;
    private final int pps_cr_qp_offset;
    final byte pps_slice_chroma_qp_offsets_present_flag;
    final byte weighted_pred_flag;
    final byte weighted_bipred_flag;
    private final byte transquant_bypass_enabled_flag;
    final byte tiles_enabled_flag;
    final byte entropy_coding_sync_enabled_flag;
    private int diff_cu_qp_delta_depth;
    int nTile_columns_minus1;
    int nTile_rows_minus1;
    byte uniform_spacing_flag;
    int[] column_width_minus1;
    int[] row_height_minus1;
    private byte loop_filter_across_tiles_enabled_flag;
    final byte pps_loop_filter_across_slices_enabled_flag;
    private final byte deblocking_filter_control_present_flag;
    byte deblocking_filter_override_enabled_flag;
    private byte pps_deblocking_filter_disabled_flag;
    private int pps_beta_offset_div2;
    private int pps_tc_offset_div2;
    private final byte pps_scaling_list_data_present_flag;
    private ScalingListData scaling_list_data;
    final byte lists_modification_present_flag;
    private final int log2_parallel_merge_level_minus2;
    final byte slice_segment_header_extension_present_flag;
    private final byte pps_extension_present_flag;
    private byte pps_range_extension_flag;
    private byte pps_multilayer_extension_flag;
    private byte pps_3d_extension_flag;
    private byte pps_scc_extension_flag;
    private int pps_extension_4bits;
    private int log2_max_transform_skip_block_size_minus2;
    private byte cross_component_prediction_enabled_flag;
    byte chroma_qp_offset_list_enabled_flag;
    private int diff_cu_chroma_qp_offset_depth;
    private int chroma_qp_offset_list_len_minus1;
    private int[] cb_qp_offset_list;
    private int[] cr_qp_offset_list;
    private int log2_sao_offset_scale_luma;
    private int log2_sao_offset_scale_chroma;
    private byte pps_curr_pic_ref_enabled_flag;
    private byte residual_adaptive_colour_transform_enabled_flag;
    byte pps_slice_act_qp_offsets_present_flag;
    private int pps_act_y_qp_offset_plus5;
    private int pps_act_cb_qp_offset_plus5;
    private int pps_act_cr_qp_offset_plus3;
    private byte pps_palette_predictor_initializer_present_flag;
    private int pps_num_palette_predictor_initializer;
    private byte monochrome_palette_flag;
    private int luma_bit_depth_entry_minus8;
    private int chroma_bit_depth_entry_minus8;
    private int[][] pps_palette_predictor_initializers;
    private byte pps_extension_data_flag;
    private final RbspTrailingBits rbspTrailingBits;

    public Pps(BitReader reader, D d) {
        this.pps_pic_parameter_set_id = reader.ue();
        this.pps_seq_parameter_set_id = reader.ue();
        this.dependent_slice_segments_enabled_flag = reader.readBit();
        this.output_flag_present_flag = reader.readBit();
        this.num_extra_slice_header_bits = reader.readBits(3);
        this.sign_data_hiding_enabled_flag = reader.readBit();
        this.cabac_init_present_flag = reader.readBit();
        this.num_ref_idx_l0_default_active_minus1 = reader.ue();
        this.num_ref_idx_l1_default_active_minus1 = reader.ue();
        this.init_qp_minus26 = reader.se();
        this.constrained_intra_pred_flag = reader.readBit();
        this.transform_skip_enabled_flag = reader.readBit();
        this.cu_qp_delta_enabled_flag = reader.readBit();
        if (this.cu_qp_delta_enabled_flag != 0) {
            this.diff_cu_qp_delta_depth = reader.ue();
        }
        this.pps_cb_qp_offset = reader.se();
        this.pps_cr_qp_offset = reader.se();
        this.pps_slice_chroma_qp_offsets_present_flag = reader.readBit();
        this.weighted_pred_flag = reader.readBit();
        this.weighted_bipred_flag = reader.readBit();
        this.transquant_bypass_enabled_flag = reader.readBit();
        this.tiles_enabled_flag = reader.readBit();
        this.entropy_coding_sync_enabled_flag = reader.readBit();
        if (this.tiles_enabled_flag != 0) {
            this.nTile_columns_minus1 = reader.ue();
            this.nTile_rows_minus1 = reader.ue();
            this.uniform_spacing_flag = reader.readBit();
            if (this.uniform_spacing_flag == 0) {
                int i;
                this.column_width_minus1 = new int[this.nTile_columns_minus1];
                for (i = 0; i < this.nTile_columns_minus1; ++i) {
                    this.column_width_minus1[i] = reader.ue();
                }
                this.row_height_minus1 = new int[this.nTile_rows_minus1];
                for (i = 0; i < this.nTile_rows_minus1; ++i) {
                    this.row_height_minus1[i] = reader.ue();
                }
            }
            this.loop_filter_across_tiles_enabled_flag = reader.readBit();
        }
        this.pps_loop_filter_across_slices_enabled_flag = reader.readBit();
        this.deblocking_filter_control_present_flag = reader.readBit();
        if (this.deblocking_filter_control_present_flag != 0) {
            this.deblocking_filter_override_enabled_flag = reader.readBit();
            this.pps_deblocking_filter_disabled_flag = reader.readBit();
            if (this.pps_deblocking_filter_disabled_flag == 0) {
                this.pps_beta_offset_div2 = reader.se();
                this.pps_tc_offset_div2 = reader.se();
            }
        }
        this.pps_scaling_list_data_present_flag = reader.readBit();
        if (this.pps_scaling_list_data_present_flag != 0) {
            this.scaling_list_data = new ScalingListData(reader);
        }
        this.lists_modification_present_flag = reader.readBit();
        this.log2_parallel_merge_level_minus2 = reader.ue();
        this.slice_segment_header_extension_present_flag = reader.readBit();
        this.pps_extension_present_flag = reader.readBit();
        d.log2MinCuQpDeltaSize = d.ctbLog2SizeY - this.diff_cu_qp_delta_depth;
        d.log2ParMrgLevel = this.log2_parallel_merge_level_minus2 + 2;
        if (this.pps_extension_present_flag != 0) {
            this.pps_range_extension_flag = reader.readBit();
            this.pps_multilayer_extension_flag = reader.readBit();
            this.pps_3d_extension_flag = reader.readBit();
            this.pps_scc_extension_flag = reader.readBit();
            this.pps_extension_4bits = reader.readBits(4);
        }
        if (this.pps_range_extension_flag != 0) {
            this.updatePpsRange(reader, d);
        }
        if (this.pps_multilayer_extension_flag != 0) {
            // empty if block
        }
        if (this.pps_3d_extension_flag != 0) {
            // empty if block
        }
        if (this.pps_scc_extension_flag != 0) {
            this.updatePpsScc(reader);
        }
        if (this.pps_extension_4bits != 0) {
            while (BitReader.moreRbspData()) {
                this.pps_extension_data_flag = reader.readBit();
            }
        }
        this.rbspTrailingBits = new RbspTrailingBits(reader);
    }

    private void updatePpsRange(BitReader reader, D d) {
        if (this.transform_skip_enabled_flag != 0) {
            this.log2_max_transform_skip_block_size_minus2 = reader.ue();
        }
        d.log2MaxTransformSkipSize = this.log2_max_transform_skip_block_size_minus2 + 2;
        this.cross_component_prediction_enabled_flag = reader.readBit();
        this.chroma_qp_offset_list_enabled_flag = reader.readBit();
        if (this.chroma_qp_offset_list_enabled_flag != 0) {
            this.diff_cu_chroma_qp_offset_depth = reader.ue();
            this.chroma_qp_offset_list_len_minus1 = reader.ue();
            this.cb_qp_offset_list = new int[this.chroma_qp_offset_list_len_minus1];
            this.cr_qp_offset_list = new int[this.chroma_qp_offset_list_len_minus1];
            for (int i = 0; i <= this.chroma_qp_offset_list_len_minus1; ++i) {
                this.cb_qp_offset_list[i] = reader.se();
                this.cr_qp_offset_list[i] = reader.se();
            }
        }
        d.log2MinCuChromaQpOffsetSize = d.ctbLog2SizeY - this.diff_cu_chroma_qp_offset_depth;
        this.log2_sao_offset_scale_luma = reader.ue();
        this.log2_sao_offset_scale_chroma = reader.ue();
    }

    private void updatePpsScc(BitReader reader) {
        this.pps_curr_pic_ref_enabled_flag = reader.readBit();
        this.residual_adaptive_colour_transform_enabled_flag = reader.readBit();
        if (this.residual_adaptive_colour_transform_enabled_flag != 0) {
            this.pps_slice_act_qp_offsets_present_flag = reader.readBit();
            this.pps_act_y_qp_offset_plus5 = reader.se();
            this.pps_act_cb_qp_offset_plus5 = reader.se();
            this.pps_act_cr_qp_offset_plus3 = reader.se();
        }
        this.pps_palette_predictor_initializer_present_flag = reader.readBit();
        if (this.pps_palette_predictor_initializer_present_flag != 0) {
            this.pps_num_palette_predictor_initializer = reader.ue();
            if (this.pps_num_palette_predictor_initializer > 0) {
                this.monochrome_palette_flag = reader.readBit();
                this.luma_bit_depth_entry_minus8 = reader.ue();
                if (this.monochrome_palette_flag == 0) {
                    this.chroma_bit_depth_entry_minus8 = reader.ue();
                }
                int nComp = this.monochrome_palette_flag != 0 ? 1 : 3;
                this.pps_palette_predictor_initializers = new int[nComp][this.pps_num_palette_predictor_initializer];
                for (int comp = 0; comp < nComp; ++comp) {
                    for (int i = 0; i < this.pps_num_palette_predictor_initializer; ++i) {
                        if (comp == 0) {
                            this.pps_palette_predictor_initializers[0][i] = reader.readBits(this.luma_bit_depth_entry_minus8 + 8);
                            continue;
                        }
                        this.pps_palette_predictor_initializers[comp][i] = reader.readBits(this.chroma_bit_depth_entry_minus8 + 8);
                    }
                }
            }
        }
    }
}

