/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heif.data;

import com.idrsolutions.image.heif.data.Type;
import com.idrsolutions.image.utility.BitReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class Nal {
    private final int nal_unit_type;
    final int nuh_layer_id;
    private final int nuh_temporal_id_plus1;
    private final int nBytesInRbsp;
    private int emulation_prevention_three_byte;
    private final byte[] rbsp;

    public Nal(BitReader reader, int nBytesInNalUnit) throws IOException {
        reader.readBit();
        this.nal_unit_type = reader.readBits(6);
        this.nuh_layer_id = reader.readBits(6);
        this.nuh_temporal_id_plus1 = reader.readBits(3);
        System.out.println("NAL unit Type " + this.nal_unit_type + " --- " + Type.getNalUnitName(this.nal_unit_type));
        try (ByteArrayOutputStream rbspStream = new ByteArrayOutputStream();){
            for (int i = 2; i < nBytesInNalUnit; ++i) {
                if (i + 2 < nBytesInNalUnit && reader.nextBits(24) == 3) {
                    rbspStream.write(reader.readU8());
                    rbspStream.write(reader.readU8());
                    i += 2;
                    this.emulation_prevention_three_byte = reader.readU8();
                    continue;
                }
                rbspStream.write(reader.readU8());
            }
            this.rbsp = rbspStream.toByteArray();
        }
        this.nBytesInRbsp = this.rbsp.length;
        System.out.println(this.nBytesInRbsp);
    }

    public boolean isVCL() {
        return this.nal_unit_type < 32;
    }

    private boolean isIDR() {
        return this.nal_unit_type == 20 || this.nal_unit_type == 19;
    }

    public boolean isRADL() {
        return this.nal_unit_type == 6 || this.nal_unit_type == 7;
    }

    private boolean isBLA() {
        return this.nal_unit_type == 16 || this.nal_unit_type == 17 || this.nal_unit_type == 18;
    }

    private boolean isCRA() {
        return this.nal_unit_type == 21;
    }

    public boolean isRAP() {
        return this.isIDR() || this.isBLA() || this.isCRA();
    }

    public boolean isRASL() {
        return this.nal_unit_type == 8 || this.nal_unit_type == 9;
    }

    public boolean isIRAP() {
        return this.nal_unit_type >= 16 && this.nal_unit_type <= 23;
    }

    public boolean isSLNR() {
        switch (this.nal_unit_type) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Nal{ nal_unit_type=" + this.nal_unit_type + ", nuh_layer_id=" + this.nuh_layer_id + ", nuh_temporal_id_plus1=" + this.nuh_temporal_id_plus1 + ", nBytesInRbsp=" + this.nBytesInRbsp + ", emulation_prevention_three_byte=" + this.emulation_prevention_three_byte;
    }
}

