/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.bmp;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.JDeliImageSupport;
import com.idrsolutions.image.bmp.options.BmpEncoderOptions;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.util.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;

public class BmpEncoder
extends JDeliImage
implements Encoder {
    private BmpEncoderOptions bmpEncoderOptions = new BmpEncoderOptions();

    public BmpEncoder(EncoderOptions format) {
        if (format != null) {
            this.bmpEncoderOptions = (BmpEncoderOptions)format;
        }
    }

    public BmpEncoder() {
    }

    public BmpEncoderOptions getEncoderOptions() {
        return this.bmpEncoderOptions;
    }

    @Override
    public void write(BufferedImage image, OutputStream outputStream) throws IOException {
        BufferedImage imageToCompress = ImageUtils.fixSubBufferedImage(JDeliImageSupport.optimiseImage(image));
        int bps = BmpEncoder.getBPS(imageToCompress);
        int rowSize = (imageToCompress.getWidth() * bps + 31) / 32 * 4;
        int pixArrayLen = rowSize * imageToCompress.getHeight();
        BmpEncoder.putLe16(outputStream, 19778);
        BmpEncoder.putLe32(outputStream, pixArrayLen + 54);
        BmpEncoder.putLe32(outputStream, 0);
        int offset = 54;
        int padding = 0;
        if (imageToCompress.getType() == 13 || bps <= 8) {
            padding = 1024;
            offset += padding;
        }
        BmpEncoder.putLe32(outputStream, offset);
        BmpEncoder.putLe32(outputStream, 40);
        BmpEncoder.putLe32(outputStream, imageToCompress.getWidth());
        BmpEncoder.putLe32(outputStream, imageToCompress.getHeight());
        BmpEncoder.putLe16(outputStream, 1);
        BmpEncoder.putLe16(outputStream, bps);
        BmpEncoder.putLe32(outputStream, 0);
        BmpEncoder.putLe32(outputStream, pixArrayLen);
        BmpEncoder.putLe32(outputStream, 0);
        BmpEncoder.putLe32(outputStream, 0);
        BmpEncoder.putLe32(outputStream, padding > 0 ? 256 : 0);
        BmpEncoder.putLe32(outputStream, padding > 0 ? 256 : 0);
        if (padding > 0) {
            BmpEncoder.addPadding(imageToCompress, outputStream);
        }
        switch (imageToCompress.getType()) {
            case 12: {
                BufferedImage convertedImg = new BufferedImage(imageToCompress.getWidth(), imageToCompress.getHeight(), 10);
                convertedImg.getGraphics().drawImage(imageToCompress, 0, 0, null);
                BmpEncoder.encodeGray(convertedImg, outputStream, rowSize);
                break;
            }
            case 10: {
                BmpEncoder.encodeGray(imageToCompress, outputStream, rowSize);
                break;
            }
            case 13: {
                BmpEncoder.encodeIndexed(imageToCompress, outputStream, rowSize);
                break;
            }
            case 5: {
                BmpEncoder.encodeBYTE_BGR(imageToCompress, outputStream, rowSize);
                break;
            }
            case 6: 
            case 7: {
                BmpEncoder.encodeBYTE_ABGR(imageToCompress, outputStream);
                break;
            }
            case 4: {
                BmpEncoder.encodeINT_BGR(imageToCompress, outputStream, rowSize);
                break;
            }
            case 1: {
                BmpEncoder.encodeINT_RGB(imageToCompress, outputStream, rowSize);
                break;
            }
            case 2: 
            case 3: {
                BmpEncoder.encodeINT_ARGB(imageToCompress, outputStream);
                break;
            }
            default: {
                BufferedImage converted = new BufferedImage(imageToCompress.getWidth(), imageToCompress.getHeight(), 5);
                converted.getGraphics().drawImage(imageToCompress, 0, 0, null);
                BmpEncoder.encodeBYTE_BGR(converted, outputStream, rowSize);
            }
        }
    }

    private static void addPadding(BufferedImage image, OutputStream outputStream) throws IOException {
        if (image.getType() == 13) {
            IndexColorModel icm = (IndexColorModel)image.getColorModel();
            byte[] r = new byte[256];
            byte[] g = new byte[256];
            byte[] b = new byte[256];
            byte[] a = new byte[256];
            icm.getReds(r);
            icm.getGreens(g);
            icm.getBlues(b);
            icm.getAlphas(a);
            for (int i = 0; i < 256; ++i) {
                outputStream.write(new byte[]{r[i], g[i], b[i], a[i]});
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                outputStream.write(new byte[]{(byte)i, (byte)i, (byte)i, -1});
            }
        }
    }

    private static void encodeGray(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int balance = rowSize - image.getWidth();
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth();
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                os.write(pix[p++] & 0xFF);
            }
            for (int i = 0; i < balance; ++i) {
                os.write(0);
            }
        }
    }

    private static void encodeIndexed(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int balance = rowSize - image.getWidth();
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth();
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                os.write(pix[p++] & 0xFF);
            }
            for (int i = 0; i < balance; ++i) {
                os.write(0);
            }
        }
    }

    private static void encodeBYTE_BGR(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int pad = rowSize > image.getWidth() * 3 ? rowSize - image.getWidth() * 3 : 0;
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth() * 3;
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                os.write(pix[p++] & 0xFF);
                os.write(pix[p++] & 0xFF);
                os.write(pix[p++] & 0xFF);
            }
            for (int i = 0; i < pad; ++i) {
                os.write(0);
            }
        }
    }

    private static void encodeBYTE_ABGR(BufferedImage image, OutputStream os) throws IOException {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth() * 4;
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                os.write(pix[p + 1] & 0xFF);
                os.write(pix[p + 2] & 0xFF);
                os.write(pix[p + 3] & 0xFF);
                os.write(pix[p] & 0xFF);
                p += 4;
            }
        }
    }

    private static void encodeINT_BGR(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        int[] pix = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int pad = rowSize > image.getWidth() * 3 ? rowSize - image.getWidth() * 3 : 0;
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth();
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                int t = pix[p++];
                os.write(t >> 16 & 0xFF);
                os.write(t >> 8 & 0xFF);
                os.write(t & 0xFF);
            }
            for (int i = 0; i < pad; ++i) {
                os.write(0);
            }
        }
    }

    private static void encodeINT_RGB(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        int[] pix = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int pad = rowSize > image.getWidth() * 3 ? rowSize - image.getWidth() * 3 : 0;
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth();
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                int t = pix[p++];
                os.write(t & 0xFF);
                os.write(t >> 8 & 0xFF);
                os.write(t >> 16 & 0xFF);
            }
            for (int i = 0; i < pad; ++i) {
                os.write(0);
            }
        }
    }

    private static void encodeINT_ARGB(BufferedImage image, OutputStream os) throws IOException {
        int[] pix = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int y = image.getHeight() - 1; y >= 0; --y) {
            int p = y * image.getWidth();
            int xx = image.getWidth();
            for (int x = 0; x < xx; ++x) {
                int t = pix[p++];
                os.write(t & 0xFF);
                os.write(t >> 8 & 0xFF);
                os.write(t >> 16 & 0xFF);
                os.write(t >> 24 & 0xFF);
            }
        }
    }

    private static void putLe16(OutputStream os, int v) throws IOException {
        os.write(v & 0xFF);
        os.write(v >> 8 & 0xFF);
    }

    private static void putLe32(OutputStream os, int v) throws IOException {
        os.write(v & 0xFF);
        os.write(v >> 8 & 0xFF);
        os.write(v >> 16 & 0xFF);
        os.write(v >> 24 & 0xFF);
    }

    private static int getBPS(BufferedImage image) {
        switch (image.getType()) {
            case 12: {
                return 8;
            }
            case 10: {
                return 8;
            }
            case 13: {
                return 8;
            }
            case 1: 
            case 4: 
            case 5: {
                return 24;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return 32;
            }
        }
        return 24;
    }

    static {
        String imageLib2ClassPath = "com/idrsolutions/image/JDeliImageSupport.class";
        ClassLoader loader = BmpEncoder.class.getClassLoader();
        if (loader.getResource("com/idrsolutions/image/JDeliImageSupport.class") != null) {
            try {
                loader.loadClass("com.idrsolutions.image.JDeliImageSupport").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                System.out.println("Unable to instance JDeli " + ex);
            }
        }
    }
}

