/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.image.awt;

import ice.debug.Debug;
import ice.pilots.image.ImageComponent;
import ice.pilots.image.ThePilot;
import ice.pilots.image.awt.TheImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.EventListener;

public class TheContainer
extends Panel
implements ImageComponent,
AdjustmentListener,
MouseListener,
KeyListener {
    private ThePilot pilot;
    private Scrollbar vbar;
    private Scrollbar hbar;
    private TheImpl impl;

    public void init(ThePilot p) {
        this.pilot = p;
        this.impl = new TheImpl(p);
        this.impl.addMouseListener(this);
        this.impl.addKeyListener(this);
        this.setLayout(new BorderLayout());
        this.hbar = new Scrollbar(0);
        this.vbar = new Scrollbar(1);
        this.hbar.addAdjustmentListener(this);
        this.vbar.addAdjustmentListener(this);
        this.initMouseWheelSupport();
        this.add((Component)this.impl, "Center");
        String scrolling = (String)p.getPilotViewport().getProperty("scrolling");
        if (scrolling != null && scrolling.equals("yes")) {
            this.add((Component)this.hbar, "South");
            this.add((Component)this.vbar, "East");
        }
    }

    private void initMouseWheelSupport() {
        block7: {
            try {
                Class<?> mouseWheelEvent = Class.forName("java.awt.event.MouseWheelEvent");
                try {
                    String className = "ice.util.awt.jdk14.AWTMouseWheelListener";
                    Constructor<?> constr = Class.forName(className).getConstructors()[0];
                    Object[] args = new Object[]{this.vbar, this.hbar};
                    EventListener aListener = null;
                    aListener = (EventListener)constr.newInstance(args);
                    this.addMouseWheelListenerReflectively(aListener, this.impl);
                    this.addMouseWheelListenerReflectively(aListener, this.vbar);
                    this.addMouseWheelListenerReflectively(aListener, this.hbar);
                    if (Debug.trace) {
                        Debug.trace((String)"MouseWheel support found and configured.");
                    }
                }
                catch (Throwable t1) {
                    if (Debug.trace) {
                        Debug.trace((String)"MouseWheel support found, but error occurred during configuration.");
                    }
                    if (Debug.ex) {
                        Debug.ex((Throwable)t1);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                if (!Debug.trace) break block7;
                Debug.trace((String)"MouseWheel support not found.");
            }
        }
    }

    private void addMouseWheelListenerReflectively(Object listener, Object target) throws Throwable {
        Class<?> targetClass = target.getClass();
        Class[] classArgs = new Class[]{Class.forName("java.awt.event.MouseWheelListener")};
        Method addListenerMethod = targetClass.getMethod("addMouseWheelListener", classArgs);
        addListenerMethod.invoke(target, listener);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.updateView();
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mousePressed(MouseEvent ev) {
        this.impl.requestFocus();
    }

    public void mouseReleased(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void keyPressed(KeyEvent ev) {
        int dx = 0;
        int dy = 0;
        switch (ev.getKeyCode()) {
            case 38: {
                dy = -this.vbar.getUnitIncrement();
                break;
            }
            case 40: {
                dy = this.vbar.getUnitIncrement();
                break;
            }
            case 37: {
                dx = -this.hbar.getUnitIncrement();
                break;
            }
            case 39: {
                dx = this.hbar.getUnitIncrement();
            }
        }
        if (dx != 0) {
            this.hbar.setValue(this.hbar.getValue() + dx);
        }
        if (dy != 0) {
            this.vbar.setValue(this.vbar.getValue() + dy);
        }
        if (dx != 0 || dy != 0) {
            this.updateView();
        }
    }

    public void keyReleased(KeyEvent ev) {
    }

    public void keyTyped(KeyEvent ev) {
    }

    public void doLayout() {
        super.doLayout();
        this.updateScrollbars();
    }

    private void updateScrollbars() {
        Dimension impl_sz = this.impl.getSize();
        this.hbar.setValues(this.hbar.getValue(), impl_sz.width, 0, this.pilot.getWidth());
        this.vbar.setValues(this.vbar.getValue(), impl_sz.height, 0, this.pilot.getHeight());
        this.hbar.setUnitIncrement(20);
        this.vbar.setUnitIncrement(20);
        this.hbar.setBlockIncrement(impl_sz.width);
        this.vbar.setBlockIncrement(impl_sz.height);
        this.updateView();
    }

    private void updateView() {
        this.impl.sx = -this.hbar.getValue();
        this.impl.sy = -this.vbar.getValue();
        this.impl.repaint();
    }

    public void updateYourself() {
        this.updateScrollbars();
    }
}

