/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.FontProvider;
import ice.util.Defs;
import ice.util.alg.CharKit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class JavaFontProvider
implements FontProvider {
    protected String[] genericToJava = new String[]{"monospace", "Monospaced", "sansserif", "SansSerif", "sans-serif", "SansSerif", "helvetica", "SansSerif", "arial", "SansSerif", "serif", "Serif"};
    protected String[] allFamilies;
    protected Hashtable familyHash;

    public JavaFontProvider() {
        this.init();
    }

    public boolean isFamilySupported(String fontFamily) {
        String family = CharKit.toLowerCase((String)fontFamily);
        Integer i = (Integer)this.familyHash.get(family);
        if (i != null) {
            return true;
        }
        for (int idx = 0; idx < this.genericToJava.length; idx += 2) {
            if (!this.genericToJava[idx].equalsIgnoreCase(family)) continue;
            return true;
        }
        return false;
    }

    public String[] getFontFamilies() {
        return this.allFamilies;
    }

    public Font getFont(String fontFamily, int fontStyle, int fontSize) {
        String family = CharKit.toLowerCase((String)fontFamily);
        Integer i = (Integer)this.familyHash.get(family);
        if (i != null) {
            return new Font(family, fontStyle, fontSize);
        }
        for (int idx = 0; idx < this.genericToJava.length; idx += 2) {
            if (!this.genericToJava[idx].equalsIgnoreCase(family)) continue;
            return new Font(this.genericToJava[idx + 1], fontStyle, fontSize);
        }
        throw new RuntimeException("Error in JavaFontProvider, has no Font implementation for: [" + family + "]");
    }

    protected void init() {
        if (!this.initJava2Fonts()) {
            this.initJava1Fonts();
        }
        this.familyHash = new Hashtable();
        String mapping = Defs.sysProperty((String)"ice.pilots.html4.addonFontMapping");
        if (mapping != null) {
            int num = 1;
            int comma = mapping.indexOf(44);
            while (comma > 0) {
                ++num;
                comma = mapping.indexOf(44, comma + 1);
            }
            String[] tmp = new String[this.genericToJava.length + num];
            System.arraycopy(this.genericToJava, 0, tmp, 0, this.genericToJava.length);
            int offset = 0;
            comma = mapping.indexOf(44);
            num = this.genericToJava.length;
            while (comma > 0) {
                tmp[num++] = CharKit.toLowerCase((String)mapping.substring(offset, comma).trim());
                offset = comma + 1;
                comma = mapping.indexOf(44, offset);
            }
            tmp[num] = CharKit.toLowerCase((String)mapping.substring(offset).trim());
            this.genericToJava = tmp;
        }
        for (int idx = 0; idx < this.allFamilies.length; ++idx) {
            this.familyHash.put(CharKit.toLowerCase((String)this.allFamilies[idx]), new Integer(idx));
        }
    }

    protected void initJava1Fonts() {
        this.allFamilies = Toolkit.getDefaultToolkit().getFontList();
        String addonFonts = Defs.sysProperty((String)"ice.pilots.html4.addonFonts");
        if (addonFonts != null) {
            int num = 1;
            int comma = addonFonts.indexOf(44);
            while (comma > 0) {
                ++num;
                comma = addonFonts.indexOf(44, comma + 1);
            }
            String[] tmp = new String[this.allFamilies.length + num];
            System.arraycopy(this.allFamilies, 0, tmp, 0, this.allFamilies.length);
            int offset = 0;
            comma = addonFonts.indexOf(44);
            num = this.allFamilies.length;
            while (comma > 0) {
                tmp[num++] = addonFonts.substring(offset, comma).trim();
                offset = comma + 1;
                comma = addonFonts.indexOf(44, offset);
            }
            tmp[num] = addonFonts.substring(offset).trim();
            this.allFamilies = tmp;
        }
    }

    protected boolean initJava2Fonts() {
        try {
            Class<?> c = Class.forName("java.awt.GraphicsEnvironment");
            Method m = c.getMethod("getLocalGraphicsEnvironment", null);
            Method m2 = c.getMethod("getAvailableFontFamilyNames", null);
            Object env = m.invoke(null, null);
            this.allFamilies = (String[])m2.invoke(env, null);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }
}

