/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DFormElement;
import ice.pilots.html4.MultipartEncoder;
import ice.storm.ContentLoader;
import ice.util.net.URLEncoder;
import java.io.File;

class FormSubmitData {
    private boolean multipartFormData;
    private boolean post;
    private MultipartEncoder encoder;
    private StringBuffer dataToSubmit;
    private DFormElement formElement;

    FormSubmitData(boolean multipartFormData) {
        this(multipartFormData, true, null);
    }

    FormSubmitData(boolean multipartFormData, boolean post) {
        this(multipartFormData, post, null);
    }

    FormSubmitData(boolean multipartFormData, boolean post, DFormElement formElement) {
        this.multipartFormData = multipartFormData;
        this.post = post;
        this.formElement = formElement;
        this.dataToSubmit = new StringBuffer(100);
        if (this.multipartFormData && this.post) {
            this.encoder = new MultipartEncoder();
        }
    }

    void appendFileData(String name, String value) {
        if (name == null || name.length() == 0 || value == null) {
            return;
        }
        if (this.multipartFormData && this.post) {
            this.encoder.appendFile(name, value);
        } else {
            this.appendData(name, value != null ? new File(value).getName() : "");
        }
    }

    void appendData(String name, String value) {
        if (name == null || name.length() == 0 || value == null) {
            return;
        }
        if (this.multipartFormData && this.post) {
            this.encoder.appendData(name, value);
        } else {
            if (this.dataToSubmit.length() > 0) {
                this.dataToSubmit.append("&");
            }
            String _defaultCharset = null;
            if (this.formElement != null) {
                _defaultCharset = this.formElement.doc.getDefaultCharset();
            }
            this.dataToSubmit.append(URLEncoder.encode((String)name, (String)_defaultCharset));
            this.dataToSubmit.append("=");
            this.dataToSubmit.append(URLEncoder.encode((String)value, (String)_defaultCharset));
        }
    }

    void prepareContentLoader(ContentLoader contentLoader) {
        if (this.multipartFormData && this.post) {
            contentLoader.setPostStream(this.encoder.getHeader(), this.encoder);
        } else {
            contentLoader.setPostData("application/x-www-form-urlencoded", this.dataToSubmit.toString().getBytes());
        }
    }

    String toLocationSearchPart() {
        if (this.multipartFormData && this.post) {
            return "";
        }
        return this.dataToSubmit.toString();
    }
}

