/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.InlineBox;
import ice.pilots.html4.LineBox;
import java.awt.Graphics;

class ButtonBox
extends InlineBox {
    private BlockBox block;
    private int dy = 0;

    ButtonBox(DElement element, CSSAttribs css, CSSLayout cssLayout, byte dynamic) {
        super(element, new CSSAttribs(cssLayout.getFontCache(), css), cssLayout, dynamic);
        css.display = 41;
        this.block = new BlockBox(element, css, cssLayout, dynamic);
        this.block.setParentBox(this);
        this.first = this.last = this.block;
    }

    void dispose() {
        this.block.dispose();
        this.block = null;
        super.dispose();
    }

    BlockBox getBlock() {
        return this.block;
    }

    CSSBox addChild(CSSBox b) {
        this.block = (BlockBox)this.block.addChild(b);
        return this;
    }

    int calcBreaks() {
        this.block.calcMinMaxWidths();
        this.minWidth = this.block.minWidth;
        this.maxWidth = this.block.maxWidth;
        this.totalWidth = this.block.maxWidth;
        FloatManager fm = new FloatManager(0, this.totalWidth);
        this.block.layout(this.block.maxWidth, -1, fm);
        this.block.ox = -this.block.css.padding_left - this.block.css.border_left_width;
        this.block.oy = -this.block.css.padding_top - this.block.css.border_top_width;
        return 0;
    }

    int getBreaks(int[] breaks, int idx) {
        return 0;
    }

    long getChunkDescentAscent(int x, int w, LineBox aLineMetrics) {
        int ascent = this.block.height + this.css.padding_top + this.css.border_top_width;
        int descent = this.css.padding_bottom + this.css.border_bottom_width;
        return ButtonBox.wrapDescentAscent(descent, ascent, descent + ascent);
    }

    void paintChunk(Graphics g, int x, int w, LineBox aBox, int aBoxId) {
        if ((this.css.misc & 1) == 0) {
            return;
        }
        this.block.paint(g);
    }
}

