/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.InlineBox;
import ice.pilots.html4.LineBox;
import ice.pilots.html4.TextBox;
import java.awt.FontMetrics;

class BreakBox
extends CSSBox {
    private boolean tall = false;
    private int _descent;
    private int _ascent;
    private int _lineHeight;

    BreakBox(DElement e, CSSAttribs css, CSSLayout cssLayout) {
        super(e, css, cssLayout);
        this.numBreaks = 1;
        this.totalWidth = 1;
        FontMetrics fm = css.getFontMetrics();
        this._descent = fm.getDescent();
        this._ascent = fm.getAscent();
        long wrap = TextBox.calculateCompressedFontSize(this._ascent, this._descent, css);
        this._descent = BreakBox.unwrapDescent(wrap);
        this._ascent = BreakBox.unwrapAscent(wrap);
        this._lineHeight = TextBox.calculateLineHeight(css);
    }

    void dispose() {
        super.dispose();
        this.element = null;
    }

    DNode getDomNode() {
        return this.element;
    }

    int calcBreaks() {
        return 1;
    }

    int getBreaks(int[] breaks, int idx) {
        this.tall = false;
        if (idx == 0) {
            if (this.parentBox instanceof BlockBox) {
                DNode n = this.parentBox.getDomNode();
                if (n == null || n.getNameId() != 14) {
                    this.tall = true;
                }
            } else if (this.parentBox instanceof InlineBox) {
                if (((InlineBox)this.parentBox).first == this) {
                    this.tall = true;
                }
            } else {
                this.tall = true;
            }
        } else if (breaks[idx - 1] < 0) {
            this.tall = true;
        }
        breaks[idx] = -1;
        return 1;
    }

    long getChunkDescentAscent(int x, int w, LineBox aBox) {
        if (this.tall) {
            return BreakBox.wrapDescentAscent(this._descent, this._ascent, this._lineHeight);
        }
        return 0L;
    }
}

