/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm;

import coldfusion.runtime.Cast;
import coldfusion.server.ORMSearchService;
import coldfusion.server.ServiceFactory;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ORMSettings {
    public static final String DATASOURCE = "datasource";
    public static final String ORM_INIT_METHOD = "ormInitMethod";
    public static final int DB_NONE = 0;
    public static final int DB_CREATE = 1;
    public static final int DB_DROP_CREATE = 2;
    public static final int DB_UPDATE = 3;
    public static final String NAMING_STRATEGY_DEFAULT = "default";
    public static final String NAMING_STRATEGY_SMART = "smart";
    private static final String DIALECT = "dialect";
    private static final String DEFAULT_SCHEMA = "schema";
    private static final String DEFAULT_CATALOG = "catalog";
    private static final String CONFIG = "ormconfig";
    private static final String AUTOGENMAP = "autogenmap";
    private static final String SAVEMAPPING = "savemapping";
    private static final String AUTOREBUILD = "autorebuild";
    private static final String USE_DB_FOR_MAPPING = "useDBForMapping";
    private static final String FLUSH_AT_REQUEST_END = "flushAtRequestEnd";
    private static final String AUTO_MANAGE_SESSION = "autoManageSession";
    private static final String DB_CREATE_OPTION = "dbcreate";
    private static final String EVENT_HANDLER = "eventHandler";
    private static final String EVENT_HANDLING_ENABLED = "eventHandling";
    private static final String CFCLOCATION = "cfclocation";
    private static final String SECONDARY_CACHE_ENABLED = "secondaryCacheEnabled";
    private static final String CACHE_PROVIDER = "cacheProvider";
    private static final String CACHE_CONFIG = "cacheConfig";
    private static final String LOG_SQL = "logSql";
    private static final String SKIP_CFC_WITH_ERROR = "skipCFCWithError";
    private static final String IMPORT_SQL_SCRIPT = "sqlscript";
    private static final String NAMING_STRATEGY = "namingStrategy";
    private static final String SEARCH_ENABLED = "searchEnabled";
    private static final String NONE_STR = "none";
    private static final String CREATE_STR = "create";
    private static final String DROP_CREATE_STR = "dropCreate";
    private static final String UPDATE_STR = "update";
    private Map<String, Object> settings;
    private Object searchSetting;
    private String datasource;
    private String datasourceUserName;
    private String datasourcePassword;

    public ORMSettings(Map<String, Object> settings) {
        this.settings = settings;
        Object datasourceObj = settings.get(DATASOURCE);
        if (datasourceObj instanceof Map) {
            Map dsMap = (Map)datasourceObj;
            this.datasource = (String)dsMap.get("name");
            String dsUsername = (String)dsMap.get("username");
            String dsPassword = (String)dsMap.get("password");
            if (dsUsername != null && dsUsername.length() > 0) {
                this.datasourceUserName = dsUsername;
                this.datasourcePassword = dsPassword;
            }
        } else {
            this.datasource = (String)datasourceObj;
        }
    }

    public String getDialect(String datasource) {
        return this.getSettingForDatasource(datasource, DIALECT);
    }

    public Object getSearchSetting() {
        ORMSearchService ormSearchService;
        if (this.searchSetting == null && this.isSearchEnabled() && (ormSearchService = ServiceFactory.getOrmSearchService()) != null) {
            this.searchSetting = ormSearchService.getSearchSettings(this.settings);
        }
        return this.searchSetting;
    }

    public String getDataSource() {
        return this.datasource;
    }

    public String getDatasourceUserName() {
        return this.datasourceUserName;
    }

    public String getDatasourcePassword() {
        return this.datasourcePassword;
    }

    public String getDefaultSchema(String datasource) {
        return this.getSettingForDatasource(datasource, DEFAULT_SCHEMA);
    }

    public String getDefaultCatalog(String datasource) {
        return this.getSettingForDatasource(datasource, DEFAULT_CATALOG);
    }

    public String getConfigFile() {
        return (String)this.settings.get(CONFIG);
    }

    public boolean shouldGenerateMapping() {
        return this.getBooleanValue(this.settings.get(AUTOGENMAP), true);
    }

    public boolean shouldSaveMapping() {
        return this.getBooleanValue(this.settings.get(SAVEMAPPING), false);
    }

    public boolean shouldUseDBForMapping() {
        return this.getBooleanValue(this.settings.get(USE_DB_FOR_MAPPING), true);
    }

    public boolean shouldAutoRebuild() {
        return this.getBooleanValue(this.settings.get(AUTOREBUILD), false);
    }

    public boolean shouldFlushAtRequestEnd() {
        return this.getBooleanValue(this.settings.get(FLUSH_AT_REQUEST_END), true);
    }

    public boolean isEventHandlingEnabled() {
        Object value = this.settings.get(EVENT_HANDLING_ENABLED);
        if (value == null) {
            return this.getEventHandler() != null;
        }
        return this.getBooleanValue(value, false);
    }

    public String getEventHandler() {
        return (String)this.settings.get(EVENT_HANDLER);
    }

    public String[] getCFCLocation() {
        Object o = this.settings.get(CFCLOCATION);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            List locations = (List)o;
            return locations.toArray(new String[locations.size()]);
        }
        return new String[]{(String)o};
    }

    public int getDBCreateOption(String datasource) {
        String createOption = this.getSettingForDatasource(datasource, DB_CREATE_OPTION);
        if (createOption == null || createOption.equalsIgnoreCase(NONE_STR)) {
            return 0;
        }
        if (CREATE_STR.equalsIgnoreCase(createOption)) {
            return 1;
        }
        if (DROP_CREATE_STR.equalsIgnoreCase(createOption)) {
            return 2;
        }
        if (UPDATE_STR.equalsIgnoreCase(createOption)) {
            return 3;
        }
        return 0;
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public Object getSetting(String key) {
        return this.settings.get(key);
    }

    public Properties getCustomSettings(String prefix) {
        Properties customSettings = new Properties();
        for (String key : this.settings.keySet()) {
            if (!key.startsWith(prefix)) continue;
            customSettings.put(key, this.settings.get(key));
        }
        return customSettings;
    }

    private boolean getBooleanValue(Object str, boolean defaultVal) {
        if (str == null) {
            return defaultVal;
        }
        return Cast._boolean((Object)str, (boolean)defaultVal);
    }

    public String getCacheProvider() {
        return (String)this.settings.get(CACHE_PROVIDER);
    }

    public String getCacheConfigFile(String datasource) {
        return this.getSettingForDatasource(datasource, CACHE_CONFIG);
    }

    public boolean isSecondaryCacheEnabled() {
        return this.getBooleanValue(this.settings.get(SECONDARY_CACHE_ENABLED), false);
    }

    public boolean isSqlLogEnabled() {
        return this.getBooleanValue(this.settings.get(LOG_SQL), false);
    }

    public boolean isSearchEnabled() {
        return this.getBooleanValue(this.settings.get(SEARCH_ENABLED), false);
    }

    public boolean isAutoSessionManagementEnabled() {
        return this.getBooleanValue(this.settings.get(AUTO_MANAGE_SESSION), true);
    }

    public String getNamingStrategy() {
        String strategy = (String)this.settings.get(NAMING_STRATEGY);
        return strategy == null ? NAMING_STRATEGY_DEFAULT : strategy;
    }

    public String getSqlScriptFile(String datasource) {
        return this.getSettingForDatasource(datasource, IMPORT_SQL_SCRIPT);
    }

    public boolean shouldSkipCFCWithError() {
        return this.getBooleanValue(this.settings.get(SKIP_CFC_WITH_ERROR), false);
    }

    private String getSettingForDatasource(String datasource, String settingName) {
        Object settingObj = this.settings.get(settingName);
        if (settingObj instanceof Map) {
            return (String)((Map)settingObj).get(datasource);
        }
        return (String)settingObj;
    }
}

