/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.image;

import ice.debug.Debug;
import ice.pilots.image.ImageComponent;
import ice.pilots.image.ThePrinter;
import ice.storm.ContentLoader;
import ice.storm.LPilot;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.util.Defs;
import ice.util.ICEException;
import ice.util.JavaVersion;
import ice.util.memory.MemoryManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class ThePilot
extends LPilot
implements ImageObserver {
    private static final Cursor WAIT_CURSOR = new Cursor(3);
    private static final Cursor NORMAL_CURSOR = new Cursor(0);
    private static final int BUFFERSIZE = 8192;
    private Image theImage = null;
    private int forcedWidth = -1;
    private int forcedHeight = -1;
    private int width = 20;
    private int height = 20;
    private String toolkit;
    private ImageComponent component;
    private MemoryManager memoryManager = null;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$image$renderable$ParameterBlock;

    public void init(String componentToolkitName) {
        super.init(componentToolkitName);
        this.memoryManager = MemoryManager.getInstance();
        this.toolkit = componentToolkitName;
    }

    public Component createComponent() {
        block4: {
            String s = "ice.pilots.image." + this.toolkit + ".TheContainer";
            try {
                Object o = Class.forName(s).newInstance();
                this.component = (ImageComponent)o;
                this.component.init(this);
            }
            catch (Exception ex) {
                if (Debug.ex) {
                    Debug.ex((Throwable)ex);
                }
                if (Debug.trace) {
                    Debug.trace((String)("Failed to create component: " + ex));
                }
                if (this.toolkit.equals("awt")) break block4;
                this.toolkit = "awt";
                this.createComponent();
            }
        }
        return (Component)((Object)this.component);
    }

    public StormPrinter createPrinter() {
        ThePrinter p = null;
        if (this.theImage != null) {
            p = new ThePrinter(this);
        }
        return p;
    }

    void flushImage() {
        if (this.theImage != null) {
            this.theImage.flush();
            this.theImage = null;
        }
    }

    public void clear(String contentType) {
        this.flushImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(ContentLoader cl) throws IOException {
        block31: {
            try {
                ImageProducer prod;
                this.setCursor(WAIT_CURSOR);
                this.firePropertyChange("location", null, cl.getLocation());
                this.firePropertyChange("title", null, cl.getLocation());
                InputStream theStream = cl.getInputStream();
                if (theStream == null) break block31;
                boolean jaiUsed = false;
                String type = cl.getContentType();
                if ("image/png".equalsIgnoreCase(type) && (prod = this.createPngImageProducer(cl)) != null) {
                    this.theImage = Toolkit.getDefaultToolkit().createImage(prod);
                }
                if (this.theImage == null && JavaVersion.isV13orGreater()) {
                    String jaiType = null;
                    String sub = type.substring(6);
                    if (sub.equalsIgnoreCase("bmp")) {
                        jaiType = "bmp";
                    } else if (sub.equalsIgnoreCase("tiff") || sub.equalsIgnoreCase("tif")) {
                        jaiType = "tiff";
                    } else if (sub.equalsIgnoreCase("vnd.fpx")) {
                        jaiType = "fpx";
                    } else if (sub.equalsIgnoreCase("x-portable-anymap")) {
                        jaiType = "pnm";
                    }
                    if (jaiType != null) {
                        jaiUsed = this.createJAIImage(theStream, jaiType);
                    }
                }
                if (this.theImage == null) {
                    try {
                        if (!this.memoryManager.canAllocate(16384)) {
                            throw new ICEException(1, 3, 2);
                        }
                        byte[] buffer = new byte[8192];
                        byte[] datastore = new byte[8192];
                        boolean finished = false;
                        int charsRead = 0;
                        int totalcharsRead = 0;
                        while (!finished) {
                            charsRead = theStream.read(buffer);
                            if (charsRead == -1) {
                                finished = true;
                                break;
                            }
                            if (datastore.length - totalcharsRead > charsRead) {
                                System.arraycopy(buffer, 0, datastore, totalcharsRead, charsRead);
                                totalcharsRead += charsRead;
                                continue;
                            }
                            int newsize = Math.max(datastore.length * 2, datastore.length + charsRead);
                            if (!this.memoryManager.canAllocate(newsize)) {
                                datastore = null;
                                throw new ICEException(1, 3, 2);
                            }
                            byte[] tmp = new byte[newsize];
                            System.arraycopy(datastore, 0, tmp, 0, totalcharsRead);
                            datastore = tmp;
                            System.arraycopy(buffer, 0, datastore, totalcharsRead, charsRead);
                            totalcharsRead += charsRead;
                        }
                        if (!this.memoryManager.canAllocate(totalcharsRead)) {
                            throw new ICEException(1, 3, 2);
                        }
                        byte[] finalarray = new byte[totalcharsRead];
                        System.arraycopy(datastore, 0, finalarray, 0, totalcharsRead);
                        this.theImage = Toolkit.getDefaultToolkit().createImage(finalarray);
                    }
                    finally {
                        theStream.close();
                    }
                }
                if (this.theImage == null) {
                    return;
                }
                if (!jaiUsed) {
                    Viewport parent;
                    Toolkit.getDefaultToolkit().prepareImage(this.theImage, -1, -1, this);
                    int w = this.theImage.getWidth(this);
                    int h = this.theImage.getHeight(this);
                    if (w > 0) {
                        this.width = w;
                    }
                    if (h > 0) {
                        this.height = h;
                    }
                    if ((parent = this.getPilotViewport().getParent()) != null) {
                        parent.getPilot().refresh();
                    }
                } else {
                    Toolkit.getDefaultToolkit().prepareImage(this.theImage, this.width, this.height, null);
                    this.refreshViewport();
                    if (this.component != null) {
                        this.component.updateYourself();
                    }
                }
            }
            finally {
                this.setCursor(NORMAL_CURSOR);
            }
        }
    }

    public Image getImage() {
        return this.theImage;
    }

    public void dispose() {
        this.flushImage();
    }

    public int getWidth() {
        int zoom = this.getPilotViewport().getZoom();
        return this.width * zoom >> 8;
    }

    public int getHeight() {
        int zoom = this.getPilotViewport().getZoom();
        return this.height * zoom >> 8;
    }

    public void setSize(int w, int h) {
        this.forcedWidth = w;
        this.forcedHeight = h;
    }

    protected void setZoom(int factor) {
        this.refreshViewport();
        if (this.component != null) {
            this.component.updateYourself();
        }
    }

    public void paint(Graphics g) {
        if (this.theImage != null) {
            int zoom = this.getPilotViewport().getZoom();
            if (this.forcedWidth >= 0 && this.forcedHeight >= 0) {
                g.drawImage(this.theImage, 0, 0, this.forcedWidth, this.forcedHeight, 0, 0, this.width, this.height, this);
            } else if (zoom != 256) {
                int w = this.width * zoom >> 8;
                int h = this.height * zoom >> 8;
                g.drawImage(this.theImage, 0, 0, w, h, 0, 0, this.width, this.height, this);
            } else {
                g.drawImage(this.theImage, 0, 0, this.width, this.height, this);
            }
        }
    }

    public boolean imageUpdate(Image img, int info, int x, int y, int width, int height) {
        if ((info & 1) != 0) {
            this.width = width;
        }
        if ((info & 2) != 0) {
            this.height = height;
        }
        if ((info & 0x33) != 0) {
            this.refreshViewport();
            if (this.component != null) {
                this.component.updateYourself();
            }
        }
        return (info & 0xE0) == 0;
    }

    boolean createJAIImage(InputStream inputStream, String type) {
        boolean jaiUsed = false;
        try {
            Class ssClass = Defs.getClass((String)"com.sun.media.jai.codec.SeekableStream");
            if (ssClass != null) {
                Method ssWrapInputStream = ssClass.getMethod("wrapInputStream", class$java$io$InputStream == null ? (class$java$io$InputStream = ThePilot.class$("java.io.InputStream")) : class$java$io$InputStream, Boolean.TYPE);
                Object seekableStream = ssWrapInputStream.invoke(null, inputStream, Boolean.TRUE);
                ParameterBlock pb = new ParameterBlock();
                pb.add(seekableStream);
                Class jaiClass = Defs.getClass((String)"javax.media.jai.JAI");
                Method jaiCreate = jaiClass.getMethod("create", class$java$lang$String == null ? (class$java$lang$String = ThePilot.class$("java.lang.String")) : class$java$lang$String, class$java$awt$image$renderable$ParameterBlock == null ? (class$java$awt$image$renderable$ParameterBlock = ThePilot.class$("java.awt.image.renderable.ParameterBlock")) : class$java$awt$image$renderable$ParameterBlock);
                Object renderedOp = jaiCreate.invoke(null, type, pb);
                if (renderedOp != null) {
                    RenderedImage ri = (RenderedImage)renderedOp;
                    Class roClass = Defs.getClass((String)"javax.media.jai.RenderedOp");
                    Method roGetAsBufferedImage = roClass.getMethod("getAsBufferedImage", new Class[0]);
                    this.theImage = (BufferedImage)roGetAsBufferedImage.invoke(renderedOp, new Object[0]);
                    int w = ri.getWidth();
                    int h = ri.getHeight();
                    if (w > 0) {
                        this.width = w;
                    }
                    if (h > 0) {
                        this.height = h;
                    }
                    if (this.theImage != null) {
                        jaiUsed = true;
                    }
                }
            } else {
                Debug.trace((String)"Java Advanced Imaging (JAI) classes not found.");
            }
        }
        catch (Exception ex) {
            Debug.ex((Throwable)ex);
        }
        return jaiUsed;
    }

    ImageProducer createPngImageProducer(ContentLoader cl) {
        ImageProducer prod = null;
        try {
            Class<?> c = Class.forName("com.sixlegs.image.png.PngImage");
            Class[] cparams = new Class[]{class$java$io$InputStream == null ? (class$java$io$InputStream = ThePilot.class$("java.io.InputStream")) : class$java$io$InputStream};
            Constructor<?> cc = c.getConstructor(cparams);
            Object[] oparams = new Object[]{cl.getInputStream()};
            prod = (ImageProducer)cc.newInstance(oparams);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prod;
    }

    private void setCursor(Cursor theCursor) {
        if (this.component != null) {
            this.component.setCursor(theCursor);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

