/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.debug.Debug;
import ice.pilots.html4.swing.LaFConfig;
import ice.util.Defs;
import ice.util.JavaVersion;
import ice.util.alg.HashArray;
import java.awt.Color;
import java.awt.Graphics;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.UIManager;

public class FocusIndicator {
    private static String jvmMajMinVersion;
    private static String jvmMajMinSubVersion;

    static LaFConfig findLaFConfig(HashArray configs, LaFConfig defaultConfig) {
        LaFConfig config;
        String key;
        Object cf;
        String lafClass = UIManager.getLookAndFeel().getClass().getName();
        if ((jvmMajMinSubVersion.equals("1.4.2") || JavaVersion.isV15orGreater()) && lafClass.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") && Defs.sysProperty((String)"swing.noxp") != null) {
            lafClass = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";
        }
        if ((cf = configs.get((Object)(key = jvmMajMinSubVersion + lafClass))) != null) {
            config = (LaFConfig)cf;
        } else {
            key = jvmMajMinVersion + lafClass;
            cf = configs.get((Object)key);
            if (cf != null) {
                config = (LaFConfig)cf;
            } else {
                config = defaultConfig;
                if (Debug.trace) {
                    String errMsg = "LaFConfig not found for jvmVersion: '" + jvmMajMinVersion + "', classname: '" + lafClass + "'.\nUsing DEFAULT LaFConfig.";
                    Debug.trace((String)errMsg);
                }
            }
        }
        if (Debug.all) {
            Debug.trace((String)("Found LaFConfig for specified jvmVersion: '" + jvmMajMinVersion + "' and lafClassName: '" + lafClass + "': \n" + config));
        }
        return config;
    }

    static HashArray parseCustomConfigs(int type, String args) {
        HashArray retConfigs;
        block6: {
            if (args == null) {
                return new HashArray(0);
            }
            StringTokenizer st = new StringTokenizer(args, ",");
            retConfigs = new HashArray(4);
            try {
                while (true) {
                    String msg;
                    LaFConfig customConfig;
                    String argStr;
                    String version = argStr = st.nextToken();
                    String laf = argStr = st.nextToken();
                    argStr = st.nextToken();
                    if (argStr.equalsIgnoreCase("NONE")) {
                        customConfig = new LaFConfig(type, version, laf, false);
                        retConfigs.put((Object)customConfig.getKey(), (Object)customConfig);
                        if (!Debug.all) continue;
                        msg = "Custom focusIndicatorConfig created from system property:\n" + customConfig.toString();
                        Debug.trace((String)msg);
                        continue;
                    }
                    int x = Integer.parseInt(argStr);
                    argStr = st.nextToken();
                    int y = Integer.parseInt(argStr);
                    argStr = st.nextToken();
                    int w = Integer.parseInt(argStr);
                    argStr = st.nextToken();
                    int h = Integer.parseInt(argStr);
                    customConfig = new LaFConfig(type, version, laf, x, y, w, h);
                    retConfigs.put((Object)customConfig.getKey(), (Object)customConfig);
                    if (!Debug.all) continue;
                    msg = "Custom focusIndicatorConfig created from system property:\n" + customConfig.toString();
                    Debug.trace((String)msg);
                }
            }
            catch (NoSuchElementException e) {
            }
            catch (NumberFormatException e) {
                if (!Debug.trace) break block6;
                String typeName = LaFConfig.getTypeAsString(type);
                String errMsg = "Incorrect format error while parsing '..." + typeName + "' system property." + "\nExpected format is: \n" + "'jvmVersion(String),lookAndFeelClassname(String),enabled(String='none')" + " OR xOffset(int),yOffset(int),widthOffest(int),heightOffset(int), etc.'" + "\nParsing of '...'" + typeName + "' aborted.";
                Debug.trace((String)errMsg);
            }
        }
        return retConfigs;
    }

    static void drawFocusRect(Graphics g, int x, int y, int width, int height) {
        int yInc;
        int xInc;
        Color origColor = g.getColor();
        g.setColor(Color.black);
        g.setXORMode(Color.white);
        for (xInc = x + 1; xInc < width - 1; xInc += 2) {
            g.drawLine(xInc, y, xInc, y);
        }
        for (xInc = x + 1; xInc < width - 1; xInc += 2) {
            g.drawLine(xInc, height - 1, xInc, height - 1);
        }
        for (yInc = y + 1; yInc < height - 1; yInc += 2) {
            g.drawLine(x, yInc, x, yInc);
        }
        for (yInc = y + 1; yInc < height - 1; yInc += 2) {
            g.drawLine(width - 1, yInc, width - 1, yInc);
        }
        g.setPaintMode();
        g.setColor(origColor);
    }

    static {
        int[] version = JavaVersion.getVMVersion().getParts();
        StringBuffer versStr = new StringBuffer();
        versStr.append(version[0]);
        versStr.append('.');
        versStr.append(version[1]);
        jvmMajMinVersion = versStr.toString();
        versStr.append('.');
        versStr.append(version[2]);
        jvmMajMinSubVersion = versStr.toString();
    }
}

