/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DAppletElement;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DIFrameElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.EmbeddedObject;
import ice.pilots.html4.ImageObjectPainter;
import ice.pilots.html4.MarqueeObjectPainter;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.ThePilot;
import ice.storm.ContentLoader;
import ice.storm.StormBase;
import ice.util.Defs;
import java.awt.Container;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

class ObjectPool
implements ImageObserver {
    private ThePilot pilot;
    private Hashtable imageHash = new Hashtable();
    private Hashtable urlHash = new Hashtable();
    private Hashtable painterHash = new Hashtable();
    private Hashtable tiledImageCache = new Hashtable();
    private int imagesToLoad = 0;
    private Hashtable oldPainterHash = null;

    ObjectPool(ThePilot p) {
        this.pilot = p;
    }

    void dispose() {
        Image img;
        Enumeration e = this.imageHash.elements();
        while (e.hasMoreElements()) {
            img = (Image)e.nextElement();
            this.pilot.sdata.imageCache.release(img);
        }
        this.imageHash.clear();
        e = this.tiledImageCache.elements();
        while (e.hasMoreElements()) {
            img = (Image)e.nextElement();
            img.flush();
        }
        this.tiledImageCache.clear();
        this.urlHash.clear();
        e = this.painterHash.elements();
        while (e.hasMoreElements()) {
            ((ObjectPainter)e.nextElement()).dispose();
        }
        this.painterHash.clear();
        this.pilot.sdata.imageCache.flushImages(false);
    }

    void stopImageLoading() {
        Enumeration e = this.imageHash.elements();
        while (e.hasMoreElements()) {
            Image img = (Image)e.nextElement();
            this.pilot.sdata.imageCache.stopLoading(img);
        }
    }

    private void fireOutstandingImagesEvent(String url) {
        this.pilot.firePropertyChange("outstandingImages", url, "" + this.imagesToLoad);
    }

    void fireOutstandingImagesEvent() {
        this.fireOutstandingImagesEvent(null);
    }

    void beginCreating() {
        this.oldPainterHash = this.painterHash;
        this.painterHash = new Hashtable();
    }

    void endCreating() {
        Enumeration e = this.oldPainterHash.elements();
        while (e.hasMoreElements()) {
            ObjectPainter p = (ObjectPainter)e.nextElement();
            p.dispose();
        }
        this.oldPainterHash.clear();
    }

    ObjectPainter getNodePainter(DNode node) {
        return (ObjectPainter)this.painterHash.get(node);
    }

    ObjectPainter createEmbeddedObjectPainter(DElement e, CSSBox box) {
        ObjectPainter p = (ObjectPainter)this.oldPainterHash.get(e);
        if (p != null) {
            if (p instanceof Container) {
                ((Container)((Object)p)).invalidate();
            }
            this.oldPainterHash.remove(e);
            this.painterHash.put(e, p);
            return p;
        }
        p = (ObjectPainter)this.painterHash.get(e);
        if (p != null) {
            return p;
        }
        if (e.isFormControl()) {
            if (e.tagId == 47 && "image".equalsIgnoreCase(e.getAttribute("type"))) {
                Image image;
                String src = e.getAttribute(102);
                if (src != null && (image = this.loadImage(e.doc.resolveUrl(src))) != null) {
                    p = new ImageObjectPainter(image);
                }
            } else {
                p = this.pilot.getCSSLayout().docPane.createFormControl(e);
            }
        } else if (e.tagId == 93) {
            p = new MarqueeObjectPainter(e.doc);
        } else if (e.tagId == 46) {
            String src = e.getAttribute(102);
            if (src == null || src.trim().equals("")) {
                p = new ImageObjectPainter(null);
            } else {
                Image image = this.loadImage(e.doc.resolveUrl(src));
                if (image != null) {
                    p = new ImageObjectPainter(image);
                }
            }
        } else if (e.tagId == 45) {
            for (DNode currNode = e.getParentDNode(); currNode != null && currNode.getNameId() != 13; currNode = currNode.getParentDNode()) {
                if (currNode.getNameId() != 60) continue;
                return null;
            }
            EmbeddedObject embedded = new EmbeddedObject(this.pilot.getStorm(), e);
            embedded.setFrameArrayMember();
            String widthStr = e.getAttribute(119);
            String heightStr = e.getAttribute(45);
            if (widthStr != null && heightStr != null) {
                int width = CSSUtil.parseLength(widthStr);
                int height = CSSUtil.parseLength(heightStr);
                if (width >= 0 && height >= 0) {
                    embedded.setDefaultSize(width, height);
                }
            }
            p = embedded;
            this.loadIFrame((DIFrameElement)e, embedded, this.pilot.isFromHistory);
        } else if (e.tagId == 5) {
            int len;
            DAppletElement appletElem = (DAppletElement)e;
            if (!appletElem.isLoaded()) {
                return null;
            }
            Hashtable params = this.getObjectParams(e);
            String loc = (String)params.get("code");
            if (loc == null) {
                if (Debug.trace) {
                    Debug.trace((String)("No applet code: elem=" + e));
                }
                return null;
            }
            if (".class".regionMatches(true, 0, loc = loc.replace('/', '.'), (len = loc.length()) - 6, 6)) {
                loc = loc.substring(0, len - 6);
            } else if (".java".regionMatches(true, 0, loc, len - 5, 5)) {
                loc = loc.substring(0, len - 5);
            }
            String type = "application/java";
            if (!this.pilot.getStorm().isMimeTypeEnabled(type)) {
                return null;
            }
            p = this.loadSubview(e, type, loc, params);
        } else if (e.tagId == 60) {
            Hashtable params = this.getObjectParams(e);
            String loc = (String)params.get("data");
            String type = (String)params.get("type");
            String classid = (String)params.get("classid");
            if (classid != null) {
                if (classid.startsWith("clsid:")) {
                    classid = classid.substring(6);
                }
                if (classid.equals("D27CDB6E-AE6D-11cf-96B8-444553540000")) {
                    type = "application/x-shockwave-flash";
                    loc = (String)params.get("movie");
                } else if (classid.equals("8AD9C840-044E-11D1-B3E9-00805F499D93") || classid.startsWith("CAFEEFAC") && classid.endsWith("ABCDEFFEDCBA")) {
                    type = "application/java";
                    loc = (String)params.get("code");
                    this.preProcessAppletParameters(e, params);
                } else if (classid.startsWith("java:")) {
                    loc = classid.substring(5);
                    type = "application/java";
                    this.preProcessAppletParameters(e, params);
                } else if (classid.equals("02BF25D5-8C17-4B23-BC80-D3488ABDDC6B")) {
                    loc = (String)params.get("src");
                    type = "video/quicktime";
                } else {
                    String codetype = (String)params.get("codetype");
                    if (codetype != null && codetype.equals("application/java")) {
                        loc = classid;
                        type = "application/java";
                        this.preProcessAppletParameters(e, params);
                    }
                }
            } else if (type != null && type.equals("application/x-weblet")) {
                loc = (String)params.get("weblet_codebase");
                if (loc == null && (loc = (String)params.get("docbase")) == null) {
                    if (Debug.trace) {
                        Debug.trace((String)("Bad weblet tag: elem=" + e));
                    }
                    return null;
                }
                this.addWebletsParams(e, params);
            }
            if (loc == null && type == null) {
                if (Debug.trace) {
                    Debug.trace((String)("NO location and type: elem=" + e));
                }
                return null;
            }
            if (type != null && !this.pilot.getStorm().isMimeTypeEnabled(type) && !type.equals("application/x-ice-dom-extension")) {
                return null;
            }
            p = type != null && type.equals("application/x-ice-dom-extension") ? this.loadDomExtension(e, params) : this.loadSubview(e, type, loc, params);
        } else if (box != null && box instanceof ScrollBox) {
            p = this.pilot.getCSSLayout().docPane.createScroller();
        }
        if (p != null) {
            this.painterHash.put(e, p);
        }
        return p;
    }

    private void preProcessAppletParameters(DElement e, Hashtable params) {
        DAttr objectCodebase = e.getDAttr(25);
        if (objectCodebase != null) {
            params.remove(objectCodebase.getName());
            params.put("jpi_codebase", objectCodebase.getValue());
            DNode n = e.getFirstDChild();
            while (n != null) {
                String attrName;
                DAttr attr;
                if (n.getNameId() == 65 && (attr = n.getDAttr(63)) != null && (attrName = attr.getNodeValue()) != null && attrName.equalsIgnoreCase("codebase")) {
                    attr = n.getDAttr(114);
                    if (attr == null) break;
                    params.put(attrName, attr.getNodeValue());
                    break;
                }
                n = n.next;
            }
        }
    }

    void loadIFrame(DIFrameElement e, EmbeddedObject embedded) {
        this.loadIFrame(e, embedded, false);
    }

    private void loadIFrame(DIFrameElement e, EmbeddedObject embedded, boolean fromHistory) {
        String s;
        String url = null;
        String tmp = e.getAttribute(102);
        if (tmp == null && (tmp = e.getAttribute(24)) == null) {
            tmp = e.getAttribute(68);
        }
        if (tmp != null && tmp.length() > 0) {
            url = e.doc.resolveUrl(tmp);
        }
        if ((s = e.getAttribute(97)) != null) {
            embedded.setProperty("scrolling", s);
        }
        if ((s = e.getAttribute(58)) == null) {
            s = "0";
        }
        embedded.setProperty("marginwidth", s);
        s = e.getAttribute(57);
        if (s == null) {
            s = "0";
        }
        embedded.setProperty("marginheight", s);
        s = this.pilot.getEncoding();
        if (s != null) {
            embedded.setProperty("encoding", s);
        }
        e.setAsEmbeddedViewHolder(embedded);
        String ctype = e.getAttribute(111);
        if (url != null) {
            Hashtable params = e.getAttributesAsHashtable();
            DNode n = e.getFirstDChild();
            while (n != null) {
                if (n.getNameId() == 65) {
                    DElement param = (DElement)n;
                    String name = param.getAttribute(63);
                    String value = param.getAttribute(114);
                    if (name != null && value != null) {
                        params.put(name.toLowerCase(), value);
                    }
                }
                n = n.next;
            }
            ContentLoader cl = this.pilot.getStorm().getContentLoaderFactory().createContentLoader(url, ctype);
            cl.setParams(params);
            cl.setIframe(true);
            if (!fromHistory) {
                this.pilot.getStorm().renderViewportContent(cl, embedded);
            }
        } else {
            if (ctype == null) {
                ctype = "text/html";
            }
            if (!fromHistory) {
                this.pilot.getStorm().clearViewportContent(ctype, embedded);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Image loadImage(String url) {
        Image image;
        String s = "image/jpeg";
        if (url.toLowerCase().endsWith(".gif")) {
            s = "image/gif";
        }
        if (!this.pilot.getStorm().isMimeTypeEnabled(s) || !this.pilot.canLoadImages()) {
            return null;
        }
        if (url.indexOf(32) != -1 && (url.startsWith("http") || url.startsWith("HTTP")) && Defs.booleanProperty((String)"ice.pilots.html4.encodeImageURL", (boolean)false)) {
            url = ObjectPool.encodeWhiteSpace(url);
        }
        if ((image = (Image)this.imageHash.get(url)) == null) {
            boolean loaded;
            image = this.pilot.sdata.imageCache.getImage(url, this.pilot);
            if (image == null) return image;
            this.imageHash.put(url, image);
            this.urlHash.put(image, url);
            int infoflags = this.pilot.sdata.imageCache.getAwtToolkit().checkImage(image, -1, -1, this);
            boolean bl = loaded = (infoflags & 0xF0) != 0;
            if (loaded) return image;
            ++this.imagesToLoad;
            this.fireOutstandingImagesEvent();
            ThePilot.prepareImage(image, this);
            return image;
        } else {
            ThePilot.prepareImage(image, null);
        }
        return image;
    }

    public Image getTiledImage(String hashKey) {
        return (Image)this.tiledImageCache.get(hashKey);
    }

    public void addTiledImageToCache(String key, Image image) {
        if (key == null || image == null) {
            throw new IllegalArgumentException("Arguments to tiledImageCache are invalid");
        }
        this.tiledImageCache.put(key, image);
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean done;
        boolean bl = done = (infoflags & 0xF0) != 0;
        if (!done) {
            ThePilot p = this.pilot;
            if (p != null) {
                if (!p.canLoadImages()) {
                    done = true;
                }
            } else {
                done = true;
            }
        }
        if (done) {
            if ((infoflags & 0x10) != 0) {
                this.pilot.sdata.imageCache.checkForAnimatedImagesBug();
            }
            --this.imagesToLoad;
            String url = (String)this.urlHash.get(img);
            this.fireOutstandingImagesEvent(url);
            return false;
        }
        return true;
    }

    private ObjectPainter loadSubview(DElement e, String type, String location, Hashtable params) {
        if (location == null && type == null) {
            Debug.bug();
        }
        EmbeddedObject embedded = new EmbeddedObject(this.pilot.getStorm(), e);
        String s = (String)params.get("scrolling");
        if (s != null) {
            embedded.setProperty("scrolling", s);
        }
        if ((s = (String)params.get("marginwidth")) != null) {
            embedded.setProperty("marginwidth", s);
        }
        if ((s = (String)params.get("marginheight")) != null) {
            embedded.setProperty("marginheight", s);
        }
        if ((s = this.pilot.getEncoding()) != null) {
            embedded.setProperty("encoding", s);
        }
        if ((s = (String)params.get("name")) != null) {
            embedded.setProperty("name", s);
        }
        if ((s = (String)params.get("height")) != null) {
            embedded.setProperty("height", s);
        }
        if ((s = (String)params.get("width")) != null) {
            embedded.setProperty("width", s);
        }
        String widthStr = (String)params.get("width");
        String heightStr = (String)params.get("height");
        if (widthStr != null && heightStr != null) {
            int width = CSSUtil.parseLength(widthStr);
            int height = CSSUtil.parseLength(heightStr);
            if (width >= 0 && height >= 0) {
                embedded.setDefaultSize(width, height);
            }
        }
        e.setAsEmbeddedViewHolder(embedded);
        String url = location == null ? e.doc.getBaseUrl() : e.doc.resolveUrl(location);
        StormBase base = this.pilot.getStorm();
        ContentLoader cl = base.getContentLoaderFactory().createContentLoader(url, type);
        cl.setReferer(e.doc.getBaseUrl());
        cl.setParams(params);
        base.renderViewportContent(cl, embedded);
        return embedded;
    }

    private ObjectPainter loadDomExtension(DElement e, Hashtable params) {
        return null;
    }

    private Hashtable getObjectParams(DElement e) {
        Hashtable<String, String> params = e.getAttributesAsHashtable();
        if (params == null) {
            params = new Hashtable<String, String>();
        }
        DNode n = e.getFirstDChild();
        while (n != null) {
            if (n.getNameId() == 65) {
                DElement param = (DElement)n;
                String name = param.getAttribute(63);
                String value = param.getAttribute(114);
                if (name != null && value != null) {
                    params.put(name.toLowerCase(), value);
                }
            }
            n = n.next;
        }
        String docbase = e.doc.getBaseUrl();
        if (docbase != null) {
            params.put("docbase", docbase);
        }
        return params;
    }

    private void addWebletsParams(DElement e, Hashtable params) {
        params.put("ownerDocument", e.getOwnerDocument());
        params.put("objectElement", e);
        params.put("creatorViewportId", this.pilot.getViewportId());
        Properties prop = new Properties();
        DNode nn = e.getFirstDChild();
        while (nn != null) {
            if (nn.getNameId() == 65) {
                DElement param = (DElement)nn;
                String name = param.getAttribute(63);
                String value = param.getAttribute(114);
                if (name != null && value != null) {
                    prop.put(name, value);
                }
            }
            nn = nn.next;
        }
        params.put("elementProperties", prop);
    }

    private static String encodeWhiteSpace(String url) {
        int index = url.length();
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < index; ++i) {
            char c = url.charAt(i);
            if (c == ' ') {
                b.append("%20");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }
}

