/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import coldfusion.document.link.G2DLink;
import ice.debug.Debug;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DAreaElement;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DMapElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.ExternalCSSBoxAssist;
import ice.pilots.html4.ImageObjectPainter;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.TextBox;
import ice.util.alg.CharKit;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.html.HTMLCollection;

public class MacromediaCSSExtension
implements ExternalCSSBoxAssist {
    public static final String[] linkTypes = new String[]{"External Link", "Internal reference Anchor", "Internal reference target"};

    @Override
    public void addonTextProcessing(Graphics g, TextBox textBox, int contentWidth, int contentHeight, int startingOffset) {
        if (!(g instanceof G2DLink)) {
            return;
        }
        Rectangle rt = new Rectangle();
        rt.width = contentWidth;
        rt.height = contentHeight;
        DNode node = this.getAnchorParent(textBox);
        if (startingOffset != 0) {
            g.translate(startingOffset, 0);
        }
        this.handleNodeParentIdLinks((G2DLink)g, textBox.parentBox.element, rt);
        if (node != null) {
            DAnchorElement aNode = (DAnchorElement)node;
            String target = aNode.getAttribute(46);
            int linkType = 1;
            if (target == null) {
                target = aNode.getAttribute(63);
            } else {
                linkType = this.getTypeFromTarget(textBox, target);
            }
            if (target != null) {
                Debug.trace((String)("Text Anchor found:\"" + target + "\",\n    type = " + linkType + ", [" + linkTypes[linkType] + "]"));
                this.addLinkToContext(textBox, g, linkType, target, rt);
            }
        }
        if (startingOffset != 0) {
            g.translate(-startingOffset, 0);
        }
    }

    private void handleNodeParentIdLinks(G2DLink g, DNode node, Rectangle rt) {
        DNode n = node;
        AffineTransform at = new AffineTransform();
        while (n != null) {
            String id;
            if (n instanceof DElement && (id = ((DElement)n).getAttribute(50)) != null && !"".equalsIgnoreCase(id)) {
                g.addLink(id, 1, at, (Shape)rt);
            }
            n = n.parent;
        }
    }

    @Override
    public void addonImageProcessing(Graphics g, ObjectBox objectBox) {
        if (!(g instanceof G2DLink)) {
            return;
        }
        G2DLink pdfG = (G2DLink)g;
        ObjectPainter o = objectBox.getObjectPainter();
        if (!(o instanceof ImageObjectPainter)) {
            return;
        }
        ImageObjectPainter iop = (ImageObjectPainter)o;
        Image image = iop.getImage();
        String altText = objectBox.parentBox.element.getAttribute(8);
        if (image != null) {
            Debug.trace((String)(" Image Alt Text found: [" + (altText == null ? "" : altText) + "]"));
            pdfG.addAltText(image, altText == null ? "" : altText);
        }
        DNode node = this.getAnchorParent(objectBox);
        Rectangle rt = new Rectangle();
        objectBox.findBoundingBox(rt);
        this.handleNodeParentIdLinks((G2DLink)g, objectBox.parentBox.element, rt);
        if (node == null) {
            node = objectBox.getUsemap();
            if (node != null) {
                this.handleUsemap((DMapElement)node, objectBox, pdfG, image);
            }
            return;
        }
        DAnchorElement aNode = (DAnchorElement)node;
        String target = aNode.getAttribute(46);
        int linkType = 1;
        if (target == null) {
            target = aNode.getAttribute(63);
        } else {
            linkType = this.getTypeFromTarget(objectBox, target);
        }
        if (target != null) {
            Debug.trace((String)("Image Anchor found:\"\", ALT=\"" + altText + "\", text = " + target + "\",\n    type = " + linkType + ", [" + linkTypes[linkType] + "]"));
            this.addLinkToContext(objectBox, g, linkType, target, rt);
        }
    }

    @Override
    public void addonAnchorProcessing(Graphics g, CSSBox anchorBox) {
        DNode anchorNode = anchorBox.getDomNode();
        if (!(anchorNode instanceof DAnchorElement)) {
            return;
        }
        DAnchorElement aNode = (DAnchorElement)anchorNode;
        if (this.hasTextOrImageChild(anchorBox)) {
            return;
        }
        int linkType = 1;
        String target = aNode.getAttribute(63);
        if (target == null) {
            target = aNode.getAttribute(50);
        }
        if (target == null) {
            return;
        }
        Rectangle rt = new Rectangle();
        AffineTransform at = ((Graphics2D)g).getTransform();
        if (Debug.trace) {
            System.out.println("  new empty anchor block: " + target + " transform: " + at);
        }
        this.addLinkToContext(anchorBox, g, linkType, target, rt);
    }

    private boolean hasTextOrImageChild(CSSBox box) {
        CSSBox child = box.getFirstChild();
        while (child != null) {
            if (child instanceof TextBox || child instanceof ObjectBox) {
                return true;
            }
            if (this.hasTextOrImageChild(child)) {
                return true;
            }
            child = child.next;
        }
        return false;
    }

    private DNode getAnchorParent(CSSBox box) {
        DNode node = box.parentBox.element;
        while (node != null) {
            if (node instanceof DAnchorElement) break;
            node = node.parent;
        }
        return node;
    }

    private void addLinkToContext(CSSBox box, Graphics g, int linkType, String target, Rectangle rt) {
        rt.x = 0;
        rt.y = 0;
        AffineTransform at2 = new AffineTransform();
        if (target.indexOf(58) == -1 && linkType == 0) {
            target = box.cssLayout.doc.resolveUrl(target);
        }
        if (Debug.trace) {
            System.out.println("    Shape:" + rt + ", Gtransform: " + ((Graphics2D)g).getTransform() + ", target: " + target + "\n");
        }
        ((G2DLink)g).addLink(target, linkType, at2, (Shape)rt);
    }

    private void handleUsemap(DMapElement map, ObjectBox box, G2DLink g, Image img) {
        int width;
        HTMLCollection areas = map.getAreas();
        Graphics2D orig = (Graphics2D)g;
        AffineTransform identity = new AffineTransform();
        AffineTransform save = (AffineTransform)orig.getTransform().clone();
        Rectangle rt = new Rectangle();
        box.findBoundingBox(rt);
        float xScale = (float)Math.abs(box.cssLayout.zoom) / 256.0f;
        float yScale = (float)Math.abs(box.cssLayout.zoom) / 256.0f;
        if (Debug.trace) {
            System.out.println("MAP Found (A): CSSScale = " + xScale);
        }
        int height = img.getHeight(null);
        int boxWidth = width = img.getWidth(null);
        int boxHeight = height;
        String temp = box.parentBox.element.getAttribute(119);
        if (temp != null) {
            boxWidth = Integer.parseInt(temp);
        }
        if ((temp = box.parentBox.element.getAttribute(45)) != null) {
            boxHeight = Integer.parseInt(temp);
        }
        xScale *= (float)boxWidth / (float)width;
        yScale *= (float)boxHeight / (float)height;
        if (Debug.trace) {
            System.out.println("MAP Found: " + map.getName() + ", scaleX: " + xScale + ", scaleY: " + yScale);
        }
        RectangularShape areaShape = null;
        int idx = areas.getLength() - 1;
        while (idx >= 0) {
            block18: {
                String shape;
                int linkType;
                String target;
                String alt;
                block20: {
                    block22: {
                        int[] coords;
                        block21: {
                            block19: {
                                DAreaElement area = (DAreaElement)areas.item(idx);
                                alt = area.getAlt();
                                coords = this.coordsToInts(area.getCoords(), xScale, yScale);
                                target = area.getHref();
                                if (target == null) break block18;
                                linkType = this.getTypeFromTarget(box, target);
                                shape = area.getShape();
                                if (shape == null) {
                                    if (coords.length == 4) {
                                        shape = "rect";
                                    } else if (coords.length == 3) {
                                        shape = "circle";
                                    } else if (coords.length > 4) {
                                        shape = "poly";
                                    } else {
                                        return;
                                    }
                                }
                                if ((shape = CharKit.toLowerCase((String)shape)).indexOf("rect") == -1) break block19;
                                if (coords.length != 4) break block18;
                                areaShape = new Rectangle(0, 0, coords[2] - coords[0], coords[3] - coords[1]);
                                orig.translate(coords[0], coords[1]);
                                break block20;
                            }
                            if (shape.indexOf("circ") == -1) break block21;
                            if (coords.length != 3) break block18;
                            areaShape = new Ellipse2D.Float(0.0f, 0.0f, 2 * coords[2], 2 * coords[2]);
                            orig.translate(coords[0] - coords[2], coords[1] - coords[2]);
                            break block20;
                        }
                        if (shape.indexOf("poly") == -1) break block22;
                        if (coords.length < 6) break block18;
                        int minX = Integer.MAX_VALUE;
                        int maxX = Integer.MIN_VALUE;
                        int minY = Integer.MAX_VALUE;
                        int maxY = Integer.MIN_VALUE;
                        int cdx = 0;
                        while (cdx < coords.length) {
                            if (coords[cdx] < minX) {
                                minX = coords[cdx];
                            }
                            if (coords[cdx] > maxX) {
                                maxX = coords[cdx];
                            }
                            if (coords[++cdx] < minY) {
                                minY = coords[cdx];
                            }
                            if (coords[cdx] > maxY) {
                                maxY = coords[cdx];
                            }
                            ++cdx;
                        }
                        Rectangle r = new Rectangle();
                        r.x = 0;
                        r.y = 0;
                        r.width = maxX - minX;
                        r.height = maxY - minY;
                        areaShape = r;
                        orig.translate(minX, minY);
                        break block20;
                    }
                    Debug.p((String)("Unsupported Shape type in Map: " + shape));
                    return;
                }
                g.addLink(target, linkType, identity, (Shape)areaShape);
                g.addAltText((Shape)areaShape, alt);
                if (Debug.trace) {
                    System.out.println("    Map : " + shape + ", Target: " + target + ", ALT TEXT: " + alt);
                    System.out.println("    Shape: " + areaShape + ", AffineXform: " + orig.getTransform() + "\n");
                }
                orig.setTransform(save);
            }
            --idx;
        }
    }

    private int[] coordsToInts(String coords, float xScale, float yScale) {
        if (coords == null) {
            return new int[0];
        }
        StringTokenizer st = new StringTokenizer(coords, ",");
        ArrayList<String> stringCoords = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            stringCoords.add(st.nextToken());
        }
        int[] returnVal = new int[stringCoords.size()];
        int idx = 0;
        while (idx < stringCoords.size()) {
            try {
                String item = (String)stringCoords.get(idx);
                returnVal[idx++] = Math.round((float)Integer.parseInt(item.trim()) * xScale);
                if (idx >= stringCoords.size()) continue;
                item = (String)stringCoords.get(idx);
                returnVal[idx++] = Math.round((float)Integer.parseInt(item.trim()) * yScale);
            }
            catch (NumberFormatException nfe) {
                returnVal[idx] = 0;
            }
        }
        return returnVal;
    }

    private int getTypeFromTarget(CSSBox box, String target) {
        URL url;
        URL currentUrl;
        block10: {
            block9: {
                block8: {
                    int chrX1 = 0;
                    chrX1 = target.indexOf("#");
                    if (chrX1 == -1) {
                        return 0;
                    }
                    if (target.indexOf(58) == -1) {
                        target = box.cssLayout.doc.resolveUrl(target);
                    }
                    currentUrl = box.cssLayout.doc.getBaseURL();
                    url = null;
                    try {
                        url = new URL(target);
                        if (url.getHost().equalsIgnoreCase(currentUrl.getHost())) break block8;
                        return 0;
                    }
                    catch (MalformedURLException malformedURLException) {
                        return 0;
                    }
                }
                if (url.getPath().equalsIgnoreCase(currentUrl.getPath())) break block9;
                return 0;
            }
            if (url.getProtocol().equalsIgnoreCase(currentUrl.getProtocol())) break block10;
            return 0;
        }
        if (url.getPort() != currentUrl.getPort()) {
            return 0;
        }
        return 2;
    }
}

