/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DElement;
import ice.pilots.html4.Names;
import ice.pilots.html4.TableCellBox;
import ice.util.alg.CharKit;
import java.awt.Color;

final class HtmlToCss {
    HtmlToCss() {
    }

    static void apply(DElement e, CSSAttribs css, CSSBox parentBox, int zoom) {
        switch (e.tagId) {
            case 1: {
                char[] cc;
                Color c;
                DAnchorElement ae;
                String s;
                if (e.getAttribute(46) == null || (s = (ae = (DAnchorElement)e).getVisited() ? e.doc.getVlinkColor() : e.doc.getLinkColor()) == null || (c = CSSUtil.parseColor(cc = s.toCharArray(), 0, cc.length)) == null) break;
                css.color = c;
                break;
            }
            case 5: {
                HtmlToCss.apply_width_height(e, css, zoom);
                HtmlToCss.apply_vspace_hspace(e, css, zoom);
                HtmlToCss.apply_block_align(e, css);
                break;
            }
            case 9: {
                break;
            }
            case 13: {
                Names names;
                int t;
                HtmlToCss.apply_direction(e, css);
                HtmlToCss.apply_bgcolor(e, css);
                HtmlToCss.apply_text_color(e, css, 109);
                String s = e.getAttribute(11);
                if (s != null && css.background_image == null) {
                    css.background_image = s;
                    css.background_image_url = s;
                }
                if ((t = HtmlToCss.parse_length(e, 58, zoom)) >= 0) {
                    css.padding_left = css.padding_right = t;
                }
                if (t == 0) {
                    css.margin_right = 0;
                    css.margin_left = 0;
                }
                if ((t = HtmlToCss.parse_length(e, 57, zoom)) >= 0) {
                    css.padding_top = css.padding_bottom = t;
                }
                if (t == 0) {
                    css.margin_bottom = 0;
                    css.margin_top = 0;
                }
                if ((t = HtmlToCss.parse_length(e, (names = e.doc.getDom().getStormData().names).getAttrId(3, "topmargin"), zoom)) >= 0) {
                    css.padding_top = t;
                }
                if ((t = HtmlToCss.parse_length(e, names.getAttrId(3, "bottommargin"), zoom)) >= 0) {
                    css.padding_bottom = t;
                }
                if ((t = HtmlToCss.parse_length(e, names.getAttrId(3, "leftmargin"), zoom)) >= 0) {
                    css.padding_left = t;
                }
                if ((t = HtmlToCss.parse_length(e, names.getAttrId(3, "rightmargin"), zoom)) < 0) break;
                css.padding_right = t;
                break;
            }
            case 14: {
                String s = e.getAttribute(23);
                if (s == null) break;
                if (s.equalsIgnoreCase("left")) {
                    css.do_floats = (byte)(css.do_floats | 4);
                    break;
                }
                if (s.equalsIgnoreCase("right")) {
                    css.do_floats = (byte)(css.do_floats | 8);
                    break;
                }
                if (!s.equalsIgnoreCase("both") && !s.equalsIgnoreCase("all")) break;
                css.do_floats = (byte)(css.do_floats | 0xC);
                break;
            }
            case 95: {
                css.misc = (short)(css.misc | 4);
                break;
            }
            case 16: {
                HtmlToCss.apply_text_align(e, css);
                break;
            }
            case 20: {
                HtmlToCss.apply_text_align(e, css);
                HtmlToCss.apply_v_align(e, css, 113);
                HtmlToCss.apply_bgcolor(e, css);
                HtmlToCss.apply_width_height(e, css, zoom);
                break;
            }
            case 21: {
                HtmlToCss.apply_text_align(e, css);
                HtmlToCss.apply_v_align(e, css, 113);
                HtmlToCss.apply_bgcolor(e, css);
                HtmlToCss.apply_width_height(e, css, zoom);
                break;
            }
            case 93: {
                HtmlToCss.apply_width_height(e, css, zoom);
                HtmlToCss.apply_bgcolor(e, css);
                break;
            }
            case 26: {
                HtmlToCss.apply_direction(e, css);
                HtmlToCss.apply_text_align(e, css);
                HtmlToCss.apply_bgcolor(e, css);
                break;
            }
            case 31: {
                HtmlToCss.apply_text_color(e, css, 27);
                String s = e.getAttribute(40);
                if (s != null && s.length() != 0) {
                    css.font_family = css.getFontCache().getSupportedFontFamily(s);
                }
                if ((s = e.getAttribute(100)) == null) break;
                int start = 0;
                int end = s.length();
                if ((start = CharKit.trimStart((String)s, (int)start, (int)end)) == (end = CharKit.trimEnd((String)s, (int)start, (int)end))) break;
                char c = s.charAt(start);
                if (c == '+' || c == '-') {
                    int t = CSSUtil.parseInt(s, start + 1, end, Integer.MIN_VALUE);
                    if (t == Integer.MIN_VALUE) break;
                    if (c == '-') {
                        t = -t;
                    }
                    css.font_size = css.getFontCache().getFontSizeAbs(t += 3, zoom);
                    break;
                }
                int t = CSSUtil.parseInt(s, start, end, -1);
                if (t < 0) break;
                if (t == 0) {
                    t = 1;
                }
                css.font_size = css.getFontCache().getFontSizeAbs(t, zoom);
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                HtmlToCss.apply_text_align(e, css);
                break;
            }
            case 42: {
                css.text_align = 2;
                HtmlToCss.apply_text_align(e, css);
                HtmlToCss.apply_width_height(e, css, zoom);
                break;
            }
            case 46: {
                HtmlToCss.apply_width_height(e, css, zoom);
                HtmlToCss.apply_vspace_hspace(e, css, zoom);
                HtmlToCss.apply_block_align(e, css);
                HtmlToCss.apply_v_align(e, css, 6);
                HtmlToCss.apply_v_align(e, css, 113);
                break;
            }
            case 47: {
                HtmlToCss.apply_direction(e, css);
                HtmlToCss.apply_text_align(e, css);
                HtmlToCss.apply_width_height(e, css, zoom);
                break;
            }
            case 45: 
            case 60: {
                String s = e.getAttribute("hidden");
                if (s != null && s.equalsIgnoreCase("true")) {
                    css.misc = (short)(css.misc & 0xFFFFFFFE);
                }
                HtmlToCss.apply_width_height(e, css, zoom);
                HtmlToCss.apply_vspace_hspace(e, css, zoom);
                HtmlToCss.apply_block_align(e, css);
                break;
            }
            case 52: {
                break;
            }
            case 53: {
                char c;
                String s = e.getAttribute(111);
                if (s == null) break;
                int type = 99;
                int L = s.length();
                if (L == 1) {
                    char t = s.charAt(0);
                    if (t == 'A') {
                        type = 107;
                    }
                } else if (L == 4) {
                    char c2 = s.charAt(0);
                    if (c2 == 'D' || c2 == 'd') {
                        if (CharKit.equalsIgnoreAsciiCase((String)"disc", (String)s)) {
                            type = 97;
                        }
                    } else if ((c2 == 'N' || c2 == 'n') && CharKit.equalsIgnoreAsciiCase((String)"none", (String)s)) {
                        type = 8;
                    }
                } else if (L == 6 && ((c = s.charAt(0)) == 'C' || c == 'c') && CharKit.equalsIgnoreAsciiCase((String)"circle", (String)s)) {
                    type = 98;
                }
                css.listStyleType = (byte)type;
                break;
            }
            case 61: {
                String s = e.getAttribute(111);
                if (s == null || s.length() <= 0) break;
                int t = s.charAt(0);
                t = t == 105 ? 102 : (t == 73 ? 103 : (t == 97 ? 105 : (t == 65 ? 107 : 100)));
                css.listStyleType = (byte)t;
                break;
            }
            case 64: {
                HtmlToCss.apply_direction(e, css);
                HtmlToCss.apply_text_align(e, css);
                break;
            }
            case 79: {
                int t;
                String s = e.getAttribute(11);
                if (s != null) {
                    css.background_image = s;
                    css.background_image_url = s;
                }
                HtmlToCss.apply_direction(e, css);
                HtmlToCss.apply_width_height(e, css, zoom);
                HtmlToCss.apply_block_align(e, css);
                HtmlToCss.apply_bgcolor(e, css);
                if (e.getAttribute(15) != null) {
                    t = HtmlToCss.parse_length(e, 15, zoom);
                    if (t >= 0) {
                        css.border_spacing_x = t;
                        css.border_spacing_y = t;
                    }
                } else if (!e.getSynthetic()) {
                    css.border_spacing_x = 3;
                    css.border_spacing_y = 3;
                }
                t = 0;
                s = e.getAttribute(13);
                if (s != null && (t = CSSUtil.parseInt(s, -1)) < 0) {
                    t = 1;
                }
                css.border_top_style = 155;
                css.border_bottom_style = 155;
                css.border_left_style = 155;
                css.border_right_style = 155;
                css.border_top_width = t;
                css.border_bottom_width = t;
                css.border_left_width = t;
                css.border_right_width = t;
                break;
            }
            case 80: 
            case 83: 
            case 85: {
                HtmlToCss.apply_text_align(e, css);
                HtmlToCss.apply_v_align(e, css, 113);
                break;
            }
            case 81: 
            case 84: {
                String s = e.getAttribute(11);
                if (s != null) {
                    css.background_image = s;
                    css.background_image_url = s;
                }
                if ((s = e.getAttribute(67)) != null) {
                    css.misc = (short)(css.misc | 8);
                }
                HtmlToCss.apply_direction(e, css);
                HtmlToCss.apply_text_align(e, css);
                HtmlToCss.apply_v_align(e, css, 113);
                HtmlToCss.apply_width_height(e, css, zoom);
                HtmlToCss.apply_bgcolor(e, css);
                if (e.tagId == 84 && css.text_align == 2 && parentBox.css.text_align != 15) {
                    css.text_align = parentBox.css.text_align;
                }
                DElement table = (DElement)e.getParentDNode().getParentDNode().getParentDNode();
                s = table.getAttribute(13);
                int t = 0;
                if (s != null && (t = CSSUtil.parseInt(s, -1)) < 0) {
                    t = 1;
                }
                if (t > 0) {
                    css.border_top_style = 154;
                    css.border_bottom_style = 154;
                    css.border_left_style = 154;
                    css.border_right_style = 154;
                    css.border_top_width = 1;
                    css.border_bottom_width = 1;
                    css.border_left_width = 1;
                    css.border_right_width = 1;
                    CSSBox tableBox = parentBox.getParentBox().getParentBox();
                    Color c = tableBox.css.background_color;
                    if (c != null) {
                        css.border_top_color = c;
                        css.border_bottom_color = c;
                        css.border_left_color = c;
                        css.border_right_color = c;
                    }
                }
                if ((t = HtmlToCss.parse_length(table, 14, zoom)) < 0) break;
                css.padding_top = t;
                css.padding_bottom = t;
                css.padding_left = t;
                css.padding_right = t;
                break;
            }
            case 87: {
                HtmlToCss.apply_text_align(e, css);
                HtmlToCss.apply_v_align(e, css, 113);
                HtmlToCss.apply_bgcolor(e, css);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 19: 
            case 24: 
            case 43: 
            case 50: 
            case 66: 
            case 67: 
            case 69: 
            case 73: 
            case 75: 
            case 77: 
            case 78: 
            case 91: {
                HtmlToCss.apply_direction(e, css);
                break;
            }
            case 18: 
            case 29: {
                HtmlToCss.apply_direction(e, css);
                HtmlToCss.apply_table_correction(e, css, parentBox);
            }
        }
    }

    private static void apply_direction(DElement e, CSSAttribs css) {
        String s = e.getAttribute(37);
        if (s != null) {
            if (s.equalsIgnoreCase("rtl")) {
                css.directionFlag = 1;
            } else if (s.equalsIgnoreCase("ltr")) {
                css.directionFlag = (byte)2;
            }
        }
    }

    private static void apply_text_align(DElement e, CSSAttribs css) {
        String s = e.getAttribute(6);
        if (s != null) {
            css.text_align = s.equalsIgnoreCase("right") ? 3 : (s.equalsIgnoreCase("center") || s.equalsIgnoreCase("middle") ? 2 : 1);
        }
    }

    private static void apply_v_align(DElement e, CSSAttribs css, int attrId) {
        String s = e.getAttribute(attrId);
        if (s != null) {
            if (s.equalsIgnoreCase("top")) {
                css.vertical_align_type = 16;
            } else if (s.equalsIgnoreCase("bottom")) {
                css.vertical_align_type = 17;
            } else if (s.equalsIgnoreCase("middle")) {
                css.vertical_align_type = 144;
            } else if (s.equalsIgnoreCase("baseline")) {
                css.vertical_align_type = 140;
            }
        }
    }

    private static void apply_table_correction(DElement e, CSSAttribs css, CSSBox op) {
        CSSBox up = op;
        boolean found = false;
        while (up != null) {
            if (up instanceof TableCellBox) {
                found = true;
            }
            up = up.parentBox;
        }
        if (found) {
            css.vertical_align_type = op.css.vertical_align_type;
        }
    }

    private static void apply_block_align(DElement e, CSSAttribs css) {
        String s = e.getAttribute(6);
        if (s != null) {
            if (s.equalsIgnoreCase("right")) {
                css.do_floats = (byte)(css.do_floats | 2);
            } else if (s.equalsIgnoreCase("left")) {
                css.do_floats = (byte)(css.do_floats | 1);
            } else if (s.equalsIgnoreCase("center")) {
                css.misc = (short)(css.misc | 0x40);
            }
        }
    }

    private static void apply_width_height(DElement e, CSSAttribs css, int zoom) {
        int t = HtmlToCss.parse_length(e, 119, zoom);
        if (t >= 0) {
            css.width = t;
            css.percentage_flag &= 0xFFEFFFFF;
        } else if (t != Integer.MIN_VALUE) {
            css.width = -t;
            css.percentage_flag |= 0x100000;
        }
        t = HtmlToCss.parse_length(e, 45, zoom);
        if (t >= 0) {
            css.height = t;
            css.percentage_flag &= 0xFFFFFFF7;
        } else if (t != Integer.MIN_VALUE) {
            css.height = -t;
            css.percentage_flag |= 8;
        }
    }

    private static void apply_vspace_hspace(DElement e, CSSAttribs css, int zoom) {
        int t = HtmlToCss.parse_length(e, 48, zoom);
        if (t > 0) {
            css.padding_left = css.padding_right = t;
        }
        if ((t = HtmlToCss.parse_length(e, 118, zoom)) > 0) {
            css.padding_top = css.padding_bottom = t;
        }
    }

    private static void apply_bgcolor(DElement e, CSSAttribs css) {
        char[] cc;
        Color c;
        String s = e.getAttribute(12);
        if (s != null && (c = CSSUtil.parseColor(cc = s.toCharArray(), 0, cc.length)) != null) {
            css.background_color = c;
        }
    }

    private static void apply_text_color(DElement e, CSSAttribs css, int attr_name) {
        char[] cc;
        Color c;
        String s = e.getAttribute(attr_name);
        if (s != null && (c = CSSUtil.parseColor(cc = s.toCharArray(), 0, cc.length)) != null) {
            css.color = c;
        }
    }

    private static int parse_length(DElement e, int attr_name, int zoom) {
        int value;
        String s = e.getAttribute(attr_name);
        if (s != null && (value = CSSUtil.parseLength(s)) != Integer.MIN_VALUE) {
            if (value > 0 && (value = value * zoom >> 8) < 1) {
                value = 1;
            }
            return value;
        }
        return Integer.MIN_VALUE;
    }
}

