/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ThePilot;
import ice.storm.DocPane;
import ice.util.Defs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class FocusManager {
    public static final int UP = 38;
    public static final int DOWN = 40;
    public static final int LEFT = 37;
    public static final int RIGHT = 39;
    public static final int NEXT = 9;
    public static final int PREVIOUS = 411;
    protected int theFocusedElement = -1;
    protected Vector domnodes = new Vector();
    protected Vector cssboxes = new Vector();
    protected Hashtable accesskeys = new Hashtable();
    private int tabIndexStart = 0;
    private int tabIndexEnd = 0;
    protected DDocument doc;
    protected CSSLayout layout;
    protected ThePilot pilot;
    protected DocPane docPane;
    private boolean frameHasFocus = false;
    protected Point documentScrollPosition = new Point();
    protected Dimension viewDimension = new Dimension();
    private Rectangle tmpRect = new Rectangle();
    private Object keyboardFocusMgr;
    private static final String KBFM_CLASS_NAME = "java.awt.KeyboardFocusManager";

    public FocusManager(DDocument d, CSSLayout cl, ThePilot p) {
        this.doc = d;
        this.layout = cl;
        this.pilot = p;
        this.docPane = cl.docPane;
    }

    void clearElements() {
        this.domnodes.removeAllElements();
        this.cssboxes.removeAllElements();
        this.theFocusedElement = -1;
        this.tabIndexStart = 0;
        this.tabIndexEnd = 0;
    }

    public final void setFrameFocused(boolean v) {
        this.frameHasFocus = v;
        if (Defs.sysPropertyBoolean((String)"ice.pilots.html4.documentFocusOutline", (boolean)true)) {
            this.layout.validateLayout();
        }
    }

    public final boolean isFrameFocused() {
        return this.frameHasFocus && this.theFocusedElement == -1;
    }

    void layoutComplete() {
        this.viewDimension.width = this.pilot.getView().getDocPane().getPaneWidth();
        this.viewDimension.height = this.pilot.getView().getDocPane().getPaneWidth();
        this.docPane = this.layout.docPane;
    }

    protected boolean isOnScreen(Rectangle r) {
        if (r == null) {
            return false;
        }
        this.documentScrollPosition.x = this.docPane.getScrollX();
        this.documentScrollPosition.y = this.docPane.getScrollY();
        if (r.y > this.viewDimension.height + this.documentScrollPosition.y) {
            return false;
        }
        if (r.x > this.viewDimension.width + this.documentScrollPosition.x) {
            return false;
        }
        if (r.y + r.height < this.documentScrollPosition.y) {
            return false;
        }
        return r.x + r.width >= this.documentScrollPosition.x;
    }

    protected int focusDefaultBox() {
        for (int i = 0; i < this.cssboxes.size(); ++i) {
            CSSBox b = (CSSBox)this.cssboxes.elementAt(i);
            this.tmpRect.y = 0;
            this.tmpRect.x = 0;
            this.tmpRect.height = 0;
            this.tmpRect.width = 0;
            b.findBoundingBox(this.tmpRect);
            if (!this.isOnScreen(this.tmpRect)) continue;
            return i;
        }
        return -1;
    }

    protected boolean localDFM(int dir) {
        return false;
    }

    protected boolean globalDFM(int dir) {
        return false;
    }

    protected void registerAccesskey(String key, Object value) {
        if (key.length() == 0) {
            return;
        }
        long charCod = key.charAt(0);
        this.accesskeys.put(new Long(charCod), value);
    }

    protected Object lookupAccesskey(Object key) {
        return this.accesskeys.get(key);
    }

    protected void setFocusedBox(DNode dnode) {
        if (dnode == null) {
            this.setFocusedBox(-1);
        } else {
            this.setFocusedBox(this.domnodes.indexOf(dnode));
        }
    }

    protected void setFocusedBox(int boxno) {
        Point p;
        if (this.theFocusedElement == boxno) {
            return;
        }
        DOMUIEvent blurEvent = null;
        DOMUIEvent focusEvent = null;
        if (this.theFocusedElement != -1) {
            DNode oldFocusNode = (DNode)this.domnodes.elementAt(this.theFocusedElement);
            CSSBox oldFocusBox = (CSSBox)this.cssboxes.elementAt(this.theFocusedElement);
            blurEvent = (DOMUIEvent)this.doc.createDOMEvent(22);
            blurEvent.target = oldFocusNode;
            p = new Point();
            oldFocusBox.findAbsolutePosition(p);
            blurEvent.setPosX(p.x);
            blurEvent.setPosY(p.y);
        } else {
            this.setFrameFocused(true);
        }
        this.theFocusedElement = boxno;
        if (this.theFocusedElement == -1) {
            this.setFrameFocused(true);
        } else {
            DNode newFocusNode = (DNode)this.domnodes.elementAt(this.theFocusedElement);
            CSSBox newFocusBox = (CSSBox)this.cssboxes.elementAt(boxno);
            focusEvent = (DOMUIEvent)this.doc.createDOMEvent(21);
            focusEvent.target = newFocusNode;
            p = new Point();
            newFocusBox.findAbsolutePosition(p);
            focusEvent.setPosX(p.x);
            focusEvent.setPosY(p.y);
            if (blurEvent != null) {
                focusEvent.relatedNode = blurEvent.target;
                blurEvent.relatedNode = focusEvent.target;
            }
            this.pilot.getCSSLayout().markDocument(p.x, p.y, 0, 0);
        }
        if (blurEvent != null) {
            this.postFocusEvent(blurEvent);
        }
        if (focusEvent != null) {
            this.postFocusEvent(focusEvent);
        }
    }

    private void postFocusEvent(final DOMUIEvent uiEvent) {
        uiEvent.setAction(new EventListener(){

            public void handleEvent(Event evt) {
                DNode target = uiEvent.target;
                if (uiEvent.typeId == 21) {
                    FocusManager.this.layout.docPane.onNodeFocusEvent(uiEvent, target);
                } else if (uiEvent.typeId == 22) {
                    FocusManager.this.layout.docPane.onNodeBlurEvent(uiEvent, target);
                }
            }
        });
        this.doc.processEventLater(uiEvent, 0L);
    }

    private int findTabIndex(DElement n) throws NumberFormatException {
        String tabidx = n.getAttribute("tabindex");
        if (tabidx != null) {
            Integer tmp = Integer.valueOf(tabidx.trim());
            return tmp;
        }
        throw new NumberFormatException("Not specified");
    }

    void registerNewElement(CSSBox b, DElement e) {
        int tabIndex = 0;
        try {
            tabIndex = this.findTabIndex(e);
            if (0 == tabIndex) {
                this.domnodes.insertElementAt(e, this.tabIndexStart);
                this.cssboxes.insertElementAt(b, this.tabIndexStart);
                ++this.tabIndexStart;
                ++this.tabIndexEnd;
            } else {
                int itmp;
                for (itmp = this.tabIndexStart; itmp < this.tabIndexEnd; ++itmp) {
                    DElement n = (DElement)this.domnodes.elementAt(itmp);
                    try {
                        int potTabIdx = this.findTabIndex(n);
                        if (potTabIdx <= tabIndex) continue;
                        break;
                    }
                    catch (NumberFormatException ex) {
                        if (!Debug.trace) continue;
                        Debug.trace((String)"tabIndex problem");
                    }
                }
                this.domnodes.insertElementAt(e, itmp);
                this.cssboxes.insertElementAt(b, itmp);
                ++this.tabIndexEnd;
            }
        }
        catch (NumberFormatException ex) {
            this.domnodes.addElement(e);
            this.cssboxes.addElement(b);
        }
        String accessKey = e.getAttribute(4);
        if (accessKey != null) {
            this.registerAccesskey(accessKey, e);
        }
    }

    boolean processAccessKey(long chr) {
        Long c = new Long(chr);
        DNode dnode = (DNode)this.lookupAccesskey(c);
        if (dnode == null) {
            return false;
        }
        this.setFocusedBox(dnode);
        return true;
    }

    protected boolean isDisabled(int elementno) {
        DElement elm;
        if (elementno < 0 || elementno >= this.domnodes.size()) {
            return true;
        }
        DNode node = (DNode)this.domnodes.elementAt(elementno);
        return node instanceof DElement && (elm = (DElement)node).getAttribute("disabled") != null;
    }

    protected int nextFocus() {
        if (this.domnodes.size() == 0) {
            return -1;
        }
        if (this.theFocusedElement < this.tabIndexStart) {
            return this.tabIndexStart;
        }
        if (this.domnodes.elementAt(this.theFocusedElement) == this.domnodes.lastElement()) {
            this.focusDocPane();
            return -1;
        }
        int itmp = this.theFocusedElement + 1;
        boolean keep_looking = true;
        while (keep_looking) {
            if (itmp == this.domnodes.size()) {
                this.focusDocPane();
                return -1;
            }
            if (this.isDisabled(itmp)) {
                ++itmp;
                continue;
            }
            keep_looking = false;
        }
        DElement currentFocusElement = (DElement)this.domnodes.elementAt(this.theFocusedElement);
        DElement newFocusElement = (DElement)this.domnodes.elementAt(itmp);
        if (currentFocusElement.isFormControl() && !newFocusElement.isFormControl()) {
            this.focusDocPane();
        }
        return itmp;
    }

    protected int previousFocus() {
        if (this.domnodes.size() == 0) {
            return -1;
        }
        if (this.theFocusedElement == -1) {
            return this.domnodes.indexOf(this.domnodes.lastElement());
        }
        int itmp = this.theFocusedElement - 1;
        boolean keep_looking = true;
        while (keep_looking) {
            if (itmp < this.tabIndexStart) {
                this.focusDocPane();
                return -1;
            }
            if (this.isDisabled(itmp)) {
                --itmp;
                continue;
            }
            keep_looking = false;
        }
        DElement currentFocusElement = (DElement)this.domnodes.elementAt(this.theFocusedElement);
        DElement newFocusElement = (DElement)this.domnodes.elementAt(itmp);
        if (currentFocusElement.isFormControl() && !newFocusElement.isFormControl()) {
            this.focusDocPane();
        }
        return itmp;
    }

    private void focusDocPane() {
        this.docPane.reqFocus();
    }

    public DNode getFocusedElement() {
        if (this.theFocusedElement == -1) {
            return null;
        }
        return (DNode)this.domnodes.elementAt(this.theFocusedElement);
    }

    public boolean requestFocus() {
        if (this.theFocusedElement == -1) {
            return false;
        }
        DNode node = (DNode)this.domnodes.elementAt(this.theFocusedElement);
        ObjectPainter painter = this.pilot.getView().getNodePainter(node);
        if (painter instanceof Component) {
            ((Component)((Object)painter)).requestFocus();
            return true;
        }
        return false;
    }

    protected void previousExternalFocus() {
        this.invokeReflectively("focusPreviousComponent");
    }

    protected void nextExternalFocus() {
        this.invokeReflectively("focusNextComponent");
    }

    private void invokeReflectively(String methodName) {
        block5: {
            if (this.keyboardFocusMgr == null) {
                this.initKeyboardFocusManager();
                if (this.keyboardFocusMgr == null) {
                    return;
                }
            }
            try {
                Method meth = Defs.getMethod((String)KBFM_CLASS_NAME, (String)methodName, null);
                meth.invoke(this.keyboardFocusMgr, Defs.EMPTY_OBJECT_ARRAY);
            }
            catch (Exception e) {
                if (Debug.ex) {
                    Debug.ex((Throwable)e);
                }
                if (!Debug.trace) break block5;
                Debug.trace((String)e.getMessage());
            }
        }
    }

    private void initKeyboardFocusManager() {
        block3: {
            try {
                Method getCurrentKFM = Defs.getMethod((String)KBFM_CLASS_NAME, (String)"getCurrentKeyboardFocusManager", null);
                this.keyboardFocusMgr = getCurrentKFM.invoke(null, null);
            }
            catch (Exception e) {
                this.keyboardFocusMgr = null;
                if (Debug.ex) {
                    Debug.ex((Throwable)e);
                }
                if (!Debug.trace) break block3;
                Debug.trace((String)e.getMessage());
            }
        }
    }
}

