/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DAllList;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFlatList;
import ice.pilots.html4.DNode;
import ice.storm.DynEnv;
import ice.storm.DynamicList;
import ice.util.Defs;
import ice.util.alg.HashArray;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;

public class DNodeList
extends DynamicList
implements NodeList,
HTMLCollection {
    public static final String ALL = "*";
    public static final String LINKS = "_links_";
    private static final int TAG_ALL = 0;
    private static final int TAG_LINKS = -100;
    private DNode startNode;
    private DNode current;
    private int tagId;
    private String attr = null;
    private Vector indexes = new Vector();
    private HashArray names_and_ids = new HashArray();
    private int mutation = 0;

    DNodeList(DNode startNode, String tagName) {
        this(startNode, tagName, null);
    }

    DNodeList(DNode startNode, String tagName, String attr) {
        this.startNode = startNode;
        this.attr = attr;
        this.tagId = tagName == ALL ? 0 : (tagName == LINKS ? -100 : startNode.doc.names.getTagId(startNode.doc.defaultNamespace, tagName));
        this.record();
    }

    private void record() {
        HashArray hash = new HashArray(Defs.NO_SYNCHRONIZATION);
        Vector v = new Vector();
        this.record_r(this.startNode, v, hash);
        hash.sealObject();
        this.indexes = v;
        this.names_and_ids = hash;
        this.mutation = this.startNode.doc.getMutation();
    }

    private void record_r(DNode n, Vector v, HashArray hash) {
        if (n instanceof DElement) {
            DElement e = (DElement)n;
            if (!(this.tagId != 0 && this.tagId != e.tagId && (this.tagId != -100 || e.tagId != 1 && e.tagId != 6) || this.attr != null && e.getAttribute(this.attr) == null)) {
                v.addElement(e);
                String id = DAllList.getIdValue(e);
                String name = e.getAttribute(63);
                if (name != null) {
                    DAllList.recordEntry(hash, name, e);
                }
                if (id != null) {
                    DAllList.recordEntry(hash, id, e);
                }
            }
        }
        n = n.getFirstDChild();
        while (n != null) {
            this.record_r(n, v, hash);
            n = n.next;
        }
    }

    public Node item(int idx) {
        if (this.startNode.doc.getMutation() != this.mutation) {
            this.record();
        }
        if (idx < 0 || idx >= this.indexes.size()) {
            return null;
        }
        return (Node)this.indexes.elementAt(idx);
    }

    protected Object script_item(int index, DynEnv env) {
        return this.item(index);
    }

    public int getLength() {
        if (this.startNode.doc.getMutation() != this.mutation) {
            this.record();
        }
        return this.indexes.size();
    }

    public Node namedItem(String name) {
        Object o;
        if (this.startNode.doc.getMutation() != this.mutation) {
            this.record();
        }
        if ((o = this.names_and_ids.get((Object)name)) instanceof DFlatList) {
            o = ((DFlatList)o).item(0);
        }
        return (Node)o;
    }

    protected Object script_namedItem(String name, DynEnv env) {
        if (this.startNode.doc.getMutation() != this.mutation) {
            this.record();
        }
        return this.names_and_ids.get((Object)name);
    }

    protected Object script_tags(String tagName, DynEnv env) {
        return new DNodeList(this.startNode, tagName);
    }
}

