/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.storm.DynEnv;
import ice.util.net.URLResolver;

public class DHrefElement
extends DElement {
    private static final int Field_hash = 1;
    private static final int Field_host = 2;
    private static final int Field_hostname = 3;
    private static final int Field_href = 4;
    private static final int Field_pathname = 5;
    private static final int Field_port = 6;
    private static final int Field_protocol = 7;
    private static final int Field_search = 8;

    protected DHrefElement(DDocument doc, int id) {
        super(doc, id);
    }

    private String getUrl() {
        String href = this.getAttribute(46);
        if (href != null) {
            href = this.doc.resolveUrl(href);
        }
        return href;
    }

    public String getHref() {
        return this.getUrl();
    }

    public void setHref(String href) {
        this.setAttribute(46, href);
    }

    public String script_toString(DynEnv env) {
        String url = this.getUrl();
        if (url != null) {
            return url;
        }
        return "";
    }

    private String script_getHash() {
        int hashPos;
        String url = this.getUrl();
        if (url != null && (hashPos = url.indexOf(35)) >= 0) {
            return url.substring(0, hashPos);
        }
        return "";
    }

    private String script_getHost() {
        String host;
        String url = this.getUrl();
        if (url != null && (host = URLResolver.getHost((String)url)) != null) {
            return host;
        }
        return "";
    }

    private String script_getHostname() {
        String host;
        String url = this.getUrl();
        if (url != null && (host = URLResolver.getHost((String)url)) != null) {
            int port = URLResolver.getPort((String)url);
            if (port != -1) {
                host = host + ':' + port;
            }
            return host;
        }
        return "";
    }

    private String script_getHref() {
        String url = this.getUrl();
        if (url != null) {
            return url;
        }
        return "";
    }

    private String script_getPathname() {
        String path;
        String url = this.getUrl();
        if (url != null && (path = URLResolver.getPath((String)url)) != null) {
            int i = path.indexOf(63);
            if (i >= 0) {
                path = path.substring(0, i);
            }
            return path;
        }
        return "";
    }

    private String script_getPort() {
        int port;
        String url = this.getUrl();
        if (url != null && (port = URLResolver.getPort((String)url)) != -1) {
            return Integer.toString(port);
        }
        return "";
    }

    private String script_getProtocol() {
        String protocol;
        String url = this.getUrl();
        if (url != null && (protocol = URLResolver.getProtocol((String)url)) != null) {
            return protocol;
        }
        return "";
    }

    private String script_getSearch() {
        int i;
        String path;
        String url = this.getUrl();
        if (url != null && (path = URLResolver.getPath((String)url)) != null && (i = path.indexOf(63)) >= 0) {
            return path.substring(i);
        }
        return "";
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DHrefElement.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DHrefElement.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return this.script_getHash();
            }
            case 2: {
                return this.script_getHost();
            }
            case 3: {
                return this.script_getHostname();
            }
            case 4: {
                return this.script_getHref();
            }
            case 5: {
                return this.script_getPathname();
            }
            case 6: {
                return this.script_getPort();
            }
            case 7: {
                return this.script_getProtocol();
            }
            case 8: {
                return this.script_getSearch();
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        if (key_id == 4) {
            this.setHref(env.toStr(value));
            return 1;
        }
        return 2;
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        int s_length = s.length();
        if (s_length == 4) {
            char c = s.charAt(1);
            if (c == 'a') {
                guess = "hash";
                id = 1;
            } else if (c == 'o') {
                c = s.charAt(0);
                if (c == 'h') {
                    guess = "host";
                    id = 2;
                } else if (c == 'p') {
                    guess = "port";
                    id = 6;
                }
            } else if (c == 'r') {
                guess = "href";
                id = 4;
            }
        } else if (s_length == 6) {
            guess = "search";
            id = 8;
        } else if (s_length == 8) {
            char c = s.charAt(1);
            if (c == 'a') {
                guess = "pathname";
                id = 5;
            } else if (c == 'o') {
                guess = "hostname";
                id = 3;
            } else if (c == 'r') {
                guess = "protocol";
                id = 7;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

