/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSUtil;
import java.util.StringTokenizer;

final class CoordsList {
    private int coord_value;
    private int coord_type;
    private int[] values;
    private int[] types;

    CoordsList(String str) {
        StringTokenizer subParser = new StringTokenizer(str, " \t\n\r,");
        int count = subParser.countTokens();
        this.values = new int[count];
        this.types = new int[count];
        try {
            int i = 0;
            while (subParser.hasMoreElements()) {
                this.makeCoord(subParser.nextToken());
                this.values[i] = this.coord_value;
                this.types[i] = this.coord_type;
                ++i;
            }
        }
        catch (Exception ex) {
            Debug.ex((Throwable)ex);
        }
        if (count == 1 && this.types[0] == 0 && this.values[0] == 0) {
            this.types[0] = 1;
            this.values[0] = 100;
        }
    }

    private void makeCoord(String str) {
        this.coord_value = 0;
        if (str.indexOf("%") != -1) {
            this.coord_type = 1;
        } else if (str.indexOf("*") != -1) {
            this.coord_type = 2;
            this.coord_value = 1;
        } else {
            this.coord_type = 0;
            if (str.endsWith("px")) {
                str = str.substring(0, str.length() - 2);
            }
        }
        if (this.coord_type > 0) {
            str = str.substring(0, str.length() - 1);
        }
        try {
            this.coord_value += CSSUtil.parseIntAsFloat(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int[] getListOfValues() {
        return this.values;
    }

    int[] getListOfTypes() {
        return this.types;
    }
}

