/**
 * MailRWLock
 *
 * Copyright (c) 1995 - 2003 Macromedia, Inc. All rights reserved.
 * DO NOT REDISTRIBUTE THIS SOFTWARE IN ANY WAY WITHOUT THE EXPRESSED
 * WRITTEN PERMISSION OF MACROMEDIA.
 *
 * Created on May 6, 2003
 * Author: tomj
 */
package coldfusion.mail;

import coldfusion.runtime.RWLock;

/**
 * Implementation of RWLock which gives preference to waiting writers.
 *
 * @author Tom Jordahl
 */
public class MailRWLock extends RWLock
{
    protected long waitingWriters = 0;

    /**
     * Allow read if no writers waiting
     */
    protected boolean allowReadAccess()
    {
        return (waitingWriters == 0 && writerThread == null) || Thread.currentThread() == writerThread;
    }

    /**
     *  Allow write if no readers
     */
    protected boolean allowWrite()
    {
        return (writerThread == null || Thread.currentThread() == writerThread) && n_readers == 0;
    }

    /**
     * Return a Write lock, keeps track of waiting writers.
     */ 
    public synchronized void requestWriteLock(long timeout) throws InterruptedException
    {
        long  deadline = System.currentTimeMillis() + timeout;

        ++waitingWriters;
        while ( ! allowWrite() )
        {
            try
            {
                waitForLock ( timeout, deadline );
            }
            catch (InterruptedException ie)
            {
                --waitingWriters;
                throw ie;
            }
        }
        --waitingWriters;
        registerWrite();
    }
}

