/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;

public class RtfParagraphStyle
extends RtfFont {
    public static final byte[] ALIGN_LEFT = "\\ql".getBytes();
    public static final byte[] ALIGN_RIGHT = "\\qr".getBytes();
    public static final byte[] ALIGN_CENTER = "\\qc".getBytes();
    public static final byte[] ALIGN_JUSTIFY = "\\qj".getBytes();
    public static final byte[] FIRST_LINE_INDENT = "\\fi".getBytes();
    public static final byte[] INDENT_LEFT = "\\li".getBytes();
    public static final byte[] INDENT_RIGHT = "\\ri".getBytes();
    public static final byte[] KEEP_TOGETHER = "\\keep".getBytes();
    public static final byte[] KEEP_TOGETHER_WITH_NEXT = "\\keepn".getBytes();
    public static final byte[] SPACING_AFTER = "\\sa".getBytes();
    public static final byte[] SPACING_BEFORE = "\\sb".getBytes();
    public static final RtfParagraphStyle STYLE_NORMAL = new RtfParagraphStyle("Normal", "Arial", 12, 0, Color.black);
    public static final RtfParagraphStyle STYLE_HEADING_1 = new RtfParagraphStyle("heading 1", "Normal");
    public static final RtfParagraphStyle STYLE_HEADING_2 = new RtfParagraphStyle("heading 2", "Normal");
    public static final RtfParagraphStyle STYLE_HEADING_3 = new RtfParagraphStyle("heading 3", "Normal");
    private static final int MODIFIED_NONE = 0;
    private static final int MODIFIED_ALIGNMENT = 1;
    private static final int MODIFIED_INDENT_LEFT = 2;
    private static final int MODIFIED_INDENT_RIGHT = 4;
    private static final int MODIFIED_SPACING_BEFORE = 8;
    private static final int MODIFIED_SPACING_AFTER = 16;
    private static final int MODIFIED_FONT_NAME = 32;
    private static final int MODIFIED_FONT_SIZE = 64;
    private static final int MODIFIED_FONT_STYLE = 128;
    private static final int MODIFIED_FONT_COLOR = 256;
    private static final int MODIFIED_LINE_LEADING = 512;
    private static final int MODIFIED_KEEP_TOGETHER = 1024;
    private static final int MODIFIED_KEEP_TOGETHER_WITH_NEXT = 2048;
    private int alignment = 0;
    private int firstLineIndent = 0;
    private int indentLeft = 0;
    private int indentRight = 0;
    private int spacingBefore = 0;
    private int spacingAfter = 0;
    private int lineLeading = 0;
    private boolean keepTogether = false;
    private boolean keepTogetherWithNext = false;
    private String styleName = "";
    private String basedOnName = null;
    private RtfParagraphStyle baseStyle = null;
    private int modified = 0;
    private int styleNumber = -1;

    public RtfParagraphStyle(String string, String string2, int n, int n2, Color color) {
        super(null, new RtfFont(string2, (float)n, n2, color));
        this.styleName = string;
    }

    public RtfParagraphStyle(String string, String string2) {
        super(null, new Font());
        this.styleName = string;
        this.basedOnName = string2;
    }

    public RtfParagraphStyle(RtfDocument rtfDocument, RtfParagraphStyle rtfParagraphStyle) {
        super(rtfDocument, rtfParagraphStyle);
        this.document = rtfDocument;
        this.styleName = rtfParagraphStyle.getStyleName();
        this.alignment = rtfParagraphStyle.getAlignment();
        this.firstLineIndent = (int)((double)rtfParagraphStyle.getFirstLineIndent() * 20.0);
        this.indentLeft = (int)((double)rtfParagraphStyle.getIndentLeft() * 20.0);
        this.indentRight = (int)((double)rtfParagraphStyle.getIndentRight() * 20.0);
        this.spacingBefore = (int)((double)rtfParagraphStyle.getSpacingBefore() * 20.0);
        this.spacingAfter = (int)((double)rtfParagraphStyle.getSpacingAfter() * 20.0);
        this.lineLeading = (int)((double)rtfParagraphStyle.getLineLeading() * 20.0);
        this.keepTogether = rtfParagraphStyle.getKeepTogether();
        this.keepTogetherWithNext = rtfParagraphStyle.getKeepTogetherWithNext();
        this.basedOnName = rtfParagraphStyle.basedOnName;
        this.modified = rtfParagraphStyle.modified;
        this.styleNumber = rtfParagraphStyle.getStyleNumber();
        if (this.document != null) {
            this.setRtfDocument(this.document);
        }
    }

    public String getStyleName() {
        return this.styleName;
    }

    public String getBasedOnName() {
        return this.basedOnName;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.modified |= 1;
        this.alignment = n;
    }

    public int getFirstLineIndent() {
        return this.firstLineIndent;
    }

    public void setFirstLineIndent(int n) {
        this.firstLineIndent = n;
    }

    public int getIndentLeft() {
        return this.indentLeft;
    }

    public void setIndentLeft(int n) {
        this.modified |= 2;
        this.indentLeft = n;
    }

    public int getIndentRight() {
        return this.indentRight;
    }

    public void setIndentRight(int n) {
        this.modified |= 4;
        this.indentRight = n;
    }

    public int getSpacingBefore() {
        return this.spacingBefore;
    }

    public void setSpacingBefore(int n) {
        this.modified |= 8;
        this.spacingBefore = n;
    }

    public int getSpacingAfter() {
        return this.spacingAfter;
    }

    public void setSpacingAfter(int n) {
        this.modified |= 0x10;
        this.spacingAfter = n;
    }

    public void setFontName(String string) {
        this.modified |= 0x20;
        super.setFontName(string);
    }

    public void setSize(float f) {
        this.modified |= 0x40;
        super.setSize(f);
    }

    public void setStyle(int n) {
        this.modified |= 0x80;
        super.setStyle(n);
    }

    public void setColor(Color color) {
        this.modified |= 0x100;
        super.setColor(color);
    }

    public int getLineLeading() {
        return this.lineLeading;
    }

    public void setLineLeading(int n) {
        this.lineLeading = n;
        this.modified |= 0x200;
    }

    public boolean getKeepTogether() {
        return this.keepTogether;
    }

    public void setKeepTogether(boolean bl) {
        this.keepTogether = bl;
        this.modified |= 0x400;
    }

    public boolean getKeepTogetherWithNext() {
        return this.keepTogetherWithNext;
    }

    public void setKeepTogetherWithNext(boolean bl) {
        this.keepTogetherWithNext = bl;
        this.modified |= 0x800;
    }

    public void handleInheritance() {
        if (this.basedOnName != null && this.document.getDocumentHeader().getRtfParagraphStyle(this.basedOnName) != null) {
            this.baseStyle = this.document.getDocumentHeader().getRtfParagraphStyle(this.basedOnName);
            this.baseStyle.handleInheritance();
            if ((this.modified & 1) != 1) {
                this.alignment = this.baseStyle.getAlignment();
            }
            if ((this.modified & 2) != 2) {
                this.indentLeft = this.baseStyle.getIndentLeft();
            }
            if ((this.modified & 4) != 4) {
                this.indentRight = this.baseStyle.getIndentRight();
            }
            if ((this.modified & 8) != 8) {
                this.spacingBefore = this.baseStyle.getSpacingBefore();
            }
            if ((this.modified & 0x10) != 16) {
                this.spacingAfter = this.baseStyle.getSpacingAfter();
            }
            if ((this.modified & 0x20) != 32) {
                this.setFontName(this.baseStyle.getFontName());
            }
            if ((this.modified & 0x40) != 64) {
                this.setSize(this.baseStyle.getFontSize());
            }
            if ((this.modified & 0x80) != 128) {
                this.setStyle(this.baseStyle.getFontStyle());
            }
            if ((this.modified & 0x100) != 256) {
                this.setColor(this.baseStyle.getColor());
            }
            if ((this.modified & 0x200) != 512) {
                this.setLineLeading(this.baseStyle.getLineLeading());
            }
            if ((this.modified & 0x400) != 1024) {
                this.setKeepTogether(this.baseStyle.getKeepTogether());
            }
            if ((this.modified & 0x800) != 2048) {
                this.setKeepTogetherWithNext(this.baseStyle.getKeepTogetherWithNext());
            }
        }
    }

    private void writeParagraphSettings(OutputStream outputStream) throws IOException {
        if (this.keepTogether) {
            outputStream.write(KEEP_TOGETHER);
        }
        if (this.keepTogetherWithNext) {
            outputStream.write(KEEP_TOGETHER_WITH_NEXT);
        }
        switch (this.alignment) {
            case 0: {
                outputStream.write(ALIGN_LEFT);
                break;
            }
            case 2: {
                outputStream.write(ALIGN_RIGHT);
                break;
            }
            case 1: {
                outputStream.write(ALIGN_CENTER);
                break;
            }
            case 3: 
            case 8: {
                outputStream.write(ALIGN_JUSTIFY);
            }
        }
        outputStream.write(FIRST_LINE_INDENT);
        outputStream.write(this.intToByteArray(this.firstLineIndent));
        outputStream.write(INDENT_LEFT);
        outputStream.write(this.intToByteArray(this.indentLeft));
        outputStream.write(INDENT_RIGHT);
        outputStream.write(this.intToByteArray(this.indentRight));
        if (this.spacingBefore > 0) {
            outputStream.write(SPACING_BEFORE);
            outputStream.write(this.intToByteArray(this.spacingBefore));
        }
        if (this.spacingAfter > 0) {
            outputStream.write(SPACING_AFTER);
            outputStream.write(this.intToByteArray(this.spacingAfter));
        }
        if (this.lineLeading > 0) {
            outputStream.write(RtfParagraph.LINE_SPACING);
            outputStream.write(this.intToByteArray(this.lineLeading));
        }
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        outputStream.write("{".getBytes());
        outputStream.write("\\style".getBytes());
        outputStream.write("\\s".getBytes());
        outputStream.write(this.intToByteArray(this.styleNumber));
        outputStream.write(RtfBasicElement.DELIMITER);
        this.writeParagraphSettings(outputStream);
        super.writeBegin(outputStream);
        outputStream.write(RtfBasicElement.DELIMITER);
        outputStream.write(this.styleName.getBytes());
        outputStream.write(";".getBytes());
        outputStream.write("}".getBytes());
        if (this.document.getDocumentSettings().isOutputDebugLineBreaks()) {
            outputStream.write(10);
        }
    }

    public void writeBegin(OutputStream outputStream) throws IOException {
        outputStream.write("\\s".getBytes());
        outputStream.write(this.intToByteArray(this.styleNumber));
        this.writeParagraphSettings(outputStream);
    }

    public void writeEnd(OutputStream outputStream) throws IOException {
    }

    public void writeContent(OutputStream outputStream) throws IOException {
    }

    public boolean equals(Object object) {
        if (!(object instanceof RtfParagraphStyle)) {
            return false;
        }
        RtfParagraphStyle rtfParagraphStyle = (RtfParagraphStyle)object;
        boolean bl = this.getStyleName().equals(rtfParagraphStyle.getStyleName());
        return bl;
    }

    public int hashCode() {
        return this.styleName.hashCode();
    }

    private int getStyleNumber() {
        return this.styleNumber;
    }

    protected void setStyleNumber(int n) {
        this.styleNumber = n;
    }

    static {
        STYLE_HEADING_1.setSize(16.0f);
        STYLE_HEADING_1.setStyle(1);
        STYLE_HEADING_2.setSize(14.0f);
        STYLE_HEADING_2.setStyle(3);
        STYLE_HEADING_3.setSize(13.0f);
        STYLE_HEADING_3.setStyle(1);
    }
}

