/*
 * Decompiled with CFR 0.152.
 */
package macromedia.resource.jdbcsybase.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.PooledConnection;
import macromedia.jdbcx.sybasebase.BaseDataSource;
import macromedia.jdbcx.sybasebase.ddx;
import macromedia.resource.jdbc.spi.JCAManagedConnectionFactory;
import macromedia.resource.jdbcsybase.JCAClassUtility;
import macromedia.resource.jdbcsybase.JCAConnectionFactoryCommon;
import macromedia.resource.jdbcsybase.spi.JCAConnectionRequestInfo;
import macromedia.resource.jdbcsybase.spi.JCADefaultConnectionManager;
import macromedia.resource.jdbcsybase.spi.JCAExceptions;
import macromedia.resource.jdbcsybase.spi.JCALogger;
import macromedia.resource.jdbcsybase.spi.JCAManagedConnection;
import macromedia.resource.jdbcsybase.spi.JCAUtil;
import macromedia.sybaseutil.ddr;

public abstract class JCAManagedConnectionFactoryCommon
extends JCAManagedConnectionFactory {
    private static String footprint = "$Revision: #1 $";
    protected BaseDataSource nativeDataSource;
    protected transient JCAExceptions exceptions;
    protected transient JCALogger logger;
    protected String connectorName;
    protected String spyAttributes;

    public JCAManagedConnectionFactoryCommon(String string, BaseDataSource baseDataSource) {
        ddr.a("dataSource argument can not be null", baseDataSource != null);
        this.exceptions = new JCAExceptions(string);
        this.nativeDataSource = baseDataSource;
        this.connectorName = string;
        this.logger = new JCALogger();
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.println("ManagedConnectionFactory.createConnectionFactroy(ConnectionManager connectionMgr)");
            this.logger.println("connectionMgr = " + connectionManager);
        }
        return this.commonCreateConnectionFactory(connectionManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.createConnectionFactory()");
        }
        Object object = this.commonCreateConnectionFactory(null);
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.createConnectionFactory", object);
        }
        return object;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object object;
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.createManagedConnection(Subject subject, ConnectionRequestInfo connectionInfo)");
            this.logger.println("subject = " + subject);
            this.logger.println("connectionInfo = " + connectionRequestInfo);
        }
        this.validateNativeDataSource();
        String string = null;
        String string2 = null;
        if (subject == null) {
            if (connectionRequestInfo != null && connectionRequestInfo instanceof JCAConnectionRequestInfo) {
                string = ((JCAConnectionRequestInfo)connectionRequestInfo).getUsername();
                string2 = ((JCAConnectionRequestInfo)connectionRequestInfo).getPassword();
            }
        } else {
            object = JCAUtil.getPasswordCredential(subject, this);
            string = object.getUserName();
            string2 = new String(object.getPassword());
            if (string.length() == 0) {
                string = null;
                string2 = null;
            }
        }
        object = null;
        JCAManagedConnection jCAManagedConnection = null;
        try {
            block17: {
                if (this.nativeDataSource instanceof ddx) {
                    try {
                        if (string == null) {
                            object = ((ddx)this.nativeDataSource).getXAConnection();
                            break block17;
                        }
                        object = ((ddx)this.nativeDataSource).getXAConnection(string, string2);
                    }
                    catch (SQLException sQLException) {
                        if (string == null) {
                            object = this.nativeDataSource.getPooledConnection();
                            break block17;
                        }
                        object = this.nativeDataSource.getPooledConnection(string, string2);
                    }
                } else {
                    object = string == null ? this.nativeDataSource.getPooledConnection() : this.nativeDataSource.getPooledConnection(string, string2);
                }
            }
            JCAManagedConnectionFactoryCommon jCAManagedConnectionFactoryCommon = this;
            jCAManagedConnection = new JCAManagedConnection((PooledConnection)object, string, string2, jCAManagedConnectionFactoryCommon, jCAManagedConnectionFactoryCommon.logger, this.exceptions);
            if (this.logger.getLogWriter() != null) {
                this.logger.printExit("ManagedConnectionFactory.createManagedConnection", jCAManagedConnection);
            }
            return jCAManagedConnection;
        }
        catch (SQLException sQLException) {
            if (object != null) {
                try {
                    object.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
            throw this.exceptions.getException(sQLException, 1);
        }
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.matchManagedConnections(Set managedConnections, Subject subject, ConnectionRequestInfo connectionInfo)");
            this.logger.println("managedConnections = " + set);
            this.logger.println("   Number of managedConnections in set = " + set.size());
            this.logger.println("subject = " + subject);
            this.logger.println("connectionInfo = " + connectionRequestInfo);
        }
        this.validateNativeDataSource();
        ManagedConnection managedConnection2 = null;
        JCAManagedConnection jCAManagedConnection = null;
        for (ManagedConnection managedConnection2 : set) {
            if (!(managedConnection2 instanceof JCAManagedConnection) || !(jCAManagedConnection = (JCAManagedConnection)managedConnection2).getOwnerFactory().equals((Object)this) || !this.matchAuthenticationInfo(jCAManagedConnection, subject, connectionRequestInfo)) continue;
            if (this.logger.getLogWriter() != null) {
                this.logger.printExit("ManagedConnectionFactory.matchManagedConnections", jCAManagedConnection);
            }
            return jCAManagedConnection;
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.matchManagedConnections", null);
        }
        return null;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setLogWriter(PrintWriter logWriter)");
            this.logger.println("logWriter = " + printWriter);
            this.logger.cleanup();
        }
        this.logger = new JCALogger(printWriter);
        try {
            if (this.nativeDataSource != null) {
                this.nativeDataSource.setLogWriter(printWriter);
            }
        }
        catch (SQLException sQLException) {
            throw this.exceptions.getException(sQLException, 4302, 0);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setLogWriter");
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        PrintWriter printWriter = this.logger.getLogWriter();
        if (printWriter != null) {
            this.logger.printEnter("ManagedConnectionFactory.getLogWriter()");
            this.logger.println("Return Value = " + printWriter);
            this.logger.printExit("ManagedConnectionFactory.getLogWriter");
        }
        return printWriter;
    }

    final Reference getDataSourceReference() {
        Reference reference = null;
        try {
            reference = this.nativeDataSource.getReference();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return reference;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof JCAManagedConnectionFactory) {
            BaseDataSource baseDataSource = this.nativeDataSource;
            BaseDataSource baseDataSource2 = ((JCAManagedConnectionFactoryCommon)((Object)object)).nativeDataSource;
            if (baseDataSource == null || baseDataSource2 == null) {
                return false;
            }
            return this.implCompareProperties(baseDataSource, baseDataSource2) && this.compareProperties(baseDataSource, baseDataSource2);
        }
        return false;
    }

    public int hashCode() {
        if (this.nativeDataSource == null) {
            return super.hashCode();
        }
        String string = this.getHashString() + this.implGetHashString();
        return string.hashCode();
    }

    protected boolean compareProperties(BaseDataSource baseDataSource, BaseDataSource baseDataSource2) {
        if (!JCAUtil.isEqual(baseDataSource.getDatabaseName(), baseDataSource2.getDatabaseName())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getServerName(), baseDataSource2.getServerName())) {
            return false;
        }
        if (baseDataSource.getPortNumber() != baseDataSource2.getPortNumber()) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getUser(), baseDataSource2.getUser())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getPassword(), baseDataSource2.getPassword())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getDataSourceName(), baseDataSource2.getDataSourceName())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getDescription(), baseDataSource2.getDescription())) {
            return false;
        }
        if (baseDataSource.getLoginTimeout() != baseDataSource2.getLoginTimeout()) {
            return false;
        }
        if (baseDataSource.getBatchPerformanceWorkaround() != baseDataSource2.getBatchPerformanceWorkaround()) {
            return false;
        }
        if (baseDataSource.getInitialPoolSize() != baseDataSource2.getInitialPoolSize()) {
            return false;
        }
        if (baseDataSource.getMaxIdleTime() != baseDataSource2.getMaxIdleTime()) {
            return false;
        }
        if (baseDataSource.getMaxPoolSize() != baseDataSource2.getMaxPoolSize()) {
            return false;
        }
        if (baseDataSource.getMaxStatements() != baseDataSource2.getMaxStatements()) {
            return false;
        }
        if (baseDataSource.getMinPoolSize() != baseDataSource2.getMinPoolSize()) {
            return false;
        }
        if (baseDataSource.getPropertyCycle() != baseDataSource2.getPropertyCycle()) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getRoleName(), baseDataSource2.getRoleName())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getSpyAttributes(), baseDataSource2.getSpyAttributes())) {
            return false;
        }
        if (baseDataSource.getInsensitiveResultSetBufferSize() != baseDataSource2.getInsensitiveResultSetBufferSize()) {
            return false;
        }
        if (baseDataSource.getJavaDoubleToString() != baseDataSource2.getJavaDoubleToString()) {
            return false;
        }
        if (baseDataSource.getEnableBulkLoad() != baseDataSource2.getEnableBulkLoad()) {
            return false;
        }
        if (baseDataSource.getBulkLoadBatchSize() != baseDataSource2.getBulkLoadBatchSize()) {
            return false;
        }
        if (baseDataSource.getJDBCBehavior() != baseDataSource2.getJDBCBehavior()) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getInitializationString(), baseDataSource2.getInitializationString())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getLoadLibraryPath(), baseDataSource2.getLoadLibraryPath())) {
            return false;
        }
        if (baseDataSource.getWorkarounds() != baseDataSource2.getWorkarounds()) {
            return false;
        }
        if (baseDataSource.getConvertNull() != baseDataSource2.getConvertNull()) {
            return false;
        }
        if (baseDataSource.getQueryTimeout() != baseDataSource2.getQueryTimeout()) {
            return false;
        }
        if (baseDataSource.getCatalogOptions() != baseDataSource2.getCatalogOptions()) {
            return false;
        }
        if (baseDataSource.getCatalogIncludesSynonyms() != baseDataSource.getCatalogIncludesSynonyms()) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getFailoverMode(), baseDataSource2.getFailoverMode())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getFailoverGranularity(), baseDataSource2.getFailoverGranularity())) {
            return false;
        }
        if (baseDataSource.getFailoverPreconnect() != baseDataSource2.getFailoverPreconnect()) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getApplicationName(), baseDataSource2.getApplicationName())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getClientUser(), baseDataSource2.getClientUser())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getClientHostName(), baseDataSource2.getClientHostName())) {
            return false;
        }
        if (!JCAUtil.isEqual(baseDataSource.getAccountingInfo(), baseDataSource2.getAccountingInfo())) {
            return false;
        }
        return JCAUtil.isEqual(baseDataSource.getProgramID(), baseDataSource2.getProgramID());
    }

    protected String getHashString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.nativeDataSource.getDatabaseName());
        stringBuilder.append(this.nativeDataSource.getServerName());
        stringBuilder.append(this.nativeDataSource.getPortNumber());
        stringBuilder.append(this.nativeDataSource.getUser());
        stringBuilder.append(this.nativeDataSource.getPassword());
        stringBuilder.append(this.nativeDataSource.getDataSourceName());
        stringBuilder.append(this.nativeDataSource.getDescription());
        stringBuilder.append(this.nativeDataSource.getLoginTimeout());
        stringBuilder.append(this.nativeDataSource.getBatchPerformanceWorkaround());
        stringBuilder.append(this.nativeDataSource.getInitialPoolSize());
        stringBuilder.append(this.nativeDataSource.getMaxIdleTime());
        stringBuilder.append(this.nativeDataSource.getMaxPoolSize());
        stringBuilder.append(this.nativeDataSource.getMaxStatements());
        stringBuilder.append(this.nativeDataSource.getMinPoolSize());
        stringBuilder.append(this.nativeDataSource.getPropertyCycle());
        stringBuilder.append(this.nativeDataSource.getRoleName());
        stringBuilder.append(this.nativeDataSource.getSpyAttributes());
        stringBuilder.append(this.nativeDataSource.getInsensitiveResultSetBufferSize());
        stringBuilder.append(this.nativeDataSource.getJavaDoubleToString());
        stringBuilder.append(this.nativeDataSource.getEnableBulkLoad());
        stringBuilder.append(this.nativeDataSource.getBulkLoadBatchSize());
        stringBuilder.append(this.nativeDataSource.getJDBCBehavior());
        stringBuilder.append(this.nativeDataSource.getInitializationString());
        stringBuilder.append(this.nativeDataSource.getLoadLibraryPath());
        stringBuilder.append(this.nativeDataSource.getConvertNull());
        stringBuilder.append(this.nativeDataSource.getQueryTimeout());
        stringBuilder.append(this.nativeDataSource.getCatalogOptions());
        stringBuilder.append(this.nativeDataSource.getCatalogIncludesSynonyms());
        stringBuilder.append(this.nativeDataSource.getFailoverMode());
        stringBuilder.append(this.nativeDataSource.getFailoverGranularity());
        stringBuilder.append(this.nativeDataSource.getFailoverPreconnect());
        stringBuilder.append(this.nativeDataSource.getApplicationName());
        stringBuilder.append(this.nativeDataSource.getClientUser());
        stringBuilder.append(this.nativeDataSource.getClientHostName());
        stringBuilder.append(this.nativeDataSource.getAccountingInfo());
        stringBuilder.append(this.nativeDataSource.getProgramID());
        return stringBuilder.toString();
    }

    protected abstract boolean implCompareProperties(BaseDataSource var1, BaseDataSource var2);

    protected abstract String implGetHashString();

    public final String getDatabaseName() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getDatabaseName();
    }

    public final void setDatabaseName(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setDatabaseName(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setDatabaseName(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setDatabaseName");
        }
    }

    public final String getDataSourceName() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getDataSourceName();
    }

    public final void setDataSourceName(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setDataSourceName(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setDataSourceName(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setDataSourceName");
        }
    }

    public final String getDescription() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getDescription();
    }

    public final void setDescription(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setDescription(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setDescription(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setDescription");
        }
    }

    public final String getExtendedOptions() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getExtendedOptions();
    }

    public final void setExtendedOptions(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setExtendedOptions(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setExtendedOptions(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setExtendedOptions");
        }
    }

    public final String getPassword() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getPassword();
    }

    public final void setPassword(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setPassword(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setPassword(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setPassword");
        }
    }

    public final String getPortNumber() {
        if (this.nativeDataSource == null) {
            return "-1";
        }
        return String.valueOf(this.nativeDataSource.getPortNumber());
    }

    public final void setPortNumber(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.println("ManagedConnectionFactory.setPortNumber(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setPortNumber(Integer.parseInt(string));
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setPortNumber");
        }
    }

    public final String getRoleName() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getRoleName();
    }

    public final void setRoleName(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setRoleName(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setRoleName(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setRoleName");
        }
    }

    public final String getServerName() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getServerName();
    }

    public final void setServerName(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setServerName(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setServerName(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setServerName");
        }
    }

    public final String getUser() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getUser();
    }

    public final String getUserName() {
        return this.getUser();
    }

    public final void setUser(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setUser(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setUser(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setUser");
        }
    }

    public final void setUserName(String string) {
        this.setUser(string);
    }

    public String getAlternateServers() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getAlternateServers();
    }

    public void setAlternateServers(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setAlternateServers(String alternateServers)");
            this.logger.println("alternateServers = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setAlternateServers(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setAlternateServers");
        }
    }

    public final Boolean getBatchPerformanceWorkaround() {
        if (this.nativeDataSource == null) {
            return new Boolean(false);
        }
        return new Boolean(this.nativeDataSource.getBatchPerformanceWorkaround());
    }

    public final void setBatchPerformanceWorkaround(Boolean bl) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setBatchPerformanceWorkaround(boolean b)");
            this.logger.println("b = " + bl);
        }
        if (this.isValidNativeDataSource() && bl != null) {
            this.nativeDataSource.setBatchPerformanceWorkaround(bl);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setBatchPerformanceWorkaround");
        }
    }

    public final Boolean getLoadBalancing() {
        if (this.nativeDataSource == null) {
            return new Boolean(false);
        }
        return new Boolean(this.nativeDataSource.getLoadBalancing());
    }

    public final void setLoadBalancing(Boolean bl) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setLoadBalancing(boolean b)");
            this.logger.println("b = " + bl);
        }
        if (this.isValidNativeDataSource() && bl != null) {
            this.nativeDataSource.setLoadBalancing(bl);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setLoadBalancing");
        }
    }

    public final Boolean getJavaDoubleToString() {
        if (this.nativeDataSource == null) {
            return new Boolean(false);
        }
        return new Boolean(this.nativeDataSource.getJavaDoubleToString());
    }

    public final void setJavaDoubleToString(Boolean bl) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setJavaDoubleToString(boolean b)");
            this.logger.println("b = " + bl);
        }
        if (this.isValidNativeDataSource() && bl != null) {
            this.nativeDataSource.setJavaDoubleToString(bl);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setJavaDoubleToString");
        }
    }

    public final Boolean getEnableBulkLoad() {
        if (this.nativeDataSource == null) {
            return new Boolean(false);
        }
        return new Boolean(this.nativeDataSource.getEnableBulkLoad());
    }

    public final void setEnableBulkLoad(Boolean bl) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setEnableBulkLoad(boolean b)");
            this.logger.println("b = " + bl);
        }
        if (this.isValidNativeDataSource() && bl != null) {
            this.nativeDataSource.setEnableBulkLoad(bl);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setEnableBulkLoad");
        }
    }

    public final Integer getBulkLoadBatchSize() {
        if (this.nativeDataSource == null) {
            return new Integer(1);
        }
        return new Integer(this.nativeDataSource.getBulkLoadBatchSize());
    }

    public final void setBulkLoadBatchSize(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setBulkLoadBatchSize(int i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setBulkLoadBatchSize(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setBulkLoadBatchSize");
        }
    }

    public final Integer getJDBCBehavior() {
        if (this.nativeDataSource == null) {
            return new Integer(1);
        }
        return new Integer(this.nativeDataSource.getJDBCBehavior());
    }

    public final void setJDBCBehavior(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setJDBCBehavior(int i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setJDBCBehavior(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setJDBCBehavior");
        }
    }

    public final Integer getLoginTimeout() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getLoginTimeout());
    }

    public final void setLoginTimeout(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setLoginTimeout(int i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setLoginTimeout(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setLoginTimeout");
        }
    }

    public final String getSpyAttributes() {
        return this.spyAttributes;
    }

    public final void setSpyAttributes(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setSpyAttributes(String s)");
            this.logger.println("s = " + string);
            this.logger.cleanup();
        }
        this.spyAttributes = string;
        this.createLogger();
    }

    public void setMaxStatements(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setMaxStatements(int i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setMaxStatements(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setMaxStatements");
        }
    }

    public Integer getMaxStatements() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getMaxStatements());
    }

    public void setInitialPoolSize(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setInitialPoolSize(int i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setInitialPoolSize(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setInitialPoolSize");
        }
    }

    public Integer getInitialPoolSize() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getInitialPoolSize());
    }

    public void setMinPoolSize(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setMinPoolSize(int i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setMinPoolSize(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setMinPoolSize");
        }
    }

    public Integer getMinPoolSize() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getMinPoolSize());
    }

    public void setMaxPoolSize(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setMaxPoolSize(Integer i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setMaxPoolSize(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setMaxPoolSize");
        }
    }

    public Integer getMaxPoolSize() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getMaxPoolSize());
    }

    public void setMaxPooledStatements(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setMaxPooledStatements(Integer i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setMaxPooledStatements(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setMaxPooledStatements");
        }
    }

    public Integer getMaxPooledStatements() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getMaxPooledStatements());
    }

    public void setMaxIdleTime(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setMaxIdleTime(int i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setMaxIdleTime(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setMaxIdleTime");
        }
    }

    public Integer getMaxIdleTime() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getMaxIdleTime());
    }

    public void setPropertyCycle(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setPropertyCycle(int i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setPropertyCycle(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setPropertyCycle");
        }
    }

    public Integer getPropertyCycle() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getPropertyCycle());
    }

    public String getResourceAdaptorName() {
        return this.connectorName;
    }

    public Integer getCatalogOptions() {
        return new Integer(this.nativeDataSource.getCatalogOptions());
    }

    public void setCatalogOptions(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setCatalogOptions(Integer catalogOptions)");
            this.logger.println("catalogOptions = " + n2);
        }
        this.nativeDataSource.setCatalogOptions(n2);
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setCatalogOptions");
        }
    }

    public Boolean getCatalogIncludesSynonyms() {
        return new Boolean(this.nativeDataSource.getCatalogIncludesSynonyms());
    }

    public void setCatalogIncludesSynonyms(Boolean bl) {
        if (bl == null) {
            return;
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setCatalogIncludesSynonyms(Boolean b)");
            this.logger.println("b = " + bl);
        }
        this.nativeDataSource.setCatalogIncludesSynonyms(bl);
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setCatalogIncludesSynonyms");
        }
    }

    public void setConnectionRetryCount(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setConnectionRetryCount(int i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setConnectionRetryCount(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setConnectionRetryCount");
        }
    }

    public Integer getConnectionRetryCount() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getConnectionRetryCount());
    }

    public void setConnectionRetryDelay(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setConnectionRetryDelay(int i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setConnectionRetryDelay(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setConnectionRetryDelay");
        }
    }

    public Integer getConnectionRetryDelay() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getConnectionRetryDelay());
    }

    public final Integer getResultsetMetaDataOptions() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getResultsetMetaDataOptions());
    }

    public final void setResultsetMetaDataOptions(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setResultsetMetaDataOptions(int i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setResultsetMetaDataOptions(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setResultsetMetaDataOptions");
        }
    }

    public void setInsensitiveResultSetBufferSize(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setInsensitiveResultSetBufferSize(int i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setInsensitiveResultSetBufferSize(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setInsensitiveResultSetBufferSize");
        }
    }

    public Integer getInsensitiveResultSetBufferSize() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getInsensitiveResultSetBufferSize());
    }

    public final String getInitializationString() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getInitializationString();
    }

    public final void setInitializationString(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setInitializationString(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setInitializationString(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setInitializationString");
        }
    }

    public final String getLoadLibraryPath() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getLoadLibraryPath();
    }

    public final void setLoadLibraryPath(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setLoadLibraryPath(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setLoadLibraryPath(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setLoadLibraryPath");
        }
    }

    public final String getImportStatementPool() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getImportStatementPool();
    }

    public final void setImportStatementPool(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setImportStatementPool(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setImportStatementPool(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setImportStatementPool");
        }
    }

    public final Integer getWorkarounds() {
        if (this.nativeDataSource == null) {
            return new Integer(0);
        }
        return new Integer(this.nativeDataSource.getWorkarounds());
    }

    public final void setWorkarounds(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setWorkarounds(Integer i)");
            this.logger.println("workaroundsArg = " + n2);
        }
        if (this.isValidNativeDataSource()) {
            this.nativeDataSource.setWorkarounds(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setWorkarounds");
        }
    }

    public void setQueryTimeout(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setQueryTimeout(int i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setQueryTimeout(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setQueryTimeout");
        }
    }

    public Integer getQueryTimeout() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getQueryTimeout());
    }

    public Integer getConvertNull() {
        if (this.nativeDataSource == null) {
            return new Integer(-1);
        }
        return new Integer(this.nativeDataSource.getConvertNull());
    }

    public void setConvertNull(Integer n2) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setConvertNull(int i)");
            this.logger.println("i = " + n2);
        }
        if (this.isValidNativeDataSource() && n2 != null) {
            this.nativeDataSource.setConvertNull(n2);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setConvertNull");
        }
    }

    public final String getFailoverMode() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getFailoverMode();
    }

    public final void setFailoverMode(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setFailoverMode(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setFailoverMode(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setFailoverMode");
        }
    }

    public final String getFailoverGranularity() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getFailoverGranularity();
    }

    public final void setFailoverGranularity(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setFailoverGranularity(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setFailoverGranularity(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setFailoverGranularity");
        }
    }

    public final Boolean getFailoverPreconnect() {
        if (this.nativeDataSource == null) {
            return new Boolean(false);
        }
        return new Boolean(this.nativeDataSource.getFailoverPreconnect());
    }

    public final void setFailoverPreconnect(Boolean bl) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setFailoverPreconnect(boolean b)");
            this.logger.println("b = " + bl);
        }
        if (this.isValidNativeDataSource() && bl != null) {
            this.nativeDataSource.setFailoverPreconnect(bl);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setFailoverPreconnect");
        }
    }

    public final String getClientAppName() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getClientAppName();
    }

    public final void setClientAppName(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setClientAppName(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setClientAppName(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setClientAppName");
        }
    }

    public final String getClientUser() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getClientUser();
    }

    public final void setClientUser(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setClientUser(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setClientUser(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setClientUser");
        }
    }

    public final String getClientHostName() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getClientHostName();
    }

    public final void setClientHostName(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setClientHostName(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setClientHostName(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setClientHostName");
        }
    }

    public final String getClientAcctInfo() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getClientAcctInfo();
    }

    public final void setClientAcctInfo(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setClientAcctInfo(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setClientAcctInfo(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setClientAcctInfo");
        }
    }

    public final String getAccountingInfo() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getAccountingInfo();
    }

    public final void setAccountingInfo(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setAccountingInfo(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setAccountingInfo(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setAccountingInfo");
        }
    }

    public final String getApplicationName() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getApplicationName();
    }

    public final void setApplicationName(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setApplicationName(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setApplicationName(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setApplicationName");
        }
    }

    public final String getProgramID() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getProgramID();
    }

    public final void setProgramID(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setProgramID(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setProgramID(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setProgramID");
        }
    }

    public final String getClientProgramID() {
        if (this.nativeDataSource == null) {
            return null;
        }
        return this.nativeDataSource.getClientProgramID();
    }

    public final void setClientProgramID(String string) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnectionFactory.setClientProgramID(String str)");
            this.logger.println("str = " + string);
        }
        if (this.isValidNativeDataSource() && !this.isEmptyString(string)) {
            this.nativeDataSource.setClientProgramID(string);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnectionFactory.setClientProgramID");
        }
    }

    final boolean matchAuthenticationInfo(JCAManagedConnection jCAManagedConnection, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object var8_8 = null;
        PasswordCredential passwordCredential = null;
        if (jCAManagedConnection != null) {
            string3 = jCAManagedConnection.getUsername();
            string4 = jCAManagedConnection.getPassword();
        }
        if (subject != null) {
            passwordCredential = JCAUtil.getPasswordCredential(subject, this);
            if (passwordCredential != null) {
                string = passwordCredential.getUserName();
                string2 = new String(passwordCredential.getPassword());
            }
            if (string.length() == 0) {
                string = null;
                string2 = null;
            }
        } else if (connectionRequestInfo != null && connectionRequestInfo instanceof JCAConnectionRequestInfo) {
            string = ((JCAConnectionRequestInfo)connectionRequestInfo).getUsername();
            string2 = ((JCAConnectionRequestInfo)connectionRequestInfo).getPassword();
        }
        return JCAUtil.isEqual(string, string3) && JCAUtil.isEqual(string2, string4);
    }

    private final Object commonCreateConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        this.validateNativeDataSource();
        if (connectionManager == null) {
            connectionManager = new JCADefaultConnectionManager(this.exceptions);
        }
        JCAManagedConnectionFactoryCommon jCAManagedConnectionFactoryCommon = this;
        JCAConnectionFactoryCommon jCAConnectionFactoryCommon = JCAClassUtility.a(connectionManager, jCAManagedConnectionFactoryCommon, jCAManagedConnectionFactoryCommon.logger, this.exceptions);
        return jCAConnectionFactoryCommon;
    }

    private final void validateNativeDataSource() throws ResourceException {
        if (this.nativeDataSource == null) {
            throw this.exceptions.getException(4303, 2);
        }
    }

    private final boolean isValidNativeDataSource() {
        return this.nativeDataSource != null;
    }

    private final boolean isEmptyString(String string) {
        return string != null && string.length() == 0;
    }

    public JCAExceptions getExceptions() {
        return this.exceptions;
    }

    private final void createLogger() {
        block3: {
            this.logger = new JCALogger(this.spyAttributes);
            if (this.isValidNativeDataSource()) {
                try {
                    this.nativeDataSource.setLogWriter(this.logger.getLogWriter());
                }
                catch (SQLException sQLException) {
                    if (this.logger.getLogWriter() == null) break block3;
                    this.logger.println("Error Setting log writer of underlying DataSource");
                }
            }
        }
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.createLogger();
        this.exceptions = new JCAExceptions(this.connectorName);
    }
}

