/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.search.core;

import java.util.HashMap;
import org.apache.lucene.search.SortField;

public class IndexableField {
    private static HashMap<String, SortField.Type> sortFieldTypeMap = new HashMap();
    private String STORE_COMPRESSED = "compressed";
    private String name;
    private String indexFieldName;
    private boolean indexable = true;
    private boolean indextokenize = true;
    private String indexStore = "no";
    private boolean indexStorable = false;
    private boolean storeCompressed = false;
    private String language;
    private float boost = 1.0f;
    private String type;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIndexFieldName() {
        return this.indexFieldName;
    }

    public void setIndexFieldName(String indexFieldName) {
        this.indexFieldName = indexFieldName;
    }

    public boolean isIndexable() {
        return this.indexable;
    }

    public boolean isIndextokenize() {
        return this.indextokenize;
    }

    public void setIndextokenize(boolean indextokenize) {
        this.indextokenize = indextokenize;
    }

    public void setIndexStore(String indexStore) {
        this.indexStore = indexStore;
        this.parsesStore(indexStore);
    }

    private void parsesStore(String indexStore) {
        if (indexStore == null) {
            this.indexStorable = false;
        } else if (indexStore.equalsIgnoreCase(this.STORE_COMPRESSED)) {
            this.indexStorable = true;
            this.storeCompressed = true;
        } else if (indexStore.equalsIgnoreCase("true") || indexStore.equalsIgnoreCase("yes")) {
            this.indexStorable = true;
        }
    }

    public boolean isIndexStorable() {
        return this.indexStorable;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public float getBoost() {
        return this.boost;
    }

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SortField.Type getSearchableFieldType() {
        if (this.type != null && sortFieldTypeMap.containsKey(this.type)) {
            return sortFieldTypeMap.get(this.type);
        }
        return SortField.Type.STRING;
    }

    static {
        sortFieldTypeMap.put("byte", SortField.Type.INT);
        sortFieldTypeMap.put("int", SortField.Type.INT);
        sortFieldTypeMap.put("integer", SortField.Type.INT);
        sortFieldTypeMap.put("short", SortField.Type.INT);
        sortFieldTypeMap.put("double", SortField.Type.DOUBLE);
        sortFieldTypeMap.put("long", SortField.Type.LONG);
        sortFieldTypeMap.put("float", SortField.Type.FLOAT);
        sortFieldTypeMap.put("string", SortField.Type.STRING);
        sortFieldTypeMap.put("custom", SortField.Type.CUSTOM);
    }
}

