/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io.impl;

import com.sun.syndication.io.impl.CFDateParser;
import com.sun.syndication.io.impl.PropertiesLoader;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateParser {
    private static String[] ADDITIONAL_MASKS = PropertiesLoader.getPropertiesLoader().getTokenizedProperty("datetime.extra.masks", "|");
    public static CFDateParser cfDateParser;
    private static final String[] RFC822_MASKS;
    private static final String[] ISO8601_MASKS;
    private static final String[] W3CDATETIME_MASKS;

    private DateParser() {
    }

    private static Date parseUsingMask(String[] masks, String sDate) {
        sDate = sDate != null ? sDate.trim() : null;
        ParsePosition pp = null;
        Date d = null;
        for (int i = 0; d == null && i < masks.length; ++i) {
            SimpleDateFormat df = new SimpleDateFormat(masks[i], Locale.US);
            df.setLenient(true);
            pp = new ParsePosition(0);
            d = ((DateFormat)df).parse(sDate, pp);
            if (pp.getErrorIndex() == -1) continue;
            d = null;
        }
        return d;
    }

    public static Date parseRFC822(String sDate) {
        int utIndex = sDate.indexOf(" UT");
        if (utIndex > -1) {
            String pre = sDate.substring(0, utIndex);
            String post = sDate.substring(utIndex + 3);
            sDate = pre + " GMT" + post;
        }
        return DateParser.parseUsingMask(RFC822_MASKS, sDate);
    }

    public static Date parseISO8601(String sDate) {
        int tzIndex = sDate.indexOf(90);
        if (tzIndex == -1 && (tzIndex = sDate.indexOf(43)) == -1) {
            tzIndex = sDate.indexOf(45, 8);
        }
        if (tzIndex == -1) {
            tzIndex = sDate.length();
        }
        int lastIndex = sDate.lastIndexOf(46) == -1 ? tzIndex : (tzIndex - sDate.lastIndexOf(46) > 3 ? sDate.lastIndexOf(46) + 4 : tzIndex);
        String sOutDate = sDate.substring(0, lastIndex);
        if (tzIndex - sDate.lastIndexOf(46) == 3) {
            sOutDate = sOutDate + "0";
        } else if (tzIndex - sDate.lastIndexOf(46) == 2) {
            sOutDate = sOutDate + "00";
        } else if (tzIndex - sDate.lastIndexOf(46) == 1) {
            sOutDate = sOutDate + "000";
        }
        if (sOutDate.indexOf(84) == 7) {
            sOutDate = sOutDate.replace('T', 'J');
        }
        if (tzIndex == sDate.length()) {
            sOutDate = sOutDate + "GMT";
        } else if (sDate.charAt(tzIndex) == 'Z') {
            sOutDate = sOutDate + "GMT";
        } else {
            String tzString = sDate.substring(tzIndex);
            if (tzString.length() == 3) {
                tzString = tzString + ":00";
            }
            sOutDate = sOutDate + "GMT" + tzString;
        }
        return DateParser.parseUsingMask(ISO8601_MASKS, sOutDate);
    }

    public static Date parseW3CDateTime(String sDate) {
        int tIndex = sDate.indexOf("T");
        if (tIndex > -1) {
            int tzdIndex;
            if (sDate.endsWith("Z")) {
                sDate = sDate.substring(0, sDate.length() - 1) + "+00:00";
            }
            if ((tzdIndex = sDate.indexOf("+", tIndex)) == -1) {
                tzdIndex = sDate.indexOf("-", tIndex);
            }
            if (tzdIndex > -1) {
                String pre = sDate.substring(0, tzdIndex);
                int secFraction = pre.indexOf(",");
                if (secFraction > -1) {
                    pre = pre.substring(0, secFraction);
                }
                String post = sDate.substring(tzdIndex);
                sDate = pre + "GMT" + post;
            }
        } else {
            sDate = sDate + "T00:00GMT";
        }
        return DateParser.parseUsingMask(W3CDATETIME_MASKS, sDate);
    }

    public static Date parseDate(String sDate) {
        Date d = DateParser.parseW3CDateTime(sDate = sDate.trim());
        if (d == null) {
            d = DateParser.parseRFC822(sDate);
            if (d == null) {
                d = DateParser.parseISO8601(sDate);
            }
            if (d == null && ADDITIONAL_MASKS.length > 0) {
                d = DateParser.parseUsingMask(ADDITIONAL_MASKS, sDate);
            }
            if (d == null && cfDateParser != null) {
                try {
                    d = cfDateParser.parseDate(sDate);
                }
                catch (Exception ex) {
                    d = null;
                }
            }
        }
        return d;
    }

    public static void registerCFDateParser(CFDateParser cf) {
        if (cfDateParser == null) {
            cfDateParser = cf;
        }
    }

    public static void removeCFDateParser() {
        cfDateParser = null;
    }

    public static String formatRFC822(Date date) {
        SimpleDateFormat dateFormater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        dateFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormater.format(date);
    }

    public static String formatW3CDateTime(Date date) {
        SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        dateFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormater.format(date);
    }

    static {
        RFC822_MASKS = new String[]{"EEE, dd MMM yy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss", "EEE, dd MMM yy HH:mm z", "dd MMM yy HH:mm:ss z", "dd MMM yy HH:mm z"};
        ISO8601_MASKS = new String[]{"yyyyDDD'J'HHmmss.SSSz", "yyyyMMddHHmmss.SSSz", "yyyyMMdd'T'HH:mm:ss.SSSz", "yyyy-MM-dd'T'HH:mm:ss.SSSz", "yyyyDDD'J'HH:mm:ss.SSSz", "yyyyMMdd'T'HHmmss.SSSz", "yyyy-MM-dd'T'HHmmss.SSSz", "yyyyMMdd HH:mm:ss.SSSz", "yyyyMMdd HHmmss.SSSz", "yyyy-MM-dd HH:mm:ss.SSSz", "yyyy-MM-dd HHmmss.SSSz", "yyyyDDD'J'HH:mm:ssz", "yyyyDDD'J'HHmmssz", "yyyyMMdd'T'HH:mm:ssz", "yyyyMMdd'T'HHmmssz", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HHmmssz", "yyyyMMdd HH:mm:ssz", "yyyyMMdd HHmmssz", "yyyy-MM-dd HH:mm:ssz", "yyyy-MM-dd HHmmssz", "yyyyMMddHHmmssz"};
        W3CDATETIME_MASKS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.Sz", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mmz", "yyyy-MM'T'HH:mmz", "yyyy'T'HH:mmz"};
    }
}

