/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.s3.consumer.TaggingConsumer;
import coldfusion.s3.request.FileMultipartUploadRequest;
import coldfusion.util.Utils;
import coldfusion.wddx.Base64Encoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.ObjectLockLegalHoldStatus;
import software.amazon.awssdk.services.s3.model.ObjectLockMode;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public class FileMultipartUploadRequestConsumer
extends ConsumerMap<FileMultipartUploadRequest> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public FileMultipartUploadRequestConsumer() {
        this.put("srcFile", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"srcFile");
            uploadFileRequest.setSrcFile(Utils.getFileFullPath((String)input, (PageContext)FusionContext.getCurrent().pageContext, (boolean)true));
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("chunkLengthInBytes", new ConsumerValidator((uploadFileRequest, value) -> {
            int v = this.cast.getIntegerProperty(value);
            ValidationUtil.validNumberInRange((long)v, (long)0x500000L, (long)0x10000000L, (String)"chunkLengthInBytes");
            uploadFileRequest.setPartSize(v);
        }, Collections.emptyList()));
        this.put("timeOutInSeconds", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.setTimeOutInSeconds(this.cast.getIntegerProperty(value)), Collections.emptyList()));
        this.put("validateContentMD5", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.setValidateContentMD5(this.cast.getBooleanProperty(value)), Collections.emptyList()));
        this.put("acl", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPartUploadRequest().acl(ObjectCannedACL.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("cacheControl", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"cacheControl");
            uploadFileRequest.getPartUploadRequest().cacheControl(input);
        }, Collections.emptyList()));
        this.put("contentDisposition", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentDisposition");
            uploadFileRequest.getPartUploadRequest().contentDisposition(input);
        }, Collections.emptyList()));
        this.put("contentEncoding", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentEncoding");
            uploadFileRequest.getPartUploadRequest().contentEncoding(input);
        }, Collections.emptyList()));
        this.put("contentLanguage", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentLanguage");
            uploadFileRequest.getPartUploadRequest().contentLanguage(input);
        }, Collections.emptyList()));
        this.put("contentType", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentType");
            uploadFileRequest.getPartUploadRequest().contentType(input);
        }, Collections.emptyList()));
        this.put("expires", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPartUploadRequest().expires(this.cast.getInstantProperty(value)), Collections.emptyList()));
        this.put("grantFullControl", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantFullControl");
            uploadFileRequest.getPartUploadRequest().grantFullControl(input);
        }, Collections.emptyList()));
        this.put("grantRead", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantRead");
            uploadFileRequest.getPartUploadRequest().grantRead(input);
        }, Collections.emptyList()));
        this.put("grantReadACP", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantReadACP");
            uploadFileRequest.getPartUploadRequest().grantReadACP(input);
        }, Collections.emptyList()));
        this.put("grantWriteACP", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"grantWriteACP");
            uploadFileRequest.getPartUploadRequest().grantWriteACP(input);
        }, Collections.emptyList()));
        this.put("key", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"key");
            uploadFileRequest.getPartUploadRequest().key(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("metadata", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPartUploadRequest().metadata(this.cast.getMapProperty(value)), Collections.emptyList()));
        this.put("serverSideEncryption", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPartUploadRequest().serverSideEncryption(ServerSideEncryption.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("storageClass", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPartUploadRequest().storageClass(StorageClass.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("websiteRedirectLocation", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"websiteRedirectLocation");
            uploadFileRequest.getPartUploadRequest().websiteRedirectLocation(input);
        }, Collections.emptyList()));
        this.put("sseCustomerAlgorithm", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"sseCustomerAlgorithm");
            uploadFileRequest.getPartUploadRequest().sseCustomerAlgorithm(input);
        }, Collections.emptyList()));
        this.put("sseCustomerKey", new ConsumerValidator((uploadFileRequest, value) -> {
            String key = this.cast.getStringProperty(value);
            uploadFileRequest.getPartUploadRequest().sseCustomerKey(BinaryUtils.toBase64((byte[])key.getBytes(Charset.forName(RuntimeServiceImpl.getDefaultCharset()))));
            uploadFileRequest.getPartUploadRequest().sseCustomerKeyMD5(Md5Utils.md5AsBase64((byte[])key.getBytes(Charset.forName(RuntimeServiceImpl.getDefaultCharset()))));
        }, Collections.emptyList()));
        this.put("ssekmsKeyId", new ConsumerValidator((uploadFileRequest, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"ssekmsKeyId");
            uploadFileRequest.getPartUploadRequest().ssekmsKeyId(input);
        }, Collections.emptyList()));
        this.put("ssekmsEncryptionContext", new ConsumerValidator((uploadFileRequest, value) -> {
            if (value instanceof String) {
                String input = this.cast.getStringProperty(value);
                ValidationUtil.validNonBlankString((String)input, (String)"ssekmsEncryptionContext");
                uploadFileRequest.getPartUploadRequest().ssekmsEncryptionContext(input);
            } else {
                String base64Encoded;
                Map map = this.cast.getMapProperty(value);
                String serializeJSON = JSONUtils.serializeJSON((Object)map);
                if (serializeJSON != null && !FusionContext.getCurrent().pageContext.isUnderCFThread()) {
                    String responseEncoding = FusionContext.getCurrent().pageContext.getResponse().getCharacterEncoding();
                    base64Encoded = Base64Encoder.encode((byte[])CfJspPage._Binary((String)serializeJSON, (String)responseEncoding));
                } else {
                    base64Encoded = Base64Encoder.encode((byte[])Cast._Binary((Object)serializeJSON));
                }
                uploadFileRequest.getPartUploadRequest().ssekmsEncryptionContext(base64Encoded);
            }
        }, Collections.emptyList()));
        this.put("requestPayer", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPartUploadRequest().requestPayer(RequestPayer.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("tagging", new ConsumerValidator((uploadFileRequest, value) -> {
            List<Tag> tags = TaggingConsumer.getInstance().getTagsList(value);
            Tagging tagging = (Tagging)Tagging.builder().tagSet(tags).build();
            String res = SdkHttpUtils.urlEncode((String)this.getTaggingString(tagging));
            uploadFileRequest.getPartUploadRequest().tagging(res);
        }, Collections.emptyList()));
        this.put("objectLockMode", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPartUploadRequest().objectLockMode(ObjectLockMode.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("objectLockRetainUntilDate", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPartUploadRequest().objectLockRetainUntilDate(this.cast.getInstantProperty(value)), Collections.emptyList()));
        this.put("objectLockLegalHoldStatus", new ConsumerValidator((uploadFileRequest, value) -> uploadFileRequest.getPartUploadRequest().objectLockLegalHoldStatus(ObjectLockLegalHoldStatus.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
    }

    private String getTaggingString(Tagging tagging) {
        StringBuilder taggingString = new StringBuilder();
        tagging.tagSet().forEach(tag -> {
            if (taggingString.length() > 0) {
                taggingString.append("&");
            }
            taggingString.append(this.getTagString((Tag)tag));
        });
        return taggingString.toString();
    }

    private String getTagString(Tag tag) {
        return tag.key() + "=" + tag.value();
    }
}

