/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSDecl;
import ice.pilots.html4.CSSRect;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.FontCache;
import ice.pilots.html4.StormData;
import ice.util.net.URLResolver;
import java.awt.Color;
import java.util.Vector;

class CSSLookup {
    static final int T_STRING = -1;
    static final int T_COLOR = -2;
    static final int T_URL = -3;
    static final int T_PERCENTAGE = -4;
    static final int T_LENGTH_EM = -5;
    static final int T_LENGTH_EX = -6;
    static final int T_LENGTH_PX = -7;
    static final int T_LENGTH_IN = -8;
    static final int T_LENGTH_CM = -9;
    static final int T_LENGTH_MM = -10;
    static final int T_LENGTH_PT = -11;
    static final int T_LENGTH_PC = -12;
    static final int T_VECTOR = -13;
    static final int T_INTEGER = -14;
    static final int T_FLOAT = -15;
    static final int T_RECT = -16;
    static final int P_BACKGROUND = 1;
    static final int P_BACKGROUND_IMAGE = 2;
    static final int P_BACKGROUND_REPEAT = 3;
    static final int P_BACKGROUND_ATTACHMENT = 4;
    static final int P_BACKGROUND_COLOR = 5;
    static final int P_BACKGROUND_POSITION = 6;
    static final int P_BORDER = 7;
    static final int P_BORDER_WIDTH = 8;
    static final int P_BORDER_STYLE = 9;
    static final int P_BORDER_COLLAPSE = 10;
    static final int P_BORDER_COLOR = 11;
    static final int P_BORDER_SPACING = 12;
    static final int P_BORDER_TOP = 13;
    static final int P_BORDER_RIGHT = 14;
    static final int P_BORDER_BOTTOM = 15;
    static final int P_BORDER_LEFT = 16;
    static final int P_BORDER_TOP_WIDTH = 17;
    static final int P_BORDER_TOP_COLOR = 18;
    static final int P_BORDER_RIGHT_COLOR = 19;
    static final int P_BORDER_BOTTOM_COLOR = 20;
    static final int P_BORDER_LEFT_COLOR = 21;
    static final int P_BORDER_TOP_STYLE = 22;
    static final int P_BORDER_RIGHT_STYLE = 23;
    static final int P_BORDER_BOTTOM_STYLE = 24;
    static final int P_BORDER_LEFT_STYLE = 25;
    static final int P_BORDER_RIGHT_WIDTH = 26;
    static final int P_BORDER_BOTTOM_WIDTH = 27;
    static final int P_BORDER_LEFT_WIDTH = 28;
    static final int P_BOTTOM = 29;
    static final int P_CAPTION_SIDE = 30;
    static final int P_CLEAR = 31;
    static final int P_CLIP = 32;
    static final int P_COLOR = 33;
    static final int P_CONTENT = 34;
    static final int P_COUNTER_INCREMENT = 35;
    static final int P_COUNTER_RESET = 36;
    static final int P_CURSOR = 37;
    static final int P_DIRECTION = 38;
    static final int P_DISPLAY = 39;
    static final int P_EMPTY_CELLS = 40;
    static final int P_FLOAT = 41;
    static final int P_FONT = 42;
    static final int P_FONT_STYLE = 43;
    static final int P_FONT_VARIANT = 44;
    static final int P_FONT_WEIGHT = 45;
    static final int P_FONT_SIZE = 46;
    static final int P_LINE_HEIGHT = 47;
    static final int P_FONT_FAMILY = 48;
    static final int P_FONT_SIZE_ADJUST = 49;
    static final int P_FONT_STRETCH = 50;
    static final int P_HEIGHT = 51;
    static final int P_LEFT = 52;
    static final int P_LETTER_SPACING = 53;
    static final int P_LIST_STYLE = 54;
    static final int P_LIST_STYLE_TYPE = 55;
    static final int P_LIST_STYLE_POSITION = 56;
    static final int P_LIST_STYLE_IMAGE = 57;
    static final int P_MARGIN = 58;
    static final int P_MARGIN_TOP = 59;
    static final int P_MARGIN_RIGHT = 60;
    static final int P_MARGIN_BOTTOM = 61;
    static final int P_MARGIN_LEFT = 62;
    static final int P_MARKER_OFFSET = 63;
    static final int P_MARKS = 64;
    static final int P_MAX_HEIGHT = 65;
    static final int P_MAX_WIDTH = 66;
    static final int P_MIN_HEIGHT = 67;
    static final int P_MIN_WIDTH = 68;
    static final int P_ORPHANS = 69;
    static final int P_OUTLINE = 70;
    static final int P_OUTLINE_COLOR = 71;
    static final int P_OUTLINE_STYLE = 72;
    static final int P_OUTLINE_WIDTH = 73;
    static final int P_OVERFLOW = 74;
    static final int P_PADDING = 75;
    static final int P_PADDING_TOP = 76;
    static final int P_PADDING_RIGHT = 77;
    static final int P_PADDING_BOTTOM = 78;
    static final int P_PADDING_LEFT = 79;
    static final int P_PAGE = 80;
    static final int P_PAGE_BREAK_AFTER = 81;
    static final int P_PAGE_BREAK_BEFORE = 82;
    static final int P_PAGE_BREAK_INSIDE = 83;
    static final int P_POSITION = 84;
    static final int P_QUOTES = 85;
    static final int P_RIGHT = 86;
    static final int P_SIZE = 87;
    static final int P_TABLE_LAYOUT = 88;
    static final int P_TEXT_ALIGN = 89;
    static final int P_TEXT_DECORATION = 90;
    static final int P_TEXT_INDENT = 91;
    static final int P_TEXT_SHADOW = 92;
    static final int P_TEXT_TRANSFORM = 93;
    static final int P_TOP = 94;
    static final int P_UNICODE_BIDI = 95;
    static final int P_VERTICAL_ALIGN = 96;
    static final int P_VISIBILITY = 97;
    static final int P_WHITE_SPACE = 98;
    static final int P_WIDOWS = 99;
    static final int P_WIDTH = 100;
    static final int P_WORD_SPACING = 101;
    static final int P_Z_INDEX = 102;
    static final int P_WORD_BREAK = 103;
    static final char[][] propNames = CSSLookup.splitAtSemicolon(";background;background-image;background-repeat;background-attachment;background-color;background-position;border;border-width;border-style;border-collapse;border-color;border-spacing;border-top;border-right;border-bottom;border-left;border-top-width;border-top-color;border-right-color;border-bottom-color;border-left-color;border-top-style;border-right-style;border-bottom-style;border-left-style;border-right-width;border-bottom-width;border-left-width;bottom;caption-side;clear;clip;color;content;counter-increment;counter-reset;cursor;direction;display;empty-cells;float;font;font-style;font-variant;font-weight;font-size;line-height;font-family;font-size-adjust;font-stretch;height;left;letter-spacing;list-style;list-style-type;list-style-position;list-style-image;margin;margin-top;margin-right;margin-bottom;margin-left;marker-offset;marks;max-height;max-width;min-height;min-width;orphans;outline;outline-color;outline-style;outline-width;overflow;padding;padding-top;padding-right;padding-bottom;padding-left;page;page-break-after;page-break-before;page-break-inside;position;quotes;right;size;table-layout;text-align;text-decoration;text-indent;text-shadow;text-transform;top;unicode-bidi;vertical-align;visibility;white-space;widows;width;word-spacing;z-index;word-break;");
    private static final int[][] colPropNames = new int[][]{{61, 63, 81}, {60, 82, 83}, {42, 53, 71, 72, 73}, {39, 41, 55}, {7, 29, 34, 66, 68}, {37}, {31, 33, 54, 62}, {32, 47, 59, 65, 67, 74}, {1, 13, 52, 64, 69, 70}, {16}, {44, 50}, {58}, {12, 43}, {10, 38, 45, 48}, {8, 9, 11, 14, 36, 40, 51}, {15, 30, 46}, {19, 23, 26}, {6, 20, 24, 27, 99}, {2, 5, 17, 18, 22, 35, 100}, {3, 21, 25, 28}, {80}, new int[0], {49}, {4, 75, 85, 86, 87, 94}, {84, 88, 96}, {95}, {93}, {76, 90, 101}, {57, 79, 97, 98}, {77, 102, 103}, {78, 89}, {56, 91, 92}};
    static final int V_NOT_FOUND = 0;
    static final int V_LEFT = 1;
    static final int V_CENTER = 2;
    static final int V_RIGHT = 3;
    static final int V_INHERIT = 4;
    static final int V_SCROLL = 5;
    static final int V_FIXED = 6;
    static final int V_TRANSPARENT = 7;
    static final int V_NONE = 8;
    static final int V_REPEAT = 9;
    static final int V_REPEAT_X = 10;
    static final int V_REPEAT_Y = 11;
    static final int V_NO_REPEAT = 12;
    static final int V_COLLAPSE = 13;
    static final int V_SEPARATE = 14;
    static final int V_AUTO = 15;
    static final int V_TOP = 16;
    static final int V_BOTTOM = 17;
    static final int V_BOTH = 18;
    static final int V_OPEN_QUOTE = 19;
    static final int V_CLOSE_QUOTE = 20;
    static final int V_NO_OPEN_QUOTE = 21;
    static final int V_NO_CLOSE_QUOTE = 22;
    static final int V_CROSSHAIR = 23;
    static final int V_DEFAULT = 24;
    static final int V_POINTER = 25;
    static final int V_MOVE = 26;
    static final int V_E_RESIZE = 27;
    static final int V_NE_RESIZE = 28;
    static final int V_NW_RESIZE = 29;
    static final int V_N_RESIZE = 30;
    static final int V_SE_RESIZE = 31;
    static final int V_SW_RESIZE = 32;
    static final int V_S_RESIZE = 33;
    static final int V_W_RESIZE = 34;
    static final int V_TEXT = 35;
    static final int V_WAIT = 36;
    static final int V_HELP = 37;
    static final int V_LTR = 38;
    static final int V_RTL = 39;
    static final int V_INLINE = 40;
    static final int V_BLOCK = 41;
    static final int V_LIST_ITEM = 42;
    static final int V_RUN_IN = 43;
    static final int V_COMPACT = 44;
    static final int V_MARKER = 45;
    static final int V_TABLE = 46;
    static final int V_INLINE_TABLE = 47;
    static final int V_TABLE_ROW_GROUP = 48;
    static final int V_TABLE_HEADER_GROUP = 49;
    static final int V_TABLE_FOOTER_GROUP = 50;
    static final int V_TABLE_ROW = 51;
    static final int V_TABLE_COLUMN_GROUP = 52;
    static final int V_TABLE_COLUMN = 53;
    static final int V_TABLE_CELL = 54;
    static final int V_TABLE_CAPTION = 55;
    static final int V_BELOW = 56;
    static final int V_LEVEL = 57;
    static final int V_ABOVE = 58;
    static final int V_HIGHER = 59;
    static final int V_LOWER = 60;
    static final int V_SHOW = 61;
    static final int V_HIDE = 62;
    static final int V_CAPTION = 63;
    static final int V_ICON = 64;
    static final int V_MENU = 65;
    static final int V_MESSAGE_BOX = 66;
    static final int V_SMALL_CAPTION = 67;
    static final int V_STATUS_BAR = 68;
    static final int V_NORMAL = 69;
    static final int V_WIDER = 70;
    static final int V_NARROWER = 71;
    static final int V_ULTRA_CONDENSED = 72;
    static final int V_EXTRA_CONDENSED = 73;
    static final int V_CONDENSED = 74;
    static final int V_SEMI_CONDENSED = 75;
    static final int V_SEMI_EXPANDED = 76;
    static final int V_EXPANDED = 77;
    static final int V_EXTRA_EXPANDED = 78;
    static final int V_ULTRA_EXPANDED = 79;
    static final int V_ITALIC = 80;
    static final int V_OBLIQUE = 81;
    static final int V_SMALL_CAPS = 82;
    static final int V_BOLD = 83;
    static final int V_BOLDER = 84;
    static final int V_LIGHTER = 85;
    static final int V_100 = 86;
    static final int V_200 = 87;
    static final int V_300 = 88;
    static final int V_400 = 89;
    static final int V_500 = 90;
    static final int V_600 = 91;
    static final int V_700 = 92;
    static final int V_800 = 93;
    static final int V_900 = 94;
    static final int V_INSIDE = 95;
    static final int V_OUTSIDE = 96;
    static final int V_DISC = 97;
    static final int V_CIRCLE = 98;
    static final int V_SQUARE = 99;
    static final int V_DECIMAL = 100;
    static final int V_DECIMAL_LEADING_ZERO = 101;
    static final int V_LOWER_ROMAN = 102;
    static final int V_UPPER_ROMAN = 103;
    static final int V_LOWER_GREEK = 104;
    static final int V_LOWER_ALPHA = 105;
    static final int V_LOWER_LATIN = 106;
    static final int V_UPPER_ALPHA = 107;
    static final int V_UPPER_LATIN = 108;
    static final int V_HEBREW = 109;
    static final int V_ARMENIAN = 110;
    static final int V_GEORGIAN = 111;
    static final int V_CJK_IDEOGRAPHIC = 112;
    static final int V_HIRAGANA = 113;
    static final int V_KATAKANA = 114;
    static final int V_HIRAGANA_IROHA = 115;
    static final int V_KATAKANA_IROHA = 116;
    static final int V_CROP = 117;
    static final int V_CROSS = 118;
    static final int V_INVERT = 119;
    static final int V_VISIBLE = 120;
    static final int V_HIDDEN = 121;
    static final int V_ALWAYS = 122;
    static final int V_AVOID = 123;
    static final int V_STATIC = 124;
    static final int V_RELATIVE = 125;
    static final int V_ABSOLUTE = 126;
    static final int V_PORTRAIT = 127;
    static final int V_LANDSCAPE = 128;
    static final int V_CODE = 129;
    static final int V_JUSTIFY = 130;
    static final int V_UNDERLINE = 131;
    static final int V_OVERLINE = 132;
    static final int V_LINE_THROUGH = 133;
    static final int V_BLINK = 134;
    static final int V_CAPITALIZE = 135;
    static final int V_UPPERCASE = 136;
    static final int V_LOWERCASE = 137;
    static final int V_EMBED = 138;
    static final int V_BIDI_OVERRIDE = 139;
    static final int V_BASELINE = 140;
    static final int V_SUB = 141;
    static final int V_SUPER = 142;
    static final int V_TEXT_TOP = 143;
    static final int V_MIDDLE = 144;
    static final int V_TEXT_BOTTOM = 145;
    static final int V_PRE = 146;
    static final int V_NOWRAP = 147;
    static final int V_DOTTED = 148;
    static final int V_DASHED = 149;
    static final int V_SOLID = 150;
    static final int V_DOUBLE = 151;
    static final int V_GROOVE = 152;
    static final int V_RIDGE = 153;
    static final int V_INSET = 154;
    static final int V_OUTSET = 155;
    static final int V_THIN = 156;
    static final int V_THICK = 157;
    static final int V_MEDIUM = 158;
    static final int V_HAND = 159;
    static final int V_XX_SMALL = 160;
    static final int V_X_SMALL = 161;
    static final int V_SMALL = 162;
    static final int V_LARGE = 163;
    static final int V_X_LARGE = 164;
    static final int V_XX_LARGE = 165;
    static final int V_SMALLER = 166;
    static final int V_LARGER = 167;
    static final int V_DOTXRD = 168;
    static final int V_BREAK_ALL = 169;
    private static final int MIN_PROPVALUE = 1;
    private static final int MAX_PROPVALUE = 169;
    static final char[][] propValues = CSSLookup.splitAtSemicolon(";left;center;right;inherit;scroll;fixed;transparent;none;repeat;repeat-x;repeat-y;no-repeat;collapse;separate;auto;top;bottom;both;open-quote;close-quote;no-open-quote;no-close-quote;crosshair;default;pointer;move;e-resize;ne-resize;nw-resize;n-resize;se-resize;sw-resize;s-resize;w-resize;text;wait;help;ltr;rtl;inline;block;list-item;run-in;compact;marker;table;inline-table;table-row-group;table-header-group;table-footer-group;table-row;table-column-group;table-column;table-cell;table-caption;below;level;above;higher;lower;show;hide;caption;icon;menu;message-box;small-caption;status-bar;normal;wider;narrower;ultra-condensed;extra-condensed;condensed;semi-condensed;semi-expanded;expanded;extra-expanded;ultra-expanded;italic;oblique;small-caps;bold;bolder;lighter;100;200;300;400;500;600;700;800;900;inside;outside;disc;circle;square;decimal;decimal-leading-zero;lower-roman;upper-roman;lower-greek;lower-alpha;lower-latin;upper-alpha;upper-latin;hebrew;armenian;georgian;cjk-ideographic;hiragana;katakana;hiragana-iroha;katakana-iroha;crop;cross;invert;visible;hidden;always;avoid;static;relative;absolute;portrait;landscape;code;justify;underline;overline;line-through;blink;capitalize;uppercase;lowercase;embed;bidi-override;baseline;sub;super;text-top;middle;text-bottom;pre;nowrap;dotted;dashed;solid;double;groove;ridge;inset;outset;thin;thick;medium;hand;xx-small;x-small;small;large;x-large;xx-large;smaller;larger;dotxrd;break-all;");
    private static final int[][] colPropValues = new int[][]{{9, 19, 47, 61, 70, 88, 98, 121, 123, 128, 137}, {58, 87, 111, 113}, {10, 28, 29, 83, 86, 114, 129, 132}, {3, 11, 30, 64, 97}, {35, 69, 92, 116, 138, 142, 152}, {22, 25, 57, 91}, {21, 90, 105, 148, 149, 158, 166, 168}, {6, 16, 36, 89, 110, 115, 151, 169}, {27, 42, 133, 159}, {17, 62, 77, 102, 106}, {15, 40, 51, 63, 82, 94, 95, 139}, {7, 48, 68, 93}, {26, 41, 80, 104, 126, 127, 134, 135, 143, 163}, {20, 81, 96}, {13, 18, 73, 74, 144}, {8, 78, 100, 112, 140}, {44, 56, 67, 99, 103, 108}, new int[0], {54, 141, 145, 150, 153}, {12, 161}, {46, 71, 120, 122, 130}, {118, 165}, {49, 50, 52, 53, 84, 124, 146}, {2, 24, 55, 117}, {23, 147, 154, 167}, {5, 45, 75, 85, 109, 131, 136}, {4, 34, 43, 76, 157, 162, 164}, {60, 119}, {1, 37, 59, 65, 160}, {38, 39, 155}, {14, 33, 66, 72, 156}, {31, 32, 79, 101, 107, 125}};
    private static final int[] display_vals = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 8, 4};
    private static final int[] direction_vals = new int[]{39, 38};
    private static final int[] halign_vals = new int[]{15, 1, 3, 2, 130, 4};
    private static final int[] valign_vals = new int[]{15, 140, 144, 141, 142, 143, 145, 16, 17, 4};
    private static final int[] position_vals = new int[]{124, 125, 126, 6, 4};
    private static final int[] visibility_vals = new int[]{121, 120, 13, 4};
    private static final int[] font_style_vals = new int[]{69, 80, 81, 4};
    private static final int[] font_weight_vals = new int[]{69, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 4};
    private static final int[] font_variant_vals = new int[]{69, 82, 4};
    private static final int[] font_size_vals = new int[]{160, 161, 162, 158, 163, 164, 165, 166, 167};
    private static final int[] text_decoration_vals = new int[]{8, 131, 132, 133, 134, 4};
    private static final int[] border_style_vals = new int[]{8, 121, 148, 149, 150, 151, 152, 153, 154, 155, 4, 168};
    private static final int[] color_vals = new int[]{7, 4};
    private static final int[] background_position_vals = new int[]{1, 3, 16, 2, 17};
    private static final int[] float_vals = new int[]{1, 3, 8, 18};
    private static final int[] auto_vals = new int[]{15, 4};
    private static final int[] cursor_vals = new int[]{15, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 159};
    private static final int[] list_style_vals = new int[]{97, 99, 98, 100, 101, 102, 103, 106, 105, 108, 107, 8};
    private static final int[] border_width_vals = new int[]{156, 158, 157, 4};
    private static final int[] background_repeat_vals = new int[]{9, 10, 11, 12};
    private static final int[] background_attachment_vals = new int[]{5, 6};
    private static final int[] background_image_vals = new int[]{8};
    private static final int[] page_break_vals = new int[]{15, 123, 122, 1, 3};
    private static final int[] line_height_vals = new int[]{69, 4};
    private static final int[] white_space_vals = new int[]{69, 147, 4};
    private static final int[] overflow_vals = new int[]{120, 121, 5, 15, 4};
    private static final int[] word_break_vals = new int[]{69, 169};

    CSSLookup() {
    }

    static final int getPropNameId(String propName) {
        char[] cc = propName.toCharArray();
        return CSSLookup.getPropNameId(cc, 0, cc.length);
    }

    static final int getPropNameId(char[] buf, int offset, int length) {
        int h = buf[offset];
        if (h <= 90 && h >= 65) {
            h += 32;
        }
        if ((h ^= length) < 96 || h > 127) {
            return -1;
        }
        int[] cols = colPropNames[h - 96];
        if (cols.length == 0) {
            return -1;
        }
        int i = 0;
        int j = 0;
        for (i = 0; i < cols.length; ++i) {
            char[] s = propNames[cols[i]];
            if (s.length != length) continue;
            int p = offset + length - 1;
            j = length - 1;
            while (j > 0) {
                h = buf[p];
                if (h <= 90 && h >= 65) {
                    h += 32;
                }
                if (h != s[j]) break;
                --j;
                --p;
            }
            if (j != 0) continue;
            return cols[i];
        }
        return -1;
    }

    static final String getPropName(int id) {
        if (id < 1 || id > 102) {
            return null;
        }
        return new String(propNames[id]);
    }

    static final int checkPropValue(char[] buf, int offset, int length, int[] vals) {
        int h2;
        int h = buf[offset];
        if (h <= 90 && h >= 65) {
            h += 32;
        }
        if ((h2 = buf[offset + length - 1]) <= 90 && h2 >= 65) {
            h2 += 32;
        }
        if ((h = h ^ h2 ^ length) < 0 || h > 31) {
            return 0;
        }
        int[] values = colPropValues[h - 0];
        if (values.length == 0) {
            return 0;
        }
        int colIdx = 0;
        int j = 0;
        int valsIdx = 0;
        for (colIdx = 0; colIdx < values.length; ++colIdx) {
            char[] property = propValues[values[colIdx]];
            if (property.length != length) continue;
            int val_id = values[colIdx];
            for (valsIdx = 0; valsIdx < vals.length; ++valsIdx) {
                if (val_id != vals[valsIdx]) continue;
                int p = offset + length - 1;
                j = length - 1;
                while (j > 0) {
                    h = buf[p];
                    if (h <= 90 && h >= 65) {
                        h += 32;
                    }
                    if (h != property[j]) break;
                    --j;
                    --p;
                }
                if (j != 0) continue;
                return val_id;
            }
        }
        return 0;
    }

    static final String getPropValue(int id) {
        if (id < 1 || id > 169) {
            return null;
        }
        return new String(propValues[id]);
    }

    static CSSDecl parseDeclaration(FontCache fontCache, char[] buf, int propOffset, int propLength, int valueOffset, int valueLength) {
        return CSSLookup.parseDeclaration(fontCache, buf, propOffset, propLength, valueOffset, valueLength, null);
    }

    static CSSDecl parseDeclaration(StormData sdata, char[] buf, int propOffset, int propLength, int valueOffset, int valueLength) {
        return CSSLookup.parseDeclaration(sdata.fontCache, buf, propOffset, propLength, valueOffset, valueLength, null);
    }

    static CSSDecl parseDeclaration(StormData sdata, char[] buf, int propOffset, int propLength, int valueOffset, int valueLength, String baseUrl) {
        return CSSLookup.parseDeclaration(sdata.fontCache, buf, propOffset, propLength, valueOffset, valueLength, baseUrl);
    }

    static CSSDecl parseDeclaration(FontCache fontCache, char[] buf, int propOffset, int propLength, int valueOffset, int valueLength, String baseUrl) {
        int id = CSSLookup.getPropNameId(buf, propOffset, propLength);
        if (id < 0) {
            return null;
        }
        CSSDecl decl = new CSSDecl(id, 0, null);
        switch (id) {
            case 38: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, direction_vals);
                break;
            }
            case 74: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, overflow_vals);
                break;
            }
            case 103: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, word_break_vals);
                break;
            }
            case 32: {
                CSSUtil.parseRect(decl, new String(buf, valueOffset, valueLength));
                break;
            }
            case 102: {
                try {
                    decl.value = new Integer(new String(buf, valueOffset, valueLength));
                    decl.type = -14;
                }
                catch (Exception exception) {}
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, page_break_vals);
                break;
            }
            case 39: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, display_vals);
                break;
            }
            case 84: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, position_vals);
                break;
            }
            case 29: 
            case 52: 
            case 86: 
            case 94: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, auto_vals);
                if (decl.type != 0) break;
                CSSUtil.parseLength(decl, buf, valueOffset, valueLength);
                break;
            }
            case 97: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, visibility_vals);
                break;
            }
            case 31: 
            case 41: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, float_vals);
                break;
            }
            case 89: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, halign_vals);
                break;
            }
            case 96: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, valign_vals);
                if (decl.type != 0) break;
                CSSUtil.parseLength(decl, buf, valueOffset, valueLength);
                break;
            }
            case 98: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, white_space_vals);
                break;
            }
            case 2: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, background_image_vals);
                if (decl.type != 0) break;
                decl.type = -3;
                String url = CSSUtil.parseUrl(buf, valueOffset, valueOffset + valueLength - 1);
                decl.value = URLResolver.resolve((String)baseUrl, (String)url);
                break;
            }
            case 4: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, background_attachment_vals);
                break;
            }
            case 3: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, background_repeat_vals);
                break;
            }
            case 6: {
                CSSLookup.parseBackgroundPosition(buf, valueOffset, valueLength, decl);
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 72: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, border_style_vals);
                break;
            }
            case 5: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 33: 
            case 71: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, color_vals);
                if (decl.type != 0) break;
                decl.value = CSSUtil.parseColor(buf, valueOffset, valueLength);
                if (decl.value == null) break;
                decl.type = -2;
                break;
            }
            case 90: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, text_decoration_vals);
                break;
            }
            case 91: {
                CSSUtil.parseLength(decl, buf, valueOffset, valueLength);
                break;
            }
            case 48: {
                decl.type = -1;
                String s = new String(buf, valueOffset, valueLength);
                decl.value = fontCache.getSupportedFontFamily(s);
                break;
            }
            case 46: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, font_size_vals);
                if (decl.type != 0) break;
                CSSUtil.parseLength(decl, buf, valueOffset, valueLength);
                break;
            }
            case 43: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, font_style_vals);
                break;
            }
            case 45: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, font_weight_vals);
                break;
            }
            case 55: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, list_style_vals);
                break;
            }
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 73: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, border_width_vals);
                if (decl.type != 0) break;
            }
            case 51: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 100: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, auto_vals);
                if (decl.type != 0) break;
                CSSUtil.parseLength(decl, buf, valueOffset, valueLength);
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, auto_vals);
                if (decl.type != 0) break;
                CSSUtil.parseLength(decl, buf, valueOffset, valueLength);
                if (decl.value != null && !(((Float)decl.value).floatValue() < 0.0f)) break;
                decl.value = new Float(0.0);
                break;
            }
            case 47: {
                char tmp;
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, line_height_vals);
                if (decl.type != 0) break;
                CSSUtil.parseLength(decl, buf, valueOffset, valueLength);
                if (decl.value == null || !(decl.value instanceof Float)) break;
                Float f = (Float)decl.value;
                if (f.floatValue() <= 0.0f) {
                    decl.type = 0;
                    break;
                }
                if (decl.type != -7 || (tmp = buf[valueOffset + valueLength - 1]) == 'x' || tmp == 'X') break;
                decl.value = new Float(f.floatValue());
                decl.type = -15;
                break;
            }
            case 34: {
                decl.type = -1;
                decl.value = new String(buf, valueOffset, valueLength);
                break;
            }
            case 37: {
                decl.type = CSSLookup.checkPropValue(buf, valueOffset, valueLength, cursor_vals);
                break;
            }
            case 36: {
                decl.value = CSSLookup.parseCounterString(buf, valueOffset, valueLength, 0);
                if (decl.value == null) break;
                decl.type = -13;
                break;
            }
            case 35: {
                decl.value = CSSLookup.parseCounterString(buf, valueOffset, valueLength, 1);
                if (decl.value == null) break;
                decl.type = -13;
                break;
            }
            case 70: {
                CSSDecl owidth = decl;
                decl.id = 73;
                CSSDecl ostyle = new CSSDecl(72, 0, null);
                CSSDecl ocolor = new CSSDecl(71, 0, null);
                CSSLookup.parseShorthandBorder(buf, valueOffset, valueLength, owidth, ostyle, ocolor);
                break;
            }
            case 1: {
                CSSLookup.parseShorthandBackground(buf, valueOffset, valueLength, decl, baseUrl);
                break;
            }
            case 58: {
                CSSDecl top = decl;
                top.id = 59;
                CSSDecl bottom = new CSSDecl(61, 0, null);
                CSSDecl left = new CSSDecl(62, 0, null);
                CSSDecl right = new CSSDecl(60, 0, null);
                CSSLookup.parseShorthandWith4Values(buf, valueOffset, valueLength, top, bottom, left, right, 0);
                break;
            }
            case 75: {
                CSSDecl top = decl;
                top.id = 76;
                CSSDecl bottom = new CSSDecl(78, 0, null);
                CSSDecl left = new CSSDecl(79, 0, null);
                CSSDecl right = new CSSDecl(77, 0, null);
                CSSLookup.parseShorthandWith4Values(buf, valueOffset, valueLength, top, bottom, left, right, 0);
                break;
            }
            case 8: {
                CSSDecl top = decl;
                top.id = 17;
                CSSDecl bottom = new CSSDecl(27, 0, null);
                CSSDecl left = new CSSDecl(28, 0, null);
                CSSDecl right = new CSSDecl(26, 0, null);
                CSSLookup.parseShorthandWith4Values(buf, valueOffset, valueLength, top, bottom, left, right, 0);
                break;
            }
            case 9: {
                CSSDecl top = decl;
                top.id = 22;
                CSSDecl bottom = new CSSDecl(24, 0, null);
                CSSDecl left = new CSSDecl(25, 0, null);
                CSSDecl right = new CSSDecl(23, 0, null);
                CSSLookup.parseShorthandWith4Values(buf, valueOffset, valueLength, top, bottom, left, right, 1);
                break;
            }
            case 11: {
                CSSDecl top = decl;
                top.id = 18;
                CSSDecl bottom = new CSSDecl(20, 0, null);
                CSSDecl left = new CSSDecl(21, 0, null);
                CSSDecl right = new CSSDecl(19, 0, null);
                CSSLookup.parseShorthandWith4Values(buf, valueOffset, valueLength, top, bottom, left, right, 2);
                break;
            }
            case 13: {
                CSSDecl bwidth = decl;
                decl.id = 17;
                CSSDecl bstyle = new CSSDecl(22, 0, null);
                CSSDecl bcolor = new CSSDecl(18, 0, null);
                CSSLookup.parseShorthandBorder(buf, valueOffset, valueLength, bwidth, bstyle, bcolor);
                break;
            }
            case 15: {
                CSSDecl bwidth = decl;
                decl.id = 27;
                CSSDecl bstyle = new CSSDecl(24, 0, null);
                CSSDecl bcolor = new CSSDecl(20, 0, null);
                CSSLookup.parseShorthandBorder(buf, valueOffset, valueLength, bwidth, bstyle, bcolor);
                break;
            }
            case 16: {
                CSSDecl bwidth = decl;
                decl.id = 28;
                CSSDecl bstyle = new CSSDecl(25, 0, null);
                CSSDecl bcolor = new CSSDecl(21, 0, null);
                CSSLookup.parseShorthandBorder(buf, valueOffset, valueLength, bwidth, bstyle, bcolor);
                break;
            }
            case 14: {
                CSSDecl bwidth = decl;
                decl.id = 26;
                CSSDecl bstyle = new CSSDecl(23, 0, null);
                CSSDecl bcolor = new CSSDecl(19, 0, null);
                CSSLookup.parseShorthandBorder(buf, valueOffset, valueLength, bwidth, bstyle, bcolor);
                break;
            }
            case 7: {
                CSSDecl bwidth = decl;
                decl.id = 17;
                CSSDecl bstyle = new CSSDecl(22, 0, null);
                CSSDecl bcolor = new CSSDecl(18, 0, null);
                CSSLookup.parseShorthandBorder(buf, valueOffset, valueLength, bwidth, bstyle, bcolor);
                CSSDecl bw = new CSSDecl(27, bwidth.type, bwidth.value);
                CSSDecl bs = new CSSDecl(24, bstyle.type, bstyle.value);
                CSSDecl bc = new CSSDecl(20, bcolor.type, bcolor.value);
                bw.next = bs;
                bs.next = bc;
                bc.next = bcolor.next;
                bcolor.next = bw;
                bw = new CSSDecl(28, bwidth.type, bwidth.value);
                bs = new CSSDecl(25, bstyle.type, bstyle.value);
                bc = new CSSDecl(21, bcolor.type, bcolor.value);
                bw.next = bs;
                bs.next = bc;
                bc.next = bcolor.next;
                bcolor.next = bw;
                bw = new CSSDecl(26, bwidth.type, bwidth.value);
                bs = new CSSDecl(23, bstyle.type, bstyle.value);
                bc = new CSSDecl(19, bcolor.type, bcolor.value);
                bw.next = bs;
                bs.next = bc;
                bc.next = bcolor.next;
                bcolor.next = bw;
                break;
            }
            case 42: {
                CSSLookup.parseShorthandFont(fontCache, buf, valueOffset, valueLength, decl);
            }
        }
        if (decl.type != 0) {
            return decl;
        }
        return null;
    }

    static final void parseShorthandWith4Values(char[] buf, int offset, int length, CSSDecl top, CSSDecl bottom, CSSDecl left, CSSDecl right, int mode) {
        top.next = bottom;
        bottom.next = left;
        left.next = right;
        int p1 = offset;
        int pos2 = offset + length;
        int t = 0;
        int count = 0;
        long tt = CSSUtil.findNextValue1(buf, p1, pos2);
        while (tt != 0L) {
            p1 = (int)tt;
            t = (int)(tt >> 32);
            if (count == 0) {
                if (mode == 0) {
                    top.type = CSSLookup.checkPropValue(buf, p1, t - p1, border_width_vals);
                    if (top.type == 0) {
                        CSSUtil.parseLength(top, buf, p1, t - p1);
                    }
                } else if (mode == 1) {
                    top.type = CSSLookup.checkPropValue(buf, p1, t - p1, border_style_vals);
                } else {
                    top.type = CSSLookup.checkPropValue(buf, p1, t - p1, color_vals);
                    if (top.type == 0) {
                        top.value = CSSUtil.parseColor(buf, p1, t - p1);
                        if (top.value != null) {
                            top.type = -2;
                        }
                    }
                }
                right.type = bottom.type = top.type;
                left.type = bottom.type;
                right.value = bottom.value = top.value;
                left.value = bottom.value;
            } else if (count == 1) {
                if (mode == 0) {
                    right.type = CSSLookup.checkPropValue(buf, p1, t - p1, auto_vals);
                    if (right.type == 0) {
                        CSSUtil.parseLength(right, buf, p1, t - p1);
                    }
                } else if (mode == 1) {
                    right.type = CSSLookup.checkPropValue(buf, p1, t - p1, border_style_vals);
                } else {
                    right.type = CSSLookup.checkPropValue(buf, p1, t - p1, color_vals);
                    if (right.type == 0) {
                        right.value = CSSUtil.parseColor(buf, p1, t - p1);
                        if (right.value != null) {
                            right.type = -2;
                        }
                    }
                }
                left.type = right.type;
                left.value = right.value;
            } else if (count == 2) {
                if (mode == 0) {
                    bottom.type = CSSLookup.checkPropValue(buf, p1, t - p1, auto_vals);
                    if (bottom.type == 0) {
                        CSSUtil.parseLength(bottom, buf, p1, t - p1);
                    }
                } else if (mode == 1) {
                    bottom.type = CSSLookup.checkPropValue(buf, p1, t - p1, border_style_vals);
                } else {
                    bottom.type = CSSLookup.checkPropValue(buf, p1, t - p1, color_vals);
                    if (bottom.type == 0) {
                        bottom.value = CSSUtil.parseColor(buf, p1, t - p1);
                        if (bottom.value != null) {
                            bottom.type = -2;
                        }
                    }
                }
            } else if (count == 3) {
                if (mode == 0) {
                    left.type = CSSLookup.checkPropValue(buf, p1, t - p1, auto_vals);
                    if (left.type == 0) {
                        CSSUtil.parseLength(left, buf, p1, t - p1);
                    }
                } else if (mode == 1) {
                    left.type = CSSLookup.checkPropValue(buf, p1, t - p1, border_style_vals);
                } else {
                    left.type = CSSLookup.checkPropValue(buf, p1, t - p1, color_vals);
                    if (left.type == 0) {
                        left.value = CSSUtil.parseColor(buf, p1, t - p1);
                        if (left.value != null) {
                            left.type = -2;
                        }
                    }
                }
            }
            tt = CSSUtil.findNextValue1(buf, t, pos2);
            ++count;
        }
    }

    static void parseShorthandBorder(char[] buf, int offset, int length, CSSDecl bwidth, CSSDecl bstyle, CSSDecl bcolor) {
        bwidth.next = bstyle;
        bstyle.next = bcolor;
        bcolor.type = -2;
        bcolor.value = null;
        bstyle.type = 8;
        bstyle.value = null;
        bwidth.type = 158;
        bstyle.value = null;
        boolean colorFound = false;
        int aa = 0;
        int p1 = offset;
        int pos2 = offset + length;
        int t = 0;
        long tt = CSSUtil.findNextValue1(buf, p1, pos2);
        while (tt != 0L) {
            p1 = (int)(tt & 0xFFFFFFFFFFFFFFFFL);
            t = (int)(tt >> 32);
            boolean used = false;
            if (bstyle.type == 8 && (aa = CSSLookup.checkPropValue(buf, p1, t - p1, border_style_vals)) != 0) {
                used = true;
                bstyle.type = aa;
            }
            if (!colorFound && !used) {
                aa = CSSLookup.checkPropValue(buf, p1, t - p1, color_vals);
                if (aa == 0) {
                    bcolor.value = CSSUtil.parseColor(buf, p1, t - p1);
                    if (bcolor.value != null) {
                        bcolor.type = -2;
                        colorFound = true;
                        used = true;
                    }
                } else {
                    bcolor.type = aa;
                    colorFound = true;
                    used = true;
                }
            }
            if (bwidth.type == 158 && !used && (aa = CSSLookup.checkPropValue(buf, p1, t - p1, border_width_vals)) == 0) {
                CSSUtil.parseLength(bwidth, buf, p1, t - p1);
                if (bwidth.type == 0) {
                    bwidth.type = 158;
                }
            }
            tt = CSSUtil.findNextValue1(buf, t, pos2);
        }
    }

    static void parseShorthandFont(FontCache fontCache, char[] buf, int offset, int length, CSSDecl fstyle) {
        fstyle.id = 43;
        CSSDecl fweight = null;
        Object fvariant = null;
        CSSDecl fsize = new CSSDecl(46, 0, null);
        String fontFamily = null;
        int temp = 0;
        int p1 = offset;
        int pos2 = offset + length;
        int t = 0;
        long tt = CSSUtil.findNextValue1(buf, p1, pos2);
        while (tt != 0L) {
            p1 = (int)(tt & 0xFFFFFFFFFFFFFFFFL);
            t = (int)(tt >> 32);
            boolean used = false;
            if (fstyle.type == 0) {
                fstyle.type = CSSLookup.checkPropValue(buf, p1, t - p1, font_style_vals);
                boolean bl = used = fstyle.type != 0;
            }
            if (fvariant == null && !used && (temp = CSSLookup.checkPropValue(buf, p1, t - p1, font_variant_vals)) != 0) {
                used = true;
            }
            if (fweight == null && !used && (temp = CSSLookup.checkPropValue(buf, p1, t - p1, font_weight_vals)) != 0) {
                fweight = new CSSDecl(45, temp, null);
                fweight.next = fstyle.next;
                fstyle.next = fweight;
                used = true;
            }
            if (fsize.type == 0 && !used) {
                int a;
                for (a = p1; a < t && buf[a] != '/'; ++a) {
                }
                fsize.type = CSSLookup.checkPropValue(buf, p1, a - p1, font_size_vals);
                if (fsize.type == 0) {
                    CSSUtil.parseLength(fsize, buf, p1, a - p1);
                }
                if (fsize.type != 0) {
                    fsize.next = fstyle.next;
                    fstyle.next = fsize;
                    used = true;
                }
            }
            if (!used) {
                fontFamily = fontFamily != null ? fontFamily + " " + new String(buf, p1, t - p1) : new String(buf, p1, t - p1);
            }
            tt = CSSUtil.findNextValue1(buf, t, pos2);
        }
        if (fstyle.type == 0) {
            fstyle.type = 69;
        }
        if (fontFamily != null) {
            fontFamily = fontCache.getSupportedFontFamily(fontFamily);
            CSSDecl d = new CSSDecl(48, -1, fontFamily);
            d.next = fstyle.next;
            fstyle.next = d;
        }
    }

    static final void parseBackgroundPosition(char[] buf, int offset, int length, CSSDecl decl) {
        int locationEnum = 0;
        int spos = offset;
        int pos2 = offset + length;
        int epos = 0;
        CSSDecl xpos = null;
        CSSDecl apos = null;
        boolean isFirst = true;
        long tt = CSSUtil.findNextValue1(buf, spos, pos2);
        while (tt != 0L) {
            spos = (int)(tt & 0xFFFFFFFFFFFFFFFFL);
            epos = (int)(tt >> 32);
            locationEnum = CSSLookup.checkPropValue(buf, spos, epos - spos, auto_vals);
            if (locationEnum == 0) {
                locationEnum = CSSLookup.checkPropValue(buf, spos, epos - spos, background_position_vals);
            }
            if (locationEnum == 0) {
                apos = new CSSDecl(6, locationEnum, null);
                CSSUtil.parseLength(apos, buf, spos, epos - spos);
                if (apos.value == null) {
                    apos = null;
                }
            } else {
                apos = new CSSDecl(6, locationEnum, null);
            }
            if (apos != null && isFirst) {
                xpos = apos;
                isFirst = false;
            }
            tt = CSSUtil.findNextValue1(buf, epos, pos2);
        }
        if (apos != null) {
            decl.type = apos.type;
            decl.id = apos.id;
            decl.value = apos.value;
        }
        if (xpos != null) {
            xpos.next = decl.next;
            decl.next = xpos;
        }
    }

    static final void parseShorthandBackground(char[] buf, int offset, int length, CSSDecl burl, String baseUrl) {
        burl.id = 2;
        CSSDecl battach = null;
        CSSDecl brepeat = null;
        CSSDecl bcolor = new CSSDecl(5, 0, null);
        CSSDecl bpos = null;
        bcolor.next = burl.next;
        burl.next = bcolor;
        int temp = 0;
        int spos = offset;
        int pos2 = offset + length;
        int epos = 0;
        long tt = CSSUtil.findNextValue1(buf, spos, pos2);
        while (tt != 0L) {
            spos = (int)(tt & 0xFFFFFFFFFFFFFFFFL);
            epos = (int)(tt >> 32);
            boolean used = false;
            if (battach == null && (temp = CSSLookup.checkPropValue(buf, spos, epos - spos, background_attachment_vals)) != 0) {
                battach = new CSSDecl(4, temp, null);
                battach.next = burl.next;
                burl.next = battach;
                used = true;
            }
            if (brepeat == null && !used && (temp = CSSLookup.checkPropValue(buf, spos, epos - spos, background_repeat_vals)) != 0) {
                brepeat = new CSSDecl(3, temp, null);
                brepeat.next = burl.next;
                burl.next = brepeat;
                used = true;
            }
            if (bcolor.type == 0 && !used) {
                bcolor.type = CSSLookup.checkPropValue(buf, spos, epos - spos, color_vals);
                if (bcolor.type == 0) {
                    bcolor.value = CSSUtil.parseColor(buf, spos, epos - spos);
                    if (bcolor.value != null) {
                        bcolor.type = -2;
                    }
                }
                if (bcolor.type != 0) {
                    used = true;
                }
            }
            if (!used) {
                temp = CSSLookup.checkPropValue(buf, spos, epos - spos, auto_vals);
                if (temp == 0) {
                    temp = CSSLookup.checkPropValue(buf, spos, epos - spos, background_position_vals);
                }
                if (temp == 0) {
                    CSSDecl test = new CSSDecl(6, temp, null);
                    CSSUtil.parseLength(test, buf, spos, epos - spos);
                    if (test.value != null) {
                        bpos = test;
                        bpos.next = burl.next;
                        burl.next = bpos;
                        used = true;
                    }
                } else {
                    bpos = new CSSDecl(6, temp, null);
                    bpos.next = burl.next;
                    burl.next = bpos;
                    used = true;
                }
            }
            if (burl.type <= 0 && !used) {
                String url;
                burl.type = CSSLookup.checkPropValue(buf, spos, epos - spos, background_image_vals);
                if (burl.type == 0 && (url = CSSUtil.parseUrl(buf, spos, epos)) != null) {
                    burl.value = URLResolver.resolve((String)baseUrl, (String)url);
                    burl.type = -3;
                }
            }
            tt = CSSUtil.findNextValue1(buf, epos, pos2);
        }
        if (burl.type == 0) {
            burl.type = 8;
        }
        if (bcolor.type == 0) {
            bcolor.type = 7;
        }
    }

    static final Vector parseCounterString(char[] buf, int offset, int length, int defaultInt) {
        Vector<Object> v = new Vector<Object>();
        int p1 = offset;
        int pos2 = offset + length;
        int t = 0;
        long tt = CSSUtil.findNextValue1(buf, p1, pos2);
        while (tt != 0L) {
            p1 = (int)(tt & 0xFFFFFFFFFFFFFFFFL);
            t = (int)(tt >> 32);
            String s = new String(buf, p1, t - p1);
            if ((v.size() & 1) == 0) {
                v.addElement(s);
            } else {
                try {
                    v.addElement(new Integer(s));
                }
                catch (Exception ex) {
                    v.addElement(new Integer(defaultInt));
                    v.addElement(s);
                }
            }
            tt = CSSUtil.findNextValue1(buf, t, pos2);
        }
        if ((v.size() & 1) != 0) {
            v.addElement(new Integer(defaultInt));
        }
        if (v.size() > 0) {
            return v;
        }
        return null;
    }

    static void apply(CSSAttribs css, CSSDecl decl, int zoom, CSSAttribs parentCss) {
        int id = decl.id;
        int type = decl.type;
        Object val = decl.value;
        switch (id) {
            case 38: {
                if (type == 39) {
                    css.directionFlag = 1;
                    break;
                }
                if (type != 38) break;
                css.directionFlag = (byte)2;
                break;
            }
            case 74: {
                css.misc = (short)(css.misc & 0xFFFFFFEF);
                css.misc = (short)(css.misc & 0xFFFFFF7F);
                if (type == 5 || type == 15) {
                    css.misc = (short)(css.misc | 0x10);
                    break;
                }
                if (type != 121) break;
                css.misc = (short)(css.misc | 0x80);
                break;
            }
            case 32: {
                if (type == 15) {
                    css.clip = null;
                    break;
                }
                if (type != -16) break;
                CSSRect r = (CSSRect)val;
                CSSUtil.cssClipRectToPixels(r, css, zoom);
                break;
            }
            case 102: {
                css.z_index = (Integer)val;
                break;
            }
            case 82: {
                if (type == 122 || type == 1 || type == 3) {
                    css.setPageBreak(0, 1);
                    break;
                }
                if (type == 1) {
                    css.setPageBreak(0, 3);
                    break;
                }
                if (type == 3) {
                    css.setPageBreak(0, 4);
                    break;
                }
                if (type != 123) break;
                css.setPageBreak(0, 2);
                break;
            }
            case 81: {
                if (type == 122) {
                    css.setPageBreak(1, 1);
                    break;
                }
                if (type == 1) {
                    css.setPageBreak(1, 3);
                    break;
                }
                if (type == 3) {
                    css.setPageBreak(1, 4);
                    break;
                }
                if (type != 123) break;
                css.setPageBreak(1, 2);
                break;
            }
            case 83: {
                if (type != 123) break;
                css.setPageBreak(2, 2);
                break;
            }
            case 39: {
                css.display = type;
                break;
            }
            case 84: {
                css.position = type;
                break;
            }
            case 94: {
                if (type == 15) {
                    css.top = -123456;
                    break;
                }
                css.top = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (type != -4) break;
                css.percentage_flag |= 0x80000;
                break;
            }
            case 29: {
                if (type == 15) {
                    css.bottom = -123456;
                    break;
                }
                css.bottom = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (type != -4) break;
                css.percentage_flag |= 4;
                break;
            }
            case 52: {
                if (type == 15) {
                    css.left = -123456;
                    break;
                }
                css.left = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (type != -4) break;
                css.percentage_flag |= 0x10;
                break;
            }
            case 86: {
                if (type == 15) {
                    css.right = -123456;
                    break;
                }
                css.right = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (type != -4) break;
                css.percentage_flag |= 0x20000;
                break;
            }
            case 97: {
                if (type == 121) {
                    css.misc = (short)(css.misc & ~1);
                    css.misc = (short)(css.misc & ~32);
                    break;
                }
                if (type == 120) {
                    css.misc = (short)(css.misc | 1);
                    css.misc = (short)(css.misc & ~32);
                    break;
                }
                if (type != 4) break;
                css.misc = (short)(css.misc | 0x20);
                break;
            }
            case 41: {
                if (type == 1) {
                    css.do_floats = (byte)(css.do_floats | 1);
                    break;
                }
                if (type != 3) break;
                css.do_floats = (byte)(css.do_floats | 2);
                break;
            }
            case 31: {
                if (type == 1) {
                    css.do_floats = (byte)(css.do_floats | 4);
                    break;
                }
                if (type == 3) {
                    css.do_floats = (byte)(css.do_floats | 8);
                    break;
                }
                if (type != 18) break;
                css.do_floats = (byte)(css.do_floats | (4 | 8));
                break;
            }
            case 96: {
                if (type == 4) {
                    css.vertical_align_type = parentCss.vertical_align_type;
                    break;
                }
                if (type <= 0) break;
                css.vertical_align_type = type;
                break;
            }
            case 98: {
                if (type == 69) {
                    css.misc = (short)(css.misc & 0xFFFFFFFB);
                    break;
                }
                if (type != 147) break;
                css.misc = (short)(css.misc | 4);
                break;
            }
            case 5: {
                if (type == 7) {
                    css.background_color = null;
                }
                if (type != -2) break;
                css.background_color = (Color)val;
                break;
            }
            case 2: {
                css.background_image = val;
                css.background_image_url = (String)val;
                break;
            }
            case 6: {
                if (type == 1) {
                    css.background_params = (short)(css.background_params | 0x100);
                    break;
                }
                if (type == 3) {
                    css.background_params = (short)(css.background_params | 0x10);
                    break;
                }
                if (type == 2) {
                    css.background_params = (short)(css.background_params | 0x20);
                    break;
                }
                if (type == 16) {
                    css.background_params = (short)(css.background_params | 0x40);
                    break;
                }
                if (type == 17) {
                    css.background_params = (short)(css.background_params | 0x80);
                    break;
                }
                if (type > -4 || type < -12) break;
                int pixelsOrPercent = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if ((css.background_params & 0x400) == 0) {
                    css.background_params = (short)(css.background_params | 0x400);
                    if (type == -4) {
                        css.percentage_flag |= 2;
                    }
                    css.background_position_y = (short)pixelsOrPercent;
                }
                css.background_position_x = (short)pixelsOrPercent;
                if (type == -4) {
                    css.percentage_flag |= 1;
                }
                css.background_params = (short)(css.background_params | 0x200);
                break;
            }
            case 3: {
                if (type == 10) {
                    css.background_params = (short)(css.background_params | 2);
                    break;
                }
                if (type == 11) {
                    css.background_params = (short)(css.background_params | 1);
                    break;
                }
                if (type != 12) break;
                css.background_params = (short)(css.background_params | 1);
                css.background_params = (short)(css.background_params | 2);
                break;
            }
            case 4: {
                if (type != 6) break;
                css.background_params = (short)(css.background_params | 4);
                break;
            }
            case 33: {
                if (type != -2) break;
                css.color = (Color)val;
                break;
            }
            case 37: {
                css.cursor = CSSUtil.cssCursorToAWT(type);
                break;
            }
            case 55: {
                css.listStyleType = (byte)type;
                break;
            }
            case 89: {
                css.text_align = type;
                break;
            }
            case 90: {
                if (type == 8) {
                    css.text_decoration = 0;
                    break;
                }
                if (type == 131) {
                    css.text_decoration = (byte)(css.text_decoration | 1);
                    break;
                }
                if (type == 133) {
                    css.text_decoration = (byte)(css.text_decoration | 2);
                    break;
                }
                if (type != 132) break;
                css.text_decoration = (byte)(css.text_decoration | 4);
                break;
            }
            case 91: {
                css.text_indent = (short)CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (css.text_indent < 0) {
                    css.text_indent = 0;
                    break;
                }
                if (type != -4) break;
                css.percentage_flag |= 0x40000;
                break;
            }
            case 100: {
                if (type == 15) {
                    css.width = -123456;
                    break;
                }
                css.width = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (type == -4) {
                    css.percentage_flag |= 0x100000;
                    break;
                }
                css.percentage_flag &= 0xFFEFFFFF;
                break;
            }
            case 51: {
                if (type == 15) {
                    css.height = -123456;
                    break;
                }
                css.height = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (type == -4) {
                    css.percentage_flag |= 8;
                    break;
                }
                css.percentage_flag &= 0xFFFFFFF7;
                break;
            }
            case 47: {
                if (type == 69) {
                    css.line_height = 110;
                    css.percentage_flag |= 0x200000;
                    break;
                }
                if (type == -15) {
                    css.line_height = (int)(((Float)val).floatValue() * 100.0f);
                    css.percentage_flag |= 0x200000;
                    break;
                }
                css.line_height = CSSUtil.cssLengthToPixels(decl, css, zoom);
                css.percentage_flag &= 0xFFDFFFFF;
                if (type != -4) break;
                css.line_height = css.line_height * css.font_size / 100;
                break;
            }
            case 48: {
                if (type != -1) break;
                css.font_family = (String)val;
                break;
            }
            case 43: {
                if (type == 80 || type == 81) {
                    css.font_style |= 2;
                    break;
                }
                css.font_style &= 0xFFFFFFFD;
                break;
            }
            case 45: {
                if (type == 83 || type == 84 || type == 90 || type == 91 || type == 92 || type == 93 || type == 94) {
                    css.font_style |= 1;
                    break;
                }
                css.font_style &= 0xFFFFFFFE;
                break;
            }
            case 46: {
                break;
            }
            case 59: {
                if (type == 15) {
                    css.margin_top = -123456;
                    break;
                }
                css.margin_top = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (type != -4) break;
                css.percentage_flag |= 0x20;
                break;
            }
            case 61: {
                if (type == 15) {
                    css.margin_bottom = -123456;
                    break;
                }
                css.margin_bottom = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (type != -4) break;
                css.percentage_flag |= 0x40;
                break;
            }
            case 62: {
                if (type == 15) {
                    css.margin_left = -123456;
                    break;
                }
                css.margin_left = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (type != -4) break;
                css.percentage_flag |= 0x80;
                break;
            }
            case 60: {
                if (type == 15) {
                    css.margin_right = -123456;
                    break;
                }
                css.margin_right = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (type != -4) break;
                css.percentage_flag |= 0x100;
                break;
            }
            case 76: {
                css.padding_top = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (type != -4) break;
                css.percentage_flag |= 0x2000;
                break;
            }
            case 78: {
                css.padding_bottom = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (type != -4) break;
                css.percentage_flag |= 0x4000;
                break;
            }
            case 79: {
                css.padding_left = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (type != -4) break;
                css.percentage_flag |= 0x8000;
                break;
            }
            case 77: {
                css.padding_right = CSSUtil.cssLengthToPixels(decl, css, zoom);
                if (type != -4) break;
                css.percentage_flag |= 0x10000;
                break;
            }
            case 17: {
                if (type == 156) {
                    css.border_top_width = 1;
                    break;
                }
                if (type == 158) {
                    css.border_top_width = 2;
                    break;
                }
                if (type == 157) {
                    css.border_top_width = 4;
                    break;
                }
                css.border_top_width = CSSUtil.cssLengthToPixels(decl, css, zoom);
                break;
            }
            case 27: {
                if (type == 156) {
                    css.border_bottom_width = 1;
                    break;
                }
                if (type == 158) {
                    css.border_bottom_width = 2;
                    break;
                }
                if (type == 157) {
                    css.border_bottom_width = 4;
                    break;
                }
                css.border_bottom_width = CSSUtil.cssLengthToPixels(decl, css, zoom);
                break;
            }
            case 28: {
                if (type == 156) {
                    css.border_left_width = 1;
                    break;
                }
                if (type == 158) {
                    css.border_left_width = 2;
                    break;
                }
                if (type == 157) {
                    css.border_left_width = 4;
                    break;
                }
                css.border_left_width = CSSUtil.cssLengthToPixels(decl, css, zoom);
                break;
            }
            case 26: {
                if (type == 156) {
                    css.border_right_width = 1;
                    break;
                }
                if (type == 158) {
                    css.border_right_width = 2;
                    break;
                }
                if (type == 157) {
                    css.border_right_width = 4;
                    break;
                }
                css.border_right_width = CSSUtil.cssLengthToPixels(decl, css, zoom);
                break;
            }
            case 18: {
                if (type == 7) {
                    css.border_top_color = CSSAttribs.COLOR_TRANSPARENT;
                    break;
                }
                if (type != -2) break;
                css.border_top_color = (Color)val;
                break;
            }
            case 20: {
                if (type == 7) {
                    css.border_bottom_color = CSSAttribs.COLOR_TRANSPARENT;
                    break;
                }
                if (type != -2) break;
                css.border_bottom_color = (Color)val;
                break;
            }
            case 21: {
                if (type == 7) {
                    css.border_left_color = CSSAttribs.COLOR_TRANSPARENT;
                    break;
                }
                if (type != -2) break;
                css.border_left_color = (Color)val;
                break;
            }
            case 19: {
                if (type == 7) {
                    css.border_right_color = CSSAttribs.COLOR_TRANSPARENT;
                    break;
                }
                if (type != -2) break;
                css.border_right_color = (Color)val;
                break;
            }
            case 22: {
                css.border_top_style = type;
                break;
            }
            case 24: {
                css.border_bottom_style = type;
                break;
            }
            case 25: {
                css.border_left_style = type;
                break;
            }
            case 23: {
                css.border_right_style = type;
                break;
            }
            case 71: {
                if (type != -2) break;
                css.outline_color = (Color)val;
                break;
            }
            case 72: {
                css.outline_style = (short)type;
                break;
            }
            case 73: {
                if (type == 156) {
                    css.outline_width = 1;
                    break;
                }
                if (type == 158) {
                    css.outline_width = 2;
                    break;
                }
                if (type == 157) {
                    css.outline_width = 4;
                    break;
                }
                css.outline_width = CSSUtil.cssLengthToPixels(decl, css, 256);
                break;
            }
            case 103: {
                if (type != 169) break;
                css.misc = (short)(css.misc | 0x100);
            }
        }
    }

    static int computeFontSize(StormData sdata, CSSDecl d, CSSAttribs css, int zoom) {
        FontCache fontCache = sdata.fontCache;
        int t = 0;
        if (d.type > 0) {
            t = d.type == 166 ? fontCache.getFontSizeRel(-1, css.font_size) : (d.type == 167 ? fontCache.getFontSizeRel(1, css.font_size) : (d.type == 158 ? fontCache.getFontSizeAbs(3, zoom) : fontCache.getFontSizeAbs(d.type - 160, zoom)));
        } else if (d.type < 0) {
            t = CSSUtil.cssLengthToPixels(d, css, zoom);
            if (d.type == -4) {
                t = css.font_size * t / 100;
            }
        }
        if (t <= 0) {
            return css.font_size;
        }
        if (t < FontCache.minFontSize) {
            t = FontCache.minFontSize;
        }
        return t;
    }

    static int getListStyle(String style) {
        char[] cc = style.toCharArray();
        int t = CSSLookup.checkPropValue(cc, 0, cc.length, list_style_vals);
        if (t == 0) {
            t = 100;
        }
        return t;
    }

    private static char[][] splitAtSemicolon(String names) {
        int next;
        int count = 0;
        int offset = 0;
        while ((next = names.indexOf(59, offset)) >= 0) {
            ++count;
            offset = next + 1;
        }
        char[][] x = new char[count][];
        offset = 0;
        for (int i = 0; i != count; ++i) {
            int next2 = names.indexOf(59, offset);
            x[i] = new char[next2 - offset];
            names.getChars(offset, next2, x[i], 0);
            offset = next2 + 1;
        }
        return x;
    }
}

