/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.api.pub;

import com.zerog.ia.api.pub.CustomError;
import com.zerog.ia.api.pub.I18NAccess;
import com.zerog.ia.api.pub.IAProxy;
import com.zerog.ia.api.pub.ProgressAccess;
import com.zerog.ia.api.pub.ReplayVariableService;
import com.zerog.ia.api.pub.ResourceAccess;
import com.zerog.ia.api.pub.ServiceAccess;
import com.zerog.ia.api.pub.SimpleRegistryManager;
import com.zerog.ia.api.pub.UninstallerAccess;
import com.zerog.ia.api.pub.VariableAccess;
import com.zerog.ia.api.pub.registry.ProductRegistryService;
import com.zerog.ia.installer.Uninstaller;
import com.zerog.ia.installer.util.service.ServiceManagerFacade;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;

public class UninstallerProxy
implements ResourceAccess,
I18NAccess,
VariableAccess,
UninstallerAccess,
ServiceAccess,
IAProxy,
ProgressAccess {
    private ResourceAccess ra;
    private VariableAccess va;
    private I18NAccess i18na;
    private UninstallerAccess ua;
    private ProgressAccess progressAccess;

    public UninstallerProxy(ResourceAccess resourceAccess, VariableAccess variableAccess, I18NAccess i18NAccess, UninstallerAccess uninstallerAccess) {
        block3: {
            block2: {
                this.progressAccess = null;
                if (resourceAccess == null || variableAccess == null || i18NAccess == null) break block2;
                if (uninstallerAccess != null) break block3;
            }
            System.err.println("InstallerProxy: Some proxy component implementations were null");
            throw new IllegalArgumentException("Some proxy component implementations were null");
        }
        this.ra = resourceAccess;
        this.va = variableAccess;
        this.i18na = i18NAccess;
        this.ua = uninstallerAccess;
    }

    public void setProgressAccess(ProgressAccess progressAccess) {
        this.progressAccess = progressAccess;
    }

    @Override
    public URL getResource(String string) {
        return this.ra.getResource(string);
    }

    @Override
    public File getTempDirectory() throws IOException {
        return this.ra.getTempDirectory();
    }

    @Override
    public File saveURLContentToFile(URL uRL) throws IOException {
        return this.ra.saveURLContentToFile(uRL);
    }

    @Override
    public String getValue(String string, Locale locale) {
        return this.i18na.getValue(string, locale);
    }

    @Override
    public String getValue(String string) {
        return this.i18na.getValue(string);
    }

    @Override
    public DataInput getLogInput() {
        return this.ua.getLogInput();
    }

    @Override
    public void setProgressPercentage(float f) {
        this.progressAccess.setProgressPercentage(f);
        Uninstaller.getInstance().setItemPercentDone((int)f);
    }

    @Override
    public void setProgressStatusText(String string) {
        this.progressAccess.setProgressStatusText(string);
        Uninstaller.getInstance().setItemDisplayText(string);
    }

    @Override
    public void setProgressTitle(String string) {
        this.progressAccess.setProgressTitle(string);
    }

    @Override
    public void setProgressDescription(String string) {
        this.progressAccess.setProgressDescription(string);
    }

    @Override
    public Object getService(Class clazz) {
        Object object = null;
        if (clazz.equals(SimpleRegistryManager.class)) {
            object = Flexeraads.ag();
        } else if (clazz.equals(CustomError.class)) {
            object = Flexeraac8.aa();
        } else if (clazz.equals(ReplayVariableService.class)) {
            object = Flexeraadp.aa();
        } else if (clazz.equals(ProductRegistryService.class)) {
            object = Flexeraadx.aa();
            ((Flexeraadx)object).ab(null, true);
        } else {
            object = ServiceManagerFacade.getInstance().getService(clazz);
        }
        return object;
    }

    @Override
    public String substitute(String string) {
        return this.va.substitute(string);
    }

    @Override
    public Object getVariable(String string) {
        return this.va.getVariable(string);
    }

    @Override
    public Enumeration getVariables() {
        return this.va.getVariables();
    }

    @Override
    public Object setVariable(String string, Object object) {
        return this.va.setVariable(string, object);
    }

    @Override
    public Object getEncryptedVariable(String string) {
        return this.va.getEncryptedVariable(string);
    }

    @Override
    public String decryptEncryptedValue(String string) {
        return this.va.decryptEncryptedValue(string);
    }

    @Override
    public int getCurrentProgressPercentage() {
        if (Uninstaller.getInstance().getInstaller() != null) {
            return Uninstaller.getInstance().getInstaller().getCurrentInstallerProgress();
        }
        return 0;
    }
}

