/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.ControlActionClosureUPP;
import com.apple.mrj.macos.generated.ControlFunctions;
import com.apple.mrj.macos.generated.PointStruct;
import com.apple.mrj.macos.generated.RectStruct;
import com.apple.mrj.macos.toolbox.ControlFontStyle;
import com.apple.mrj.macos.toolbox.ControlHandle;
import com.apple.mrj.macos.toolbox.FSSpec;
import com.apple.mrj.macos.toolbox.MacOSError;
import com.apple.mrj.macos.toolbox.OSType;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.Ptr;
import com.apple.mrj.macos.toolbox.QuickdrawFont;
import com.apple.mrj.macos.toolbox.RGBColor;
import com.apple.mrj.macos.toolbox.Rect;
import com.apple.mrj.macos.toolbox.Str255;
import com.apple.mrj.macos.toolbox.WindowRef;

public class ControlRef
extends ControlHandle {
    public ControlRef(int n) {
        super(n);
    }

    public ControlRef(int n, Object object) {
        super(n, object);
    }

    public ControlRef(short s, WindowRef windowRef) {
        super(s, windowRef);
    }

    public ControlRef(int n, RectStruct rectStruct, byte[] byArray, boolean bl, short s, short s2, short s3, short s4, int n2) {
        super(n, rectStruct, byArray, bl, s, s2, s3, s4, n2);
    }

    public ControlRef(int n, RectStruct rectStruct, byte[] byArray, boolean bl, short s) {
        super(n, rectStruct, byArray, bl, (short)0, (short)0, (short)1, s, 0);
    }

    public ControlRef(WindowRef windowRef, Rect rect, Str255 str255, boolean bl, short s) {
        this(windowRef.getWindowPointer(), rect.getRect(), str255.getBytes(), bl, 0, 0, 1, s, 0);
    }

    public ControlRef(WindowRef windowRef, Rect rect, boolean bl, short s, short s2, short s3, short s4, int n) {
        this(windowRef.getWindowPointer(), rect.getRect(), new byte[1], bl, s, s2, s3, s4, n);
    }

    public static ControlRef GetOwnedControlRef(int n, Object object) {
        if (n != 0) {
            return new ControlRef(n, object);
        }
        return null;
    }

    public static ControlRef createRootControl(WindowRef windowRef) {
        int[] nArray = new int[1];
        MacOSError.checkResult(ControlFunctions.CreateRootControl(windowRef.getWindowPointer(), nArray));
        return new ControlRef(nArray[0], (Object)windowRef);
    }

    public static ControlRef getRootControl(WindowRef windowRef) {
        int[] nArray = new int[1];
        MacOSError.checkResult(ControlFunctions.GetRootControl(windowRef.getWindowPointer(), nArray));
        return new ControlRef(nArray[0], (Object)windowRef);
    }

    public void embed(ControlHandle controlHandle) {
        MacOSError.checkResult(ControlFunctions.EmbedControl(this.getControl(), controlHandle.getControl()));
    }

    public void autoEmbed(WindowRef windowRef) {
        MacOSError.checkResult(ControlFunctions.AutoEmbedControl(this.getControl(), windowRef.getWindowPointer()));
    }

    public short countSubControls() {
        short[] sArray = new short[1];
        MacOSError.checkResult(ControlFunctions.CountSubControls(this.getControl(), sArray));
        return sArray[0];
    }

    public ControlRef getIndexedSubControl(short s) {
        int[] nArray = new int[1];
        MacOSError.checkResult(ControlFunctions.GetIndexedSubControl(this.getControl(), s, nArray));
        return new ControlRef(nArray[0], this);
    }

    public ControlRef getSuper() {
        int[] nArray = new int[1];
        MacOSError.checkResult(ControlFunctions.GetSuperControl(this.getControl(), nArray));
        return new ControlRef(nArray[0], this);
    }

    public void setSupervisor(ControlHandle controlHandle) {
        MacOSError.checkResult(ControlFunctions.SetControlSupervisor(this.getControl(), controlHandle.getControl()));
    }

    public static void dumpHierarchy(WindowRef windowRef, FSSpec fSSpec) {
        MacOSError.checkResult(ControlFunctions.DumpControlHierarchy(windowRef.getWindowPointer(), fSSpec.getFSSpec()));
    }

    public short activate() {
        return ControlFunctions.ActivateControl(this.getControl());
    }

    public short deactivate() {
        return ControlFunctions.DeactivateControl(this.getControl());
    }

    public boolean isActive() {
        return ControlFunctions.IsControlActive(this.getControl());
    }

    public int sendMessage(short s, int n) {
        return ControlFunctions.SendControlMessage(this.getControl(), s, n);
    }

    public int sendMessage(short s, byte[] byArray) {
        return ControlFunctions.SendControlMessage(this.getControl(), s, byArray);
    }

    public int getViewSize() {
        return ControlFunctions.GetControlViewSize(this.getControl());
    }

    public int get32BitValue() {
        return ControlFunctions.GetControl32BitValue(this.getControl());
    }

    public int get32BitMinimum() {
        return ControlFunctions.GetControl32BitMinimum(this.getControl());
    }

    public int get32BitMaximum() {
        return ControlFunctions.GetControl32BitMaximum(this.getControl());
    }

    public void setViewSize(int n) {
        ControlFunctions.SetControlViewSize(this.getControl(), n);
    }

    public void set32BitValue(int n) {
        ControlFunctions.SetControl32BitValue(this.getControl(), n);
    }

    public void set32BitMinimum(int n) {
        ControlFunctions.SetControl32BitMinimum(this.getControl(), n);
    }

    public void set32BitMaximum(int n) {
        ControlFunctions.SetControl32BitMaximum(this.getControl(), n);
    }

    public void drawInCurrentPort() {
        ControlFunctions.DrawControlInCurrentPort(this.getControl());
    }

    public int findUnderMouse(Point point, WindowRef windowRef, short[] sArray) {
        return ControlFunctions.FindControlUnderMouse(point.getPoint(), windowRef.getWindowPointer(), sArray);
    }

    public short find(Point point, WindowRef windowRef, int[] nArray) {
        short[] sArray = new short[1];
        nArray[0] = this.findUnderMouse(point, windowRef, sArray);
        return sArray[0];
    }

    public short handleKey(short s, short s2, short s3) {
        return ControlFunctions.HandleControlKey(this.getControl(), s, s2, s3);
    }

    public static void idleControls(WindowRef windowRef) {
        ControlFunctions.IdleControls(windowRef.getWindowPointer());
    }

    public short handleClick(PointStruct pointStruct, short s, ControlActionClosureUPP controlActionClosureUPP) {
        return ControlFunctions.HandleControlClick(this.getControl(), pointStruct, s, controlActionClosureUPP);
    }

    public short handleClick(Point point, short s, ControlActionClosureUPP controlActionClosureUPP) {
        return this.handleClick(point.getPoint(), s, controlActionClosureUPP);
    }

    public short track(Point point, ControlActionClosureUPP controlActionClosureUPP) {
        return this.handleClick(point, (short)0, controlActionClosureUPP);
    }

    public static void setKeyboardFocus(WindowRef windowRef, ControlRef controlRef, short s) {
        MacOSError.checkResult(ControlFunctions.SetKeyboardFocus(windowRef.getWindowPointer(), controlRef.getControl(), s));
    }

    public static ControlRef getKeyboardFocus(WindowRef windowRef) {
        int[] nArray = new int[1];
        MacOSError.checkResult(ControlFunctions.GetKeyboardFocus(windowRef.getWindowPointer(), nArray));
        return new ControlRef(nArray[0], (Object)windowRef);
    }

    public static void advanceKeyboardFocus(WindowRef windowRef) {
        MacOSError.checkResult(ControlFunctions.AdvanceKeyboardFocus(windowRef.getWindowPointer()));
    }

    public static void reverseKeyboardFocus(WindowRef windowRef) {
        MacOSError.checkResult(ControlFunctions.ReverseKeyboardFocus(windowRef.getWindowPointer()));
    }

    public static void clearKeyboardFocus(WindowRef windowRef) {
        MacOSError.checkResult(ControlFunctions.ClearKeyboardFocus(windowRef.getWindowPointer()));
    }

    public short getFeatures(int[] nArray) {
        return ControlFunctions.GetControlFeatures(this.getControl(), nArray);
    }

    public boolean testFeature(int n) {
        int[] nArray = new int[1];
        this.getFeatures(nArray);
        return (nArray[0] & n) != 0;
    }

    public short getBestRect(Rect rect, short[] sArray) {
        return this.getBestRect(rect.getRect(), sArray);
    }

    public short getBestRect(RectStruct rectStruct, short[] sArray) {
        return ControlFunctions.GetBestControlRect(this.getControl(), rectStruct, sArray);
    }

    public void setData(short s, OSType oSType, int n, Ptr ptr) {
        ControlFunctions.SetControlData(this.getControl(), s, oSType.toInt(), n, ptr.getPointer());
    }

    public short getData(short s, OSType oSType, int n, Ptr ptr, int[] nArray) {
        return ControlFunctions.GetControlData(this.getControl(), s, oSType.toInt(), n, ptr.getPointer(), nArray);
    }

    public short getDataSize(short s, OSType oSType, int[] nArray) {
        return ControlFunctions.GetControlDataSize(this.getControl(), s, oSType.toInt(), nArray);
    }

    public short setForeColor(RGBColor rGBColor) {
        return this.setColors(rGBColor, null);
    }

    public short setBackColor(RGBColor rGBColor) {
        return this.setColors(null, rGBColor);
    }

    public short setColors(RGBColor rGBColor, RGBColor rGBColor2) {
        return this.setFontStyle(new ControlFontStyle(rGBColor, rGBColor2));
    }

    public short setFont(QuickdrawFont quickdrawFont) {
        return this.setFontStyle(new ControlFontStyle(quickdrawFont));
    }

    public short setFontStyle(ControlFontStyle controlFontStyle) {
        return ControlFunctions.SetControlFontStyle(this.getControl(), controlFontStyle.getControlFontStyle());
    }

    public short setVisibility(boolean bl, boolean bl2) {
        return ControlFunctions.SetControlVisibility(this.getControl(), bl, bl2);
    }

    public boolean isVisible() {
        return ControlFunctions.IsControlVisible(this.getControl());
    }

    public short setUpBackground(short s, boolean bl) {
        return ControlFunctions.SetUpControlBackground(this.getControl(), s, bl);
    }
}

