/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.jdirect;

import com.apple.mrj.internal.jdirect.Accessor;
import com.apple.mrj.internal.jdirect.ArrayCopy;
import com.apple.mrj.jdirect.Struct;

public abstract class HandleStruct
extends Struct {
    protected int handle;

    public HandleStruct(int n) {
        this.handle = n;
    }

    protected final boolean getBooleanAt(int n) {
        return Accessor.getBooleanFromHandle(this.handle, n);
    }

    protected final byte getByteAt(int n) {
        return Accessor.getByteFromHandle(this.handle, n);
    }

    protected final char getCharAt(int n) {
        return Accessor.getCharFromHandle(this.handle, n);
    }

    protected final short getShortAt(int n) {
        return Accessor.getShortFromHandle(this.handle, n);
    }

    protected final int getIntAt(int n) {
        return Accessor.getIntFromHandle(this.handle, n);
    }

    protected final long getLongAt(int n) {
        return Accessor.getLongFromHandle(this.handle, n);
    }

    protected final float getFloatAt(int n) {
        return Accessor.getFloatFromHandle(this.handle, n);
    }

    protected final double getDoubleAt(int n) {
        return Accessor.getDoubleFromHandle(this.handle, n);
    }

    protected final void setBooleanAt(int n, boolean bl) {
        Accessor.setBooleanInHandle(this.handle, n, bl);
    }

    protected final void setByteAt(int n, byte by) {
        Accessor.setByteInHandle(this.handle, n, by);
    }

    protected final void setCharAt(int n, char c) {
        Accessor.setCharInHandle(this.handle, n, c);
    }

    protected final void setShortAt(int n, short s) {
        Accessor.setShortInHandle(this.handle, n, s);
    }

    protected final void setIntAt(int n, int n2) {
        Accessor.setIntInHandle(this.handle, n, n2);
    }

    protected final void setLongAt(int n, long l) {
        Accessor.setLongInHandle(this.handle, n, l);
    }

    protected final void setFloatAt(int n, float f) {
        Accessor.setFloatInHandle(this.handle, n, f);
    }

    protected final void setDoubleAt(int n, double d) {
        Accessor.setDoubleInHandle(this.handle, n, d);
    }

    protected void setBytesAt(int n, byte[] byArray) {
        if (n + byArray.length > this.getSize()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ArrayCopy.copyArrayToHandle(byArray, 0, this.handle, n, byArray.length);
    }

    protected void setStructAt(int n, Struct struct) {
        byte[] byArray = struct.getBytesAt(0, struct.getSize());
        this.setBytesAt(n, byArray);
    }

    public byte[] getBytesAt(int n, int n2) {
        if (n + n2 > this.getSize()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] byArray = new byte[n2];
        ArrayCopy.copyHandleToArray(this.handle, n, byArray, 0, n2);
        return byArray;
    }

    public byte[] getBytes() {
        return this.getBytesAt(0, this.getSize());
    }

    public abstract int getSize();

    public final int getHandle() {
        return this.handle;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof HandleStruct) {
            HandleStruct handleStruct = (HandleStruct)object;
            return this.handle == handleStruct.handle;
        }
        return false;
    }
}

