/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.internal.jdirect;

import com.apple.mrj.internal.jdirect.Library;
import com.apple.mrj.internal.jdirect.LibraryArrayCache;
import com.apple.mrj.internal.jdirect.Linkage;
import com.apple.mrj.jdirect.Linker;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Vector;
import sun.misc.Cache;

public abstract class LinkerAbstract {
    protected static Cache methodsCache = new Cache();
    protected LibraryArrayCache knownLibrarySearchPaths = new LibraryArrayCache();
    public static final int PLATFORM_UNKNOWN = 0;
    public static final int PLATFORM_MACOS = 1;
    public static final int PLATFORM_MACOSX = 2;
    public static final int kPlatform = LinkerAbstract.getPlatform();
    private static final String kLibraryStringName = LinkerAbstract.getLibraryStringName();
    protected Hashtable thunks = new Hashtable();
    static /* synthetic */ Class class$com$apple$mrj$jdirect$Linker;

    abstract Library[] namesToLibraries(String[] var1);

    abstract boolean lockMethodCalls(long var1);

    abstract long createJumpTable(int var1, int var2, boolean var3);

    abstract long getJumpTableEntry(long var1, int var3, int var4);

    abstract long patchJumpTableEntry(long var1, int var3, int var4, long var5, long var7);

    abstract long createThunk(String var1);

    abstract void releaseJumpTable(Class var1, long var2);

    abstract boolean shellVariableDefined(String var1);

    abstract void installJNINativeMethod(Class var1, String var2, String var3, long var4);

    public abstract long createMethodClosure(Object var1, String var2, String var3, boolean var4);

    public abstract void disposeMethodClosure(long var1);

    protected long link(Class clazz, boolean bl) {
        if (clazz != null) {
            Library[] libraryArray;
            Method[] methodArray = LinkerAbstract.getMethods(clazz);
            int n = 0;
            int n2 = 0;
            while (n2 < methodArray.length) {
                libraryArray = methodArray[n2];
                if (Modifier.isNative(libraryArray.getModifiers())) {
                    ++n;
                }
                ++n2;
            }
            if (n == 0) {
                if (Linker.verbose) {
                    System.err.println("no native methods found in class " + clazz.getName());
                }
                return 0L;
            }
            libraryArray = this.namesToLibraries(LinkerAbstract.getLibraryNames(clazz, Linker.verbose));
            int n3 = this.knownLibrarySearchPaths.arrayToIndex(libraryArray);
            long l = this.createJumpTable(n3, n, bl);
            int n4 = 0;
            int n5 = 0;
            while (n5 < methodArray.length) {
                Method method = methodArray[n5];
                if (Modifier.isNative(method.getModifiers())) {
                    this.installJNINativeMethod(clazz, method.getName(), LinkerAbstract.getSignature(method), this.getJumpTableEntry(l, n4, n));
                    ++n4;
                }
                ++n5;
            }
            if (Linker.verbose) {
                System.err.println("JDirect: Linked class: " + clazz.getName());
                System.err.println("         Created jumptable at: 0x" + Long.toHexString(l));
                System.err.println("         With native method count: " + n);
                System.err.println("         Functions will be searched for in:");
                int n6 = 0;
                while (n6 < libraryArray.length) {
                    System.err.println("              " + libraryArray[n6].getName());
                    ++n6;
                }
            }
        }
        return 0L;
    }

    static long lazyPatchJumpTableEntry(Object object, long l, int n, int n2, int n3) {
        if (object instanceof Class) {
            return Linkage.getPlaformLinker().doPatchJumpTableEntry((Class)object, l, n, n2, n3);
        }
        throw new LinkageError("JDirect native methods must be static");
    }

    protected long doPatchJumpTableEntry(Class clazz, long l, int n, int n2, int n3) {
        Library[] libraryArray = this.knownLibrarySearchPaths.indexToArray(n3);
        Method method = LinkerAbstract.findNativeMethod(clazz, n);
        String string = LinkerAbstract.getSignature(method);
        LinkerAbstract.checkSignatureErrors(method, string);
        boolean bl = this.lockMethodCalls(l);
        if (bl) {
            string = string + "+";
        }
        String string2 = method.getName();
        int n4 = 0;
        while (n4 < libraryArray.length) {
            if (libraryArray[n4] != null) {
                try {
                    long l2 = libraryArray[n4].findSymbol(string2);
                    if (l2 != 0L) {
                        long l3 = this.getThunk(string);
                        if (Linker.verbose) {
                            System.err.println("JDirect: lazily loading method " + string2 + " in class " + clazz.getName());
                        }
                        return this.patchJumpTableEntry(l, n, n2, l3, l2);
                    }
                }
                catch (LinkageError linkageError) {
                    // empty catch block
                }
            }
            ++n4;
        }
        throw new LinkageError(LinkerAbstract.functionNotFoundMessage(string2, libraryArray));
    }

    protected static Method[] getMethods(final Class clazz) {
        Method[] methodArray = (Method[])methodsCache.get((Object)clazz);
        if (methodArray == null) {
            methodArray = System.getSecurityManager() != null ? (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getDeclaredMethods();
                }
            }) : clazz.getDeclaredMethods();
            methodsCache.put((Object)clazz, (Object)methodArray);
        }
        return methodArray;
    }

    protected static Method findNativeMethod(Class clazz, int n) {
        Method[] methodArray = LinkerAbstract.getMethods(clazz);
        int n2 = 0;
        int n3 = 0;
        while (n3 < methodArray.length) {
            Method method = methodArray[n3];
            if (Modifier.isNative(method.getModifiers())) {
                if (n2 == n) {
                    return method;
                }
                ++n2;
            }
            ++n3;
        }
        return null;
    }

    protected static String findNativeMethodName(Class clazz, int n) {
        Method method = LinkerAbstract.findNativeMethod(clazz, n);
        if (method != null) {
            return method.getName();
        }
        return "unknown[" + clazz.getName() + "," + n + "]";
    }

    private static String functionNotFoundMessage(String string, Library[] libraryArray) {
        int n = libraryArray.length;
        int n2 = 0;
        int n3 = 0;
        if (Linker.verbose) {
            System.err.println("\t" + string + " could not be found to link via JDirect");
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n4 = 0;
        while (n4 < n) {
            if (libraryArray[n4] != null) {
                if (libraryArray[n4].isLoaded()) {
                    ++n3;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(libraryArray[n4].getName());
                } else {
                    ++n2;
                    if (stringBuffer2.length() > 0) {
                        stringBuffer2.append(", ");
                    }
                    stringBuffer2.append(libraryArray[n4].getName());
                }
            }
            ++n4;
        }
        String string2 = n == 0 ? "JDirect native method \"" + string + "\" not found . Unable to find \"JDirect_...\" String" : (n3 == 0 ? "JDirect native method \"" + string + "\" not found because unable to load library(s): " + stringBuffer2 : (n2 == 0 ? "JDirect native method \"" + string + "\" not found in library(s): " + stringBuffer : "JDirect native method \"" + string + "\" not found in library(s): " + stringBuffer + ".  Unable to load library(s): " + stringBuffer2));
        return string2;
    }

    private static int getPlatform() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.arch");
        if (string.equals("Mac OS") && string2.equals("PowerPC")) {
            return 1;
        }
        if (string.equals("Mac OS X") || string.equals("Darwin")) {
            return 2;
        }
        System.err.println("JDirect:  unknown os.arch and os.name");
        return 0;
    }

    private static String getLibraryStringName() {
        switch (kPlatform) {
            case 1: {
                return "JDirect_MacOS";
            }
            case 2: {
                return "JDirect_MacOSX";
            }
        }
        return "JDirect_" + System.getProperty("os.name") + "_" + System.getProperty("os.arch");
    }

    protected static String[] getLibraryNames(final Class clazz, final boolean bl) {
        if (clazz == null) {
            return new String[0];
        }
        final Vector vector = new Vector();
        if (bl) {
            System.err.println("JDirect: looking for String field(s) " + kLibraryStringName + " for " + clazz);
        }
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    LinkerAbstract.walkInheritanceChain(clazz, vector, bl);
                    return null;
                }
            });
        } else {
            LinkerAbstract.walkInheritanceChain(clazz, vector, bl);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static void walkInheritanceChain(Class clazz, Vector vector, boolean bl) {
        Class clazz2 = class$com$apple$mrj$jdirect$Linker == null ? (class$com$apple$mrj$jdirect$Linker = LinkerAbstract.class$("com.apple.mrj.jdirect.Linker")) : class$com$apple$mrj$jdirect$Linker;
        Class clazz3 = clazz;
        while (clazz3 != clazz2 && clazz3 != null) {
            LinkerAbstract.accumulateLibraryStrings(clazz3, vector, bl);
            LinkerAbstract.accumulateLibraryStrings(clazz3.getInterfaces(), vector, bl);
            clazz3 = clazz3.getSuperclass();
        }
    }

    private static native String getStringFromField(Class var0, Field var1);

    private static void accumulateLibraryStrings(Class clazz, Vector vector, boolean bl) {
        block3: {
            try {
                Field field = clazz.getDeclaredField(kLibraryStringName);
                String string = LinkerAbstract.getStringFromField(clazz, field);
                vector.addElement(string);
                if (bl) {
                    System.err.println("\t" + clazz + ": found " + kLibraryStringName + "=\"" + string + "\"");
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!bl) break block3;
                System.err.println("\t" + clazz + ": does not have String field " + kLibraryStringName);
            }
        }
    }

    private static void accumulateLibraryStrings(Class[] classArray, Vector vector, boolean bl) {
        int n = 0;
        while (n < classArray.length) {
            Class clazz;
            block4: {
                clazz = classArray[n];
                try {
                    Field field = clazz.getDeclaredField(kLibraryStringName);
                    String string = LinkerAbstract.getStringFromField(clazz, field);
                    vector.addElement(string);
                    if (bl) {
                        System.err.println("\t" + clazz + ": found " + kLibraryStringName + "=\"" + string + "\"");
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (!bl) break block4;
                    System.err.println("\t" + clazz + ": does not have String field " + kLibraryStringName);
                }
            }
            LinkerAbstract.accumulateLibraryStrings(clazz.getInterfaces(), vector, bl);
            ++n;
        }
    }

    protected static void checkSignatureErrors(Method method, String string) {
        String string2 = null;
        int n = string.indexOf(41);
        if (n != -1 && string.charAt(n + 1) == '[') {
            string2 = "JDirect native methods cannot have array return types";
        } else if (n != -1 && string.charAt(n + 1) == 'L') {
            string2 = "JDirect native methods cannot have Object return types";
        } else if (string.indexOf("[Z") != -1) {
            string2 = "JDirect native methods cannot have boolean array parameters";
        } else if (string.indexOf(59) != -1) {
            string2 = "JDirect native methods cannot have Objects as parameters";
        } else if (!Modifier.isStatic(method.getModifiers())) {
            string2 = "JDirect native methods must be static";
        }
        if (string2 != null) {
            if (Linker.verbose) {
                System.err.println("\t" + method.getName() + string + " has an illegal signature for JDirect");
            }
            throw new LinkageError(string2);
        }
    }

    protected static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(LinkerAbstract.getSignature(classArray[n2]));
            ++n2;
        }
        stringBuffer.append(')');
        stringBuffer.append(LinkerAbstract.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    protected static String getSignature(Class clazz) {
        String string = clazz.getName();
        if (clazz.isPrimitive()) {
            char c = Character.toUpperCase(string.charAt(0));
            switch (c) {
                case 'B': {
                    if (clazz == Byte.TYPE) {
                        return "B";
                    }
                    return "Z";
                }
                case 'L': {
                    return "J";
                }
            }
            char[] cArray = new char[]{c};
            return new String(cArray);
        }
        if (clazz.isArray()) {
            return "[" + LinkerAbstract.getSignature(clazz.getComponentType());
        }
        return "L" + string.replace('.', '/') + ";";
    }

    protected long getThunk(String string) {
        Object v = this.thunks.get(string);
        if (v != null && v instanceof Long) {
            Long l = (Long)v;
            return l;
        }
        long l = this.createThunk(string);
        this.thunks.put(string, new Long(l));
        return l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

