/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.JManager;

import com.apple.mrj.JManager.BasicAuthentication;
import com.apple.mrj.JManager.JMAWTContext;
import com.apple.mrj.JManager.JMAWTContextImpl;
import com.apple.mrj.JManager.JMProxyInfo;
import com.apple.mrj.JManager.JMReferenced;
import com.apple.mrj.JManager.JMSession;
import com.apple.mrj.JManager.JMTextImpl;
import com.apple.mrj.JManager.JManagerException;
import com.apple.mrj.JManager.JManagerImpl;
import com.apple.mrj.JManager.MEventDispatcher;
import com.apple.mrj.internal.jdirect.ArrayCopy;
import com.apple.mrj.jdirect.JDirectLinker;
import com.apple.mrj.macos.generated.MemoryFunctions;
import com.apple.mrj.macos.toolbox.FSSpec;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import sun.net.www.protocol.http.HttpAuthenticator;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.MoreAdvancedHttpAuthenticator;

public class JMSessionImpl
extends JMReferenced
implements JMSession,
MoreAdvancedHttpAuthenticator {
    public static boolean theJManagerOneCompatabilityMode = false;
    public static boolean theDebugJavaLibraryIsBeingUsed = false;
    public static JMSessionImpl theSession;
    public static int theSessionRef;
    private static String[] theProxyNames;

    public void forgetReference() {
        theSession = null;
        theSessionRef = 0;
        super.forgetReference();
    }

    JMSessionImpl(int n, boolean bl, boolean bl2, int n2) {
        super(n2);
        JManagerImpl.libraryInstance = JDirectLinker.loadLibrary(n);
        theDebugJavaLibraryIsBeingUsed = bl;
        theJManagerOneCompatabilityMode = bl2;
        theSessionRef = n2;
        theSession = this;
        HttpURLConnection.setDefaultAuthenticator((HttpAuthenticator)((Object)this));
    }

    public int getSessionRef() {
        return theSessionRef;
    }

    public int getClientData() throws JManagerException {
        int[] nArray = new int[1];
        JManagerException.checkError(JManagerImpl.JMGetSessionData(theSessionRef, nArray));
        return nArray[0];
    }

    public void setClientData(int n) throws JManagerException {
        JManagerException.checkError(JManagerImpl.JMSetSessionData(theSessionRef, n));
    }

    public void addToClassPath(File file) throws FileNotFoundException, JManagerException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getName());
        }
        FSSpec fSSpec = new FSSpec(file);
        JManagerException.checkError(JManagerImpl.JMAddToClassPath(theSessionRef, fSSpec.getBytes()));
    }

    public String fileToURL(File file) throws JManagerException {
        FSSpec fSSpec = new FSSpec(file);
        int n = JManagerImpl.JMFSSToURL(theSessionRef, fSSpec.getBytes());
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[MemoryFunctions.GetHandleSize(n) - 1];
        ArrayCopy.copyHandleToArray(n, 0, byArray, 0, byArray.length);
        return new String(byArray, 0, 0, byArray.length);
    }

    public File urlToFile(String string) throws JManagerException {
        FSSpec fSSpec = new FSSpec();
        JMTextImpl jMTextImpl = new JMTextImpl(string);
        JManagerException.checkError(JManagerImpl.JMURLToFSS(theSessionRef, jMTextImpl.getTextRef(), fSSpec.getBytes()));
        jMTextImpl.forgetReference();
        return fSSpec.toFile();
    }

    public JMProxyInfo getProxyProps(int n) throws JManagerException {
        JMProxyInfo jMProxyInfo = new JMProxyInfo();
        String string = theProxyNames[n];
        jMProxyInfo.itsSet = Boolean.getBoolean(String.valueOf(string) + "Set");
        jMProxyInfo.itsName = System.getProperty(String.valueOf(string) + "Host", "");
        jMProxyInfo.itsPort = Integer.parseInt(System.getProperty(String.valueOf(string) + "Port", "80").trim());
        return jMProxyInfo;
    }

    public void setProxyProps(int n, JMProxyInfo jMProxyInfo) throws JManagerException {
        String string = theProxyNames[n];
        Properties properties = System.getProperties();
        ((Hashtable)properties).put(String.valueOf(string) + "Set", new Boolean(jMProxyInfo.itsSet).toString());
        ((Hashtable)properties).put(String.valueOf(string) + "Host", jMProxyInfo.itsName);
        ((Hashtable)properties).put(String.valueOf(string) + "Port", new Integer(jMProxyInfo.itsPort).toString());
    }

    public int getSessionTextEncoding() {
        return JManagerImpl.jmGetSessionEncoding(theSessionRef);
    }

    public JMAWTContext getContextForThread(Thread thread) {
        if (thread != null) {
            if (thread instanceof MEventDispatcher) {
                return (JMAWTContext)((Object)thread);
            }
            ThreadGroup threadGroup = thread.getThreadGroup();
            while (threadGroup != null) {
                if (threadGroup instanceof JMAWTContext) {
                    return (JMAWTContext)((Object)threadGroup);
                }
                threadGroup = threadGroup.getParent();
            }
        }
        return (JMAWTContext)((Object)JMAWTContextImpl.theHackyDefaultDispatcher);
    }

    private static native String doMRJAuthDialog(int var0, String var1, String var2);

    private static native boolean doMRJAuthFailedDialog(int var0, String var1, String var2);

    public boolean schemeSupported(String string) {
        return string.toLowerCase().equals("basic");
    }

    public String authString(URL uRL, String string, String string2) {
        String string3 = JMSessionImpl.doMRJAuthDialog(theSessionRef, uRL.getHost(), string2);
        if (string3 == null) {
            return null;
        }
        return BasicAuthentication.encryptString(string3);
    }

    public boolean shouldContinueRequestingAuth(URL uRL, String string, String string2) {
        return JMSessionImpl.doMRJAuthFailedDialog(theSessionRef, uRL.getHost(), string2);
    }

    static {
        theProxyNames = new String[]{"proxy", "firewall", "ftpProxy"};
    }
}

