/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.Handle;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.ScriptConstants;
import com.apple.MacOS.Str255;
import com.apple.MacOS.TranslateString;
import com.apple.memory.ByteObject;

public class StringPtr
extends ByteObject {
    private short scriptCode = ScriptConstants.SystemFontScript;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public StringPtr(int n) {
        super(n > 256 ? 256 : n);
    }

    public StringPtr(String string) {
        this(TranslateString.asPascalBytes(string));
    }

    protected StringPtr(String string, int n) {
        this(n);
        this.setString(string);
    }

    protected StringPtr(StringPtr stringPtr, int n) {
        this(n);
        this.setBytesAt(0, Math.max(n, stringPtr.length()), stringPtr.bytes);
    }

    public StringPtr(byte[] byArray) {
        super(byArray);
    }

    public final int length() {
        return this.bytes[0];
    }

    public void setScript(short s) {
        this.scriptCode = s;
    }

    public short getScript() {
        return this.scriptCode;
    }

    public final String asString() {
        return TranslateString.asString(this.bytes, (short)1, (short)(this.bytes[0] + 1), this.scriptCode);
    }

    public final String toString() {
        return this.asString();
    }

    public final void setString(String string) {
        this.scriptCode = TranslateString.setStringPtr(this, string);
    }

    public void Draw() {
        StringPtr.DrawString(this.bytes);
    }

    public void DebugStr() {
        StringPtr.DebugStr(this.bytes);
    }

    public int Width() {
        return StringPtr.StringWidth(this.bytes);
    }

    public boolean EqualString(Str255 str255, boolean bl, boolean bl2) {
        return StringPtr.EqualString(this.getBytes(), str255.getBytes(), bl, bl2);
    }

    public short IdenticalString(Str255 str255, Handle handle) {
        return StringPtr.IUEqualPString(this.getBytes(), str255.getBytes(), handle.getHandle());
    }

    public short StringOrder(Str255 str255, short s, short s2, short s3, short s4) {
        return StringPtr.IUStringOrder(this.getBytes(), str255.getBytes(), s, s2, s3, s4);
    }

    public short RelString(Str255 str255, boolean bl, boolean bl2) {
        return StringPtr.RelString(this.getBytes(), str255.getBytes(), bl, bl2);
    }

    public short CompareString(Str255 str255, Handle handle) {
        return StringPtr.IUCompPString(this.getBytes(), str255.getBytes(), handle.getHandle());
    }

    public void UpperString(boolean bl) {
        StringPtr.UpperString(this.getBytes(), bl);
    }

    public short TruncString(short s, short s2) {
        return StringPtr.TruncString(s, this.getBytes(), s2);
    }

    private static native void DrawString(byte[] var0);

    private static native void DebugStr(byte[] var0);

    private static native short StringWidth(byte[] var0);

    private static native boolean EqualString(byte[] var0, byte[] var1, boolean var2, boolean var3);

    private static native short IUEqualPString(byte[] var0, byte[] var1, int var2);

    private static native short IUStringOrder(byte[] var0, byte[] var1, short var2, short var3, short var4, short var5);

    private static native short RelString(byte[] var0, byte[] var1, boolean var2, boolean var3);

    private static native void UpperString(byte[] var0, boolean var1);

    private static native short TruncString(short var0, byte[] var1, short var2);

    private static native short IUCompPString(byte[] var0, byte[] var1, int var2);

    private static native short IUCompString(byte[] var0, byte[] var1);

    private static native short IUEqualString(byte[] var0, byte[] var1);
}

